@*H THIS_CLASS(DIA_INFER_CDS)
 With this Dialog one or more nucleotide sequences can be translated to
 amino acids according to the WIKI:Genetic_code such that they are most similar to a given reference amino acid sequence.
 The resulting amino acid sequence depends on
 <UL>
 <LI>the nucleotide sequence</LI>
 <LI>the WIKI:Reading_frame (forward or WIKI:Reverse_complement)</LI>
 <LI>The WIKI:Coding_sequence / WIKI:Non_coding_DNA</LI>
 </UL>
*@
#define _butUndo _bb[1]
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _jlistSequences=newProteinJlist(IF_NT_or_ACTGN|NEWPROTEINJLIST_SELECT_ALL);
        final Object
            westNorth=pnl(VBPNL,
                          "Reference amino acid sequence",
                          _choiceSequence=newProteinCombo(IF_NOT_ACTGN),
                          " ",
                          pnl(newBut(BUTS_GO,this),_butUndo=_bb[SBUTS_DIA_INFER_CDS_Undo]));
        return pnl(GRIDLAYOUT(1,2),
                   scrllpn(0,pnl(CNSEW,null,westNorth,null,null,pcpKey(KOPT_TRACKS_VIEWPORT_WIDTH))),
                   pnl(CNSEW,scrllpn(SCRLLPN_INHERIT_SIZE,_jlistSequences),"List of nucleotide sequence to be translated"));
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        baLog(LOG_MSG).send();
        if(bid==BUTS_GO || bid==SBUTS_DIA_INFER_CDS_Undo){
            final Protein[]pp=proteinJlistSelectedOrAll(_jlistSequences);
            int count=0;
            if(bid==BUTS_GO){
                final BA sbError=new BA(0),sbWarning=new BA(0);
                final Protein pRef=sp(_choiceSequence);
                if(pp.length==0) sbError.aln("Select at least one protein with coding nt-sequence.");
                if(pRef==null) sbError.aln("No reference amino acid sequence selected.");
                for(Protein p:pp) if(p!=pRef && !p.onlyActgn() && !p.isTranslated()) sbWarning.a(p).aln(" does not contain nucleotides (Letters A C T and G)");
                if(sze(sbWarning)>0) sbWarning.special(BA_ERROR);
                if(sze(sbError)>0) {sbError.special(BA_ERROR); return null;}
                final byte[]aa=pRef.getResType();
                for(Protein p:pp){
                    if(p==pRef) continue;
                    _log.an('=',99).a("\nSequence ").aln(p);
                    byte[]ntSeq=p.getNucleotides();
                    if(ntSeq==null && p.onlyActgn()) ntSeq=p.getResType();
                    if(ntSeq==null) continue;
                    final BA result=bl2seqCompute(BLAST_PRG_TBLASTX,ntSeq,aa,_log);
                    final TYPE_BL2SEQ_HIT[]hh=bl2seqHits(result);
                    if(sze(hh)>0){
                        final int[][]trans=getTranslatedNucleotides(hh);
                        if(trans[0].length>0){
                            final boolean reverse=hh[0][BL2SEQ_HIT_fromI]>hh[0][BL2SEQ_HIT_toI];
                            if(reverse){
                                for(int[]ft:trans){
                                    ROFi0(trans[0].length) ft[i]=ntSeq.length-ft[i]-1;
                                    Arrays.sort(ft);
                                }
                            }
                            pcp(_butUndo,new Object[]{p.isReverseComplement()?"":null,p.exons()},p);
                            p.setExons(trans,reverse);
                            count++;
                        }
                    }
                }
                if(count>0)  awtc(AWTC_SET_ENABLED,_butUndo);
            }
            if(bid==SBUTS_DIA_INFER_CDS_Undo){
                for(Protein p:pp){
                    final Object oo=gcp(_butUndo,p);
                    if(oo instanceof Object[]){
                        p.setExons((int[][])iThEl(1,oo),null!=iThEl(0,oo));
                        count++;
                    }
                }
            }
            if(count>0) strapEvtDispatch(EVT_NUCL_TRANSLATION);
        }
        BREAK;
    }
 }
#undef _butUndo
