/* (NUM1 1) */
#define DIA_INTERMEDIATE_SEQ_PROGRESS 1
#define DIA_INTERMEDIATE_SEQ_CHOICE_DB 2

@*H THIS_CLASS(DIA_INTERMEDIATE_SEQ)

Intermediate sequences is a method to discover remote homology between
two sequences by identifying a third sequence, that is similar to the
two sequences under consideration.

<H3>Identifying Blast hits that are common to both sequences</H3>
<OL>
<LI>One sequence is selected in the first, and one in the second sequence list.</LI>

<LI>For each sequence a BLAST search is performed against a non-redundant set of sequences such as Uniref50
The BLAST hits are compared and all common segments presented graphically.
</LI>
</OL>

<H3>Failure due to truncation of Blast results</H3>

This method requires that the Blast results comprise also remote homologs.
Since the number of displayed alignments is limited for the public
services at NCBI and EBI, the result list may end before the remote
homologs are shown.

In this case the method fails.

This is particularly the case for sequences with
many paralogs.

<H3>Improving multiple sequence alignments</H3>
Alignment programs perform better when sequences are added that share similarity with the proteins
to be aligned.
Using two additional steps one can improve multiple sequence alignments:
<OL>
<LI>Choose hits that are similar to either sequence by activating the respective check-boxes.</LI>
<LI>Protein objects are created for each activated Blast segment. At this stage overlapping segments with the same sequence ID but different start and end positions are joined.</LI>
<LI>Finally a multiple sequence alignment is computed <i>HTMLDOC_BUTTON:BUT_C1(DialogAlign)!</i>.</LI>
</OL>
<BR>
<B>Related publications:</B> PUBMED:11159329 PUBMED:9367767
<BR>
*@
#define _intermAli _v
#define _diaBlastV _v1
#define _intermDB _v2
#define _tabs _v3
#define _intermLogNoHits _log
#define _intermMapBlastResult _mapProtObj
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _tabs=new ArrayList();
        _intermAli=NEW_VECTOR();
        _intermDB=NEW_VECTOR();
        _intermMapBlastResult=new WeakHashMap();
        _diaBlastV=new ArrayList();
        setSelIdx(0,addActLi(this,_jlistSequences=newProteinJlist(0)));
        setSelIdx(1,addActLi(this,_bb[SDIALOGS_JLIST_SEQUENCES_2]=newProteinJlist(0)));
        _intermLogNoHits.aln(butTxt(SBUTS_DIA_INTERMEDIATE_SEQ_listPairsWithoutCommonBlastHits)).aln();
        final Object
            pStep23=pnl(VB,
                        pnl(VBHB,BRDR_ETCHED_EM,
                            " ",
                            "1st step: Load blast hits with check-box activated.",_bb[SBUTS_DIA_INTERMEDIATE_SEQ_Load_selected]," ",
                            "2nd step: Align the sequences together with the loaded blast hits.",
                            buttn(BUT_C1(DialogAlign)))),
            details=pnl(VBHB,"Method:",getPnl(setPrefSze(MIN_INT,prefH(_bb[SBUTS_DIA_INTERMEDIATE_SEQ_Go]),
                                                         _choiceClass=addActLi(this,setSelIdx(SEQ_BLASTER_WEB_EBI,new ChJCombo(arry(SARRAYeq_BLAST_CMD)))))),
                        "Database:",_bb[DIA_INTERMEDIATE_SEQ_CHOICE_DB]=addActLi(this,new ChJCombo(0,_intermDB))),
            pStep1=pnl(VB,pcpKey(KOPT_TRACKS_VIEWPORT_WIDTH),
                       pnl(VBPNL,BRDR_ETCHED_EM,
                           "Find common blast hits.",
                           pnl(_bb[SBUTS_DIA_INTERMEDIATE_SEQ_Go],
                               setPrefSze(0,0,setTip("Progress of blast runs",_bb[DIA_INTERMEDIATE_SEQ_PROGRESS]=guiCmpnt(GUICMPNT_NEW_PRGRSS_BAR))),
                               newCtrlBut(this)),
                           pnlTogglOpts(details),
                           details),
                       " ",
                       pnl(HBL,pnlTogglOpts(TOGGL_PNL_Strap_ResultImprovesSeqAli,pStep23)),
                       pStep23);

        runCR(_RUN_DIA_INTERMEDIATE_SEQ_UPDATE_DB,this);
        add(scrllpn(0,pStep1));
        add(pnl(GRIDLAYOUT(2,1),scrllpn(SCRLLPN_OPTS_PROTEINS,_jlistSequences),scrllpn(SCRLLPN_OPTS_PROTEINS,_bb[SDIALOGS_JLIST_SEQUENCES_2])));
        break;
    }
    CASE_ARGV(RUN_DISPOSE){
        //for(SDialogs sp:childsR(this,SDialogs.class)) if(sp._it==TAB_INTERMEDIATE_SEQ) dispos(sp);
        dispos(_tabs);
        clr(_intermMapBlastResult);
        RETURN(TRUEr);
    }
    CASE_ARG(RUN_GET_CTRL_PNL,Object,supported){
        if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
        if(_ctrl==null) _ctrl=pnl(CNSEW,scrllpn(SCRLLPN_SIZE_56x24,
                                                new ChJList(JLIST_DEFAULT_RENDERER|JLIST_ONCLICK_SHOW_CTRLPNL|JLIST_BACKSPACE_DEL_ITEM,_diaBlastV)),
                                  null,
                                  pnl(_bb[SBUTS_DIA_INTERMEDIATE_SEQ_listPairsWithoutCommonBlastHits]));
        RETURN _ctrl;
    }
    CASE_ARGV(_RUN_INTERMSEQ_GO,Protein[],proteins0,Protein[],proteins1){
        Protein[]pp0=proteins0,pp1=proteins1;
        if(pp1.length==0) pp1=pp0;
        if(pp0.length==0 && (pp0=pp1).length==0) baLog(LOG_MSG).a(RED_ERROR).aln("Select at least one sequence in the top and button list");
        else{
            final SequenceBlaster[][]results=new SequenceBlaster[2][];
            for(int i2=0,count=0;i2<2;i2++){
                final Protein[]pp=i2==0?pp0:pp1;
                results[i2]=new SequenceBlaster[pp.length];
                FORiP(0,pp.length){
                    final Protein p=pp[iP];
                    setPrgrss(++count*100/(1+pp0.length+pp1.length),s(p),_bb[DIA_INTERMEDIATE_SEQ_PROGRESS]);
                    SequenceBlaster b=(SequenceBlaster)gcp(p,_intermMapBlastResult);
                    if(b==null){
                        b=new SequenceBlaster((10<<BLAST_SHIFT_SENSITIVITY),
                                              getSlctIdx(_choiceClass),
                                              p.getResTypeSUC(),s(_bb[DIA_INTERMEDIATE_SEQ_CHOICE_DB]),
                                              addPfx("Intermediate Sequences ",p));
                        _diaBlastV.add(b);
                        b.blastAlignments();
                    }
                    _intermMapBlastResult.put(p,newSoftRef(results[i2][iP]=b));
                }
            }
            setPrgrss(0,"Blast done",_bb[DIA_INTERMEDIATE_SEQ_PROGRESS]);
            thrdCR(_RUN_INTERMSEQ_COMPUTE|THRDCR_EDT_LATER,this,pp0,pp1,results[0],results[1]);
            awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_INTERMEDIATE_SEQ_Load_selected]);
            awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_INTERMEDIATE_SEQ_Go]);
            awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_INTERMEDIATE_SEQ_listPairsWithoutCommonBlastHits]);
        }
        BREAK;
    }
    CASE_ARGV(_RUN_INTERMSEQ_COMPUTE,Protein[],pp1,Protein[],pp2,SequenceBlaster[],rr1,SequenceBlaster[],rr2){
        boolean success=false;
        FORi(0,pp1.length){
            FORj(0,pp2.length){
                final Protein p1=pp1[i],p2=pp2[j];
                if(p1!=p2){
                    if(iThEl(i,rr1)==null) {_intermLogNoHits.aa("Error ",p1,": No Blast Result\n"); continue;}
                    if(iThEl(j,rr1)==null) {_intermLogNoHits.aa("Error ",p2,": No Blast Result\n"); continue;}
                    final SDialogs r=new SDialogs(TAB_INTERMEDIATE_SEQ);
                    _tabs.add(r);
                    r._pp=new Protein[]{p1,p2};
                    r._bb[TAB_INTERMEDIATE_SEQ_SequenceBlaster_0]=rr1[i];
                    r._bb[TAB_INTERMEDIATE_SEQ_SequenceBlaster_1]=rr2[j];
                    runCR(RUN_INIT_DIALOG,r);
                    //final IntermediateSeqPair r=new IntermediateSeqPair(p1,p2,rr1[i],rr2[j]);
                    if(sze(r._vHitViewShown)==0){
                        shwTxtInW("Intermediate Sequences ",_intermLogNoHits.aa(p1," and ").aln(p2));
                        dispos(r);
                    }else{
                        success=true;
                        adTab(DISPOSE_CtrlW,tabText2p(p1,p2),r,_tabbed);
                    }
                }
            }
        }
        if(success) setSelIdx(_tabbed.getTabCount()-1,_tabbed);
        BREAK;
    }
    CASE_ARGV(_RUN_DIA_INTERMEDIATE_SEQ_UPDATE_DB){
        final String[]dd=new SequenceBlaster((2000<<BLAST_SHIFT_NUMALI)|(3<<BLAST_SHIFT_WORDSIZE),getSlctIdx(_choiceClass),null,null,null).getAvailableDatabases(0);
        adAll(dd,clr(_intermDB));
        ROFi0(sze(dd)) if(strstr(STR_IC,"uniref50",dd[i])>=0) setSelIdx(i,_bb[DIA_INTERMEDIATE_SEQ_CHOICE_DB]);
        if(sze(_intermDB)==0) _intermDB.add("Error: no Database");
        BREAK;
    }
    CASE_ARGV(_RUN_DIA_INTERMEDIATE_SEQ_UNION){
        ROFj0(sze(_intermAli)){
            TYPE_BLASTALIGNMENT a0=(TYPE_BLASTALIGNMENT)_intermAli.get(j);
            if(a0==null) continue;
            ROFi0(sze(_intermAli)){
                final TYPE_BLASTALIGNMENT a1=(TYPE_BLASTALIGNMENT)_intermAli.get(i);
                if(a1==null||a1==a0) continue;
                final TYPE_BLASTALIGNMENT u=blastAlignmentUnion(a0,a1);
                if(u!=null){
                    _intermAli.set(j,a0=u);
                    _intermAli.set(i,null);
                }
            }
        }
        while(_intermAli.remove(null)){}
        BREAK;
    }
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        if(evtType[0]==EVT_AA_SHADING_CHANGED) awtc(AWTC_OPT_REPAINT,this);
        return TRUEr;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==SDIALOGS_CHOICE_CLASS || bid==DIA_INTERMEDIATE_SEQ_CHOICE_DB) clr(_intermMapBlastResult);
        if(bid==SDIALOGS_CHOICE_CLASS) runCR(_RUN_DIA_INTERMEDIATE_SEQ_UPDATE_DB,this);
        if(bid==SBUTS_DIA_INTERMEDIATE_SEQ_Go){
            setPrefSze(FLAG_SET_PREFSZE_REVAL|20*EX,prefH(_bb[SBUTS_DIA_INTERMEDIATE_SEQ_Go]),_bb[DIA_INTERMEDIATE_SEQ_PROGRESS]);
            awtc(AWTC_SET_DISABLED,_bb[SBUTS_DIA_INTERMEDIATE_SEQ_Load_selected]);
            awtc(AWTC_SET_DISABLED,_bb[SBUTS_DIA_INTERMEDIATE_SEQ_Go]);
            awtc(AWTC_SET_DISABLED,_bb[SBUTS_DIA_INTERMEDIATE_SEQ_listPairsWithoutCommonBlastHits]);
            thrdCR(_RUN_INTERMSEQ_GO|THRDCR_START,this,spp(_jlistSequences),spp(_bb[SDIALOGS_JLIST_SEQUENCES_2]));
        }
        if(bid==SBUTS_DIA_INTERMEDIATE_SEQ_listPairsWithoutCommonBlastHits){
            ChFrame.frame(0,butTxt(SBUTS_DIA_INTERMEDIATE_SEQ_listPairsWithoutCommonBlastHits),_intermLogNoHits).shw(FRAME_AT_CLICK);
        }
        if(bid==SBUTS_DIA_INTERMEDIATE_SEQ_Load_selected){
            clr(_intermAli);
            //for(SDialogs sp:childsR(this,SDialogs.class)) if(sp._it==TAB_INTERMEDIATE_SEQ){
            FORj(0,sze(_tabs)){
                final SDialogs sp=(SDialogs)_tabs.get(j);
                FORi(0,sze(sp._vIntersections)){
                    final TYPE_BlastIntersection x=(TYPE_BlastIntersection)sp._vIntersections.get(i);
                    if(x[BLASTINTERSECT_SELECTED]!=null){
                        final TYPE_BLASTALIGNMENT a0=(TYPE_BLASTALIGNMENT)x[BLASTINTERSECT_ALIGNMENT_0],ba=new Object[BLASTAL_ZZZ];
                        ba[BLASTAL_ID]=a0[BLASTAL_ID];
                        ba[BLASTAL_DB]=a0[BLASTAL_DB];
                        ba[BLASTAL_DESCRIPTION]=a0[BLASTAL_DESCRIPTION];
                        ba[BLASTAL_H_B]=a0[BLASTAL_H_B];
                        ba[BLASTAL_H_E]=a0[BLASTAL_H_E];
                        ba[BLASTAL_H_SEQ]=a0[BLASTAL_H_SEQ];
                        _intermAli.add(ba);
                    }
                }
            }
            runCR(_RUN_DIA_INTERMEDIATE_SEQ_UNION,this);
            final Collection<Protein>vProteins=NEW_VECTOR();
            FORi(0,sze(_intermAli)){
                final TYPE_BLASTALIGNMENT a=(TYPE_BLASTALIGNMENT)_intermAli.get(i);
                final String pn=s(new BA(99).aa("ss",a[BLASTAL_ID],'-',a[BLASTAL_H_B],'-',a[BLASTAL_H_E]));
                if(sequenceWithName(pn,null)==null){
                    final Protein p=new Protein();
                    p.setProperty(PROTEINO_ALIGNMENT,_main);
                    p.setName(pn);
                    p.setResidueType(a[BLASTAL_H_SEQ]);
                    p.setProperty(P_HEADER,s(a[BLASTAL_DESCRIPTION]));
                    adUniq(p,vProteins);
                }
            }
            if(sze(vProteins)==0) baLog(LOG_MSG).a(RED_ERROR).aln("You must select blast hits in the result tabs");
            setCursorColumn(io(MAX_INT),1);
            strapAddProteins(-1,spp(vProteins));
        }
        BREAK;
    }
 }
if(RUN_M_EVT(id)) baLog(LOG_MSG).send();
#undef _intermDB
#undef _intermAli
#undef _intermLogNoHits
#undef _intermMapBlastResult
#undef _diaBlastV
// http://bibiserv.techfak.uni-bielefeld.de/altavist/
//https://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=pubmed&dopt=Abstract&list_uids=16076885&itool=iconabstr&query_hl=8
