/* (NUM1 1) */
#define _tfThreshold _bb[1]
#define _progress _bb[2]
@*H THIS_CLASS(DIA_NON_REDUNDANT_SEQUENCES)
 A set of sequences is generated from the selected sequences<BR>
 where the sequence identity ratio is not higher than the given threshold.<BR><BR>

 Those sequences are excluded for which another very similar sequence exists.<BR>
 This procedure is rather primitive and more sophisticated programs for this task exist (E.g. nrdb90).<BR><BR>
 Because it is aligning each sequence against all others by ClustalW the time rises with the square of the number of sequences.<BR><BR>
 Enter the threshold (0 ... 1).<BR>
 The larger the number, the more sequences  will be returned.
*@
//   see also http://www.ebi.ac.uk/~holm/nrdb90/nrdb90.pl.txt
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        setSelO(sclDefaultForInterface(INTRFC_SequenceAligner2),_choiceClass=classChoice(INTRFC_SequenceAligner));
        final Object pClass=pnl(HBL,"Method: ",getPnl(_choiceClass));
        pnl(this,VBHB,
            pcp(BUTTN_KEY_COLLAPSE_HIDE,pClass,_bb[STOG_DIA_NON_REDUNDANT_SEQUENCES_Use_Current]),
            pClass,
            pnl(HB,"Sequence similarity threshold (0...100) ",_tfThreshold=new ChTextField("80%").cols(TF_CONTENTTYPE_PERCENT|5)," The larger the more."),
            newBut(BUTS_GO,this));
        break;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==BUTS_GO){
            final Object
                jl=new ChJList(JLIST_DEFAULT_RENDERER|JLIST_ICON_ROW_HEIGHT|JLIST_FILE_TRANSFER_HANDLER|JLIST_DRAG_ENABLED,_v=new ArrayList()),
                pp[]=selectedOrVisibleProteins(1);
            adAll(pp,clr(_v));
            runCR1(RUN_NEW_DROPTARGET,_main,jl);
            adTab(0,s(_tfThreshold),
                  pnl(CNSEW,scrllpn(0,jl),
                      new BA(99).aa(_choiceClass==null?"As aligned in Strap":"Compare sequences with ",shrtClasNamOrAlias(_choiceClass)," Threshold=",_tfThreshold),
                      _progress=pnl()),
                  _tabbed);
            thrdCR1(RUN_DIA_NON_REDUNDANT_SEQUENCES_BG|THRDCR_START,this,jl);
        }
        BREAK;
    }
    CASE_ARG(RUN_DIA_NON_REDUNDANT_SEQUENCES_BG,Object,jList){
        final int threshold=xatoi(getTxt(_tfThreshold));
        final Object clazz=isCbSlct(STOG_DIA_NON_REDUNDANT_SEQUENCES_Use_Current)?null:_choiceClass;
        if(clazz!=null && null==sclInstanceSA(0,null,clazz)) setTxt(new BA(99).aa(RED_FAILED," create ").aln(shrtClasNamOrAlias(clazz)),_progress);
        else{
            final Protein[]pp=spp(_v);
            final boolean[][]done=new boolean[pp.length][pp.length];
            for(int N=pp.length*(pp.length-1)/2,count=0,i=0;i<pp.length;i++){
                FORj(0,pp.length){
                    if(i==j || pp[i]==null||pp[j]==null || done[i][j] || done[j][i]) continue;
                    done[i][j]=true;
                    final int maxLen=maxi(pp[i].getResType().length,pp[j].getResType().length);
                    if(maxLen>0){
                        final byte[][]aligned=clazz!=null?
                            (byte[][])iThEl(ALIGNRESULT_GAPPED,sclInstanceSA(0,null,clazz).computeAlignment(0,new Protein[]{pp[i],pp[j]})):
                            new byte[][]{pp[i].getGappedSequence(false),pp[j].getGappedSequence(false)};
                        final int maxCol=clazz!=null?MAX_INT:1+maxi(pp[i].getResColumnMax(),pp[j].getResColumnMax());
                        if(sze(aligned)>=2 && (CPP_NUMERATOR(alignmentIdentity(aligned[0],aligned[1],0,maxCol)))/(0.01f*maxLen)>threshold){
                            final int rm=countChrClas(chrClas(LETTR),pp[i].getResType(),0,MAX_INT)>countChrClas(chrClas(LETTR),pp[j].getResType(),0,MAX_INT)?j:i;
                            _v.remove(pp[rm]);
                            pp[rm]=null;
                            awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,jList);
                        }
                    }
                }
                setTxt(new BA(99).aPlrl(++count," Progress: %n / ").a(N),_progress);
            }
            final Protein[]selected=rmNullPP(pp);
            setTxt(new BA(99).aa("Finished. Selected ",selected.length).aPlrl(pp.length,"  of %N  sequence%S."),_progress);
            break;
        }
    }
 }
#undef _tfThreshold
#undef _progress
