@*H THIS_CLASS(DIA_PUBLISH)
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogExportHTML)</i>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogTEXshade)</i>

 <div class="figure">

 <table style="caption-side: bottom">
 <CAPTION><B>Figure:</B>
 Generation of a Html link. The html code is generated automatically and can be tested in the web browser.
 </CAPTION>
 <tr><td> <i>HTMLDOC_JCOMPONENT:HTMLDOC_JC_DialogPublishAlignment</i></td></tr>

 </table>

 </div>

 With this dialog a Web-Link can be formed which loads the proteins from the public databases into Strap and displays an alignment.
 Java is required on the client machine.

 Depending on the amount of information two different types are
 available:

 <h3>1. Single web address</h3>

 The web address can not only be included in web-pages,
but also in e-mails and Office-documents.

 The generation is conducted in two steps:
 <OL>

 <LI> <i>HTMLDOC_BUTTON:SBUTS_DIA_PUBLISH_Mk_Parameters</i> The
 parameter String is written into the first text field and can
 be modified by the user.  Not the sequence but the database
 accession id is stored.  For technical details see
 http://www.bioinformatics.org/strap/createStrapLinks.html.
 </LI>

 <LI> <i>HTMLDOC_BUTTON:SBUTS_DIA_PUBLISH_Mk_Url</i> From the
 text in the first text field the web address will be generated
 using WIKI:Url_encoding and written into the 2nd text field.
 </LI>

 <LI><i>HTMLDOC_BUTTON:SBUTS_DIA_PUBLISH_Browser</i> The
 generated web address can be tested by clicking. A new Strap
 session will be opened in web-mode and an alignment will be
 loaded with the specified information.  </LI>

 </OL>

 <h3>2. Web form</h3>

 Since the web form has no  size limitation,
the entire information for the alignment can be included.
 The draw-back is that it can only be included in web-pages,
but not in office documents or e-mails.

 <OL>
 <LI><i>HTMLDOC_BUTTON:SBUTS_DIA_PUBLISH_Mk_Form</i>
 A html-page including the web link for the selected sequences is generated.</LI>

 <LI><i>HTMLDOC_BUTTON:SBUTS_DIA_PUBLISH_Browser</i>
 The link can be tested in the web browser.
 From this html code the text between the opening and closing and &lt;body&gt; tags can be used in any html-page.
 </LI>
 </OL>
*@
#define ALL_SELECTED_NONE_all 0
#define ALL_SELECTED_NONE_selected 1
#define ALL_SELECTED_NONE_none 2
@*SARRAYeq_ALL__SELECTED__NONE
 All=ALL_SELECTED_NONE_all Only selected=ALL_SELECTED_NONE_selected None=ALL_SELECTED_NONE_none
*@
#define DIA_PUBLISH_RADIO 1
#define DIA_PUBLISH_TA_PARAMETERS 2
#define DIA_PUBLISH_TA_ENCODED 3
#define DIA_PUBLISH_TA_FORM 4
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){

        undrlneRefs(ULREFS_WEB_COLORS|ULREFS_NEVER|ULREFS_NOT_CLICKABLE,_bb[DIA_PUBLISH_TA_PARAMETERS]);
        IF_MEIN_DEBUG(assert DIA_PUBLISH_TA_PARAMETERS+2==DIA_PUBLISH_TA_FORM);;
        ROFi0(3)tcTools(_bb[DIA_PUBLISH_TA_PARAMETERS+i]=new ChTextArea(""))
            .enableWordCompletion(NEW_OBJECTS(iFile(DIR_WORKING),arry(SARRAY_STRAP_SCRIPT_CMD_FOR_WORDCOMPLETION))).enableUndo(true);

        _bb[DIA_PUBLISH_RADIO]=addActLi(this,radioGrp(SARRAYeq_ALL__SELECTED__NONE));
        (_tabbed=new JTabbedPane()).add("Comprehensive Web form",pnl(CNSEW,scrllpn(0,_bb[DIA_PUBLISH_TA_FORM]),pnl(_bb[SBUTS_DIA_PUBLISH_Mk_Form]),pnl(HBL,_bb[SBUTS_DIA_PUBLISH_Browser])));
        _tabbed.add("Compact web address",pnl(GRIDLAYOUT(2,1),pnl(CNSEW,scrllpn(0,_bb[DIA_PUBLISH_TA_PARAMETERS]),pnl(_bb[SBUTS_DIA_PUBLISH_Mk_Parameters]),BRDR_EM),pnl(CNSEW,_bb[DIA_PUBLISH_TA_ENCODED],pnl(_bb[SBUTS_DIA_PUBLISH_Mk_Url]))));
        return pnl(CNSEW,_tabbed,pnl(_bb[STOGS_DIA_PUBLISH_Icons],pnl(BRDR_ETCHED,"  Included residue annotations: ",_bb[DIA_PUBLISH_RADIO])));
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        Protein[]pp=selectedProteinsInVisibleOrder();
        if(ARRAY_EMPTY(pp)) pp=strapVisibleProteins();
        final BA sb=new BA(333);
        final int xAnno=radioGrpIdx(_bb[DIA_PUBLISH_RADIO]);
        if(bid==SBUTS_DIA_PUBLISH_Mk_Parameters){
            final Object[]selResan=selectedResidueSelections(SOBJECT_RESAN);
            for(Protein p:pp){
                final String pdb=p.getPdbID(PDBID_ID),ch=orS(pdbChain(pdb),p.getChain());
                String pName=null;
                if(pdb!=null && ch!=null) sb.aa("PDB:",pName=pdbID(pdb),'_',ch);
                else if(p.seqId(GETSEQID_ACCESSION)!=null)  sb.a(pName=p.seqId(GETSEQID_ACCESSION));
                else if(p.getProperty(PROTEINO_URL)!=null){
                    sb.a(p.getProperty(PROTEINO_URL));
                    pName=lstPathCmpnt(p.getProperty(PROTEINO_URL));
                }
                sb.a('|');
                if(pName!=null) pName=delLstCmpnt('.',delToLstChr1(':',pName));
                if(pName==null || !pName.equalsIgnoreCase(delLstCmpnt('.',p.getName()))) sb.a(p.getName());
                if(bid==SBUTS_DIA_PUBLISH_Mk_Parameters){
                    sb.a('|');/*X  ---  Icon --- */
                    if(isSlct(_bb[STOGS_DIA_PUBLISH_Icons]) && strstr(STR_w,IMG_URL_NOT_IN_STRAP_LINK,p.iconURL())<0) sb.a(p.iconURL());
                    sb.a('|');/*X  ---  ResidueAnnotation --- */
                    if(xAnno!=ALL_SELECTED_NONE_none){
                        for(ResidueAnnotation a:p.residueAnnotations()){
                            if((xAnno==ALL_SELECTED_NONE_all || cntainsEl(a,selResan)) && a.featureName()==null){
                                final Object color=getColrO(a);
                                if(color!=null && a.run(RUN_IS_ENABLED,null)==TRUEr && a.featureName()==null)  sb.aa('#',color,',',resSelSimplifyPos(CFALSE,a));
                            }
                        }
                    }
                    sb.a('|');/*X  --- CDS --- */
                    if(p.getIntProperty(PROTEINI_CDS)>=0) sb.a(p.getIntProperty(PROTEINI_CDS));
                    else if(Bitset.notEmpty(p.exons())) Bitset.toText(p.exons(),p.isReverseComplement(),sb);
                    sb.a('|');
                }
                undrlneRefs(ULREFS_WEB_COLORS,setTxt(sb.a('\n').replace(0,"|\n","\n"),_bb[DIA_PUBLISH_TA_PARAMETERS]));
            }
        }
        if(bid==SBUTS_DIA_PUBLISH_Mk_Form){
            final Collection<byte[]>vScript=new ArrayList(pp.length+10);
            sb.aa("<FORM action=\"",iUrl(iURL_STRAP_STRAP_PHP)).aln("?separateInstance=t\" method=\"POST\"> <INPUT type=\"hidden\" name=\"script\" value=\"\n").bytesToCollection(vScript);
            Protein.mkStrapScript((!isSlct(_bb[STOGS_DIA_PUBLISH_Icons])? SSCRIPT_NO_ICONS:0)|
                          (xAnno==ALL_SELECTED_NONE_none?SSCRIPT_NO_RESSEL:0)|
                          (xAnno==ALL_SELECTED_NONE_selected?SSCRIPT_SELECTED_RESSEL:0),
                          pp,sb,vScript);
            clr(sb).join0(vScript).aln("\n\"/> <INPUT type=\"SUBMIT\" name=\"SUBMIT\" value=\"This is the Web-Button to start Strap.\"/></FORM>");
            undrlneRefs(ULREFS_WEB_COLORS|ULREFS_NOT_CLICKABLE|ULREFS_NO_ICON|ULREFS_GO,
                        pcp(KEY_HELPCOMMANDS,HelpCommands.getInstance(RSC_SCRIPT_COMMANDS),
                            setTip(null,setTxt(sb,_bb[DIA_PUBLISH_TA_FORM]))));
        }
        if(bid==SBUTS_DIA_PUBLISH_Mk_Url) undrlneRefs(ULREFS_NEVER,setTxt(iPath2(iURL_STRAP_STRAP_PHP,s('?')).aWWW("align",s(_bb[DIA_PUBLISH_TA_PARAMETERS])
                                                                         .replaceAll("\\s+"," ")
                                                                         .replaceAll("\\|+ "," ")),_bb[DIA_PUBLISH_TA_ENCODED]));
        if(bid==SBUTS_DIA_PUBLISH_Browser) wrte(WRTE_VISIT_URL,iFile(FSUFFIX_html),new BA(9999).aln("<HTML><BODY>").aln(_bb[DIA_PUBLISH_TA_FORM]).aln("</BODY></HTML>"));
        BREAK;
    }
 }
