@*SARRAY_DIA_RENAME_VARS
 $UNIPROT|$UNIPROT_$ORGANISM5|$SWISSPROT|$SWISSPROT_$UNIPROT|$OSCIENTIFIC_$UNIPROT|$ORGANISM1|_$UNIPROT|$UNIPROT_$ORGANISM1|$ORGANISM1_$UNIPROT
*@
@*SARRAYeq_FLY_PROPERTY
 Drosophila melanogaster=P_ORGANISM_SC
 Fruit_fly=P_ORGANISM
*@
@*SARRAY_FLY_REF
 UNIPROT:PRC3_DROME|UNIPROT:P40301
*@
@*H THIS_CLASS(DIA_RENAME_SEQS)
 Enter a line for each sequence to be renamed.
 Each line should contain the current name and the new name.
 Tabulator key for auto completion.
 <H3>Pruning sequences</H3>
 The first or last residues of a sequence can be removed by appending an exclamation mark and a range expression to the sequence name.
 For the sub-sequence from residue 100 to 200 of a sequence "myProtein", one would type the following:
 <PRE class="data">
 myProtein.seq ==> myProtein.seq!100-200
 </PRE>
 The positions refer to the natural numbering with 1 being the first residue.
 For PDB/mmCIF files also the PDB residue number can be used with the Rasmol/JMol syntax (residueNumber-colon[-chainLetter]).
 <H3>Rubber band selection</H3>
 A rectangular region can be opened in the alignment with mouse.
 Then right clicking the rubber band opens a context menu with the item
 <i>HTMLDOC_BUTTON:SBUT_CROP_RECTANGLE!</i>
 <H3>Selecting one single chain of the multi chain structure file</H3>
 an underscore followed by the chain letter needs to be added.<BR><BR>
 Consider the pdb file 1ryp.pdb. When it is renamed to 1ryp_C.pdb only chain C is shown.
*@
#define PRFX_PREV "DRP$$P"
#define tmp() baClr(67)
#define COL0 "Current sequence name"

#define _mapPrevious _mapProtObj
/* (NUM1 1)*/
#define _taHeader _bb[1]
#define _ressel _bb[2]
#define _cutTermini _bb[3]
#define _labInfo _bb[4]
#define _rect _bb[5]
#define _cbCopy _bb[6]
/* --- */
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _mapPrevious=new WeakHashMap();
        tcTools(addActLi(this,_jTextArea=new ChTextArea(""))).enableWordCompletion(strapProteinsV(0)).enableUndo(true);

        {
            final Protein p=new Protein();
            p.setProperty(P_ORGANISM_SC,iConst(SARRAYeq_FLY_PROPERTY,P_ORGANISM_SC));
            p.setProperty(P_ORGANISM,iConst(SARRAYeq_FLY_PROPERTY,P_ORGANISM));
            p.addSeqRef(ADD_SEQREF_ACC,iConst(SARRAY_FLY_REF,1));
            p.addSeqRef(0,iConst(SARRAY_FLY_REF,0));
            final String[]ss=arry(SARRAY_DIA_RENAME_VARS);
            final int L=maxSze(ss)+3;
            ROFi0(ss.length) ss[i]=s(tmp().aTrailingSpc(ss[i],L).a(delPfx("UNIPROT_",p.rplcVars(true,ss[i]))));
            _choiceClass=monospc(setSelIdx(4,new ChJCombo(ss)));
        }
        //pnlTogglOpts(details),
        final Object
            pnlGenerate=pnl("Alternatively, sequence names can be generated according to a rule.",pnl(HBL,_choiceClass," ",_bb[SBUTS_DIA_RENAME_SEQS_Rule])),
            details=pnl(VBHB,_cbCopy=cbox("Copy files instead of rename"),pnl(VB,pcpKey(KOPT_HIDE_IF_DISABLED),BRDR_ETCHED,pnlTogglOpts(TOGGL_PNL_Strap_NamesFromOrganism|TOGGL_PNL_OPT_PACK,pnlGenerate),pnlGenerate)),
            undo=pnl(HBL,BRDR_ETCHED,_bb[SBUTS_DIA_RENAME_SEQS_Reset]," ",_bb[SBUTS_DIA_RENAME_SEQS_Reset_Orig]),
            center=pnl(CNSEW,scrllpn(SCRLLPN_SIZE_56x24,highlightSeqsInTA(0,_jTextArea)),_taHeader=awtc(AWTC_SET_NOT_EDITABLE,new ChTextArea("")),BRDR_ETCHED);
        pnl(this,CNSEW,center,
            pnl(VBHB,dialogHead(this),pnl(HBL,iicon(IC_SCISSOR)," or crop amino acid sequences ",pnlTogglOpts(details)),details),
            pnl(VBHB,
                newBut(BUTS_GO,this),
                pnlTogglOpts(TOGGL_PNL_Undo|TOGGL_PNL_OPT_PACK,undo),
                undo,
                _labInfo=pnl()));
        break;
    }/*X RUN_INIT_DIALOG*/
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        if(bid==SBUTS_DIA_RENAME_SEQS_Reset) runCR1(_RUN_DialogRenameSeqs_insTxt_RESET,this,null);
        if(bid==SBUTS_DIA_RENAME_SEQS_Reset_Orig) runCR1(_RUN_DialogRenameSeqs_insTxt_RESET_ORIG,this,null);
        if(bid==SBUTS_DIA_RENAME_SEQS_Rule) runCR1(_RUN_DialogRenameSeqs_insTxt,this,s(_choiceClass));
        if(bid==BUTS_GO){
            final Protein[]pp=strapProteins();
            final BA ba=toBA(_jTextArea);
            final byte[]T=ba.bytes();
            final ChTokenizer t=new ChTokenizer(SPC);
            final BA sbError=new BA(9999),sbCopy=new BA(99);
            int count=0;
            final boolean copy=isSlct(_cbCopy);
            for(int ee[]=ba.eol(),iL=0;iL<ee.length;iL++){
                final int b=BOL0(iL,ee),e=ee[iL];
                if(e<=b || T[b]=='#' || !t.setText(T,b,e).nextToken()) continue;
                final String old=t.asString();
                if(!t.nextToken()){sbError.aPlrl(iL,"Line %n: missing new name").aln();continue;}
                final String neu=t.asString();
                if(t.nextToken()){sbError.aPlrl(iL,"Line %n: more than two tokens found in line").aln();continue;}
                if(old.equals(neu)) continue;
                final Protein p=sequenceWithName(old,pp);
                if(p==null){sbError.aPlrl(iL," Line %n: no such sequence  ").aln(old);continue;}
                {
                    final File fOld=p.getFile();
                    final int[]gapOld;
                    boolean success=false;
                    {
                        final int[]gg=p.getResGap();
                        gapOld=gg==null?new int[p.countRes()]:gg.clone();
                    }
                    if(fOld==null){sbError.aa("Warning: ",old).aln(" has no file");if(copy) continue;}
                    if(neu.indexOf(':')>0 && p.getChain()==null){ sbError.aa("Error: ",old," colon found in \"",neu).aln("\" but file is not a PDB-chain");continue;}
                    final int idx0_old=p.subsetStart();
                    final File fNeu,fNeuNoChain,fOldNoChain;
                    {
                        final BA sb=tmp();
                        if(!copy) sb.aa(fOld.getParent(),'/');
                        final int end=sb.end();
                        fNeu=file(sb.a(seqName2file(neu)));
                        final String[]ccNeu=analyzeSequenceFile(neu),ccOld=analyzeSequenceFile(old);
                        fNeuNoChain=file(sb.setEnd(end).aFilter(FILTER_URL_ENCODE,ccNeu[SEQFILE_BASE]).aa(ccNeu[SEQFILE_EXT3D],ccNeu[SEQFILE_COMPRESS_SUFFIX]));
                        fOldNoChain=file(sb.setEnd(end).aFilter(FILTER_URL_ENCODE,ccOld[SEQFILE_BASE]).aa(ccOld[SEQFILE_EXT3D],ccOld[SEQFILE_COMPRESS_SUFFIX]));
                    }
                    if((p._flags&PFLAG_IS_IN_MSF)==0){
                        if(copy) p.save(iFile(DIR_WORKING),tmp(),null);
                        FORm(1,FP_ZZZ){
                            final File fN=fileOfProtein(m,neu),fO=fileOfProtein(m,old);
                            if(!fO.equals(fN)){
                                fileDel(0,fN);
                                if(copy){
                                    cpy(fO,fN);
                                    if(sze(fN)==0 && !equlsCanonicalPathF(fO,fN)) renamFileOrCpy(0,fO,fN);
                                    fileChooserMarkModified(fO);
                                }
                                if(fileExsts(fN)) fileChooserMarkModified(fN);
                            }
                        }
                    }
                    if(copy){
                        if(!fNeu.equals(fOld)){
                            if(!canModifyNiceMsg(fNeu)) continue;
                            fileDel(0,fNeu);
                            if((p._flags&PFLAG_IS_IN_MSF)!=0){
                                wrte(fNeu,tmp().a('>').aln(p).aln(p.getResidueType()));
                                if(p.getIntProperty(PROTEINI_AA_IDX_OFFSET)==0) fileDel(0,fileOfProtein(FP_1stIdx,s(fNeu)));
                                else wrte(fileOfProtein(FP_1stIdx,s(fNeu)),s(p.getIntProperty(PROTEINI_AA_IDX_OFFSET)));
                            }else if(sze(fOldNoChain)>0){
                                if(!fNeuNoChain.equals(fOldNoChain) && cpy(fOldNoChain,fileDel(0,fNeuNoChain))) fileChooserMarkModified(fNeuNoChain);
                            }else if(cpy(fOld,fNeu)) fileChooserMarkModified(fNeu);
                            success=true;
                        }
                        sbCopy.aln(neu);
                    }else{
                        final String[]ccNeu=analyzeSequenceFile(neu),ccOld=analyzeSequenceFile(old);
                        if(ccNeu[SEQFILE_CHAIN]==null && sze(fNeu)==0){
                            if((p._flags&PFLAG_IS_IN_MSF)==0 && !delLstCmpnt('!',fNeu).equals(delLstCmpnt('!',fOld))){
                                if(!canModifyNiceMsg(fNeu)) continue;
                                if(renamFile(fOld,fNeu)){fileChooserMarkModified(fNeu);fileChooserMarkModified(fOld);}
                            }
                            success=true;
                        }
                        p.setSubset(null);
                        p.setName(p.rplcVars(true,neu));
                        if(!eq(ccOld[SEQFILE_CHAIN_BY_COLON],ccNeu[SEQFILE_CHAIN_BY_COLON]) || !eq(ccNeu[SEQFILE_CHAIN],ccOld[SEQFILE_CHAIN]) || !eq(ccOld[SEQFILE_SUBSET],ccNeu[SEQFILE_SUBSET])){
                            if(sze(fNeu)>0 && !eqPathF(fNeu,fOld)){
                                p.setSubsetFT(0,MAX_INT);
                                parseAgain(fNeu,p);
                            }
                            p.setSubset(lstCmpnt1('!',neu));
                            final int D=p.subsetStart()-idx0_old,R=p.countRes();
                            int[]gapNew=(int[])gcp(addPfx(PRFX_PREV,neu),p);
                            if(D>0 && p.subsetStart()>=0){
                                System.arraycopy(gapOld,D,gapNew=new int[R],0,mini(gapOld.length-D,R));
                                FORi(0,D)gapNew[0]+=(gapOld.length>i?gapOld[i]:0)+1;
                                p.setResidueGap(gapNew);
                                pcp(addPfx(PRFX_PREV,p),gapOld,p);
                            }
                            if(D<0){
                                if(gapNew==null){
                                    System.arraycopy(gapOld,0,gapNew=new int[R],-D,mini(gapOld.length,R+D));
                                    gapNew[0]=maxi(0,gapNew[-D]+D);/*X java.lang.ArrayIndexOutOfBoundsException: 148*/
                                    gapNew[-D]=0;
                                }
                                p.setResidueGap(gapNew);
                            }
                            strapEvtDispatch(EVT_RESIDUES|SEVTMS*1);
                            if(hasCalpha(p)) strapEvtDispatch(EVT_ATOM_XYZ|SEVTMS*1);
                        }
                        success=true;
                        if(sze(fNeu)>0) p.setFile(fNeu);
                    }
                    if(success) count++;
                }
            }
            if(count>0)fileChooserRescan();
            if(sze(sbCopy)>0) loadTheProteinsInListAliPanel(LOADP_PROCESS_LOADED_P|LOADP_EV_PP_ADDED,sbCopy);
            if(sze(sbError)>0) sbError.special(BA_ERROR);
            setTxt(new BA(99).aPlrl(count,copy?"Copied %N sequence%S.":"Renamed %N sequence%S."),_labInfo);
            setFG(0x00FF00,_labInfo);
            strapEvtDispatch(EVT_SEQUENCE_RENAMED|SEVTMS*111);
            strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
            setTxt(s(_jTextArea),_jTextArea);
            //runCR1(_RUN_DialogRenameSeqs_insTxt,this,null);
        }
        BREAK;
    }/*X RUN_M_actionPerformed*/
    CASE_ARG(RUN_SET_SEQUENCES,Protein[],pp){
        clr(_mapPrevious);
        for(Protein p:(_pp=pp)) if(p!=null) _mapPrevious.put(p,s(p));
        runCR1(_RUN_DialogRenameSeqs_insTxt,this,null);
        RETURN TRUEr;
    }
    CASE_ARG(RUN_DialogRenameSeqs_SET_RECT,Object,rect){
        _rect=rect;
        runCR1(_RUN_DialogRenameSeqs_insTxt,this,null);
        _rect=null;
        BREAK;
    } /*X int[]*/
    CASE_ARG(RUN_SET_RESSEL,Object,residueSelections){
        runCR1(RUN_SET_SEQUENCES,this,spp(_ressel=residueSelections));
        runCR1(_RUN_DialogRenameSeqs_insTxt,this,null);
        _ressel=null;
        BREAK;
    }
    CASE_ARG(_RUN_DialogRenameSeqs_insTxt,Object,type)
        CASE_ARG(_RUN_DialogRenameSeqs_insTxt_RESET,Object,type)
        CASE_ARG(_RUN_DialogRenameSeqs_insTxt_RESET_ORIG,Object,type){
        final BA sb=new BA(999);
        sortVisibleOrder(_pp);
        final int max=maxi(sze(nam(longestName(_pp))),CPP_STRLEN(COL0));
        for(Protein p:_pp){
            if(p!=null){
                int rangeF=MAX_INT,rangeT=0;
                ROFi0(sze(_ressel)){
                    final ResidueSelection s=(ResidueSelection)iThEl(i,_ressel);
                    if(s!=null){
                        rangeF=mini(rangeF,resSelFirstAmino(s))+1;
                        rangeT=maxi(rangeT,resSelLastAmino(s)+1);
                    }
                }
                if(_rect!=null){
                    rangeF=firstResIdx(p)+p.columnToIndex(CTRUE,x(_rect))+1;
                    rangeT=firstResIdx(p)+p.columnToIndex(CFALSE,x(_rect)+wdth(_rect)-1)+1;
                }
                final String
                    n=s(p),
                    neu=
                    rangeF<rangeT?s(new BA(99).aWithoutLstCmpnt('!',n).a('!').aFromDashTo(rangeF,rangeT)):
                    id==_RUN_DialogRenameSeqs_insTxt_RESET_ORIG?orS(p.getProperty(PROTEINO_ORIGINAL_NAME),n):
                    id==_RUN_DialogRenameSeqs_insTxt_RESET?(String)_mapPrevious.get(p):
                    type==null?n:
                    delPfx("UNIPROT_",fstTkn(type));
                sb.aLeadingSpc(n,max+1).a("  ").or(p.rplcVars(true,neu),neu).a('\n');
            }
        }
        setTxt(sb,_jTextArea);
        setTxt(tmp().an(' ',max+1-CPP_STRLEN(COL0)).a(COL0+"  New sequence name"),setBG(DEFAULT_BACKGROUND,_taHeader));
        BREAK;
    }
 }

#undef PRFX_PREV
#undef tmp
#undef COL0
#undef _mapPrevious
#undef _taHeader
#undef _ressel
#undef _cutTermini
#undef _labInfo
#undef _rect
