@*H THIS_CLASS(DIA_RESAN_CHANGE)
 This dialog  allows to perform string replacements in many residue annotations.<BR><BR>

 The dialog acts on all selected residue selections.
 If none is selected then  all residue annotations of all sequences are considered.
 The annotation type like "Remark" or "Note" needs to be specified in the choice menu.
 All residue selections with annotations of the selected type appear in the preview table.

 <BR><BR>The user can enter a text pattern and the replacement text. The effect is observe in the preview table.

 <BR><BR>The changes are committed by one of three buttons.
 <i>HTMLDOC_BUTTON:SBUTS_DIA_RESAN_CHANGE_Rplc</i>
 <i>HTMLDOC_BUTTON:SBUTS_DIA_RESAN_CHANGE_Add</i>
 <i>HTMLDOC_BUTTON:SBUTS_DIA_RESAN_CHANGE_Kill</i>.

 <BR><BR>

 WIKI:Regular_expressions: Groups are captured with parenthesis which are not preceded by backslash.
 The first captured group is referenced by $1-number.
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(AddAnnotation)</i>
*@
#define DIA_RESAN_CHANGE_DATA1 5
#define COL_RESAN_TITLE 0
#define COL_ENTRY_TYPE 1
#define COL_ENTRY_VALUE 2
#define COL_REPLACED 3
#define NO_MATCH "    No match\n"
/* --- */
#define BB_comboKeys 1
#define BB_comboNum 2
#define BB_jTable1 3
/* --- */
#define _resanChangeData2 _v
#define _resanChangeNum _resultNum
#define _resanChangeData1 _data
#define _comboKeys _bb[BB_comboKeys]
#define _comboNum _bb[BB_comboNum]
#define _jTable2 _jt
@*SARRAYeq_DialogResidueAnnotationChanges_COLUMN_TITLE
 Residue Selection=COL_RESAN_TITLE Annotation type=COL_ENTRY_TYPE Original String=COL_ENTRY_VALUE
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        (_resanChangeData1=new String[2][1+DIA_RESAN_CHANGE_DATA1])[0][0]="Search pattern";
        _resanChangeData1[1][0]="Replace by";
        _resanChangeData2=new ArrayList();
        {setSelO(iConst(SARRAYeq_RESAN_KEYS,IRESAN_NAME),_comboKeys=addActLi(this,new ChJCombo(JLIST_CLASS_RENDERER,strapInstance(LSTMDL_RESSEL_KEYS_ALL))));}
        final String[]num=new String[DIA_RESAN_CHANGE_DATA1];
        ROFi0(DIA_RESAN_CHANGE_DATA1) num[i]=plrl(i+1,"%N Replacement%S");
        _jTable2=new ChJTable(JLIST_DEFAULT_RENDERER,new ChTableModel(0,null,_resanChangeData2));
        final Object
            t1=_bb[BB_jTable1]=addActLi(this,new ChJTable(JLIST_DEFAULT_RENDERER,new ChTableModel(0,null,_resanChangeData1).editable(0xFFFe))),
            north=pnl(VBHB,
                      //dialogHead(this),
                      pnl(HB,"Specify the annotation type:  ",_comboKeys),
                      setFG(0xFF0000,_bb[SBUTS_DIA_RESAN_CHANGE_Label]),
                      " ",
                      "Enter the string pattern and replacement text: (Tabulator key for auto completion)",
                      ((ChJTable)t1).getTableHeader(),addActLi(this,pcp(KOPT_NO_ICON,"",t1)),
                      " ",
                      pnl(HBL,"Preview of replacement")),
            advanced=pnl(VBHB,
                         pnl(HBL,"Several subsequent replacements: ",_comboNum=new ChJCombo(num,this)),_bb[STOGS_DIA_RESAN_CHANGE_Regexpr],
                         pnl(HBL,"Select rows in the preview table by string match ",newButtonOpenDialogStringMatch(DIA_MATCH_FROM_RENDERER_COMPONENT,new Object[]{wref(_jTable2)},"resCh"))),
            south=pnl(VB,
                      pnl(
                          "Act on all or on all selected rows of the preview table: ",
                          _bb[SBUTS_DIA_RESAN_CHANGE_List_Matching],
                          _bb[SBUTS_DIA_RESAN_CHANGE_Rplc],
                          " ",_bb[SBUTS_DIA_RESAN_CHANGE_Add],
                          " ",_bb[SBUTS_DIA_RESAN_CHANGE_Kill]),
                      " ",
                      pnlTogglOpts(advanced),
                      advanced);
        runCR(RUN_DIA_RESAN_CHANGES_GO,this);
        // remainSpcS(this,pnl(CNSEW,scrllpn(0,addLi(this,LSTNR_MO|LSTNR_ACT,this,pcp(KOPT_NO_ICON,"",_jTable2))),north,south));
        remainSpcS(this,pnl(CNSEW,scrllpn(0,addLi(this,LSTNR_MO|LSTNR_ACT,_jTable2)),north,south));
        ((ChJTable)t1).setRowSelectionAllowed(false);
        runCR1(RUN_DIA_RESAN_CHANGES_SET_NUM,this,io(1));
        addSrvc(RUN_SERVICE_PAINTHOOK,this,this);
        return pnl(CNSEW,scrllpn(0,addLi(this,LSTNR_MO|LSTNR_ACT,pcp(KOPT_NO_ICON,"",_jTable2))),north,south);
    }
    CASE_ARG(RUN_DIA_RESAN_CHANGES_SET_NUM,Object,num){
        _resanChangeNum=xatoi(num);
        final ChJTable t1=(ChJTable)_bb[BB_jTable1];
        {
            final String[]h1=new String[_resanChangeNum+1],h2=chSze(arry(SARRAYeq_DialogResidueAnnotationChanges_COLUMN_TITLE),_resanChangeNum+COL_REPLACED,String.class);
            ROFi0(_resanChangeNum){
                h1[i+1]=plrl(i+1,"Replacement No %n");
                h2[i+COL_REPLACED]=plrl(i+1,"After Replacement %n");
            }
            runCR1(RUN_TABLEMODEL_setColumnNames,t1.getModel(),h1);
            runCR1(RUN_TABLEMODEL_setColumnNames,_jTable2.getModel(),h2);
        }
        t1.createDefaultColumnsFromModel();
        _jTable2.createDefaultColumnsFromModel();
        t1.setColWidth(EM*15,0);
        _jTable2.setColWidth(EM*15,TABLE_COLUMN_RESIZABLE|0);
        _jTable2.setColWidth(EM*15,TABLE_COLUMN_RESIZABLE|1);
        awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,t1);
        awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_jTable2);
        break;
    }
    CASE_ARGV(RUN_DIA_RESAN_CHANGES_GO){
        _needsUpdate=false;
        final String key=s(_comboKeys);
        if(sze(key)>0){
            final Collection vWC=new HashSet();
            ResidueAnnotation[]aa=(ResidueAnnotation[])selectedResidueSelections(SOBJECT_RESAN);
            if(aa.length==0){
                final Collection v=new ArrayList(1000);
                for(Protein p:strapProteins()) adAll(p.residueAnnotations(),v);
                aa=toArry(v,ResidueAnnotation.NONE);
            }
            clr(_resanChangeData2);
            final boolean regex=isSlct(_bb[STOGS_DIA_RESAN_CHANGE_Regexpr]);
            int countKey=0;
            for(ResidueAnnotation s:aa){
                for(ResidueAnnotation.Entry e: s.entries()){
                    if(!key.equals(e.key())) continue;
                    countKey++;
                    String haystack=e.value();
                    if(haystack==null) continue;
                    final Object[]row=new Object[COL_REPLACED+_resanChangeNum];
                    row[COL_RESAN_TITLE]=s;
                    row[COL_ENTRY_TYPE]=e;
                    row[COL_ENTRY_VALUE]=haystack;
                    //                    String[]tt=(String[])mapSplit.get(e.value());
                    //if (tt==null) mapSplit.put(e.value(),tt=splitTkns(e.value()));
                    //for(String t:tt) if(isChrClas(LETTR_DIGT,t,0)) vWC.add(t);
                    vWC.add(e);
                    {
                        boolean match=false,noNeedle=true;
                        FORr(0,_resanChangeNum){
                            final String needle=(String)_resanChangeData1[0][1+r];
                            String result=null;
                            if(sze(needle)>0){
                                final String replacement=toStrgN(_resanChangeData1[1][1+r]);
                                noNeedle=false;
                                if(regex){
                                    try{
                                        if(regexPattern(needle).matcher(haystack).find()){
                                            result=s(regexReplace(regexPattern(needle),replacement,haystack));
                                            match=true;
                                        }
                                    }catch(Exception ex){setTxt(new BA(99).aa("Error on processing regexpr. ",needle,' ',ex),_bb[SBUTS_DIA_RESAN_CHANGE_Label]);}
                                }else if(strstr(0,needle,haystack)>=0){
                                    result=s(strplc(0,needle,replacement,haystack));
                                    match=true;
                                }
                            }
                            if(result==null) break;
                            row[r+COL_REPLACED]=haystack=result;
                        }
                        if(match || noNeedle) _resanChangeData2.add(row);
                    }
                }
            }
            setTxt(aa.length==0?"Error: no residue annotations found!":
                   countKey==0?new BA(99).aPlrl(aa.length,"Error: none of the %N residue annotation%S has an entry  ").aa(key,' '):
                   "",_bb[SBUTS_DIA_RESAN_CHANGE_Label]);
            awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_jTable2);
            tcTools(((ChJTable)_bb[BB_jTable1]).getChRenderer().getRndrerTextfield()).enableWordCompletion(vWC.toArray());
        }
        final int k=resanKeyToUniqIdx(strM(STR_INTERN_RESAN_KEY,s(_comboKeys)));
        if(IRESAN_POS==k || IRESAN_NAME==k || IRESAN_GROUP==k){
            awtc(AWTC_SET_DISABLED,_bb[SBUTS_DIA_RESAN_CHANGE_Kill]);
            awtc(AWTC_SET_DISABLED,_bb[SBUTS_DIA_RESAN_CHANGE_Add]);
        }else{
            awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_RESAN_CHANGE_Kill]);
            awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_RESAN_CHANGE_Add]);
        }
        break;
    }
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        if((evtType[0]&SEVT_MASK)==EVT_OBJECTS_SELECTED){
            _needsUpdate=true;
            awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_400,this);
        }
        return TRUEr;
    }
    CASE_ARG(RUN_PAINT_HOOK_AFTER,Object,component){
        if(_needsUpdate) runCR(RUN_DIA_RESAN_CHANGES_GO,this);
        BREAK;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==BB_comboNum) runCR1(RUN_DIA_RESAN_CHANGES_SET_NUM,this,io(getSlctIdx(_comboNum)+1));
        if(bid==STOGS_DIA_RESAN_CHANGE_Regexpr || bid==BB_comboKeys || bid==BB_jTable1) runCR(RUN_DIA_RESAN_CHANGES_GO,this);
        if(bid==SBUTS_DIA_RESAN_CHANGE_Rplc || bid==SBUTS_DIA_RESAN_CHANGE_Add || bid==SBUTS_DIA_RESAN_CHANGE_Kill || bid==SBUTS_DIA_RESAN_CHANGE_List_Matching){
            jTableStopCellEditing();
            final int[]ii=((ChJTable)_jTable2).getSelectedRows();
            final Object[][]data=toArry(_resanChangeData2,Object[].class);
            boolean changed=false;
            final BA sb=new BA(9999);
            Object aPrev=null,pPrev=null;
            FORr(0,data.length){
                if(!ARRAY_EMPTY(ii) && idxOf(r,ii)<0) continue;
                final Object[]oo=data[r];
                final ResidueAnnotation a=(ResidueAnnotation)oo[0];
                final ResidueAnnotation.Entry e=(ResidueAnnotation.Entry)oo[1];
                if(bid==SBUTS_DIA_RESAN_CHANGE_Kill){
                    a.resanRemoveE(e);
                    changed=true;
                }else{
                    if(bid==SBUTS_DIA_RESAN_CHANGE_List_Matching){
                        if(sp(a)!=pPrev) sb.aa("\n"+ANSI_FG_WHITE+ANSI_BLACK,pPrev=sp(a),ANSI_RESET);
                        if(aPrev!=a) sb.aln().a("  ").aAnsiRGB(true,rgba(getColr(a),RGBA_FOR_NULL)).aa("  "+ANSI_RESET,runCR1(RUN_GET_RENDERER_TXT,aPrev=a,NULL_AS_INT),ANSI_RESET,' ',NO_MATCH);
                    }
                    String newValue=null;
                    for(int i=mini(_resanChangeNum,oo.length-COL_REPLACED); sze(newValue)==0 && --i>=0;) newValue=(String)oo[i+COL_REPLACED];
                    if(newValue!=null && !newValue.equals(e.value())){
                        if(bid==SBUTS_DIA_RESAN_CHANGE_List_Matching) sb.del(NO_MATCH).aa("\n      ",e.key(),":  ",e.value(),"  =>  ",newValue).aln();
                        else if(bid==SBUTS_DIA_RESAN_CHANGE_Add)  a.addE(RESAN_ENTRY_EDITED,e.key(),newValue);
                        else if(bid==SBUTS_DIA_RESAN_CHANGE_Rplc) a.resanSetE(RESAN_ENTRY_EDITED,newValue,e);
                        changed=true;
                    }
                }
            }
            if(bid==SBUTS_DIA_RESAN_CHANGE_List_Matching) runCR1(RUN_SHOW_IN_FRAME,undrlneRefs(ULREFS_NOT_CLICKABLE|ULREFS_WEB_COLORS,new ChTextView(sb)),NULL_AS_INT);
            if(changed) strapEvtDispatch(EVT_RESIDUE_SELECTION);
        }
        BREAK;
    }
 }
if(evtIsPopupTrggr(arg)){
    final Object o=objectAt(null,arg);
    strapJPopupMenu(SOBJECT_RESAN,derefResan(o instanceof ResidueAnnotation.Entry?((ResidueAnnotation.Entry)o)._a:o),NO_Object);
 }
#undef COL_RESAN_TITLE
#undef COL_ENTRY_TYPE
#undef COL_ENTRY_VALUE
#undef COL_REPLACED
#undef NO_MATCH
#undef _comboKeys
#undef _comboNum
#undef _jTable2
#undef BB_comboKeys
#undef BB_comboNum
#undef BB_jTable1
