/* --- */
#define NUM_AA 0
#define NUM_NUC 1
#define NUM_PDB 2
/* --- */

@*H THIS_CLASS(DIA_RESAN_LIST)
 This dialog allows to create residue annotations from  lists of the  form
 <PRE class="data">
 E815R  G4711A  C4444Q
 </PRE>
 or
 <PRE class="data">
 Glu815Arg  Gly4711Ala  Cys4444Gln
 </PRE>

 These items may be mutations or SNPs or residue lists from crystallographic papers.

 Each item should contain a number which is interpreted as a sequence position or a PDB-residue number.

 <BR>
 <BR>
 <U>Related resources</U> http://www.mutdb.org http://gila.bioengr.uic.edu/snp/toposnp/
 <BR>
 <i>HTMLDOC_SEE_CLASS:BUT_C1(ResidueAnnotation)</i>
 <i>HTMLDOC_SEE_CLASS:BUT_C1(AddAnnotation)</i>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogResidueAnnotationChanges)</i>

*@
@*SARRAYeq_DIA_RESAN_LIST_SEQ_TYPES
 Indices of amino acids=NUM_AA
 Indices of nucleotide=NUM_NUC
 Residue numbers in PDB files=NUM_PDB
*@
@*RSC_DialogResidueAnnotationList_MSG_DISCREPANCIES
 There are possibly discrepancies between the residues in the sequence and the designations of the mutations.
 Please check:
*@
/*(NUM1 1)*/
#define _tfGroup _bb[1]
#define _tfOffset _bb[2]
#define _choiceNumbering _bb[3]
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        final Object
            south=pnl("#",
                      newBut(SBUTS_DIALOGS_NEWBIES_EXAMPLE,this),
                      " ",
                      setTip("Creates a selection for each token in the text area",newBut(BUTS_GO,this)),
                      "#",
                      REMAINING_VSPC1),
            north=pnl(VBHB,
                      dialogHead(this),
                      pnl(HB,"Sequence:  ",_choiceSequence=newProteinCombo(0),"  Residue numbering: ",_choiceNumbering=new ChJCombo(arry(SARRAYeq_DIA_RESAN_LIST_SEQ_TYPES))),
                      pnl(HBL,"Index offset:  ",_tfOffset=new ChTextField("0").cols(TF_CONTENTTYPE_INT|4)," (Negative values shift the residue selections to the left, positive values to the right.)"),
                      pnl(HBL,"Group (Short free text):  ",_tfGroup=new ChTextField("mutations").cols(TF_NOT_MINIMUMSIZE|30)));
        pnl(this,CNSEW,scrllpn(SCRLLPN_INHERIT_SIZE,pcp(KEY_IF_EMPTY,"Enter a list of mutations such as E33A Lys144Glu ...",_jTextArea=new ChTextArea("\n\n\n"))),north,south);
        tcTools(_jTextArea).enableUndo(true);
        break;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        if(bid==SBUTS_DIALOGS_NEWBIES_EXAMPLE) setTxt(new BA(999).aln("E33Q L44I M55C").a(_jTextArea),_jTextArea);
        if(bid==BUTS_GO){
            String err=null;
            final Protein p=sp(_choiceSequence);
            final int iType=getSlctIdx(_choiceNumbering);
            if(p==null) err="No sequence selected\n";
            else if(iType==NUM_PDB && !p.isProteinStructure()) err="No PDB residue numbers found.\n";
            else if(iType==NUM_NUC && !p.isTranslated()) err="No nucleotides found\n";
            else{
                final String[]tokens=splitTkns(0,s(_jTextArea),0,MAX_INT,chrClas(SPACE_COMMA));
                if(ARRAY_EMPTY(tokens)) baLog(LOG_MSG).a(RED_ERROR).aln("Enter some tokens like E33Q or L44I");
                else{
                    final ResidueAnnotation[]vNewRA=new ResidueAnnotation[tokens.length];
                    int count=0;
                    final Collection v=new HashSet();
                    for(String t:tokens){
                        if(v.add(t)){
                            ResidueAnnotation s=null;
                            final int dgt=nxt(0,chrClas(DIGT),t);
                            if(dgt>=0){
                                final String idx=s(atoi(t,dgt)+xatoi(_tfOffset));
                                (s=new ResidueAnnotation(p)).annoAdd(IRESAN_NAME,t);
                                s.annoAdd(iType==NUM_NUC?RESAN_ENTRY_NT|IRESAN_POS:IRESAN_POS,iType==NUM_PDB?new BA(99).aa(idx,':'):idx);
                            }else{
                                final int open=t.indexOf('['),close=t.indexOf(']');
                                if(open>0 && open+2==t.indexOf('/') && t.indexOf('/')<close){
                                    final byte[]seq=new BA(999).aFT(t,0,open).a(t.charAt(open+1)).aFT(t,close+1,MAX_INT).bytes(),trans=p.triplets();
                                    final int
                                        iNT=strstr(STR_IC,seq,p.getNucleotides()),
                                        iTrans=iNT<0?strstr(STR_IC,seq,trans,0,strLen(trans)):-1,
                                        ia=strstr(STR_IC,seq,p.getResType());
                                    if(iNT>=0||iTrans>=0||ia>=0){
                                        s=new ResidueAnnotation(p);
                                        final int pos=iNT>=0?iNT:iTrans>=0?iTrans/3:ia;
                                        s.annoAdd(IRESAN_NAME,new BA(99).a(pos+1).aFT(t,open+1,close))
                                            .annoAdd(iType==NUM_NUC?RESAN_ENTRY_NT|IRESAN_POS:IRESAN_POS,io(pos+open+1))
                                            .annoAdd(IRESAN_REMARK,t);
                                    }
                                }
                            }
                            if(s!=null){
                                s.annoAdd(IRESAN_GROUP,s(_tfGroup));
                                s.annoAdd(IRESAN_TEXSHADE,"\\feature{bottom}{$TEX_PROTEIN}{$TEX_RESIDUES}{fill:$\\uparrow$}{$SELECTION_NAME}");
                                s.annoAdd(IRESAN_VIEW3D,V3DCMD_spheres);
                                s.setStyle(SSTYLE_LOWER_HALF);
                                for(ResidueAnnotation a:p.residueAnnotations()) if(resSelEqualsA(a,s)) {s=null;break;}
                            }
                        if(s!=null) vNewRA[count++]=s;
                        }
                    }
                    final ResidueAnnotation[]aa=mayBeAddResidueAnnotations(vNewRA);
                    final BA sb=new BA(99);
                    int num=0;
                    for(ResidueAnnotation s:aa){
                        final String name=s.getName();
                        final int iDigit=nxt(0,chrClas(DIGT),name);
                        if(NUM_NUC!=getSlctIdx(_choiceNumbering)){
                            final int ia=fstTrue(s.getSelectedAminoacids())+s.getSelectedAminoacidsOffset()-firstResIdx(p);
                            int ss=p.getResTypeAt(ia);
                            if(iDigit==1 && ss>0){
                                ss&=~32;
                                final int c0=name.charAt(0)&~32;
                                if(ss!=c0) sb.aa(num++==0?rsc(RSC_DialogResidueAnnotationList_MSG_DISCREPANCIES):null,' ',name,": residue at ",1+ia," is ",(char)ss).aln();
                            }
                            if(iDigit==3){
                                final int c=toOneLetterCode((name.charAt(0)&~32)|((name.charAt(1)&~32)<<8)|((name.charAt(2)&~32)<<16));
                                if(c!=0 && c!='X' && c!=ss){
                                    if(num++==0) sb.a(rsc(RSC_DialogResidueAnnotationList_MSG_DISCREPANCIES));
                                    sb.aa(name,": residue at ",ia," is ",(char)ss,' ').aBytes(toThreeLetterCode(ss)).aln();
                                }
                            }
                        }else{
                            final int iNt=fstTrue(s.getSelectedNucleotides())+s.getSelectedNucleotidesOffset(),nt=iThByte(iNt,p.getNucleotides())&~32;
                            if(nt>0 && iDigit==1 && (name.charAt(0)&~32)!=nt){
                                    if(num++==0) sb.a(rsc(RSC_DialogResidueAnnotationList_MSG_DISCREPANCIES));
                                    sb.aa(name,": nucleotide at ",1+iNt," is ",(char)nt).aln();
                            }
                        }
                    }

                    showInJListCreatedResan(aa,sb);
                }
            }
            baLog(LOG_MSG).and(RED_ERROR,err);
        }
        BREAK;
    }
 }

#undef NUM_AA
#undef NUM_NUC
#undef NUM_PDB
#undef _tfOffset
#undef _choiceNumbering
#undef _tfGroup
