/*(NUM1 1)*/
#define DIA_RESTORE_BACKUP_JLIST 1
@*H THIS_CLASS(DIA_RESTORE_BACKUP)
 A backup of the multiple sequence alignment data can be written to the
 directory ./backup/.

 The files in the backup-directory contain the gaps, the annotations to
 amino acid and nucleotide positions, the nucleotide frame-shift and
 the 3D-rotation and 3D-translation.

 Using the dialog <i>HTMLDOC_ITEM:BUT_C1(DialogRestoreFromBackup)</i>, the saved
 information is loaded by pressing
 <i>HTMLDOC_BUTTON:BUTS_GO</i>.
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        final Object tools=pnl(VBHB,pnl(HBL,"File directory: ",iFile(DIR_STRAP_BACKUP)),_bb[SBUTS_DIA_RESTORE_BACKUP_Delete]);
        _bb[DIA_RESTORE_BACKUP_JLIST]=new ChJList(0,new ArrayList());
        runCR(_RUN_DIA_RESTORE_BACKUP_Update,this);
        return pnl(CNSEW,scrllpn(0,_bb[DIA_RESTORE_BACKUP_JLIST]),
                   pnl(VBHB,dialogHead(this),"Select a backup. The date format is Year_Month_Day_Hour_Minute"),
                   pnl(VBPNL,
                       pnl(HBL,"Select the sequence to be restored. Then push the button ",newBut(BUTS_GO,this)),
                       pnlTogglOpts(TOGGL_PNL_Tools,tools),
                       tools),
                   pnl(VB,buttn(STOG_RESTOREBACKUP_Gaps),buttn(STOG_RESTOREBACKUP_Anno),buttn(STOG_RESTOREBACKUP_Trans3D),buttn(STOG_RESTOREBACKUP_CDS)));

    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        baLog(LOG_MSG).send();
        if(bid==BUTS_GO || bid==SBUTS_DIA_RESTORE_BACKUP_Delete){
            final int i=getSlctIdx(_bb[DIA_RESTORE_BACKUP_JLIST]);
            final Object v=runCR(RUN_CHJLIST_GET_ARRAYLIST,_bb[DIA_RESTORE_BACKUP_JLIST]);
            final File dir=i<0?null: newFile(iFile(DIR_STRAP_BACKUP),xiThEl(i,v));
            if(dir==null) baLog(LOG_MSG).a(RED_ERROR).aln("A backup folder must be selected");
            else{
                if(bid==BUTS_GO){
                    Protein[]pp=selectedProteins();
                    if(sze(pp)==0){
                        if(!dlgYesNo("No sequence is selected. Do you want to restore all sequences?"))return null;
                        pp=strapProteins();
                    }
                    int what=-1;
                    if(!isCbSlct(STOG_RESTOREBACKUP_CDS)) what&=~SEQ_ATTRIBUTE_CDS;
                    if(!isCbSlct(STOG_RESTOREBACKUP_Gaps)) what&=~SEQ_ATTRIBUTE_GAPS;
                    if(!isCbSlct(STOG_RESTOREBACKUP_Trans3D)) what&=~SEQ_ATTRIBUTE_TRANS3D;
                    if(!isCbSlct(STOG_RESTOREBACKUP_Anno)) what&=~SEQ_ATTRIBUTE_ANNO;
                    for(Protein p:pp) readAttributes(what,p,dir);
                    setNotSaved();
                    strapEvtDispatch(EVT_NUCL_TRANSLATION|SEVTMS*111);
                    strapEvtDispatch(EVT_ALIGNMENT|SEVTMS*111);
                }
                if(bid==SBUTS_DIA_RESTORE_BACKUP_Delete && dlgYesNo(new BA(99).aa("Really delete ",dir))){
                    fileDel(DEL_FILE_TREE,dir);
                    runCR(_RUN_DIA_RESTORE_BACKUP_Update,this);
                }
            }
        }
        BREAK;
    }
    CASE_ARGV(_RUN_DIA_RESTORE_BACKUP_Update){
        final Collection v=(Collection)runCR(RUN_CHJLIST_GET_ARRAYLIST,_bb[DIA_RESTORE_BACKUP_JLIST]);
        adAll(lstDir(iFile(DIR_STRAP_BACKUP)),clr(v));
        sortArry(v,null);
        amsDo(AMS_CONTENT_CHANGED,111,_bb[DIA_RESTORE_BACKUP_JLIST],null);
        BREAK;
    }
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        if(evtType[0]==EVT_BACKUP_WRITTEN) runCR(_RUN_DIA_RESTORE_BACKUP_Update,this);
        return TRUEr;
    }
 }
#undef DIA_RESTORE_BACKUP_JLIST
