@*H THIS_CLASS(DIA_SELECTION_OF_RESIDUES)
 Residues selections are computed by a method chosen by the user.
 The selected residues will be shown in the alignment pane,
  the  horizontal scroll-bar and all 3d-backbones.
*@
@*SARRAYeq_HELIX_US_SHEET_US
 Helix_=ASCII_H Sheet_=ASCII_E
 Secondary_structure=ASCII_G
*@

switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        final Object more=pnl(VBHB,
                              pnl(HBL,_bb[SBUTS_DIA_SELECTION_OF_RESIDUES_From_Secstru]),
                              setIcn(IC_UNDERLINE,buttn(M_P_HL_DIFF)),
                              " ","Intron / Exon boundaries: See context menu",
                              " ",pnl(HBL,"Dialogs, optionally selecting residues: ",buttn(BUT_C1(DialogBlast)),buttn(BUT_C1(DialogAlignOneToAll))));
        return pnl(VBHB,
                   getPnl(_choiceClass=classChoice(INTRFC_ResidueSelection)),
                   newBut(BUTS_GO,this),
                   pnlTogglOpts(TOGGL_PNL_More,more),
                   more);
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==BUTS_GO){
            final Object c=instanceOfSelectedClass(MKINSTANCE_SHOW_ERROR,_choiceClass);
            if(c instanceof ResidueSelection){
                //adTab(CLOSE_DISPOSE,shrtClasNamOrAlias(c),new TabSelectionOfResidues(c,selItemJC(_choiceClass)),_tabbed);
                final SDialogs tab=new SDialogs(TAB_SELECTION_OF_RESIDUES);
                tab._bb[TAB_SELECTION_OF_RESIDUES_class]=_choiceClass;
                tab._sharedInstance=c;
                runCR(RUN_INIT_DIALOG,tab);
                adTab(CLOSE_DISPOSE,shrtClasNamOrAlias(c),tab,_tabbed);
            }

        }
        if(bid==SBUTS_DIA_SELECTION_OF_RESIDUES_From_Secstru){
            Protein[]pp=selectedProteins();
            if(pp.length==0) pp=strapProteins();
            final Collection<ResidueSelection>v=new ArrayList();
            for(Protein p:pp){
                final byte[]ss=p==null?null:p.getResidueSecStrType();
                if(ss==null) continue;
                FORt('E','H'+1){
                    if(iConst(SARRAYeq_HELIX_US_SHEET_US,t)==null) continue;
                    for(ResidueAnnotation s:p.residueAnnotations()){
                        if(iConst(SARRAYeq_HELIX_US_SHEET_US,ASCII_G).equals(s.value(IRESAN_GROUP))&&
                            // && cntainsOnly(DIGT,s.getName(),iConst(SARRAYeq_HELIX_US_SHEET_US,t).length(),MAX_INT))
                            nam(s).startsWith(iConst(SARRAYeq_HELIX_US_SHEET_US,t)) && 0>nxt(0,chrClas(-DIGT),nam(s),iConst(SARRAYeq_HELIX_US_SHEET_US,t).length(),MAX_INT)){
                            dispos(s);
                        }
                    }
                    final int first=firstResIdx(p),nR=p.countRes();
                    int count=0;
                    FORi(0,nR){
                        final int aFL=i+p.subsetStart();
                        if(aFL>=ss.length) break;
                        if(ss[aFL]==t){
                            final int from=i;
                            while(++i<nR && ss[aFL]==t){}
                            v.add(annotateSeqStyleRgbPosNameGrp(p,SSTYLE_LOWER_HALF|SFLAG_NO_SAVE,t=='H'?0xFF0000:0xFFff00,new int[]{first+1+from,first+i},iConst(SARRAYeq_HELIX_US_SHEET_US,t)+ ++count,iConst(SARRAYeq_HELIX_US_SHEET_US,ASCII_G))
                                  .annoAdd(IRESAN_BG_IMAGE,"prediction_"+(char)t));
                        }
                    }
                }
            }
            if(sze(v)==0) error(pp.length==0?"No sequence": "No secondary structure");
            else{
                strapEvtDispatch(EVT_RESIDUE_SELECTION);
                showInJListCreatedResan(oo(v),null);
            }
        }
        BREAK;
    }
 }
