@*H THIS_CLASS(DIA_SIMILAR_STRUCTURE)
 Proteins loaded from sequence files like Uniprot or Genpept files lack 3D-information and cannot be visualized three-dimensionally.

 With this dialog  similar structures for given sequences can be identified.

 Only if a suitable 3D model exist, the 3D-coordinates can be assigned and the protein can be visualized in 3D.

 <BR><BR>The search result is presented in a table.
 Each table row represents one protein. It shows candidates of matching PDB-IDs.

 The location of the hit relative to the query sequence is shown graphically as a gray bar.

 <BR>To infer the proposed 3D-coordinates
 the user needs to press the button BUT_LABEL_ASSOCIATE in the last table column.

 Those amino acids in the amino acid sequence that inherited xyz-3D-coordinates will be written as an upper case
 letter. Residues without 3D-coordinates are shown as lower case letter.

 Amino acid positions where the residue type of the 3D model differs are marked.

 <BR><BR>The associated 3D-structure can be dissociated using the context menu of the protein.

 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogBlast)</i>
 <i>HTMLDOC_INCLUDE_DOC2:BUT_C1(SequenceBlaster)</i>
*@
@*~RSC_DialogSimilarStructure_EXPLAIN_SYNTAX
 CPP_HASH Type PDB-IDs. Use the following syntax:
 CPP_HASH CPP_UNSTRINGIZE(SCRIPT_project_XYZ) PDB-ID_chainChar, sequence-name
 CPP_HASH Peptide-chain character is optional. Upper/lower case does not matter. Example:
 CPP_HASH CPP_UNSTRINGIZE(SCRIPT_project_XYZ) 1NED, HSLV_ECOLI
*@
#define VARS_DIA_SIMILAR_STRUCTURE private static ChRunnable _diaSimStruScrPnl
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        final Object
            details=pnl(VBHB,buttn(TOG_CACHE)," ",_bb[SBUTS_DIA_SIMILAR_STRUCTURE_Manually]),
            left=pnl(VBHB,"Search homologous structures ",newBut(BUTS_GO,this),pnlTogglOpts(details),details);
        pnl(this,CNSEW,scrllpn(SCRLLPN_INHERIT_SIZE,_jlistSequences=newProteinJlist(IF_NO_3D_FILE)),null,null,null,pnl(CNSEW,null,left));
        break;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        if(bid==SBUTS_DIA_SIMILAR_STRUCTURE_Manually||bid==BUTS_GO){
            final Protein[]pp=proteinsThatComply(IF_NO_3D_FILE,spp(_jlistSequences));
            // Protein[]pp=spp(_jlistSequences).clone();
            // ROFiP0(pp.length){
            //     if(FALSEr==runCR(RUN_IS_OBJECT_ENABLED,_jlistSequences,pp[iP])) pp[iP]=null;
            // }
            // pp=rmNullPP(pp);
            if(pp.length==0) error("Select at least one protein that has not been loaded from a 3D-file!");
            else{
                if(bid==BUTS_GO){
                    if(pp.length<33||dlgYesNo("Are you sure to start the search for similar structures for that many proteins?")) runCR1(RUN_COMPUTE,this,null);
                }else{
                    final BA sb=new BA(999).aln(rsc(RSC_DialogSimilarStructure_EXPLAIN_SYNTAX));
                    if(_diaSimStruScrPnl==null){
                        adMainTab(pnl(GRIDLAYOUT(1,2),
                                      this,
                                      pnl(CNSEW,_diaSimStruScrPnl=newScriptPanel(SCRIPTPNL_NO_SAVE),
                                          pnl(REMAINING_VSPC1),
                                          newBut(BUTS_SCRIPTPNL_RUN_ALL,_diaSimStruScrPnl))),
                                  _tabbed);
                    }
                    for(Protein p:pp) sb.aa(SCRIPT_project_XYZ,p.getPdbID(PDBID_ID),',').aln(p);
                    setTxt(sb,_diaSimStruScrPnl);
                }
            }
        }
        BREAK;
    }
    CASE_ARG(RUN_COMPUTE,Object,unused){
        final SDialogs tab=new SDialogs(TAB_SIMILAR_STRUCTURE);
        tab._opt=gcpi(KEY_OPTIONS,this);
        tab._pp=proteinsThatComply(IF_NO_3D_FILE,spp(_jlistSequences));
        adTab(DISPOSE_CtrlW,plrl(++_resultNum,"%n    "),tab,_tabbed);
        runCR(RUN_INIT_DIALOG,tab);
        pcp(KEY_OPTIONS,null,this);
        break;

    }
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        final int t=evtType[0];
        if(EVT_PROTLABEL_AAA<t && t<EVT_PROTLABEL_ZZZ) awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_200,this);
        return TRUEr;
    }
 }
