@*H THIS_CLASS(DIA_SUPER3D)

The mobile protein and the reference protein[s] are selected by the
user. C&alpha;-Coordinates are required. Either the sequences are loaded from pdb/mmCIF files or the the 3D-coordinates of a homologous sequences had been inferred.

Pressing <i>HTMLDOC_BUTTON:SBUTS_DIA_SUPER3D_Go</i>  finds an optimal  rotation/translation that minimizes
the square root mean distance (RMSD) between C-alpha  atoms of both proteins.
The result is displayed three-dimensionally in a preview panel.

Only after pressing <i>HTMLDOC_BUTTON:SBUTS_TAB_SUPER3D_Apply</i>
this transformation is applied to the mobile protein whereas the
target protein remains unchanged.

<BR><BR><B>For Writing PDB-files in new coordinates:</B> See
<i>HTMLDOC_DIALOG:BUT_C1(DialogExportProteins)</i>.
How do I import an eps file into Word
*@
@*~RSC_DIA_SUPERIMPOSE3D_TOOLTIP_EMPTY
 .<BR>If kept empty all c-Alpha-atoms are taken.<BR>Example: "10-100,120-199"<BR><BR>Residue selections can be copied via Drag-and-Drop.
*@
@*~RSC_DIA_SUPERIMPOSE3D_ERROR_NO_XYZ
Select at least one mobile protein with C-alpha atoms
*@

@*~RSC_DIA_SUPERIMPOSE3D_ERROR_CURSOR
Inserting Cursor-Position: First place the cursor in the alignment pane
*@
@*SARRAYeq_DialogSuperimpose3D_TF_RANGE_EMPTY
 Mobile protein: Residue range like "10-20"=ASCII_M
 Reference protein: Residue range like "10-20"=ASCII_R
 Alignment columns like "10-100"=ASCII_C
*@
/* (NUM1 1)*/
#define DIA_SUPER3D_CHOICE_P_MOBILE 1
#define DIA_SUPER3D_CHOICE_P_REFERENCE 2
#define DIA_SUPER3D_TOG_OPTIONS 3
#define _tfSelectionObject _bb[4]
/* (NUM1 1)*/
#define _tffSelection _ooo[1]
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _v=new ArrayList();
        _tfSelectionObject=new ChTextField['R'+1];
        _bb[DIA_SUPER3D_CHOICE_P_REFERENCE]=newProteinCombo(IF_CALPHA);
        _tffSelection=new Object['Z'];
        _bb[DIA_SUPER3D_CHOICE_P_MOBILE]=addActLi(this,newProteinJlist(IF_CALPHA|NEWPROTEINJLIST_SELECT_ALL));
        {
            final Protein[]pp=strapProteins();
            int iP=0;
            while(iP<pp.length) if(hasCalpha(pp[iP++])) {setSelO(pp[iP-1],_bb[DIA_SUPER3D_CHOICE_P_REFERENCE]);break;}
            while(iP<pp.length) if(hasCalpha(pp[iP++])) {setSelIdx(iP-1,_bb[DIA_SUPER3D_CHOICE_P_MOBILE]);break;}
        }
        final Object[]panSel=new Object['R'+1];
        FORi('C','R'+1){
            if(i=='C'||i=='M'||i=='R'){
                final Object tf=_tffSelection[i]=new ChTextField();
                tcTools(tf).enableUndo(false).saveInFile("DialogSuperimpose3D_tf"+(char)i);
                runCR1(RUN_NEW_DROPTARGET,_main,tf);
                panSel[i]=pnl(CNSEW,tf,null,null,pcp(KEY_DialogSuperimpose3D_CMR,io(i),_bb[SBUTS_DIA_SUPER3D_Insert_cursor]));
                pcp(KEY_IF_EMPTY,iConst(SARRAYeq_DialogSuperimpose3D_TF_RANGE_EMPTY,i),
                    setTip(addPfx(iConst(SARRAYeq_DialogSuperimpose3D_TF_RANGE_EMPTY,i),rsc(RSC_DIA_SUPERIMPOSE3D_TOOLTIP_EMPTY)),tf));
                if(i=='C') pcp(RESSEL_KOPT_DND_COLUMNS,"",tf);

            }
        }
        if(!isMac()) _tabbed.setTabPlacement(TPANE_LEFT);
        final Object pSettings=pnl(VB,getPnl(_choiceClass=classChoice(INTRFC_Superimpose3D|CLASSCHOICE_SHIFT_SAVEPRPRTY(PRPRTY_Superimpose3D_method))),buttn(TOG_CACHE),buttn(TOG_ALI_NOT_COMMUT));
        add(scrllpn(0,pnl(CNSEW,null,
                          pnl(VBPNL,
                              pnl(CNSEW,_bb[DIA_SUPER3D_CHOICE_P_REFERENCE],"<B>Reference protein</B>",panSel['R'],null,BRDR_ETCHED),
                              pnl(HBL,_bb[DIA_SUPER3D_TOG_OPTIONS]=new ChButton(BUTTN_CB,"Options").cp(BUTTN_KEY_COLLAPSE,(new Object[]{pSettings,panSel,_tfSelectionObject})),"#",_bb[SBUTS_DIA_SUPER3D_Go],"#"),
                              pSettings),
                          null,null,pcpKey(KOPT_TRACKS_VIEWPORT_WIDTH))));
        add(pnl(CNSEW,scrllpn(SCRLLPN_INHERIT_SIZE,_bb[DIA_SUPER3D_CHOICE_P_MOBILE]),"<B>Mobile protein[s]</B>",pnl(VB,panSel['M'],panSel['C']),null,BRDR_ETCHED));
        break;
    }
    CASE_ARG(_RUN_DIA_SUPERIMP_ADD_TAB,SDialogs,tab){
        //setTiti(tabText2p(tab._pp[0],tab._pp[1]),null,null,null,getPnl(tab));
        final int idx=_tabbed.getSelectedIndex(),count=_tabbed.getTabCount();
        adTab(0,tabText2p(tab._pp[0],tab._pp[1]),tab,_tabbed);
        if(idx!=0 && idx!=count-1) setSelIdx(idx,_tabbed);
        BREAK;
    }
    CASE_ARG(_RUN_DIA_SUPERIMP_COMPUTING,SDialogs[],tabs){
        pcp(_KOPT_COMPUTING,"",this);
        for(SDialogs tab:tabs){
            if(tab!=null){
                tab._v=_v;
                //tab._aligner=mkInstance(iCLASS_SequenceAligner,_choiceClass);
                runCR(RUN_DIALOG_COMPUTE_BG,tab);
                _v.add(tab);
                thrdCR1(_RUN_DIA_SUPERIMP_ADD_TAB|THRDCR_EDT_LATER,this,tab);
            }
        }
        pcp(_KOPT_COMPUTING,null,this);
        awtc(AWTC_OPT_REVALIDATE,this);
        BREAK;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        baLog(LOG_MSG).send();
        if(bid==DIA_SUPER3D_CHOICE_P_MOBILE) awtc(spp(_bb[DIA_SUPER3D_CHOICE_P_MOBILE]).length==1?(AWTC_SET_ENABLED|AWTC_OPT_PARENT):(AWTC_SET_DISABLED|AWTC_OPT_PARENT),_tffSelection['M']);
        final Protein pR=sp(_bb[DIA_SUPER3D_CHOICE_P_REFERENCE]);
        if(bid==SBUTS_DIA_SUPER3D_Insert_cursor){
            final int cmr=gcpi(KEY_DialogSuperimpose3D_CMR,evtSrc(ev));
            if(isEnbld(_tffSelection[cmr])){
                final Protein p=strapCursorProtein();
                final int iA=indexOfAminoAcidAtCursorZ(p);
                if(iA<0 || p==null) baLog(LOG_MSG).a(RED_ERROR).aln(rsc(RSC_DIA_SUPERIMPOSE3D_ERROR_CURSOR));
                else{
                    final Protein[]ppM=spp(_bb[DIA_SUPER3D_CHOICE_P_MOBILE]);
                    if(cmr=='M' && ppM.length!=1 || cmr=='R' && pR==null) return null;
                    final Protein pDest=cmr=='R'?pR: cmr=='M'?ppM[0]:null;
                    final int col=p.getResColumnAt(iA);
                    if(col>=0) insertAtCaret(" "+((pDest!=null?pDest.columnToIndex(CTRUE,col):col)+1)+" ",_tffSelection[cmr]);
                }
            }
        }
        if(bid==SBUTS_DIA_SUPER3D_Go){
            if(0!=(modi&CTRL_MASK)){
                final Protein[]pp=selectedOrVisibleProteins(1);
                final TYPE_ALIGN_RESULT[][]rrr=new Object[pp.length][pp.length][];
                FORi(0,pp.length){
                    FORj(0,pp.length){
                        if(i!=j && hasCalpha(pp[j]) && hasCalpha(pp[i])){
                            final SequenceAligner s3d=(SequenceAligner)mkInstance(iCLASS_SequenceAligner,_choiceClass);
                            if(s3d!=null) rrr[i][j]=s3d.computeAlignment(0,new Protein[]{pp[j],pp[i]});
                        }
                    }
                }
                final Protein
                    best=iThProt(structureWhichRepresentsOthers(true,rrr),pp),
                    wors=iThProt(structureWhichRepresentsOthers(false,rrr),pp);
                if(_sequenceListFile!=null){
                    final String base=delLstCmpnt('.',_sequenceListFile);
                    if(best!=null) wrte(file("info/"+base+".REP"),best+"\n");
                    if(wors!=null) wrte(file("info/"+base+".EXTREME"),wors+"\n");
                }
                setSelO(0!=(modi&SHIFT_MASK)?best:wors,_bb[DIA_SUPER3D_CHOICE_P_REFERENCE]);
                awtc(AWTC_REVALAND_REPAINT_MAYBE,_bb[DIA_SUPER3D_CHOICE_P_REFERENCE]);
            }else if(0!=(modi&SHIFT_MASK)){
                final float f=(float)atof(dlgInput("This removes all superposition results<BR>with a score below a threshhold.<BR>Enter threshhold","3.1"));
                ROFi0(_tabbed.getTabCount()){
                    final Object s3d=_tabbed.getComponentAt(i);
                    if(s3d instanceof SDialogs && scor(((SDialogs)s3d)._aligner)<f) dispos(s3d);
                }
            }else{
                if(pR==null) baLog(LOG_MSG).a(RED_ERROR).aln("Select a reference protein");
                else if(!hasCalpha(pR)) baLog(LOG_MSG).a(RED_ERROR).aln("No c-alpha coordinates in the reference protein");
                else if((SequenceAligner)mkInstance(iCLASS_SequenceAligner,_choiceClass)==null) baLog(LOG_MSG).a(RED_ERROR).aln("Could not instantiate superposition class");
                else{
                    final String[]subset=new String['R'+1];
                    ROFi0(subset.length){
                        final Object jc=_tffSelection[i];
                        if(isEnbld(jc) && isSlct(_bb[DIA_SUPER3D_TOG_OPTIONS])){
                            final String s=jc.toString();
                            subset[i]=nxt(0,chrClas(-SPC),s)>=0?s:null;
                        }
                    }
                    final Protein protR=subset['R']==null?pR:pR.newProteinSubset(subset['R']),ppM[]=proteinJlistSelectedOrAll(_bb[DIA_SUPER3D_CHOICE_P_MOBILE]);
                    {
                        Protein lastMobile=null;
                        FORi(0,sze(ppM)) if(hasCalpha(ppM[i])) lastMobile=ppM[i];
                        if(lastMobile==null) {baLog(LOG_MSG).a(RED_ERROR).aln(rsc(RSC_DIA_SUPERIMPOSE3D_ERROR_NO_XYZ)); return null;}
                    }
                    final SDialogs[]tabs=new SDialogs[ppM.length];
                    ROFi0(ppM.length){
                        final Protein pM=ppM[i],protM;
                        if(!hasCalpha(pM) || ppM.length>1 && pM==pR) continue;
                        if(subset['C']!=null){
                            final int[]minIdx={0};
                            final boolean[]bb=pM.residueSubsetAsBool(subset['C'],minIdx);
                            protM=pM.newProteinSubset(new int[]{minIdx[0]+fstTrue(bb)-1,minIdx[0]+lstTrue(bb)});
                        }else protM=subset['M']==null?pM: pM.newProteinSubset(subset['M']);
                        if(protM!=null && protM.countRes()>=3){
                            final SDialogs tab=tabs[i]=new SDialogs(TAB_SUPER3D);
                            tab._aligner=mkInstance(iCLASS_SequenceAligner,_choiceClass);
                            tab._pp=new Protein[]{pR,pM};
                            tab._seqs=new Protein[]{protR,protM};/*X ppSubset*/
                            runCR(RUN_INIT_DIALOG_TAB,tabs[i]);
                        }
                    }
                    thrdCR1(_RUN_DIA_SUPERIMP_COMPUTING|THRDCR_START,this,tabs);
                }
            }
        }
        BREAK;
    }
 }
