@*H THIS_CLASS(DIA_TREE)
 This dialog is used to draw phylogenetic dendrograms of aligned sequences.
*@
@*~RSC_DIA_TREE_TEXT
 <BR>The sequences must be aligned.<BR>
 Select some sequences or open a rectangular alignment region with the mouse.<BR>
*@
@*~RSC_DIA_TREE_TEXT_AT_LEAST_3
 Phylogenetic trees require at least 3 sequences
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        return pnl(VBHB,
                   rsc(RSC_DIA_TREE_TEXT),
                   getPnl(_choiceClass=classChoice(INTRFC_PhylogeneticTree)),
                   buttn(SBUT_WARN_MARCHING_ANTS),
                   pnl(newButtn(BUTS_GO,null,this)));
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==BUTS_GO){
            final Protein[]pp=ppInRectangleForAlignment(3);
            if(pp.length<3) baLog(LOG_MSG).a(RED_ERROR).aln(rsc(RSC_DIA_TREE_TEXT_AT_LEAST_3));
            else{
                baLog(LOG_MSG).aln(" ");
                final int[]r=rectRubberBand();
                displayPhylogeneticTree(_choiceClass,pp,x(r),r!=null?x2(r):MAX_INT,null);
            }
        }
        BREAK;
    }
 }

/*  http://mesquiteproject.org/mesquite/mesquite.html */
