#define SELECTION_NAME "blast_match"
@*~RSC_DIA_BLAST_INFO_OUTPUT_WIDTH
 Long Blast alignments will be folded at num-characters.<BR>
 Note that line breaks may prevent recognizing string patterns with Ctrl+F.<BR>
*@

@*~RSC_DIA_BLAST_INFO_DOWNLOAD_SEQS
 <H2>Downloading sequences from the Blast result</H2>
 Entries in the blast-result start with a greater than sign
 followed by a database and a sequence identifier.<BR>
 Consider the the following example and watch the mouse cursor while moving over the identifiers:
 <PRE>
 71&gt; UNIPROTKB:P56817
 </PRE>
 Clicking before the colon, the respective Web page is opened in the browser while on clicking after the colon, the sequence is loaded into Strap.
 <BR><BR>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogFetchSRS)</i>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogFetchPdb)</i>
*@
@*~RSC_DIA_BLAST_INFO_CREATE_RESSEL
 The selected sequence (I.e. the sequence marked in alignment row header) are analyzed.<BR>
 The sequences of the blast hits are considered (I. e. the lines starting with the letter "H").<BR>
 If a hit sequence is identical or part of a sequence in the alignment,<BR>
 then a residue selection is created.
*@
@*RSC_TAB_BLAST_APPLY_RESSEL
 Compute multiple sequence alignment using only these matching parts
*@
@*RSC_TAB_BLAST_RESSEL_CREATED
 %N Residue selection%S created by Blast
*@

/* (NUM1 1) */
#define BB_tfFormat 1
#define _tp _bb[2]
#define _pnlCount _bb[3]
#define _pnlFormat _bb[4]
/* (NUM1 1) */
#define _isAlreadyEDT _ii[1]
/* --- */
#define _vSelections _v

/* (NUM1 1) */
#define TAB_FETCH_PDB_urls 1
#define TAB_FETCH_PDB_chains 2
#define TAB_FETCH_PDB_fileNames 3
#define TAB_BLAST_blaster 4
#define TAB_BLAST_query 5
#define TAB_BLAST_db 6

final SequenceBlaster blaster=(SequenceBlaster)_bb[TAB_BLAST_blaster];
if(blaster==null)return null;

final String blasterName=iConst(SARRAYeq_BLAST_CMD,blaster._type);
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        //pcp(KEY_RESULT_LABEL,new BA(99).aa(shrtClasNamOrAlias(blaster),' ',_p),blaster);
        _pnlCount=pnl();
        _tp=new ChTextView((File)null);
        _bb[BB_tfFormat]=addLi(this,LSTNR_ACT|LSTNR_FOCUS,new ChTextField(s(9999)).cols(7));
        setTxt(_tmp()
               .and("Query=",_bb[TAB_BLAST_query])
               .and("\nProgram=",blasterName)
               .and("/",iConst(SARRAYeq_BLAST_CMD,blaster._type))
               .and("\nDatabase=",_bb[TAB_BLAST_db]).aln("\nComputing ..."),
               pcp(KEY_TITLE,addPfx("Blast ",_p),_tp));
        final Object tools=pnl(VBHB,
                               ChButton.doView(io(RSC_DIA_BLAST_INFO_DOWNLOAD_SEQS)).t("Download sequences..."),
                               pnl(HBL,_bb[SBUTS_TAB_BLAST_Ressel],buttn(BUTTN_CLASS_HELP_SMALL|RSC_DIA_BLAST_INFO_CREATE_RESSEL)),
                               _bb[SBUTS_TAB_BLAST_Format],
                               newCtrlBut(blaster),
                               " ",
                               pnl(HBL,"Options for result-text ",scrllpn(0,s(rsc(RSC_TXTCOMPONENT_KEYBINDINGS)))));
        pnl(this,CNSEW,scrllpn(0,_tp),pnl(VB,pnl(HBL,pnlTogglOpts(TOGGL_PNL_Tools,tools),_pnlCount),tools));
        thrdCR(_RUN_DIABLAST_COMPUTE|THRDCR_START,this);
        break;
    }
    CASE_ARGV(RUN_DISPOSE){
        dispos(blaster);
        return TRUEr;
    }
    CASE_ARG(RUN_M_focusLost,Object,ev)
        CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==SBUTS_TAB_BLAST_Format){
            if(_pnlFormat==null) _pnlFormat=pnl(VBHB,rsc(RSC_DIA_BLAST_INFO_OUTPUT_WIDTH),pnl(HB,"Max output width ",_bb[BB_tfFormat]));
            ChFrame.frame(FRAME_PACK,butTxt(SBUTS_TAB_BLAST_Format),_pnlFormat).shw(FRAME_AT_CLICK);
        }
        if(bid==BB_tfFormat) runCR(_RUN_DIABLAST_COMPUTE,this);
        if(bid==STOGS_TAB_BLAST_Highlight){
            if(!isSlct(_bb[STOGS_TAB_BLAST_Highlight])){
                tcRemoveHighlight(_textMatches,_tp);
                _textMatches=null;
                awtc(AWTC_OPT_REPAINT,_tp);
            }else if(_textMatches==null) _textMatches=tcHighlightOccurrence(BLAST_LABEL_NEW_HIT,null,null,HIGHLIGHT_REPAINT,C(0xffafaf),_tp);
        }
        if(bid==SBUTS_TAB_BLAST_Ressel){
            final Protein[]pp=selectedOrVisibleProteins(1);
            _vSelections=new ArrayList();
            boolean[]bb=null;
        nextProt:
            for(Protein p:pp){
                final byte[]rt=p.getResTypeUC();
                if(sze(bb)<rt.length) bb=new boolean[rt.length+333];
                for(TYPE_BLASTALIGNMENT a:blaster.blastAlignments()){
                    final byte[]mSeq=(byte[])a[BLASTAL_H_SEQ],qSeq=(byte[])a[BLASTAL_Q_SEQ];
                    final int pos=strstr(STR_IC,allLettersB(mSeq,0,MAX_INT),rt);/*X  Consider idxOfLetters(*/
                    if(pos>=0){
                        final byte[][]ml=similarityMatrix(SIMILARITY_MATRIX_BLASTMIDLINE);
                        for(int iA=pos,i=0;iA<bb.length && i<mSeq.length && i<qSeq.length;i++) bb[iA++]=ml[mSeq[i]&127][qSeq[i]&127]!=' ';
                    }
                }
                if(fstTrue(bb)>=0){
                    for(ResidueAnnotation a:p.residueAnnotations()){
                        if(SELECTION_NAME.equals(a.getName())){
                            _vSelections.add(a);
                            continue nextProt;
                        }
                    }
                    _vSelections.add(annotateSeqStyleRgbPosNameGrp( p,SSTYLE_LOWER_HALF,0x8888FF,_tmp().boolToText(bb,1+firstResIdx(p),",","-"),SELECTION_NAME,"Blast-match"));
                }
            }
            showInJList(SHOWINJLIST_IN_JFRAME,_vSelections.toArray(),plrl(sze(_vSelections),rsc(RSC_TAB_BLAST_RESSEL_CREATED)),pnl(rsc(RSC_TAB_BLAST_APPLY_RESSEL),_bb[SBUTS_TAB_BLAST_Realign]));
            strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*9);
        }
        if(bid==SBUTS_TAB_BLAST_Realign) openDialogRealignResSel(toArry(_vSelections,ResidueAnnotation.class));
        BREAK;
    }
    //SequenceBlaster
    CASE_ARGV(_RUN_DIABLAST_COMPUTE){
        final File f=blaster.blastToTextFile(maxi(20,xatoi(_bb[BB_tfFormat])));
        if(sze(f)>0){
            thrdCR1(_RUN_DIA_BLAST_RUN_EDT|THRDCR_EDT_LATER,this,f);
            setEnbld(true,_bb[SBUTS_TAB_BLAST_Format]);
            setEnbld(true,_bb[SBUTS_TAB_BLAST_Ressel]);
            setEnbld(true,_bb[STOGS_TAB_BLAST_Highlight]);
            setEnbld(true,_bb[SBUTS_TAB_BLAST_Realign]);
        }
        break;
    }
    CASE_ARG(_RUN_DIA_BLAST_RUN_EDT,File,f){
        ((ChTextView)pcp(KOPT_SEARCH_SKIP_BLANKS,"",_tp)).setFile(f);
        if(_isAlreadyEDT++==0){
            if(blaster._blastResultCountNovelHits>0 && blaster._blastResultCountNovelHits<blaster._blastResultCountHits){
                adC(pnl(plrl(blaster._blastResultCountNovelHits,"%N Novel Blast hits."),_bb[STOGS_TAB_BLAST_Highlight]),_pnlCount);
            }else{
                adC(pnl(plrl(blaster._blastResultCountHits,"#hits = %N")),_pnlCount);
            }
            awtc(AWTC_SET_ENABLED,_bb[SBUTS_TAB_BLAST_Format]);
        }
        awtc(AWTC_REVALAND_REPAINT_MAYBE,_tp);
        BREAK;
    }
 }
#undef SELECTION_NAME
#undef _pnlCount
#undef _tp
#undef BB_tfFormat

#undef _isComputed
#undef _vSelections
#undef _pnlFormat
