/* A graphical representation of a graph   adjusting the node distances dynamically. */
/* @author Christoph Gille  */
/* See TabCompareSequences.java  SDialogs,DIA_COMPARE_SEQUENCES */
/* --- */
#define Node Object[]
#define NODE_RECTANGLE 0
#define NODE_OBJECT 1
#define NODE_ZZZ 2
/* --- */
#define Edge Object[]
#define EDGE_NODE1 0
#define EDGE_NODE2 1
#define EDGE_DATA 2
#define EDGE_IS_DISTANCE 3
#define EDGE_ZZZ 4
/* --- */
#define FLOAT double
#define IS_NAN(n) Double.isNaN(n)
#define NAN Double.NaN
#define FLOAT_MIN Double.MIN_VALUE
#define FLOAT_MAX Double.MAX_VALUE
/* --- */
#define nodeRectangle(n) (double[])n[NODE_RECTANGLE]
#define nodeObject(n) n[NODE_OBJECT]
#define edgeNode1(e) ((Node)e[EDGE_NODE1])
#define edgeNode2(e) ((Node)e[EDGE_NODE2])
#define edgeData(e) (Object[])e[EDGE_DATA]
#define foreachNode(n) for(Node n:_graphNodes)if(n!=null)
#define foreachEdge(e) for(Edge e:_graphEdges)if(e!=null)
#define isNodeFixed(node) false
#define _WITH_FIXED 0
#define _IF_FIXED(a)
#define GRAPH_SCALE_MAX 400
private FLOAT _graphMax,_graphMin,_graphClosest[],_graphPick[];
private Object _graphScale,_graphBB[],_graph;
private int _graphW=333,_graphH=333;
private Node[]_graphNodes={};
private Edge[]_graphEdges={};
private void addNode(Node n){
    if(idxOf(n,_graphNodes)<0){
        _graphNodes=adToArry(33,n,_graphNodes,Node.class);
        final FLOAT[]r=nodeRectangle(n);
        r[RECTx]=100*Math.random();
        r[RECTy]=100*Math.random();
    }
}
public void run(){
    if(runCR1(RUN_IS_OBJECT_ENABLED,this,this)==FALSEr) return;
/* preventFixedNodesFromfloatingOutTheScreen */
#if _WITH_FIXED
    foreachNode(n){
        final FLOAT[]r=nodeRectangle(n);
        if(isNodeFixed(n)){
            if(r[RECTx]<0) r[RECTx]=0;
            if(r[RECTy]<40) r[RECTy]=40;
            if(r[RECTx]+20>w) r[RECTx]=_graphW-20;
            if(r[RECTy]+20>h) r[RECTy]=_graphH-20;
        }
    }
#endif //_WITH_FIXED
    final FLOAT scale;
    {
        FLOAT mv=_graphMax-_graphMin; if(mv==0) mv=1;
        scale=intValueC(_graphScale)/300f/mv*_graphW;
    }
    FLOAT max=FLOAT_MIN,min=FLOAT_MAX;
    foreachEdge(e){
        final FLOAT v=edgeLen(e);
        if(max<v) max=v;
        if(min>v) min=v;
    }
    _graphMax=max;
    _graphMin=min;
    foreachEdge(e){
        final FLOAT
            r1[]=nodeRectangle(edgeNode1(e)),
            r2[]=nodeRectangle(edgeNode2(e)),
            v=(edgeLen(e)-min),
            //distance=e[EDGE_IS_DISTANCE]!=null?v: max-min-v;
            distance=v-min;
        if(!IS_NAN(distance)){
            final FLOAT vx=r2[RECTx]-r1[RECTx],vy=r2[RECTy]-r1[RECTy],len=Math.sqrt(vx*vx+vy*vy),f=len<2?0: distance*scale/len-1 ;
            if(!IS_NAN(f)){
                final FLOAT dx=f*vx,dy=f*vy;
                r2[RECTw]+=dx; r2[RECTh]+=dy;
                r1[RECTw]+=-dx; r1[RECTh]+=-dy;
            }
        }
    }
    foreachNode(n1){
        FLOAT dx=0,dy=0;
        final FLOAT[]r1=nodeRectangle(n1);
        foreachNode(n2){
            final FLOAT[]r2=nodeRectangle(n2);
            if(n1!=n2){
                final FLOAT
                    vx=r1[RECTx]-r2[RECTx],
                    vy=r1[RECTy]-r2[RECTy],
                    len=vx*vx+vy*vy;
                if(len==0){
                    dx+=Math.random();
                    dy+=Math.random();
                }else if(len<100*100){
                    dx+=vx/len;
                    dy+=vy/len;
                }
            }
        }
        FLOAT dlen=dx*dx+dy*dy;
        if(dlen>0){
            dlen=Math.sqrt(dlen)/2;
            r1[RECTw]+=dx/dlen;
            r1[RECTh]+=dy/dlen;
        }
    }
    foreachNode(n){
        final FLOAT[]r=nodeRectangle(n);
        if(!isNodeFixed(n) && r!=_graphPick){
            r[RECTx]+=Math.max(-5,Math.min(5,r[RECTw]))-r[RECTx]/(_graphW+1)*10;
            r[RECTy]+=Math.max(-5,Math.min(5,r[RECTh]))-r[RECTy]/(_graphH+1)*10;
#if 0
            //if (r[RECTx] < 0) r[RECTx]=0; else if(r[RECTx] > d.width) r[RECTx]=d.width;
            //if (r[RECTy] < 0) r[RECTy]=0; else if(r[RECTy] > d.height) r[RECTy]=d.height;
#endif //0
        }
        r[RECTw]/=2;
        r[RECTh]/=2;
    }
    awtc(AWTC_OPT_REPAINT,_graph);
}
private FLOAT[]closestNode(int x,int y){
    FLOAT bestdist=9999,closest[]=null;
    foreachNode(n){
        final FLOAT
            r[]=nodeRectangle(n),
            dx=r[RECTx]-x,
            dy=r[RECTy]-y,
            dist=dx*dx+dy*dy;
        if(dist<bestdist){
            closest=r;
            bestdist=dist;
        }
    }
    return closest;
}
static Object[]newNode(Object o){
    final Node n=new Object[NODE_ZZZ];
    n[NODE_OBJECT]=o;
    n[NODE_RECTANGLE]=new FLOAT[4];
    return n;
}
public FLOAT edgeLen(Edge e){
    e[EDGE_IS_DISTANCE]=TRUEr;
    final FLOAT[]dd=(FLOAT[])runCR1(RUN_TAB_COMPARE_SEQUENCES_GET_DISSIMILARITY,this,e);
    return dd==null?NAN:dd[0];
}
private Edge newEdge(Node n1,Node n2,Object o){
    final Edge e=new Object[EDGE_ZZZ];
    e[EDGE_DATA]=o;
    e[EDGE_NODE1]=n1;
    e[EDGE_NODE2]=n2;
    _graphEdges=adToArry(33,e,_graphEdges,Edge.class);
    addNode(edgeNode1(e));
    addNode(edgeNode2(e));
    return e;
}
