@*H THIS_CLASS(TAB_COMPARE_SEQUENCES_PAIR)
 In each line of the input file the program expects two (or more) sequence files.
 The sequences are loaded and compared with each other.
 In the result list the sequences names and the alignment score are written.
*@
@*SARRAY_TAB_COMPARE_SEQUENCES_PAIR_tableHeader
 Sequence1|Sequence2|Score
*@
/* (NUM1 1) */
#define TAB_COMPARE_SEQUENCES_PAIR_class 1
#define TAB_COMPARE_SEQUENCES_PAIR_sharedInstance 2
#define TAB_COMPARE_SEQUENCES_PAIR_from 3
#define TAB_COMPARE_SEQUENCES_PAIR_to 4
#define _south _bb[4]
#define _pnlFile _bb[5]
#define _otherClass _bb[6]
#define BB_tfFile 7
#define _frameFs _bb[8]
#define fromCol _ii[TAB_COMPARE_SEQUENCES_PAIR_from]
#define toCol _ii[TAB_COMPARE_SEQUENCES_PAIR_to]
/* --- */
#define _clazz _bb[TAB_COMPARE_SEQUENCES_PAIR_class]
#define _fromTo _bb[TAB_COMPARE_SEQUENCES_PAIR_fromTo]
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _jt=new ChJTable(JTABLE_ROW_SORTER|JLIST_DEFAULT_RENDERER,new ChTableModel(0,arry(SARRAY_TAB_COMPARE_SEQUENCES_PAIR_tableHeader),_v=new ArrayList()));
        tcTools(_bb[BB_tfFile]=pcp(KEY_IF_EMPTY,"Enter input file name",addActLi(this,new ChTextField(COMPLETION_DIRECTORY_PATH,"").saveInFile("TabCompareSequencePair_inputFile"))))
            .enableWordCompletion(iFile(DIR_WORKING));
        pnl(this,CNSEW,
            scrllpn(0,_jt),
            dialogHead(this),
            _pnlFile=pnl(CNSEW,_bb[BB_tfFile],BRDR_EM_RL,_south=pnl(_bb[BUTS_GO]=newBut(BUTS_GO,this),buttn(TOG_CACHE),BRDR_EM),_bb[SBUTS_TAB_COMPARE_SEQUENCES_PAIR_HardDisk],"Input file:"));
        undrlneRefs(ULREFS_NOT_CLICKABLE,_bb[BB_tfFile]);
        break;
    }
    CASE_ARG(_RUN_COMPSEQ_GO,BA,ba){
        if(mkInstance(MKINSTANCE_SHOW_ERROR,_clazz)!=null){
            clr(_v);
            final Collection vAlready=new HashSet(),v=new ArrayList();
            final int ee[]=ba.eol();
        Line:
            FORiL(0,ee.length){
                clr(v);
                for(String s:splitTkns(0,ba.bytes(),BOL0(iL,ee),ee[iL],chrClas(SPC_COMMA))){
                    if(gcp(KOPT_DISPOSED,this)!=null) break Line;
                    final boolean doLog=vAlready.add(s);
                    Protein p=sequenceWithName(s,null);
                    if(p==null){
                        final Map map=mapSoft(148);
                        if((p=(Protein)map.get(s))==null) map.put(s,p=newProteinInstance(0,file(s)));
                        if(doLog) _log.aFile(s);
                    }else if(doLog) _log.a(". Take loaded sequence");
                    if(p!=null){
                        if(doLog) _log.aa(". Residues: ",p.countRes()).aln();
                        v.add(p);
                    }else if(doLog) _log.aln(". No sequence");
                }
                int time0=timeOn();
                final Protein[]pp=spp(v);
                for(Protein p0:pp){
                    for(Protein p1:pp){
                        if(gcp(KOPT_DISPOSED,this)!=null) break Line;
                        if(p0==null||p1==null || s(p0).equals(s(p1)) || !vAlready.add(s(_tmp().aa(p0,' ',p1)))) continue;
                        final Object dis=mkInstance(MKINSTANCE_SHOW_ERROR,_clazz);
                        _v.add(new Object[]{s(p0),s(p1),new Double(valueOfTwoProteins(0,dis,p0,p1,fromCol,toCol))});
                        final int t=timeOn();
                        if(t-time0>333){
                            awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_jt);
                            time0=t;
                        }
                        dispos(dis);
                    }
                    if(pp.length==2) break;
                }
                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_jt);
            }
            thrdCR(_RUN_COMPSEQ_FINISH|THRDCR_EDT_LATER,this);
            awtc(AWTC_REMOVE_FROM_PARENT,_bb[SBUTS_TAB_COMPARE_SEQUENCES_PAIR_Stop]);
        }
        BREAK;
    }
    CASE_ARGV(_RUN_COMPSEQ_FINISH){
        setTxt("All done",setBG(0xFF00,_pnlFile));
        awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_pnlFile);
        break;
    }
    CASE_ARG(RUN_FileChooser_APPROVE_SELECTION,Object,fileChooser){
        setTxt(runCR(RUN_FCHOOSER_selectedFile,fileChooser),_bb[BB_tfFile]);
        BREAK;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        baLog(LOG_MSG).send();
        if(bid==SBUTS_TAB_COMPARE_SEQUENCES_PAIR_HardDisk){
            if(_frameFs==null) _frameFs=new ChFrame("").ad(addActLi(this,newFileChooser(PRPRTY_FC_Compare2Seqs|FCHOOSER_CLOSE)));
            ((ChFrame)_frameFs).shw(FRAME_CENTER);
        }
        if(bid==BUTS_GO || bid==BB_tfFile){
            final BA txt=readBytes(file(_bb[BB_tfFile]));
            if(txt==null) {baLog(LOG_MSG).aa(RED_ERROR,"Could not open input file ").aln(_bb[BB_tfFile]); return null;}
            awtc(AWTC_REMOVE_ALL,_pnlFile);
            adC(ChButton.doView(_log).t("Log"),_south);
            if(HAS_CTRL_PNL(_clazz)) adC(_bb[SBUTS_TAB_COMPARE_SEQUENCES_PAIR_Ctrl],_south);
            if(isAssignblFrm(SequenceAligner.class,_clazz)) adC(_bb[SBUTS_TAB_COMPARE_SEQUENCES_PAIR_View],_south);
            adC(_bb[SBUTS_TAB_COMPARE_SEQUENCES_PAIR_Stop],_south);
            awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_south);
            thrdCR1(_RUN_COMPSEQ_GO|THRDCR_START,this,txt);
            awtc(AWTC_SET_NOT_EDITABLE,_bb[BB_tfFile]);
        }
        if(bid==SBUTS_TAB_COMPARE_SEQUENCES_PAIR_Stop) dispos(this);
        if(bid==SBUTS_TAB_COMPARE_SEQUENCES_PAIR_View || bid==SBUTS_TAB_COMPARE_SEQUENCES_PAIR_Ctrl){
            final int i=_jt.getSelectedRow();
            if(i<0) {baLog(LOG_MSG).a(RED_ERROR).aln("Select a table row first"); return null;}
            final Object dis=mkInstance(MKINSTANCE_SHOW_ERROR,_clazz),v=iThEl(i,_v); /*X List<String>*/
            setSharedInstance(_sharedInstance,dis);
            valueOfTwoProteins(bid==SBUTS_TAB_COMPARE_SEQUENCES_PAIR_View?COMPARE_PP_SHOW_RESULT_GRAPHICALLY:0,dis,iThProt(0,v),iThProt(1,v),fromCol,toCol);
            if(bid==SBUTS_TAB_COMPARE_SEQUENCES_PAIR_Ctrl) shwCtrlPnl(0,s(v),dis);
        }
    }
    BREAK;
 }
 if(isEDT()) setEnbld(sze(file(_bb[BB_tfFile]))>0,_bb[BUTS_GO]);
#undef _south
#undef _clazz
#undef BB_tfFile
#undef _pnlFile
#undef _frameFs
#undef _fromTo
#undef fromCol
#undef toCol
