package charite.christo.strap;
import static charite.christo.ChUtils.*;
import charite.christo.*;
import java.io.*;
import java.util.*;
import static charite.christo.strap.Strap.*;
/** @author Christoph Gille */
#define BUT_XML 1
#define BUT_XMLb 2
#define BUT_TXT 3
#define BUT_TXTe 4
#define BUT_BROWSER 5
#define BUT_BLAST_ZZZ 6
#define _DB_pdb "pdb"
#define _DB_uniprot "uniprot"

/* (NUM1 0) */
#define SEQUENCEBLASTER_STATE_COMPUTED (1<<1)
#define SEQUENCEBLASTER_STATE_HAS_XML_RESULT (1<<2)
#define SEQUENCEBLASTER_STATE_COMPUTATION_ERROR (1<<3)
// https://www.ebi.ac.uk/Tools/services/rest/ncbiblast/result/ncbiblast-R20171205-222935-0302-70274696-p1m/xml
@*H
 Blast for (Basic Local Alignment Search Tool) is used to identify sequences within a large set of sequences that a similar to a given query sequence.
 <BR><BR>
 In the dialog <i>HTMLDOC_DIALOG:BUT_C1(DialogBlast)</i>, loaded sequences a Blast method and a sequence database are selected.
 <BR>
 <BR>
 In the dialog <i>HTMLDOC_DIALOG:BUT_C1(DialogSimilarStructure)</i>, Blast is used to assign Uniprot identifiers.

 Since local implementations are much faster than current remote services,
 Strap is first probing locally installed NCBI-BLAST, AB-BLAST and WU-BLAST if the respective environment variables BLASTDB, ABBLASTDB and WUBLASTDB
 are pointing to a directory with Blast-databases and the respective executables blastall, ab-blastall or wu-blastall, respectively, are in the execution path.
 <BR>
 <BR>
 Otherwise the NCBI and EBI servers are used such that one sequence after the other (one at a time) is submitted to these servers.
 Both servers are employed to reduce the time to process a number of sequences and to obtain a result even if one of both fail.
 For NCBI and EBI, the sequences are submitted in opposite order.
 <BR>
 <BR>
 Occasionally, the servers are down.
 It also happened in the past at EBI and NCBI, that Blast services stopped working or their programming interfaces changed.

 <PRE>
 ====================================
 ========== Local AB-BLAST ==========
 ====================================
 CPP_HASH  ABBLASTDB must be set.
 export ABBLASTMAT=/local/bioinf/AB-blast/matrix

 CPP_HASH WUBLASTDB points to the directory where the blast databases are
 export ABBLASTDB=/local/bioinf/db/ab-blast
 mkdir -p $ABBLASTDB

 cd $ABBLASTDB
 ab-formatdb -p  T  -i pdb.fasta.gz -n pdb

 CPP_HASH Testing
 echo '>test' > test.fa
 echo 'LIKADKVQAQGFKGANVKVAVLDTGIQASHPDLNVVGGASFVAGEAY' >> test.fa
 ab-blastall -p blastp -d pdb -i test.fa -b 300 -m 7
 ====================================
 ========== Local WU-BLAST ==========
 ====================================
 CPP_HASH The environment variables  WUBLASTMAT and WUBLASTDB and WUBLASTFILTER must be set.
 export WUBLASTMAT=/local/bioinf/wu-blast/matrix

 CPP_HASH WUBLASTDB points to the directory where the blast databases
 export WUBLASTDB=/local/bioinf/db/wu-blast
 mkdir -p $WUBLASTDB
 cd $WUBLASTDB
 wu-formatdb -p  T  -i pdb.fasta.gz  -n pdb

 CPP_HASH Testing
 echo '>test' > test.fa
 echo 'LIKADKVQAQGFKGANVKVAVLDTGIQASHPDLNVVGGASFVAGEAY' >> test.fa
 wu-blastall -p blastp -d pdb -i test.fa -b 300 -m 7
 ======================================
 ========== Local NCBI-BLAST ==========
 ======================================
 CPP_HASH Add The  /ncbi/build/ directory  containing the blastall command to the PATH environment variable!
 The environment variable

 CPP_HASH BLASTDB points to the directory  where the Blast databases are installed.
 export BLASTDB=/local/bioinf/blastdb/
 mkdir  -p $BLASTDB
 cd $BLASTDB
 formatdb -i  allPdbSequences.fasta -o -n pdb

 CPP_HASH Testing:
 echo '>test' > test.fa
 echo 'LIKADKVQAQGFKGANVKVAVLDTGIQASHPDLNVVGGASFVAGEAY' >> test.fa
 blastall -p blastp -d pdb -i test.fa -b 300 -m 7
 </PRE>
*@
/*X  Sensitivity 1...10 */

/* EBI-blast numAli sind nur bestimmte Zahlen zulaessig.  */

// wget -S -O t.txt --post-data='email=christoph.gille@charite.de&align=0&program=blastp&alignments=100&scores=100&stype=protein&sequence=PITKHIGLVYSGMGPDYRVLVHRARKLAQQYYLVY&database=uniprotkb&exp=100&compstats=false&gapalign=false' https://www.ebi.ac.uk/Tools/services/rest/ncbiblast/run/; cat t.txt

// wget -S -O t.txt --post-data='email=christoph.gille@charite.de&align=0&program=blastp&alignments=100&scores=100&stype=protein&sequence=PITKHIGLVYSGMGPDYRVLVHRARKLAQQYYLVY&database=uniprotkb&exp=100&compstats=F&gapalign=false' https://www.ebi.ac.uk/Tools/services/rest/ncbiblast/run/; cat t.txt

@*SARRAYeq_SequenceBlaster_DBS
 EMBL Release em_rel;EMBL Updates emnew;EMBL Coding Sequence em_cds_rel|*aminos_from_3D_structures pdb;aminoacid uniprotkb;*aminoacids uniref100;aminoacids uniref90;aminoacids uniref50=SEQ_BLASTER_WEB_EBI
 Nucleotide collection nr/nt nr;Reference RNA sequences refseq_rna;Reference genomic sequences refseq_genomic;NCBI Genomes chromosome;Expressed sequence tags est|Non-redundant protein sequences nr;Reference proteins refseq_protein;UniProtKB/Swiss-Prot swissprot;Patented protein sequences pat;Protein Data Bank proteins pdb;Metagenomic proteins env_nr=SEQ_BLASTER_WEB_NCBI
*@
public class SequenceBlaster IF_GUI(implements ChRunnable){
    private static int _inst;
    private int _state;
    final int _type;
    private final int _opt,_time=timeOn();
    private final String _db;
    private File _fTxt,_fOut,_fIn,_dir;
    private String _urlResultHtml,_query,_cacheK,_logPfx=ANSI_INVERSE+"Blast"+ANSI_RESET+"  ";
    private final BA IF_GUI(_rendererTxt,)_log;
    public SequenceBlaster(int opt,int t,String seq,String db IF_GUI(,String seqName)){
        _type=t;
        _log=!withGui()||baLog(LOG_CK_URL)==baLog(LOG_OUT)?baLog(LOG_OUT):new BA(999);
        seq=_query=s(new BA(999).aFilter(FILTER_TO_UPPER|LETTR,seq));
        if(0==(opt&BLAST_NUCLEOTIDE_QUERY) && seq!=(_query=seq.replace('O','A').replace('B','A').replace('J','A'))) _log.aa(RED_ERROR," blastp: Wrong residue in ").aln(seq);
        _opt=opt;
        if(strStarts(STR_IC,"uniprot",db)) db=_DB_uniprot;
        if(strStarts(STR_IC|STR_w_R,"pdb",db)) db=_DB_pdb;
        _db=delToLstChr1(' ',db);
        IF_GUI(_rendererTxt=new BA(333).aa(dateToStrg(DATE_YYYY_MM_DD_d_HH_mm,0),' ',seqName,' ',_db,' '));;
    }
    private BA _blastCheckError(BA ba){
        if(strstr(0,"FATAL: ",ba)>0){
            if(_state!=(_state|=SEQUENCEBLASTER_STATE_COMPUTATION_ERROR)) _log.a(_logPfx).a(RED_ERROR).aln("Found 'FATAL:'").aln(ba);
            return null;
        }
        return ba;
    }
    public BA blastXML(){
#if CPP_WITH_GUI
        if(_blastJlist==null) thrdCR(_RUN_BLASTER_MK_JLIST|THRDCR_EDT_NOW,this);
        if(adUniq(this,_blastV)) awtc(AWTC_REVALAND_REPAINT_MAYBE,_blastJlist);
#endif //CPP_WITH_GUI
        BA ba=null;
        if(isPrprty(IS_CACHE_READ)) ba=_blastCheckError(CacheResult.getValue(iConst(SARRAYeq_BLAST_CMD,_type),cacheK(),null));
        if(ba!=null||(ba=computeBlast())!=null){
            if(0==(_state&SEQUENCEBLASTER_STATE_HAS_XML_RESULT)){
                _state|=SEQUENCEBLASTER_STATE_HAS_XML_RESULT;
                _log.a(_logPfx);
                if(0==(_state&SEQUENCEBLASTER_STATE_COMPUTED)){
                    final int e=_log.end();
                    _rendererTxt.aFT(_log.a(" Found in cache ").a(dateToStrg(DATE_YYYY_MM_DD_d_HH_mm,CacheResult.cacheLastModified(iConst(SARRAYeq_BLAST_CMD,_type),cacheK()))),e,MAX_INT);
                }
                _log.aln();
            }
        }
        return ba;
    }
/* <<<  <<< */
/* ---------------------------------------- */
/* >>> GUI >>> */
#if CPP_WITH_GUI
    private Object _color,_ctrl;
    private final Object[]_but=new Object[BUT_BLAST_ZZZ],_shared=new Object[SHARED_FIELD_ZZZ];
    CPP_FINAL_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(_RUN_BLASTER_MK_JLIST){
                toLogMenu(0,buttn(SBUTS_SHOW_BLAST_RESULTS),null,null,null);
                break;
            }
            CASE_ARG(RUN_GET_RENDERER_TXT,int,opt){
                RETURN _rendererTxt;
            }
            CASE_ARGV(RUN_GET_COLOR){
                return _color;
            }
            CASE_ARGV(RUN_ENABLE_DISABLE){
                if(!isEDT()) thrdCR(RUN_ENABLE_DISABLE|THRDCR_EDT_LATER,this);
                else{
                    ROFi0(_but.length)  setEnbld(i==BUT_BROWSER?0<sze(_urlResultHtml): 0!=(_state&SEQUENCEBLASTER_STATE_HAS_XML_RESULT),_but[i]);
                }
                break;
            }
            CASE_ARG(RUN_M_actionPerformed,Object,ev){
                final int iBut=idxOf(evtSrc(ev),_but);
                if(iBut==BUT_XML) shwTxtInW("Blast XML",blastXML());
                if(iBut==BUT_BROWSER) visitURL(0,_urlResultHtml);
                if(iBut==BUT_TXTe || iBut==BUT_TXT){
                    final File f=blastToTextFile(80);
                    if(sze(f)>0){
                        if(iBut==BUT_TXTe) viewFile(f);
                        if(iBut==BUT_TXT) shwTxtInW("Blast result",f);
                    }
                }
                if(iBut==BUT_XMLb){
                    final BA xml=blastXML();
                    if(xml!=null) wrte(WRTE_VIEW_FILE,iFile(FSUFFIX_xml),xml);
                }
                BREAK;
            }
            CASE_ARG(RUN_GET_CTRL_PNL,Object,supported){
@*SARRAYeq_SequenceBlaster_File_Opts
                 XML in file browser=BUT_XMLb Result XML=BUT_XML Result text=BUT_TXT Text in editor=BUT_TXTe View in Browser=BUT_BROWSER
*@
                if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                if(_ctrl==null){
                    ROFi0(BUT_BLAST_ZZZ) _but[i]=newButtn(0,iConst(SARRAYeq_SequenceBlaster_File_Opts,i),this);
                    _ctrl=pnl(CNSEW,scrllpn(SCRLLPN_SIZE_8x8,_log),pnl(_but[BUT_XML],_but[BUT_XMLb]," ",_but[BUT_TXT],_but[BUT_TXTe]," ",_but[BUT_BROWSER]));
                    runCR(RUN_ENABLE_DISABLE,this);
                }
                RETURN(_ctrl);
            }
        }
        return returnPrgParas(id,arg,_shared,this);;
    }
#endif //CPP_WITH_GUI
/* <<< GUI <<< */
/* ---------------------------------------- */
/* >>> Cache >>> */
    public String cacheK(){
        if(_query==null) return null;
        if(_cacheK==null){
            final BA ba=cacheKeyForSeq(_query,null).aa(_db,'/').aHex(_opt,8).a('/');
            IF_GUI(ba.join('_',runCR(RUN_PRGPARAS_AS_STRING_ARRAY,runCR(RUN_GET_PRG_PARAS,this))));;
            _cacheK=s(ba);
        }
        return _cacheK;
    }
    IF_DEACTIVATED(private long maxAge=MAX_INT; public void cachedResultsNotOlderThanSec(int time){maxAge=time;});;
/* <<< Cache <<< */
/* ---------------------------------------- */
/* >>> Compute >>> */
#define IN_SEQUENCEBLASTER " in SequenceBlaster: "
public BA computeBlast(){
        if(isBlastdbSet(_type)==CFALSE || 0!=(_state&SEQUENCEBLASTER_STATE_COMPUTED) || 0!=(_opt&(BLAST_CACHE_ONLY))) return null;
        _state|=SEQUENCEBLASTER_STATE_COMPUTED;
        if(sze(_query)<5){
            _log.aa(_logPfx,RED_ERROR,IN_SEQUENCEBLASTER,"query sequence too short").aln(_query).send();
            return null;
        }
        if(_db==null){
            IF_MEIN_DEBUG(_log.aa(_logPfx,RED_ERROR,IN_SEQUENCEBLASTER).aln("_db=null"));;
            return null;
        }
        final String cmd=iConst(SARRAYeq_BLAST_CMD,_type),sync=toStrgIntrn(new BA(99).aa(cmd,'_',hashCd(cacheK())));
        BA result=null;
        CPP_synchronized(recordSync(sync,IN_SEQUENCEBLASTER)){
            if(result==null){
                result=_compute();
                _log.del(" ...");
                if(onlyOnce(21)) baLog(LOG_UNAVAILABLE).a(result==null?"Failed: ":GREEN_AVAILABLE).aln(cmd);
                IF_GUI(_color=C(result!=null?0xFF00:0xFF0000));;
                if(result!=null){
                    _log.a(_logPfx).aln(GREEN_SUCCESS);
                    CacheResult.putValue(0,cmd,cacheK(),result);
                    _state|=SEQUENCEBLASTER_STATE_HAS_XML_RESULT;
                }else{
                    _log.a(_logPfx).aln(RED_FAILED);
                }
            }
        }
        runCR(RUN_ENABLE_DISABLE,this);
        //IF_GUI(if(withGui()) repaintC(_blastJlist));;
        return _blastCheckError(result);
    }
/* <<< Compute <<< */
/* ---------------------------------------- */
/* >>> command line >>> */
    private BA _compute(){
        int wordSize=0xF&(_opt>>>BLAST_SHIFT_WORDSIZE),sensitivity=0xF&(_opt>>>BLAST_SHIFT_SENSITIVITY),numAli=0xFFF&(_opt>>>BLAST_SHIFT_NUMALI);
        if(numAli==0) numAli=2000;
        final String cmd=iConst(SARRAYeq_BLAST_CMD,_type),prg=0==(_opt&BLAST_NUCLEOTIDE_QUERY)?(0==(_opt&BLAST_NUCLEOTIDE_DB)?"blastp": "tblastn"): (0==(_opt&BLAST_NUCLEOTIDE_DB)?"blastx": "blastn");
        if(null!=iConst(SARRAYeq_BLASTDB_ENV,_type)){
            if(wordSize>3) wordSize=3;
            if(_db==null) return null;
            _fOut=fileDel(0,newFile(_dir=mkdrsErr(iPath2(DIR_TMP,cmd).aa('/',_inst++)),"output.xml"));
            _fIn=wrte(newFile(_dir,"input.fa"),new BA(333).aln(">query").aln(_query));
#if CPP_WITH_GUI
            if(withGui()){
                fileDel(DEL_FILE_ON_EXIT,_fIn);
                fileDel(DEL_FILE_ON_EXIT,_fOut);
                fileDel(DEL_FILE_ON_EXIT,_dir);
            }
#endif //CPP_WITH_GUI
            final BA cmdLine=new BA(99).aa(cmd," -p ",prg," -d ",_db," -i ",_fIn," -o ",_fOut,' '," -b ",numAli," -m 7 -e 100 -Ff ");
            if(wordSize>0) cmdLine.aa(" -W ",wordSize);
            final ChExec ex=new ChExec(EXEC_STDOUT|EXEC_STDERR|EXEC_NO_LOG_STDOUT);/*X Log stdout already via baLog(LOG_BLAST) */
            ex.out(EXEC_OUT_CREATE|EXEC_FIELD_STATUS).addSend(baLog(LOG_BLAST)).addSend(_log);
            ex.setCommandLines(s(cmdLine)).setDir(_dir).run();
            if(ex.exitValue()!=0) _log.aa(_logPfx,RED_ERROR,IN_SEQUENCEBLASTER," exitValue()!=0 ",cmdLine," exitValue()!=0 ").aFile(_fOut).aln().aln(ex.stdoutAndDispose()).aln(runCR(RUN_EXEC_GET_STDERR,ex));
            return readBytes(_fOut);
        }else{
            try{
                String urlStatus=null,urlXML=null,seq=_query;
                if(sze(seq)<3) return null;
                if(sze(seq)>2000) _log.aa(_logPfx,"Query>2000 not allowed for remote Blast. Shorten ").aln(seq=seq.substring(2000));
                //ncbiblast-R20160123-111557-0986-24712557-oy
                final BA data=new BA(999);
                String db=delToLstChr1(' ',_db),url=null;
                if(_type==SEQ_BLASTER_WEB_EBI){/*X http://www.ebi.ac.uk/Tools/services/rest/ncbiblast?wadl */
                    data.a("email=christoph.gille@charite.de&align=0&")
                        .aWWW("program",prg)
                        .aWWW("alignments",s(maxi(100,mini(_type==SEQ_BLASTER_WEB_EBI?1000:2000,numAli))))
                        .aWWW("scores",s(maxi(100,mini(_type==SEQ_BLASTER_WEB_EBI?1000:2000,numAli))))
                        //  .aWWW("match_scores","1,-3").aWWW("gapopen","-1").aWWW("gapext","-1")
                        .aWWW("stype",0!=(_opt&BLAST_NUCLEOTIDE_DB)?"dna":"protein")
                        .aWWW("sequence",seq)
                        .aWWW("database",_DB_uniprot==db?(db="uniprotkb"):db);
                    if(sensitivity==1) data.aWWW("exp","100").aWWW("compstats","F");//.aWWW("filter","false");
                    if(0!=(_opt&BLAST_NO_GAPS)) data.aWWW("gapalign","false");
                    //{"compstats","F"},{"filter","F"},{"dropoff","0"},
                    url=s(new BA(99).aa(cmd,"run/"));
                }else if(_type==SEQ_BLASTER_WEB_NCBI){/*X https://ncbi.github.io/blast-cloud/dev/api.html */
                    final String db2=db==_DB_uniprot?"swissprot":db;
                    data.a("CMD=Put&FORMAT_TYPE=XML&")
                        .aWWW("QUERY",seq)
                        .aWWW("DATABASE",db2)
                        .aWWW("HITLIST_SIZE",s(maxi(100,mini(500,numAli))))
                        .aWWW("ALIGNMENTS",s(maxi(100,mini(500,numAli))))
                        .aWWW("PROGRAM",prg)
                        .aWWW(strEquAt(STR_IC,"swissprot",db2,0) || db==_DB_pdb?null:"NCBI_GI","on");
                    if(wordSize>1) data.aWWW("WORD_SIZE",s(mini(7,wordSize)));
                    //if(0!=(_opt&BLAST_NO_GAPS)) data.aWWW("GAPCOSTS","11 1");
                    if(sensitivity!=0) data.aWWW("EXPECT",sensitivity<=3?"1e-1":"100");
                    url=cmd;
                }
                IF_GUI(_log.a(_logPfx).aln(_rendererTxt));;
                _log.a(_logPfx).aln("Command line equivalent\n ").aShellQuote(wgetCurlCmd(url,"-",data)).aln();
                final BA hasRid=serverRspns(url,data,null);
                _log.aa(_logPfx,"hasRid=").aln(hasRid);
                Object rid=null;
                int seconds=0;
                if(_type==SEQ_BLASTER_WEB_EBI){
                    _urlResultHtml=urlXML=s(new BA(99).aa(cmd,"result/",rid=s(hasRid),"/xml"));
                    urlStatus=s(new BA(99).aa(cmd,"status/",rid));
                }else{
                    final int b=strstr(0,"<!--QBlastInfoBegin",hasRid),e=b<0?-1:strstr(0,"-->",hasRid,b,MAX_INT);
                    if(e>0){
                        seconds=atoi(hasRid,strstr(STR_AFTER,"RTOE =",hasRid,b,e));
                        final int eq=strstr(STR_AFTER,"RID =",hasRid,b,e);
                        if(eq>0){
                            urlXML=s(new BA(99).aa(cmd,"?CMD=Get&FORMAT_TYPE=XML&RID=",rid=wordAt(hasRid,nxt(0,chrClas(-SPC),hasRid,eq+1,e))));
                            _urlResultHtml=s(new BA(99).aa(cmd,"?CMD=Web&PAGE_TYPE=BlastFormatting&RID=",rid));
                        }
                    }
                }
                if(sze(rid)==0){
                    _log.a(_logPfx).aln(hasRid);
                    return null;
                }
                _log.aa(_logPfx,"\nFor web browser: "+ANSI_FG_BLUE,_urlResultHtml).aln(ANSI_RESET).aln(urlStatus).aln(urlXML);
                runCR(RUN_ENABLE_DISABLE,this);
                BA xml=null;
                final int logEnd=_log.end();
                FORt(0,2222){
                    sleepMS(_db==_DB_pdb?3000:5000+t*10);
                    _log.setEnd(logEnd).aa(url," Seconds=",(timeOn()-_time)/1000,'/',seconds).del("/0").send();
                    CPP_AS_OBJECT(CharSequence) status=null;
                    int ok=0;
                    if(_type==SEQ_BLASTER_WEB_EBI){
                        if(0>strstr(0,"RUNNING",status=readBytes(urlOpnStrm(0,urlStatus,null,_log)))){
                            if(strstr(0,"FINISHED",status)<0) ok=CFALSE;
                            else{
                                ok=CTRUE;
                                xml=readBytes(urlOpnStrm(0,urlXML,null,_log),new BA(1000*333));
                            }
                        }
                    }else{
                        if(null==(xml=readBytes(urlXML))) status="NULL";
                        else if(strstr(STR_w,status="Status=WAITING",xml)>0){}
                        else if(strstr(STR_w,status="Status=FAILED",xml)>0 || strstr(STR_w,status="Status=UNKNOWN",xml)>0) ok=CFALSE;
                        else if(strStarts(status="<?xml",xml.trim())) ok=CTRUE;
                    }
                    _log.aln().aa(_logPfx,"Status=").aWithoutPfx("Status=",status).aln();
                    if(ok==CTRUE) return xml;
                    if(ok==CFALSE) break;
                }
                _log.a(_logPfx).aln(ANSI_RED+"Timeout"+ANSI_RESET);
            }catch(Throwable ex){stckTrc(123,ex);}
            return null;
        }
    }
    private final static String[][][]_DB=new String[SEQ_BLASTER_ZZZ][][];
    public String[]getAvailableDatabases(int opt){
        final String env=iConst(SARRAYeq_BLASTDB_ENV,_type);
        if(env!=null){
            final String BLASTDB=getEnv(env);
            final File dirDB=file(BLASTDB);
            final Object error=
                BLASTDB==null?new BA(99).aa("Shell variable $",env," is not set"):
                !isDir(dirDB)?new BA(99).aa(" No such directory:  $",env,'=',BLASTDB):
                null;
            if(error!=null){
                _log.aa(_logPfx,RED_ERROR).aln(error);
                return NO_String;
            }
            _log.aa(_logPfx,"The environment variable ",env," has the value").aln(BLASTDB);
            final Collection v=new ArrayList(99);
            {
                final String ext=iConst(SARRAYeq_BLASTDB_EXT,_type);
                for(String s:lstDir(dirDB)) if(s.endsWith(ext)) v.add(delSfx(ext,s));
                _log.aa(_logPfx,"Databases found in ",BLASTDB,' ').aln(v);
                if(sze(v)==0) _log.aa(_logPfx,RED_ERROR,": No database files with ending ",ext,"\nfound in ").aln(dirDB);
            }
            return toStrgArray(0,v);
        }else{
            if(_DB[_type]==null){
                final String[]ss=splitTkns('|',iConst(SARRAYeq_SequenceBlaster_DBS,_type));
                _DB[_type]=new String[][]{splitTkns(';',ss[0]),splitTkns(';',ss[1])};
            }
            return _DB[_type][(0==(opt&BLAST_NUCLEOTIDE_DB))?1:0];
        }
    }
/* The variable ..BLASTDB points to the directory where databases are installed. */
/* Strap reads this directory to provide a List of available databases.  */
/* <<< command line <<< */
#include "SequenceBlaster_Parser_Inc.java"
}
