package charite.christo.strap;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
@*H

   Simple 3D-views show the C-alpha trace of one or several proteins as polygons.
   Helices may be drawn in red and sheets in yellow or different peptide chain are drawn in different colors.

    Advantages over sophisticated 3D-views:
   <UL>
   <LI>Minimal memory consumption</LI>
   <LI>Applies transformation matrices of biological molecules. E.g. in the case of virus capside, the entire biological molecule is shown.</LI>
   </UL>
*@
public class Simple3D extends AbstractView3d{
    public Simple3D(){super(V3D_SIMPLE,Simple3DCanvas.class);}
    protected Matrix3D _mxPreview;
    protected int _iColor,_colorHeteros=1,_showNucl=1,_clickedA,_shiftRange;
    protected Object _colorChooser,_butNucl,_cbHetero,_cbCS,_toolPnl,_pLabel;
    protected long _molecules=-1;
    public ResidueSelectionImpl simple3dResSel(){
        final Protein p=sp(this);
        ResidueSelectionImpl s=(ResidueSelectionImpl)gcp(_KEY_SIMPLE3D_RESSEL,p);
        if(p!=null&&s==null){
            pcp(_KEY_SIMPLE3D_RESSEL,s=new ResidueSelectionImpl(RESSEL_IMPL_BACKBONE),p);
            setProt(p,s);
            addToProt(s,p);
        }
        return s;
    }
/* --- Interface View3d --- */
}
