package charite.christo.strap;
import charite.christo.*;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
#define DEPTH 64
/* (NUM1 0) */
#define LINE 0
#define DISC 1
#define PLUS 2
#define CROSS 3
#define LETTER 4
#define LETTER_SELECTED 5
/*---*/
#define SEC_STRU -1
#define CHAINS -2
#define INVISIBLE -3
#define KEY_BIOMOL "P3$$M"
// !!!!!!!!!!!!!! KEY_BIOMOL FIXME
#define ASSEMBLY_ASYM 0
#define ASSEMBLY__ONE 1
#define ASSEMBLY__ONE_COLOR 2
#define ASSEMBLY_CUSTOM 3
/* (NUM1 1) */
#define NY 3
#define ICON_by_NY 10
#define COLORS_SIZE 26
/* (NUM1 0) */
#define FAINT_WHITE 0
#define FAINT_RED 1
#define FAINT_YELLOW 2
#define FAINT_GREEN 3
#define FAINT_ZZZ 4
/* --- */
@*~RSC_Simple3D_TIP_ASSEMBLY
 The four options are <OL>
 <LI>The <i>HTMLDOC_BUTTON:BUTS_WEB_Asymmetric_Unit!</i> as recorded in the ATOM-lines of the PDB-file.</LI>
 <LI>The WIKI:Macromolecular_assembly is  reconstructed from the transformation matrices given in PDB and CIF-files.</LI>
 <LI>Same as above. Each chain gets a different color to contrast adjacent chains.</LI>
 <LI>The user can specify what bio-molecules he wants to see.</LI>
 </OL>
*@
@*SARRAY_Simple3D_tableAssembly_title
 Protein or PDB-ID|Available assemblies|Selected assembly
*@
@*SARRAY_Simple3D_tableAssembly_tip
 |Molecules recorded in the PDB file|List of molecule numbers entered by the user
*@
@*SARRAYeq_Simple3D_CHOICE_BIO
 Asymmetrical unit=ASSEMBLY_ASYM
 Customized=ASSEMBLY_CUSTOM
 First assembly=ASSEMBLY__ONE
 First assembly with colors=ASSEMBLY__ONE_COLOR
*@
@*SARRAYeq_BALLOON_SIMPLE3D_COLOR
 <HTML><BODY>Helices <font color="#FF0000"> red</font> and sheets <font color="#AAAA00"> yellow</font></BODY></HTML>=0
 Each chain in a different color=1
 Hide protein=2
 The entire protein in the respective color=
*@
@*RSC_Simple3D_MSG_BIO_MOL
 Biological molecules are assembled from the <i>HTMLDOC_BUTTON:BUTS_WEB_Asymmetric_Unit!</i> with transformation matrices.
 Matrices are recorded in PDB files like<PRE class="data">REMARK 350 BIOMOLECULE ...</PRE>
 Table columns:
 <OL><LI>Molecule</LI>
 <LI>Available assemblies</LI>
 <LI>Select assemblies. To hide, enter a non-existing number such as "99". Leave table cell empty to see the <i>HTMLDOC_BUTTON:BUTS_WEB_Asymmetric_Unit!</i>.</LI></OL><BR>
*@
#define sbTmp() baClr(69)
#define COLORS_ATOMS_SIZE 256
public final class Simple3DCanvas extends AbstractView3dCanvas{
#define _lines _X[45]
    private static float[]_xyzT;
    private final static Color[]
        FAINT[]=new Color[FAINT_ZZZ][],
        COLORS_SECSTRU[]=new Color[256][],
        COLORS_ATOMS[]=new Color[COLORS_ATOMS_SIZE][],
        COLORS[]=new Color[COLORS_SIZE][];
    private final Runnable
        _runLayout=thrdCR(_RUN_SIMPLE3D_LAYOUT,this),
        _runMsg=thrdCR(_RUN_SIMPLE3D_MSG,this);
    private final Matrix3D _tmat=new Matrix3D(),_m3D=new Matrix3D().scale(5f);
    private final Line MOUSE=new Line(),MOUS_HET=new Line();
    private final Object
        _dataBio[][][]=new Object[2][][],
        PAN_SE=pnl(),
        _transp[]=new Component[99],
        _bb[]=newButtns(this,SBUTS_SIMPLE3D_AAA|(SBUTS_SIMPLE3D_ZZZ<<16));
    private final Component _choiceAssembly=new ChJCombo(JLIST_DEFAULT_RENDERER|JLIST_ICON_ROW_HEIGHT,arry(SARRAYeq_Simple3D_CHOICE_BIO));
    private boolean _dragged,_isWheel,_notYetScaled=true,_mouseIn;
    private Object _sliderDistDna,_shiftRangeV;
    private int _meanDuration=33,_size,_countLines,_ox,_oy,_prevx,_prevy,_thumbY[],_whenKeyEvent;
    private double _dxMean,_dyMean,_dzMean,_mzT;
    private float _scale=1;
    private final float[]_xyzCursor=new float[3];
    private ChJTable _tableBio;
/* >>> Instance >>> */
    public Simple3DCanvas(){
        super();
        IF_MEIN_DEBUG(assert ICON_by_NY==ICON_HGT/NY);;
        if(FAINT[FAINT_WHITE]==null){
            {
                final int rgbs[]=intArry(SARRAY_V3D_CHAIN_RGBS);
                ROFi0(rgbs.length) COLORS[i]=fainted(rgbs[i]);
            }
            Color[][]cc;
            Arrays.fill(cc=COLORS_SECSTRU,FAINT[FAINT_WHITE]=fainted(0xFFffFF));
            cc['h']=cc['H']=FAINT[FAINT_RED]=fainted(0xFF0000);
            cc['e']=cc['E']=FAINT[FAINT_YELLOW]=fainted(0xAAaa00);
            Arrays.fill(cc=COLORS_ATOMS,fainted(0xFFffFF));
            cc['n']=cc['N']=fainted(0x0000FF);
            cc['o']=cc['O']=fainted(0xff0000);
            cc['s']=cc['S']=fainted(0xffFF00);
            cc['p']=cc['P']=FAINT[FAINT_GREEN]=fainted(0x00ff00);
        }
        addLi(this,LSTNR_MOMO|LSTNR_MO|LSTNR_FOCUS|LSTNR_KEY|LSTNR_WHEEL,rtt(this));
        setMinSze(1,1,this);
        setBG(0,this);
        setLayout(null);
        setTip(io(RSC_Simple3D_TIP_ASSEMBLY),
               addLi(this,LSTNR_MOMO,
                     pcp(KOPT_HIDE_IF_DISABLED,"",
                         addActLi(this,
                                  setSelIdx(ASSEMBLY__ONE,
                                            _choiceAssembly)))));
    }
    private Simple3D[]_vv(){return (Simple3D[])_vPV.asArray();}
    private Matrix3D mx3d(Simple3D pv){
        if(pv==null) return null;
        if(runCR(RUN_SIMPLE3D_IS_PREVIEW,this)!=null) return pv._mxPreview;
        final Protein p=sp(pv);
        return pv._mxPreview!=null?pv._mxPreview: p!=null?p.getRotationAndTranslation():null;
    }
    private void setAssemblyOne(){for(Simple3D v:_vv()) v._molecules=1<<1;}
/* <<<  Instance <<< */
/* ---------------------------------------- */
/* >>> Thread >>> */
    private static boolean[]_selBuffer;
    CPP_RUN_ID_ARG(){
        final Object ret=super.run(id,arg);
        switch(id){
            CASE_ARGV(RUN_SIMPLE3D_IS_PREVIEW){
                for(Simple3D pv:_vv()) if(pv._mxPreview!=null) return TRUEr;
                break;
            }
            CASE_ARG(RUN_SIMPLE3D_SET_HIDE_DISTANT_DNA,Object,cb){
                if(_sliderDistDna==null) _sliderDistDna=new ChJSlider(CHJSLIDER_Simple3DCanvas_distanceDna,this);
                final ChFrame f=ChFrame.frame(FRAME_CENTER,"Distant DNA",_sliderDistDna).size(100,64);
                if(isSlct(cb)) f.shw(FRAME_ALWAYS_ON_TOP);
                else awtc(AWTC_SET_VISIBLE_OFF,f);
                BREAK;
            }
            CASE_ARG(RUN_SIMPLE3D_EACH_CHAIN_ONE_COLOR,int,options){
                final int opt=options;
                boolean changed=false;
                FORi(0,sze(_vPV)){
                    final Simple3D pv=(Simple3D)iThEl(i,_vPV);
                    final Protein p=sp(pv);
                    if(p==null) continue;
                    final String chain=p.getChain();
                    if(sze(chain)==1){
                        final int c=chrAt(0,chain),newCol=(0!=(opt&CHAINCOLOR3D_AS_CHAIN) && is(DIGT,c)?c+('P'-'A'-'0'): 0!=(opt&CHAINCOLOR3D_AS_CHAIN) && is(LETTR,c)?(c|32)-'a': COLORS_SIZE-1-(i%COLORS_SIZE))% COLORS_SIZE;
                        changed|=newCol!=pv._iColor;
                        if(0==(opt&CHAINCOLOR3D_TEST)) pv._iColor=newCol;
                    }
                }
                RETURN changed?TRUEr:null;
            }
            CASE_ARGV(RUN_ENABLE_DISABLE){
                boolean isBioUnits=false;
                for(Simple3D pv:_vv()){
                    final Protein p=sp(pv);
                    setEnbld(p.getMolecules(CHAINTYPE_HET).length>0,pv._cbHetero);
                    setEnbld(p.getMolecules(CHAINTYPE_NUC).length>0,pv._butNucl);
                    isBioUnits=isBioUnits||getAssemblyMatrices(p).length>0;
                }
                runCR1(RUN_SIMPLE3D_EACH_CHAIN_ONE_COLOR,this,io(CHAINCOLOR3D_AS_CHAIN|CHAINCOLOR3D_TEST));
                if(null!=awtc(isBioUnits?(AWTC_SET_ENABLED|AWTC_OPT_OR_NULL):(AWTC_SET_DISABLED|AWTC_OPT_OR_NULL),_choiceAssembly)) inEDTms(_runLayout,333);
                break;
            }
            CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
                if(evtType[0]==EVT_RESIDUE_SELECTION) runCR(RUN_ENABLE_DISABLE,this);
                BREAK;
            }
            CASE_ARG(RUN_PROVIDE_TOOLTIP,Object,objOrEv){
                if(objOrEv==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                final Simple3D pv=(Simple3D)gcp(KEY_Simple3D,evtSrc(objOrEv));
                if(pv!=null && evtSrc(objOrEv)==pv._colorChooser){
                    final int mx=x(objOrEv),my=y(objOrEv);
                    FORi(0,COLORS_SIZE){
                        final int ix=i/NY,iy=i%NY,x=ix*ICON_by_NY,y=iy*ICON_by_NY;
                        if(x<=mx && mx<=x+ICON_by_NY && y<=my && my<=y+ICON_by_NY) return iConst(SARRAYeq_BALLOON_SIMPLE3D_COLOR,i);
                    }
                }
                RETURN(null);
            }
            CASE_ARGV(RUN_AVIEW3D_HIGHLIGHT_ATOMS,Selection3D[],atoms,Object,pv){
                final boolean[]bb=_selBuffer=selection3dToBoolZ(atoms,sp(pv),_selBuffer);
                _xyzCursor[0]=Float.NaN;
                ROFi0(bb.length) if(bb[i]) highlightAminoAcid(i,(Simple3D)pv);
                BREAK;
            }
            CASE_ARGV(RUN_AFTER_DISPOSE) inEDTms(_runLayout,111);BREAK;
            CASE_ARGV(RUN_AVIEW3D_INTERPRET,BA,command,AbstractView3d,pv){
                final int cmd=v3dCmdInLine(command),L0=sze(iConst(SARRAY_STRAP_SCRIPT_CMD,cmd));
                if(v3dIsSupporting(cmd,pv)){
                    if(cmd==iV3DCMD_background) setBG((int)(0xFFffFF&v3dRgbInScript(command)),this);
                    else if(cmd==iV3DCMD_reset) _m3D.unit().scale(5);
                    else if(cmd==iV3DCMD_biomolecule){
                        final long m=atolDecHex(command,L0);
                        ((Simple3D)pv)._molecules=m<0?0:m;
                        int sel=m<0?ASSEMBLY_ASYM:ASSEMBLY_CUSTOM;
                        if(m>0) ROFi0(ASSEMBLY_CUSTOM) if(0!=(m&(1L<<i))) sel=i;
                        setSelIdx(sel,_choiceAssembly);
                    }
                    awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_100,this);
                }
                BREAK;
            }
            CASE_ARG(RUN_V3D_TO_CANVAS_IMPL,Object,view3D){
                if(view3D instanceof Simple3D){
                    final Simple3D pv=(Simple3D)view3D;
                    pv._cbCS=buttn(STOGS_SIMPLE3D_AS);
                    final Protein p=sp(pv);
                    buttn(STOGS_SIMPLE3D_HETERO);
                    {
                        int count=0;
                        final Object[]bb=new Object[99];
                        pv._cbHetero=buttn(STOGS_SIMPLE3D_HETERO);
                        bb[count++]=pv._cbHetero;
                        bb[count++]=pv._cbCS;
                        addSrvc(RUN_SERVICE_PAINTHOOK,this,bb[count++]=pv._colorChooser=
                                specifcLstnrWithChilds(MOLI_REFRESH_TIP,
                                                       setTip(this,
                                                              pcp(KEY_PREF_SIZE,dim(((COLORS_SIZE-1)/3+2)*ICON_HGT/3,ICON_HGT),
                                                                  new ChButton(null)))));
                        bb[count++]=pv._butNucl=buttn(SBUTS_SIMPLE3D_N);
                        bb[count++]=buttn(SBUTS_SIMPLE3D_CLOSE);
                        {
                            final Object weakRef=wref(pv);
                            for(Object b:bb) if(pcp(KEY_Simple3D,weakRef,addLi(this,LSTNR_MO,b)) instanceof ChButton) addActLi(this,b);
                        }
                        addLi(this,LSTNR_MO,pv._toolPnl=pnl(CNSEW,pnl(pv._pLabel=newSeqLabel(0,p)),null,null,pnl(bb),BRDR_LBEVEL));
                    }
                    pv._iColor=SEC_STRU;
                    _vPV.add(pv);
                assembly1:
                    ROFi0(sze(_vPV)){
                        for(Matrix3D m3d:getAssemblyMatrices(sp(iThEl(i,_vPV)))){
                            if(m3d._assemblyID==1){
                                setAssemblyOne();
                                setSelIdx(1,_choiceAssembly);
                                break assembly1;
                            }
                        }
                    }
                    drawProteins(null);
                    _notYetScaled=true;
                }
                BREAK;
            }
            CASE_ARGV(_RUN_SIMPLE3D_MSG){
                if(mouseMsgRect.width>0) repaint(mouseMsgRect);
                mouseMsgPrepare();
                if(mouseMsgRect.width>0) repaint(mouseMsgRect);
                break;
            }
#if WRITE_CONCATENATED_JAVA||defined _SIMPLE3D_RUN_BIOMOL
            CASE_ARGV(_SIMPLE3D_RUN_BIOMOL,Protein,p,int,i){
                final Simple3D pv=simple3dForProtein(p);
                if(pv!=null){
                    pv._molecules=i==-1?0:i;
                    setSelIdx(i==-1?ASSEMBLY_ASYM: ASSEMBLY_CUSTOM,_choiceAssembly);
                    awtc(AWTC_OPT_REPAINT,this);
                }
                _notYetScaled=true;
                BREAK;
            }
#endif //WRITE_CONCATENATED_JAVA||defined _SIMPLE3D_RUN_BIOMOL
            CASE_ARGV(_RUN_SIMPLE3D_LAYOUT){
                awtc(AWTC_REMOVE_ALL,this);
                final int w=getWidth(),h=getHeight();
                final float lastScale=_scale;
                MOUSE.molecule=MOUS_HET.molecule=null;
                final Component cb=(Component)_bb[STOGS_SIMPLE3D_LIST_PROTEINS];
                if(w>16*EX){
                    cb.setBounds(0,h-prefH(cb),prefW(cb),prefH(cb));
                    add(cb);
                }
                if(isSlct(cb) && w>16*EX && sze(_vPV)>0){
                    final JScrollPane sp=scrllpn(0,PAN_SE);
                    add(sp);
                    awtc(AWTC_REMOVE_ALL,PAN_SE);
                    {
                        int maxWidth=1;
                        for(Simple3D pv:_vv())  maxWidth=maxi(maxWidth,prefW(pv._toolPnl));
                        final int gridH=mini(_vv().length,maxi(1,(w-cb.getWidth())/maxWidth)),gridV=(_vv().length-1)/gridH+1;
                        ((Container)PAN_SE).setLayout(new GridLayout(gridV,gridH));
                        ROFi0(3)  setBrdrC(null,awtc(AWTC_SET_OPAQUE_OFF,i==0?PAN_SE: i==1?sp: sp.getViewport()));
                        ROFi0(mini(_transp.length,gridH*gridV-_vv().length)){
                            if(_transp[i]==null) setBrdrC(null,_transp[i]=pnl(ALIAS_OPAQUE_FALSE));
                            adC(_transp[i],PAN_SE);
                        }
                    }
                    for(Simple3D pv:_vv()) adC(pv._toolPnl,PAN_SE);
                    awtc(AWTC_OPT_REPAINT,PAN_SE);
                    int ht=prefH(PAN_SE),wt=prefW(PAN_SE);
                    if(wt>w-32) {wt=w-32; ht+=EX; sp.setHorizontalScrollBarPolicy(JScrollPane_HORIZONTAL_SCROLLBAR_ALWAYS);}
                    else sp.setHorizontalScrollBarPolicy(JScrollPane_HORIZONTAL_SCROLLBAR_NEVER);
                    if(ht>h/2) {ht=h/2; wt+=EX; sp.setVerticalScrollBarPolicy(JScrollPane_VERTICAL_SCROLLBAR_ALWAYS);}
                    else sp.setVerticalScrollBarPolicy(JScrollPane_VERTICAL_SCROLLBAR_NEVER);
                    sp.setBounds(w-wt-3,h-ht-3,wt,ht);
                    if(w>0) _scale=(w-(float)ht)/w;
                }else{
                    _scale=1;
                }
                if(!Float.isNaN(_scale) && _scale!=lastScale) _m3D.scale(_scale/lastScale);
                runCR(RUN_ENABLE_DISABLE,this);
/* int x=w; */
/* final Component[]ccNE=vNE.asArray(); */
/* ROFi0(ccNE.length) { */
/*     final Component c=ccNE[i]; */
/*     final int ph=prefH(c),pw=prefW(c); */
/*     if((x-=pw-1)>0 || i==ccNE.length-1) { */
/*         c.setBounds(x,0,pw,ph); */
/*         add(c); */
/*         if(i==ccNE.length-1 && c instanceof ChButton)  ((ChButton)c).setContentAreaFilled(w<4*EX); */
/*     }else remove(ccNE[i]); */
/* } */
#define x w
                int y=x<16*EM?ICON_HGT:0;
                if(w>16*EM){
                    final int ph=prefH(_choiceAssembly);
                    _choiceAssembly.setBounds(0,y,prefW(_choiceAssembly),ph);
                    y+=ph+1;
                    add(_choiceAssembly);
                }else remove(_choiceAssembly);
                awtc(AWTC_OPT_REPAINT,this);
#undef x
                break;
            }
            CASE_ARG(RUN_PAINT_HOOK_BEFORE,Object,component)
                CASE_ARG(RUN_PAINT_HOOK_AFTER,Object,component){
                final Graphics g=_paintHookG;
                final Simple3D pv=(Simple3D)gcp(KEY_Simple3D,component);
                if(pv!=null && component==pv._colorChooser){
                    if(id==RUN_PAINT_HOOK_BEFORE) return FALSEr;
#define isDoc gcp(HTMLDOC_KEY_DO_NOT_CLONE,component)!=null
                    final int iC=pv._iColor;
                    g.setColor(iC<0?C(0):  COLORS[iC%COLORS_SIZE][0]);
                    g.fillRect(0,0,999,999);
                    final Protein p=sp(pv);
                    ROFi0(COLORS_SIZE+3){
                        final int x=i/NY*ICON_by_NY+4,y=(i%NY)*ICON_by_NY+1;
                        switch(i){
                        case 0:
                            if(p.getResidueSecStrType()!=null || isDoc){
                                setColorRGB(0xFF0000,g);
                                g.fill3DRect(x,y,ICON_by_NY-1,ICON_by_NY-1,iC!=SEC_STRU);
                                setColorRGB(0xFFff00,g);
                                g.fillRect(x,y+ICON_by_NY/2,ICON_by_NY-2,ICON_by_NY/2-1);
                            }
                            break;
                        case 1:
                            if(isDoc){
                                g.setColor(C(0));
                                g.fill3DRect(x,y,ICON_by_NY-1,ICON_by_NY-1,iC!=CHAINS);
                                FORj(y+2,y+ICON_by_NY-1) {g.setColor(COLORS[j%COLORS_SIZE][0]); g.drawLine(x+2,j,x+ICON_by_NY-2,j);}
                            }
                            break;
                        case 2:
                            setColorRGB(0,g);
                            g.fill3DRect(x,y,ICON_by_NY-2,ICON_by_NY-2,iC!=INVISIBLE);
                            g.setColor(C(0xFFffFF));
                            g.drawRect(x,y,ICON_by_NY-2,ICON_by_NY-2);
                            break;
                        default:
                            g.setColor(COLORS[i-3][0]);
                            g.fill3DRect(x,y,ICON_by_NY-1,ICON_by_NY-1,i!=iC+3);
                        }
                    }
                }
#undef u
#undef isDoc
                BREAK;
            }/*X RUN_PAINT_HOOK_AFTER*/
        }
#define cmd evtCmd(ev)
#define bid evtBid(ev)
#define ev arg
        if(RUN_M_EVT(id)){
            final Object q=evtSrc(ev);
            if(bid==STOGS_SIMPLE3D_LIST_PROTEINS) runR(_runLayout);
            if(bid==STOG_3D_COLOR_ENTIRE_PROTEIN||q instanceof ChTableModel || bid==SBUTS_SIMPLE3D_RST_BIO || bid==STOGS_SIMPLE3D_ORDERED_BY_ID) setSelIdx(ASSEMBLY_CUSTOM,_choiceAssembly);
            if(q==this){
                final Protein p=sp(evt2thumb(ev));
                //if (p!=null && processEvt(ev,pv._pLabel)) return;
                if(p!=null && id==RUN_M_mouseDragged && !_dragged){
                    adUniq(p.getFile(),clr(dndV(this)));
                    exportDrg(this,(EventObject)ev,TransferHandler_COPY);
                }
                if(gcp(KEY_IS_RESIZING,this)!=null) return null;
                if(evtScaleUpDown(ev)!=0){
                    //_tmat.unit();
                    _m3D.mult(_tmat.unit().scale(1f+(evtScaleUpDown(ev)<0?-20f: 20f)/maxi(1,getHeight())));
                    awtc(AWTC_OPT_REPAINT,this);
                }
            }
            if(id==RUN_M_stateChanged || bid==STOG_3D_COLOR_ENTIRE_PROTEIN) repaint();
            {
                final boolean
                    showTableBio=(cmd!=null || id==RUN_M_mousePressed) && ((bid==STOGS_SIMPLE3D_ORDERED_BY_ID || q==_choiceAssembly || bid==SBUTS_SIMPLE3D_RST_BIO) && getSlctIdx(_choiceAssembly)==ASSEMBLY_CUSTOM),
                    rstDataBio=showTableBio && _dataBio[0]==null || bid==SBUTS_SIMPLE3D_RST_BIO;
                if(rstDataBio){
                    final Collection v=new ArrayList(),vPdbId=new ArrayList();
                    final Map<String,long[]>mapMol=new HashMap();
                    boolean moreMolecules=false,hasPdbId=false;
                    final Protein[]pp=rmNullPP(spp(_vPV));
                    sortArry(pp,comparator(COMPARE_NAME));
                    for(Protein p:pp){
                        for(Matrix3D m3d:getAssemblyMatrices(p)) moreMolecules|=m3d._assemblyID>1;
                        hasPdbId=hasPdbId||p.getPdbID(PDBID_ID)!=null;
                    }
                    setEnbld(moreMolecules,_bb[STOGS_SIMPLE3D_ORDERED_BY_ID]);
                    ROFt0(2){/*X t*/
                        clr(mapMol);
                        clr(vPdbId);
                        for(Protein p:pp){
                            final long iPropMol=atol(gcp(KEY_BIOMOL,p));
                            long mols=0;
                            for(Matrix3D m3d:getAssemblyMatrices(p)) mols|=1L<<m3d._assemblyID;
                            if(mols!=0){
                                if(hasPdbId && t==0){
                                    final String pdb=p.getPdbID(PDBID_ID);
                                    if(pdb!=null){
                                        long[]m=mapMol.get(pdb);
                                        if(m==null) mapMol.put(pdb,m=new long[2]);
                                        m[0]|=mols;
                                        if(iPropMol>0) m[1]|=iPropMol;
                                        adUniq(pdb,vPdbId);
                                    }
                                }else{
                                    v.add(new Object[]{p,s(sbTmp().boolToText(mols,0,"-")),s(sbTmp().boolToText(gcp(KEY_BIOMOL,p)!=null?iPropMol:mols,0,"-")),null});
                                }
                            }
                        }
                        if(hasPdbId && t==0){
                            for(String pdbId:toStrgArray(TO_SARRAY_SORT,vPdbId)){
                                final long mols=mapMol.get(pdbId)[0],iPropMol=mapMol.get(pdbId)[1];
                                final String s=s(sbTmp().boolToText(mols,0,"-"));
                                v.add(new Object[]{pdbId,s,iPropMol>0?s(sbTmp().boolToText(iPropMol,0,"-")):  (mols&2)!=0?"1":s});
                            }
                        }
                        _dataBio[t]=toArryClr(v,NO_Objects);
                    }
                }
                final int bioByID=isSlct(_bb[STOGS_SIMPLE3D_ORDERED_BY_ID])?0:1;
                if(showTableBio){
                    if(_tableBio==null){
                        final ChTableModel tm=new ChTableModel(JLIST_SET_VALUE_SELECTED_ROWS,arry(SARRAY_Simple3D_tableAssembly_title),IF_CHECK_CODE((Collection))null).editable(0xC/*false,false,true,true*/);
                        addActLi(this,tm);
                        addLi4CntxtMenu(_tableBio=new ChJTable(JLIST_DEFAULT_RENDERER|JLIST_ICON_ROW_HEIGHT,tm).headerTip(arry(SARRAY_Simple3D_tableAssembly_tip)));
                        final Object pTxt=pnl(rsc(RSC_Simple3D_MSG_BIO_MOL)),pMsg=pnl(VBHB,pnlTogglOpts(TOGGL_PNL_BioUnitx|TOGGL_PNL_OPT_PACK,pTxt),pTxt);
                        pcp(KEY_NORTH_PANEL,pMsg,_tableBio);
                        pcp(KEY_SOUTH_PANEL,pnl(_bb[STOGS_SIMPLE3D_COLOR_CHAIN]," "," ",_bb[STOGS_SIMPLE3D_ORDERED_BY_ID],_bb[SBUTS_SIMPLE3D_RST_BIO]),_tableBio);
                    }else{
                        _tableBio.setRowHeight(32+bioByID);
                        awtc(AWTC_OPT_REPAINT,_tableBio);
                    }
                    ChFrame.frame(FRAME_AT_CLICK,"Customized",_tableBio).shw(FRAME_TO_FRONT)
                        .setLocation(screenX(_choiceAssembly)-2*ICON_HGT,screenY(_choiceAssembly)+3*ICON_HGT);
                    ROFi0(3) _tableBio.setColWidth(i==0?200:i==1?64:200,TABLE_COLUMN_RESIZABLE|i);
                    awtc(AWTC_OPT_REPAINT,this);
                }
                if((showTableBio||rstDataBio) && _tableBio!=null) runCR1(RUN_TABLEMODEL_setData,_tableBio.getModel(),_dataBio[bioByID]);
                if(q instanceof ChTableModel || q==_choiceAssembly || showTableBio || rstDataBio || bid==STOGS_SIMPLE3D_ORDERED_BY_ID){
                    if(getSlctIdx(_choiceAssembly)==ASSEMBLY_CUSTOM && _dataBio[bioByID]!=null){
                        for(Object[]row:_dataBio[bioByID]){
                            FORi(0,sze(_vPV)){
                                final Protein p=sp(iThEl(i,_vPV));
                                if(p!=null && (p==row[0]||row[0]==p.getPdbID(PDBID_ID))){
                                    final Simple3D pv=simple3dForProtein(p);
                                    final String s=toStrgTrim(row[2]);
                                    if(pv!=null && s!=null) pv._molecules=sze(s)==0?-1: boolToLong(parseSetStrg(s,0,999));
                                }
                            }
                        }
                        awtc(AWTC_OPT_REPAINT,_tableBio);
                    }else setAssemblyOne();
                    awtc(AWTC_OPT_REPAINT,this);
                }
            }
            final boolean shift=0!=(SHIFT_MASK&evtModi(ev)),ctrl=0!=(CTRL_MASK&evtModi(ev));
            final int x=x(ev),y=y(ev);
            {
                final Simple3D pv=(Simple3D)gcp(KEY_Simple3D,q);
                if(ev instanceof java.awt.event.MouseEvent && pv!=null){
                    if(id==RUN_M_mousePressed && q==pv._colorChooser){
                        final int f=((x-4)/ICON_by_NY)*NY+y/ICON_by_NY;
                        pv._iColor=f==0?SEC_STRU: f==1?CHAINS: f==2?INVISIBLE: f-3;
                        runCR(RUN_ENABLE_DISABLE,this);
                    }
                    if(ctrl) for(Simple3D d:_vv()) d._iColor=pv._iColor;
                    awtc(AWTC_OPT_REPAINT,this);
                }
                if(id==RUN_M_actionPerformed){
                    if(pv!=null){
                        if(bid==SBUTS_SIMPLE3D_N && ++pv._showNucl>2) pv._showNucl=0;
                        for(Simple3D d:_vv()){
                            if(ctrl || pv==d){
                                if(bid==SBUTS_SIMPLE3D_CLOSE) dispos(d);
                                if(bid==SBUTS_SIMPLE3D_N && !shift) d._showNucl=pv._showNucl;
                                if(bid==STOGS_SIMPLE3D_AS) setSlct(isSlct(q),d._cbCS);
                                if(q==pv._cbHetero){
                                    if(shift&&ctrl) {pv._colorHeteros++; setSlct(!isSlct(q),pv._cbHetero);}
                                    if(!shift) {setSlct(isSlct(pv._cbHetero),d._cbHetero); d._colorHeteros=pv._colorHeteros;}
                                }
                            }
                        }
                        if(q==pv._cbHetero || bid==STOGS_SIMPLE3D_AS || bid==SBUTS_SIMPLE3D_N) repaint();
                    }
                }
            }
            final int H=maxi(1,getHeight()),W=maxi(1,getWidth());
            if(q==this){
                final int k=evtKeyCode(ev);
                final Simple3D v=(Simple3D)(k!=0?_shiftRangeV:MOUSE.molecule);
                final Protein p=sp(v);
                if(k!=0 && id==RUN_M_keyPressed && (!ctrl&&!shift)){
                    _tmat.unit();
                    if(k== VK_UP || k==VK_DOWN) {_m3D.mult(ctrl?_tmat.scale(k==VK_UP?1.1f:.9f): _tmat.rotate('x',k==VK_UP?.1:-.1)); repaint();}
                    if(k==VK_PAGE_UP||k==VK_PAGE_DOWN) {_m3D.mult(_tmat.rotate('x',k==VK_PAGE_UP?3.1415: -3.1415)); repaint();}
                    _whenKeyEvent=timeOn();
                }
                if(id==RUN_M_focusLost || id==RUN_M_focusGained) repaint();
                int range1=0,range2=0;
                boolean changed=false;
                if(p!=null && (ctrl||shift) && (k==VK_LEFT||k==VK_RIGHT)){
                    range1=v._shiftRange;
                    if(ctrl) v._shiftRange=(k==VK_LEFT?0:p.countRes());
                    else v._shiftRange+=(k==VK_LEFT?-1:  1);
                    range2=v._shiftRange;
                }
                if(ev instanceof java.awt.event.MouseEvent){
                    setTipTiming(id==RUN_M_mouseMoved && !shift && !ctrl?500: -1,0);
                    final int iA=MOUSE.idx;
                    if(id==RUN_M_mouseClicked){
                        awtc(AWTC_REQUEST_FOCUS,this);
                        if(p!=null){
                            if(v!=null){
                                mkEvtPickedV3d(v,p.resnAt(0,iA),p.getChain(),chrAt(iA+p.subsetStart(),p.getResidueInsCode()),-1);
                                if(shift){
                                    range1=iA;
                                    range2=v._clickedA;
                                }else{
                                    changed=resSelSetAminoSelected(ctrl?SELECTION_TOGGLE:SELECTION_ONLY,iA+firstResIdx(p),ALIAS_POSITION_PLUS_1,v.simple3dResSel());
                                    v._shiftRange=v._clickedA=iA;
                                    _shiftRangeV=v;
                                }
                            }
                        }
                    }
                    if(!ctrl && evtWheel(ev)!=0){
                        _isWheel=true;
                        _m3D.mult(_tmat.unit().rotate('z',evtWheel(ev)*.1f));
                        MOUSE.molecule=MOUS_HET.molecule=null;
                        awtc(AWTC_OPT_REPAINT,this);
                    }
                    if(id==RUN_M_mouseReleased || id==RUN_M_mouseMoved&&!shift){
                        _isWheel=false;
                        if(_dragged){_dragged=false;repaint();}
                    }
                    if(id==RUN_M_mouseMoved){
                        if(!shift && findMouse(x-_ox,y-_oy)){
                            mouseMsg[0]=mouseMsg[1]=mouseMsg[2]=null;
                            inEDTms(_runMsg,11);
                        }
                        if(p!=null){
                            int cursor=Cursor_DEFAULT_CURSOR;
                            final boolean cbCS=isSlct(v._cbCS);
                            for(ResidueSelection sel:p.aaSelectionsAtZ(iA,ALIAS_POSITION_PLUS_1,VIS123_STRUCTURE|VIS123_OPT_NO_MOUSE_OVER)){
                                if(gcp(FEATURE_ACTIVE_SITE,sel)!=null && !cbCS) continue;
                                if(sel instanceof Simple3D || sel instanceof ResidueAnnotation){
                                    cursor=Cursor_HAND_CURSOR;
                                    continue;
                                }
                            }
                            setCursrC(cursor,this);
                        }
                    }
                    if(evtButtn(ev)!=2 && (id==RUN_M_mouseDragged || id==RUN_M_mouseMoved&&shift)){
                        if(!_dragged){
                            _prevx=x;
                            _prevy=y;
                            _dragged=true;
                            return null;
                        }
                        {
                            _tmat.unit();
                            final float
                                dx=(_prevx-x)*2f/W,
                                dy=(_prevy-y)*2f/H;
                            if(!ctrl && !shift && evtButtn(ev)!=3 && evtButtn(ev)!=2 || id==RUN_M_mouseMoved){
                                _tmat.rotate('x',4f*dy);
                                _tmat.rotate('y',4f*dx);
                            }else{
                                if(ctrl && !shift) _tmat.rotate('z',-4f*dx);
                                if(shift && !ctrl) _tmat.scale(1f-dy*2).rotate('z',-4f*dx);
                            }
                            _m3D.mult(_tmat);
                        }
                        _prevx=x;
                        _prevy=y;
                        MOUSE.molecule=MOUS_HET.molecule=null;
                        awtc(AWTC_OPT_REPAINT,this);
                    }
                    if(id==RUN_M_mouseEntered || id==RUN_M_mouseExited) _xyzT=null;
                }
                if(range1!=range2 && v!=null) changed=resSelSetAminoSelected(SELECTION_ADD,mini(range1,range2)+firstResIdx(p),maxi(range1,range2)+firstResIdx(p)+1,v.simple3dResSel());
                if(changed){
                    awtc(AWTC_OPT_REPAINT,this);
                    strapEvtDispatch(EVT_RESIDUE_SELECTION);
                }
            }
            if(!_dragged){
                if(_mouseIn?
                   (id==RUN_M_mouseExited&&evtButtn(ev)!=1 && (q==this||parentC(q)==this && (x<2||y<2||x>W-3||y>H-3))):
                   (id==RUN_M_mouseMoved||id==RUN_M_mouseEntered)){
                    _mouseIn=!_mouseIn;
                    repaint();
                }
            }
        }
        return ret;
    }
#undef bid
#undef cmd
#undef ev
/* <<< Thread <<< */
/* ---------------------------------------- */
/* >>>  Single Shapes >>> */
    private static class Line implements Comparable{
        Object molecule;
        int x0,y0,z0,x1,y1;
        Color[]color;
        short idx;
        Object m3d;
        byte style,chainType;
        OVERRIDE_PUBLIC int compareTo(Object o){
            if(o==null) return -1;
            final float z=((Line)o).z0;
            return z<z0?-1: z>z0?1:0;
        }
    }
    private void boundingBox(Line[]lines,final int nLines){
        double mxT,myT;
        float xminT,xmaxT,yminT,ymaxT,zminT,zmaxT;
        xminT=yminT=zminT=MAX_INT;
        xmaxT=ymaxT=zmaxT=MIN_INT;
        mxT=myT=_mzT=_dxMean=_dyMean=_dzMean=0;
        int styleLine=0;
        FORi(0,nLines){
            final Line l=lines[i];
            if(null==l){
                MEIN_ASSRT();
            }else if(l.style==LINE) styleLine++;
        }
        int iLines=0;
        FORi(0,nLines){
            final Line l=lines[i];
            if(l==null || (styleLine>2 && l.style!=LINE)) continue;
            if(l.x0<xminT) xminT=l.x0;
            if(l.x0>xmaxT) xmaxT=l.x0;
            if(l.y0<yminT) yminT=l.y0;
            if(l.y0>ymaxT) ymaxT=l.y0;
            if(l.z0<zminT) zminT=l.z0;
            if(l.z0>zmaxT) zmaxT=l.z0;
            mxT+=l.x0;
            myT+=l.y0;
            _mzT+=l.z0;
            iLines++;
        }
        if(iLines==0) return;
        mxT/=iLines; myT/=iLines; _mzT/=iLines;
        // --- Mean derivation ---
        FORi(0,nLines){
            final Line l=lines[i];
            if(l==null || (styleLine>2 && l.style!=LINE)) continue;
            final float dx=xminT-l.x0,dy=yminT-l.y0,dz=zminT-l.z0;
            _dxMean+=(dx>0?dx:-dx);
            _dyMean+=(dy>0?dy:-dy);
            _dzMean+=(dz>0?dz:-dz);
        }
        _dxMean/=iLines;
        _dyMean/=iLines;
        _dzMean/=iLines;
        if(_dzMean==0) _dzMean=.1f;
        _ox=(int)(getWidth()/2F-mxT);
        final int visH=getHeight()-(isSlct(_bb[STOGS_SIMPLE3D_LIST_PROTEINS])?scrllpn(0,PAN_SE).getHeight():0);
        _oy=(int)(visH/2F-myT);
    }
    private Collection _onlyOneHet=new HashSet();
    private void drawProteins(Graphics g){
        Line[]lines=(Line[])deref(_lines);
        if(lines==null) _lines=newSoftRef(lines=new Line[100*1000]);
        int iLine;
        clr(_onlyOneHet);
        while(true){
            iLine=0;
            for(Simple3D pv:_vv()){
                final Protein p=sp(pv);
                if(p!=null){
                    final boolean het=isSlct(pv._cbHetero),nuc=pv._showNucl>0;
                    final int what=!het&&!nuc?-1: !het&&nuc?CHAINTYPE_NUC:het&&!nuc?CHAINTYPE_HET:CHAINTYPE_NUC_OR_HET;
                    if(what>=0) for(Protein h:p.getMolecules(what)) if(_onlyOneHet.add(h)) iLine=makeLines(lines,h,pv,iLine);
                    if(_onlyOneHet.add(p)) iLine=makeLines(lines,p,pv,iLine);
                }
            }
            if(iLine+99>lines.length) _lines=newSoftRef(lines=new Line[iLine+9999]); else break;
        }
        _countLines=iLine;
        if(g!=null){
            boundingBox(lines,iLine);
            Arrays.sort(lines,0,iLine);
            drawLines(true,lines,iLine,g);
        }
    }
    private int makeLines(Line[]lines,Protein p,Simple3D pv,int iL){
        final int choiceBio=getSlctIdx(_choiceAssembly);
        if(pv._iColor==INVISIBLE) return iL;
        final Matrix3D[]mm3d=choiceBio==ASSEMBLY_ASYM?null: getAssemblyMatrices(p);
        final int type=p.getIntProperty(PROTEINI_CHAINTYPE);
        final float[]xyz=type==CHAINTYPE_HET?p.getAtomXYZ(null): p.getResidueCalphaXYZ(null);
        if(xyz!=null){
            final int subsetEnd=type==CHAINTYPE_HET?xyz.length/3:p.subsetEnd(),het32=type==CHAINTYPE_HET?p.getResidueName32()[0]:0;
            final float[]xyzT=_xyzT=redim(_xyzT,xyz.length,99);
            Arrays.fill(xyzT,Float.NaN);
            final byte[]ss=p.getResidueSecStrType();
            final boolean cbCS=isSlct(pv._cbCS);
            boolean hasActiveSite=false;
            ROFm0(maxi(1,sze(mm3d))){
                final int iColor=choiceBio==2?m:pv._iColor;
                Matrix3D m3d=null;
                if(choiceBio!=ASSEMBLY_ASYM && mm3d.length>0){
                    if(sze(mm3d)<=m||
                       (m3d=mm3d[m])!=null&&
                       ((p.getChain()!=null&&idxOfStrg(0,p.getChain(),m3d._chains)<0||
                         (choiceBio==ASSEMBLY_CUSTOM?pv._molecules!=-1&&(pv._molecules&(1L<<m3d._assemblyID))==0:m3d._assemblyID!=1)))) continue;
                    if(isUnitOrNull(m3d)) m3d=null;
                }
                _tmat.unit().mult(m3d).mult(mx3d(pv)).mult(_m3D).transformPoints(xyz,p.subsetStart(),subsetEnd,xyzT);
                {
                    final short[]hetElement=type==CHAINTYPE_HET?p.getResidueElement(false,0):null;
                    for(int iA=0,i3=0;iA<subsetEnd-p.subsetStart() && i3+3<xyzT.length;  iA++,i3+=3){
                        if(Float.isNaN(xyzT[i3]-xyzT[i3+3])) continue;
                        final Line l=iL>=lines.length?null: lines[iL]==null?lines[iL]=new Line(): lines[iL];
                        iL++;
                        if(l!=null){
                            byte stl=LINE;
                            Color[]colors=FAINT[FAINT_GREEN];
                            l.idx=(short)iA;
                            l.m3d=m3d;
                            l.molecule=type==CHAINTYPE_PEP?pv:p;
                            l.x0=(int)xyzT[i3  ]; l.y0=(int)xyzT[i3+1]; l.z0=(int)xyzT[i3+2];
                            l.x1=(int)xyzT[i3+3]; l.y1=(int)xyzT[i3+4];
                            l.chainType=(byte)type;
                            if(type==CHAINTYPE_HET){
                                colors=(pv._colorHeteros&1)!=0 && sze(hetElement)>iA?COLORS_ATOMS[hetElement[iA]%COLORS_ATOMS_SIZE]: (iColor>=0?COLORS[iColor%COLORS_SIZE]:FAINT[FAINT_WHITE]);
                                stl=DISC;
                                final int n=het32,A8='A'<<8,M8='M'<<8,O8='O'<<8,N8='N'<<8,I8='I'<<8,E8='E'<<8;
                                if(n=='N'+A8||n=='S'+E8||n=='N'+I8) stl=PLUS;
                                else if(n=='N'+M8||n=='Z'+N8||n=='M'+N8||n=='M'+I8||n=='F'+E8||n=='C'+O8) stl=CROSS;
                            }else if(type==CHAINTYPE_PEP){
                                final boolean bioCol=choiceBio==ASSEMBLY_CUSTOM && isSlct(_bb[STOGS_SIMPLE3D_COLOR_CHAIN]);
                                if(!bioCol && iColor==SEC_STRU){
                                    colors=COLORS_SECSTRU[iThByte(iA+p.subsetStart(),ss)];
                                }else if(!bioCol && iColor==CHAINS){
                                    if(sze(p.getChain())==1) colors=COLORS[ (chrAt(0,p.getChain())+(26-'A'%26))%COLORS_SIZE];
                                }else{
                                    colors=bioCol?COLORS[((iColor>=0?iColor:0)+m)%COLORS_SIZE]:
                                        iColor>=0?COLORS[iColor%COLORS_SIZE]:
                                        FAINT[FAINT_WHITE];
                                }
                            }
                            l.color=colors;
                            l.style=stl;
                        }
                    }
                }
                for(ResidueSelection s:p.resSel(SOBJECT_RESSEL_AND_RESAN)){
                    if(gcp(FEATURE_ACTIVE_SITE,s)!=null){
                        hasActiveSite=true;
                        if(!cbCS) continue;
                    }
                    if(vis123isThere(VIS123_STRUCTURE,s)){
                        final Color[]colors=fainted(rgba(getColrO(s),RGBA_FOR_NULL));
                        final boolean[]bb=s.getSelectedAminoacids();
                        final int
                            off=s.getSelectedAminoacidsOffset()-firstResIdx(p),A=mini(sze(bb)+off,subsetEnd-p.subsetStart()),
                            style=idxOf(s,selectedResidueSelections(SOBJECT_RESSEL_AND_RESAN))>=0?LETTER_SELECTED:LETTER;
                        FORa(maxi(0,off),A){
                            if(bb[a-off]){
                                if(iL>=lines.length) break;
                                Line l=lines[iL];
                                if(l==null) l=lines[iL]=new Line();
                                l.molecule=null;
                                if(a*3+2>=xyzT.length) break;
                                l.style=(byte)style;
                                if(Float.isNaN(xyzT[a*3])) continue;
                                l.x0=(int)xyzT[a*3];
                                l.y0=(int)xyzT[a*3+1];
                                l.z0=(int)xyzT[a*3+2];
                                l.x1=p.getResTypeAt(a);
                                l.color=colors;
                                iL++;
                            }
                        }
                    }
                }
            }
            setEnbld(hasActiveSite,pv._cbCS);
        }
        return iL;
    }
    private void drawLines(boolean all,Line[]lines,int n,Graphics g){
        Color color=null;
        final String[]strgLen1=arry(SARRAYeq_STRGSLEN1);
        final int clip[]=clipBnds(g),charH,charA;
        {
            final Font f=mkFont(12,Font_BOLD);
            g.setFont(f);
            charH=charH(f);
            charA=charA(f);
        }
        FORi(0,n){
            final Line l=lines[i];
            if(!all && l.chainType!=CHAINTYPE_PEP) continue;
            {
                final int z=(int)((l.z0-_mzT)/_dzMean*DEPTH+DEPTH/4);
                final Color c=(l.molecule!=null && l.molecule==MOUS_HET.molecule?FAINT[FAINT_YELLOW]:l.color)[maxi(0,mini(DEPTH-1,z))];
                if(color!=c) g.setColor(color=c);
                if(_dragged && _meanDuration>33 && z>(_meanDuration>55?DEPTH/3:DEPTH/2)) continue;
            }
            final int x=_ox+l.x0,y=_oy+l.y0,x1=_ox+l.x1,y1=_oy+l.y1,style=l.style;
            if((x<clip[RECTx] && (style!=LINE||x1<clip[RECTx]))||
               (x>clip[RECTx]+clip[RECTw] && (style!=LINE || x1>clip[RECTx]+clip[RECTw]))||
               (y<clip[RECTy]) && (style!=LINE || y1<clip[RECTy])||
               (y>clip[RECTy]+clip[RECTh] && (style!=LINE || y1>clip[RECTy]+clip[RECTh]))) continue;
            switch(style){
            case LINE:g.drawLine(x,y,x1,y1);break;
            case PLUS:g.drawLine(x-3,y,x+3,y); g.drawLine(x,y-3,x,y+3);break;
            case CROSS:g.drawLine(x-3,y-3,x+3,y+3); g.drawLine(x+3,y-3,x-3,y+3);break;
            case LETTER_SELECTED:
            case LETTER:
                g.drawString(strgLen1[(byte)(l.x1&127)],x,y);
                if(style==LETTER_SELECTED) g.drawOval(x-charH/3,y-charA,charH,charH);
                break;
            default:g.fillOval(x-2,y-2,4,4);
            }
        }
    }
/* <<< Shapes <<< */
/* ---------------------------------------- */
/* >>> Paint >>> */
    private final Rectangle mouseMsgRect=new Rectangle();
    private final String[]mouseMsg=new String[3];
    private final int[]mouseMsgX=new int[3],mouseMsgW=new int[3];
    private void mouseMsgPrepare(){
        final int a=MOUSE.idx;
        final Simple3D pv=(Simple3D)MOUSE.molecule;
        final Graphics g=(Graphics)_g;
        if(g==null || pv==null){
            mouseMsg[0]=mouseMsg[1]=mouseMsg[2]=null;
            mouseMsgRect.setBounds(0,0,0,0);
            return;
        }
        int wMax=0;
        final int x0=_ox+MOUSE.x0,y0=_oy+MOUSE.y0;
        int bx1=mini(x0-3,_ox+MOUSE.x1-3);
        int bx2=maxi(x0+3,_ox+MOUSE.x1+3);
        final int by1=mini(y0-3,_oy+MOUSE.y1-3,y0-3*charH(g));
        final int by2=maxi(y0+3,_oy+MOUSE.y1+3);
        final Protein p=sp(pv);
        setMouseOverSequence(p,a+firstResIdx(p));
        ROFi0(3){
            final BA sb=baClr(70);
            switch(i){
            case 0:
                if(sze(_vPV)<2) continue;
                sb.a(p);
                break;
            case 1:
                if(a>=0) p.resnAsText(0,a,sb.aa(' ',a,' ').aBytesAdj(p.getResName32At(a),4).a(' '));
                break;
            case 2:
                if(getSlctIdx(_choiceAssembly)!=ASSEMBLY_ASYM && MOUSE.m3d!=null) sb.a("Assembly ID ").a(((Matrix3D)MOUSE.m3d)._assemblyID);
                //.a(" BIOMT:").a(MOUSE.m3d._matrixNum);
                break;
            }
            final int textWidth=mouseMsgW[i]=strgWidth(g,mouseMsg[i]=s(sb));
            wMax=maxi(wMax,textWidth);
            bx1=mini(bx1,mouseMsgX[i]=mini(x0,getWidth()-textWidth));
            bx2=maxi(bx2,mouseMsgX[i]+textWidth);
        }
        mouseMsgRect.setBounds(bx1,by1,bx2-bx1,by2-by1);
    }
    OVERRIDE_PUBLIC void paintComponent(Graphics g){
        final int W=getWidth(),H=getHeight();
        if(_mouseIn && !_dragged && _size!=W+H) {_mouseIn=false;  inEDTms(_runLayout,111); _size=W+H;}
        final int time=timeOn(),clip[]=clipBnds(g,W,H);
        g.setColor(isCbSlct(TOG_WHITE_BG)?C(0xFFffFF): getBackground());
        g.fillRect(clip[RECTx],clip[RECTy],clip[RECTw],clip[RECTh]);
        g.setColor(getForeground());
        drawProteins(g);
        final Color white=C(0xFFffFF);
        if(gcp(KOPT_JUST_WRITING_PNG,this)==null){
            final Simple3D pv=(Simple3D)MOUSE.molecule;
            if(pv!=null){
                setColorRGB(RGBA_PINK,g);
                final int y0=_oy+MOUSE.y0;
                g.fillOval(_ox+MOUSE.x0-3,y0-3,6,6);
                g.drawOval(_ox+MOUSE.x1-3,_oy+MOUSE.y1-3,6,6);
                if(W>ICON_HGT && sp(pv)!=null && !_isWheel && !_dragged && timeOn()-_whenKeyEvent>999){
                    final int charA=charA(g),charH=charH(g);
                    ROFl0(3){
                        final String msg=mouseMsg[l];
                        if(msg!=null){
                            setColorRGB(0x66000000,g);
                            final int y=y0+(l-3)*charH;
                            g.fillRect(mouseMsgX[l],y,mouseMsgW[l],charH);
                            g.setColor(white);
                            g.drawString(msg,mouseMsgX[l],y+charA);
                        }
                    }
                }
            }
        }
        _meanDuration=(_meanDuration*9+(timeOn()-time))/10;
        _hlAminoAcid();
        //if (awtc(AWTC_IF_HAS_FOCUS,this)!=null) {g.setColor(RED); g.drawLine(0,0,9999,0);}
        if(_notYetScaled){
            _notYetScaled=false;
            final float d=(float)(_dxMean+_dyMean+_dzMean);
            if(d!=0) _m3D.mult(_tmat.unit().scale(Math.min(1,(H+W)/d/3)));
            awtc(AWTC_OPT_REPAINT,this);
        }
        if(W<=ICON_HGT){
            final int[]tYY=_thumbY=chSze(_thumbY,2*sze(_vPV));
            int y=H;
        nextProt:
            FORi(0,sze(_vPV)){
                final Image im=img(sp(iThEl(i,_vPV)));
                if(im!=null){
                    FORj(0,i)if(im==img(sp(iThEl(j,_vPV)))) continue nextProt;
                    tYY[2*i]=y-=W+1;
                    tYY[2*i+1]=y+W;
                    g.drawImage(im,0,y,W,W,this);
                }
            }
            pcp(TLAYOUT_KEY_HEIGHT_SOUTH_PANEL,io(y),this);
        }else{
            pcp(TLAYOUT_KEY_HEIGHT_SOUTH_PANEL,null,this);
        }
        _g=g;
        paintHooks(this,g,true);
        final String msg=gcps(KEY_MSG_NO_PROTEIN,this);
        if(msg!=null){
            setColorRGB(0xAAaaFF,g);
            g.drawString(msg,EX,EM);
        }
    }
    public void paintChildren(Graphics g){
        try{
            if(_mouseIn && !_dragged && gcp(KOPT_JUST_WRITING_PNG,this)==null) super.paintChildren(g);
        }catch(Exception e){}
    }
/* <<< Paint <<< */
/* ---------------------------------------- */
/* >>> Tooltip >>> */
    private String _tt;
    OVERRIDE_PUBLIC String getToolTipText(java.awt.event.MouseEvent ev){
        Simple3D pv=evt2thumb(ev);
        if(sp(pv)!=null) return s(addHtmlTags(runCR1(RUN_GET_TIP_TEXT,sp(pv),ev)));
        if(MOUS_HET.molecule!=null){
            if(_tt==null){
                final BA sb=baClr(30);
                {
                    final String rt=s(runCR1(RUN_GET_RENDERER_TXT,MOUS_HET.molecule,NULL_AS_INT));
                    sb.aa("<HTML><BODY><PRE>",rt," Matrix:");
                    final Matrix3D m3d=(Matrix3D)MOUS_HET.m3d;
                    if(m3d!=null) sb.a(m3d._assemblyID);
                }
                for(int isFirst=0,i=0,N=sze(_vPV);i<N;i++){
                    final Protein p=sp(iThEl(i,_vPV));
                    if(p!=null)
                        for(Protein h:p.getMolecules(CHAINTYPE_HET)){
                            if(MOUS_HET.molecule!=h) continue;
                            if(isFirst++==0) sb.a('\n');
                            sb.a(p);
                            break;
                        }
                }
                _tt=s(sb.a("</PRE></HTML></BODY>"));
            }
            return _tt;
        }
        {
            final Protein p=sp(pv=(Simple3D)MOUSE.molecule);
            if(p!=null){
                final boolean cbCS=isSlct(pv._cbCS);
                for(ResidueSelection sel:p.aaSelectionsAtZ(MOUSE.idx,ALIAS_POSITION_PLUS_1,VIS123_STRUCTURE|VIS123_OPT_NO_MOUSE_OVER)){
                    if(cbCS || gcp(FEATURE_ACTIVE_SITE,sel)==null) return s(addHtmlTags(s(orO(tip(sel),sel))));
                }
            }
        }
        return null;
    }
/* <<< Tooltip <<< */
/* ---------------------------------------- */
/* >>>  Event >>> */
    private Simple3D evt2thumb(Object ev){
        if(getWidth()<=ICON_HGT){
            final int tYY[]=_thumbY,y=y(ev);
            ROFi0(sze(tYY)/2) if(tYY[2*i]<y && y<tYY[2*i+1]) return(Simple3D)iThEl(i,_vPV);
        }
        return null;
    }
/* <<< Event <<< */
/* ---------------------------------------- */
/* >>> Mouse >>> */
    private boolean findMouse(int mx,int my){
        int distCA=MAX_INT,distHA=MAX_INT;
        short  dp_idx=0;
        Object h=null,pv=null;
        final Line[]lines=(Line[])deref(_lines);
        if(lines==null) return false;
        ROFi0(_countLines){
            final Line l=lines[i];
            if(l==null || (l.style==LETTER||l.style==LETTER_SELECTED)) continue;
            final int x=l.x0,y=l.y0;
            final Object mol=l.molecule;
            if(mol!=null){
                final int dx=x-mx,dy=y-my,dd=dx*dx+dy*dy;
                if(dd<8*8 && mol instanceof Protein){
                    if(distHA>dd){
                        distHA=dd;
                        if(MOUS_HET.molecule!=mol) _tt=null;
                        MOUS_HET.x0=x;
                        MOUS_HET.y0=y;
                        MOUS_HET.m3d=l.m3d;
                        h=mol;
                    }
                }else if(dd<8*8 && mol instanceof Simple3D && distCA>dd){
                    distCA=dd;
                    MOUSE.x0=x;
                    MOUSE.y0=y;
                    MOUSE.x1=l.x1;
                    MOUSE.y1=l.y1;
                    MOUSE.m3d=l.m3d;
                    dp_idx=l.idx;
                    pv=mol;
                }
            }
        }
        boolean changed= dp_idx!=MOUSE.idx || pv!=MOUSE.molecule;
        if(h!=MOUS_HET.molecule){
            MOUS_HET.molecule=h;
            changed=true;
            final Graphics g=getGraphics();
            if(g!=null) drawLines(false,lines,_countLines,g);
        }
        MOUSE.molecule=pv;
        MOUSE.idx=dp_idx;
        return changed;
    }
/* <<< Mouse <<< */
/* ---------------------------------------- */
/* >>> Highlight Residue >>> */
    private void _hlAminoAcid(){
        final float[]xyz=_xyzCursor;
        if(!isShowing() || Float.isNaN(xyz[0])) return;
        if(_xyzT==null) _xyzT=new float[3];
        _m3D.transformPoints(xyz,0,3,_xyzT);
        v3dHighlightAtoms(this,_ox+(int)_xyzT[0],_oy+(int)_xyzT[1]);
    }
    public void highlightAminoAcid(int idx,Simple3D pv){
        final Protein p=sp(pv);
        if(p==null) return;
        final float[]xyz=p.getResidueCalphaXYZ(null);
        if(xyz!=null){
            final int a3FL=(idx+p.subsetStart())*3;
            if(xyz.length>a3FL){
                _xyzCursor[0]=xyz[a3FL];
                _xyzCursor[1]=xyz[a3FL+1];
                _xyzCursor[2]=xyz[a3FL+2];
                final Matrix3D m3d=mx3d(pv);
                if(m3d!=null) m3d.transformPoints(_xyzCursor,0,1,_xyzCursor);
                _hlAminoAcid();
            }
        }
    }
/* <<<  Highlight Residue <<< */
/* ---------------------------------------- */
/* >>> Color >>> */
    CPP_PRIVATE static Color[]fainted(int rgb){
        if(rgb==0) rgb=0xffFFff;
        final Map m=weakmapNoClr(261);
        Color[]ret=(Color[])m.get(io(rgb));
        if(ret==null){
            m.put(io(rgb),ret=new Color[DEPTH+1]);
            double fR,fG,fB;
            fR=255&(rgb>>>16);
            fG=255&(rgb>>>8);
            fB=255&rgb;
            FORi(0,DEPTH+1){
                double k=DEPTH+1-i; k=k/(DEPTH+1);
                ret[i]=new Color((int)(k*fR),(int)(k*fG),(int)(k*fB));
            }
        }
        return ret;
    }
/* <<< Paint <<< */
/* ---------------------------------------- */
/* >>> Class Single Peptide chain  >>> */
    public Simple3D simple3dForProtein(Protein prot){
        if(prot!=null) for(Simple3D pv:_vv()) if(sp(pv)==prot) return pv;
        return null;
    }
}
