// See  Strap_cases_DnD_Inc.java loadTheProteinsInList( // webAlignment getTransferData
@*SARRAY_DND_RADIO_TRANSFORMED_XYZ
 Simply copy the file|Write the protein with transformed coordinates
*@
@*SARRAY_DND_RADIO_CHAIN
 Drag only current protein chain|Drag all chains of the original structure file
*@
@*SARRAY_DND_RADIO_MSA
 Transfer only current protein in fasta format|Transfer complete multiple sequence file
*@
@*~RSC_dragOpts_delay
 Warning: There might be a delay<BR>of a few seconds for large files.
*@
@*~RSC_dragOpts_biomt
 Macromolecular assemblies are defined by BIOMT lines in the PDB file
*@
@*~RSC_dragOpts_dna
 <B>Options for RNA/DNA structures,ligands and hetero compounds</B> <i>HTMLDOC_BUTTON:TOG_DND_TRANSFORM_HETERO!</i>
*@
@*~RSC_dragOpts_msf
 <B>Options for multiple sequence files</B> (clustalW,MSF,Fasta,Stockholm)<BR>
*@
@*~RSC_dragOpts_pdb
 <B>Options for PDB structure files</B>
*@
@*~RSC_dragOpts_main
 <B><U>Options for sequence export via Drag-and-Drop</B></U>
*@

private static void removeLeadingSpace(BA ba){
    final byte[]T=ba.bytes();
    final boolean[]no_spc=chrClas(-SPC);
    for(int eol[]=ba.eol(),indent=MAX_INT,t=0;t<2;t++){/*X 1=do it*/
        FORiL(0,eol.length){
            final int b=BOL(iL,eol,ba),e=eolTrim(T,b,eol[iL]);
            if(b<e){
                if(t!=0){
                    System.arraycopy(T,b+indent,T,b,e-b-indent);
                    FORi(e-indent,e) T[i]=(byte)' ';
                }else{
                    final int noSpc=nxt(no_spc,T,b,e);
                    if(indent>noSpc-b) indent=noSpc-b;
                    if(indent==0) return;
                }
            }
        }
    }
}
/* --- Macosx has a bug. see CDataTransferer_dragQueryFile --- */
private void dropIntoJList(){
    final Object ee=gcp(KEY_DROP_ACCEPT_FILE_EXT,_drop[DROP_TARGET_JCOMPONENT]);
    if(ee!=null){
        final File[]ff=(File[])_drop[DROP_Files];
        FORi(0,sze(ff))if(strEnds(STR_IC,ee,ff[i])) adUniq(ff[i],(Collection)runCR(RUN_CHJLIST_GET_ARRAYLIST,_drop[DROP_TARGET_JCOMPONENT]));
        awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_drop[DROP_TARGET_JCOMPONENT]);
    }
}
public static int dragOptions(){
    pnlDragOptions();
    return
        (radioGrpIdx(_dragRadioMSA)==1?P_DRAG_MSA:0)|
        (radioGrpIdx(_dragRadioChn)==1?P_DRAG_ALL_CHAINS:0)|
        (radioGrpIdx(_dragRadioOri)==0?P_DRAG_ORIG:0)|
        (isCbSlct(STOG_dragBiom)?((getSlctIdx(_dragBiomChoice)+1)<<8):0);
}
private static Object pnlDragOptions(){
    if(_dragOpts==null){
        final String[]ss=new String[100];
        ROFi0(ss.length) ss[i]=plrl(1+i,"Molecule %N");
        final Object pnlBio=pnl(VBHB,pnl(HBL,_dragBiomChoice=new ChJCombo(ss)," ",rsc(RSC_dragOpts_delay)),rsc(RSC_dragOpts_biomt));
        _dragOpts=pnl(VBHB,pnl(HB,rsc(RSC_dragOpts_main),"#",buttn(BUTTN_CLASS_HELP_SMALL|BUT_C1(DialogExportProteins))),
                      pnl(VBHB,BRDR_ETCHED_EM,rsc(RSC_dragOpts_pdb),
                          _dragRadioOri=addActLiMain(radioGrp(SARRAY_DND_RADIO_TRANSFORMED_XYZ))," ",
                          _dragRadioChn=addActLiMain(radioGrp(SARRAY_DND_RADIO_CHAIN))," ",buttn(STOG_dragBiom).cp(BUTTN_KEY_COLLAPSE,pnlBio),pnl(pnlBio)," "),
                      pnl(VBHB,BRDR_ETCHED_EM,rsc(RSC_dragOpts_msf)," ",_dragRadioMSA=addActLiMain(radioGrp(SARRAY_DND_RADIO_MSA))),
                      pnl(VBHB,BRDR_ETCHED_EM,rsc(RSC_dragOpts_dna)),
                      buttn(SBUT_DND_RESTORE));
    }
    return _dragOpts;
}
private static void dropRows(BA data,int row,ResidueAnnotation a){
    boolean success=false;
    final ResidueAnnotation.Entry[]ee=a.entries();
    for(String line:splitLns(data)){
        final String[]ff=splitTkns('\t'|SPLIT_ALLOW_EMPTY_TOKENS,line);
        if(ff.length<3+2) continue;
        final int hc=atoi(ff,4),srcRow=atoi(ff,5);
        success=true;
        int mvE=-1;
        if(hc==a.hashCode()){
            ROFi0(ee.length){
                if(ff[RESAN_COL_KEY].equals(ee[i].key()) && ff[RESAN_COL_VALUE].equals(ee[i].value()) && (mvE=i)==srcRow) break;
            }
        }
        if(mvE>=0) adUniqR(a._vE.get(mvE),row,a._vE);
        else a.addE((isTrue(ff[RESAN_COL_CB])?0:RESAN_ENTRY_DISABLED) | (RESAN_ENTRY_ROW|(row<<RESAN_ENTRY_ROW_SHIFT)),ff[RESAN_COL_KEY],ff[RESAN_COL_VALUE]);
        runCR(RUN_INC_MC,a);
    }
    if(success){
        awtc(AWTC_REVALAND_REPAINT_MAYBE,getPnl(a));
        strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
    }
}
@*RSC_STRAP_SHOPPINGCARD_TOOLTIP
 Drop protein files and protein links into the shopping cart.<BR>The files will be loaded in Strap.<BR>It is detachable. Move it close to where the files or sequence links are.<BR><BR>
 <SUB>Limitations: Windows Internet Explorer and some versions of MS-Edge do not support Drag-and-drop.<BR>
  A good choice is Chromium. The portable version can be installed without admin rights.</SUB>
*@
private static Object shoppingCard(){
    if(_shoppingCard==null){
        addSrvc(RUN_SERVICE_PAINTHOOK,_main,
                specifcLstnrWithChilds(MOLI_REPAINT_ON_ENTER_AND_EXIT,
                                       setTip(io(RSC_STRAP_SHOPPINGCARD_TOOLTIP),
                                              addLiMain(LSTNR_MO,
                                                        _shoppingCard=pnl(CNSEW,null,null,null,null,
                                                                          pcp(BUTTN_KEY_OPENURL,hrefToUrlString(HREF_WEB_LINK|HREF_PLAIN_TEXT|HREF_PROTEIN_FILE,"Drop_Web_Link*"),buttn(SBUT_SHOPPING_CARD_HELP)),
                                                                          dim(9*EM+ICON_HGT*3/2,ICON_HGT+2))))));
        callPeriodically(99,thrdCR(_RUN_SHOPPING,_main));
        runCR1(RUN_NEW_DROPTARGET_RECURSIVE,_main,_shoppingCard);
    }
    return _shoppingCard;
}
