/* (NUM1 0) */
#define RESAN_EXISTS_REPLACE 0
#define RESAN_EXISTS_KEEP_AND_CREATE_ANOTHER 1
#define RESAN_EXISTS_SKIP 2
#define RESAN_EXISTS_CANCEL 3

@*SARRAYeq_RESAN_ASK_EXISTS
 Replace=RESAN_EXISTS_REPLACE Keep it and create another=RESAN_EXISTS_KEEP_AND_CREATE_ANOTHER  Skip it=RESAN_EXISTS_SKIP  Cancel=RESAN_EXISTS_CANCEL
*@
@*RSC_RESAN_ASK_EXISTS
 %N annotation%S with the name<BR><B><CENTER>@</CENTER></B><BR>already exists for this sequence.<BR>It is possible to have several annotations with the same name.<BR>How to proceed?<BR>
 <i>HTMLDOC_BUTTON:STOG_RESSEL_PROCEEDSAME!</i>
*@
/* ---------------------------------------- */
/* >>> ResidueSelection Bounding Box >>> */
public static int[]enclosingRectangle(Object[]pp_oo){
    int left=MAX_INT,right=MIN_INT,top=MAX_INT,bottom=MIN_INT;
    final Protein[]ppVis=strapVisibleProteins();
    for(Object o:oo(pp_oo)){
        final ResidueSelection s=derefRessel(o);
        final Protein p=sp(o);
        final int row=p!=null?idxOf(p,ppVis): -1;
        if(row>=0){
            final int a0=resSelFirstAmino(s);
            top=mini(top,row);
            bottom=maxi(bottom,row+1);
            if(a0>=0){
                final int nR=p.countRes(),a1=resSelLastAmino(s),idx1=firstResIdx(p);
                left=mini(left,p.getResColumnAt(mini(nR-1,a0-idx1)));
                right=1+maxi(right,p.getResColumnAt(mini(nR-1,a1-idx1)));
            }
        }
    }
    return top>bottom?null:new int[]{left,top,right-left,bottom-top};
}
/* <<< ResidueSelection Bounding Box <<< */
/* ---------------------------------------- */
/* >>> ResidueSelection >>> */
/** Displays a selection of residues so that the user can edit it */
private static void resSelRenameGroup(Object g){
    final String old=getTxt(g),neu;
    if(sze(neu=toStrgTrim(dlgInput("Please enter the new name for this group of annotations",old)))>0){
        for(Object o:oo(g)){
            if(o instanceof ResidueAnnotation && old.equals(((ResidueAnnotation)o).value(IRESAN_GROUP))) ((ResidueAnnotation)o).annoAdd(IRESAN_GROUP,neu);
        }
        setTxt(neu,g);
    }
    strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS);
}
public static BA resSelSequenceAsString(ResidueSelection sel,BA sb){
    final Protein p=sp(sel);
    final byte[]aa=p!=null?p.getResType():null;
    if(aa==null) return sb;
    final boolean[]bb=sel.getSelectedAminoacids();
    for(int off=resSelAminoOffsetZ(sel),I=mini(sze(bb),p.countRes()-off),i=maxi(0,-off);i<I;i++){
        if(bb[i]) sb.a((char)aa[i+off]); else sb.a1(',');
    }
    return sb.del(',');
}
public static BA resSelListFromTo(ResidueSelection[]ss,int minLen,BA sb){
    final Protein[]pp=spp(ss);
    sortVisibleOrder(pp);
    for(Protein p:pp){
        int frst=MAX_INT,last=MIN_INT;
        for(ResidueSelection s:ss){
            if(p!=sp(s)) continue;
            frst=mini(frst,resSelFirstAmino(s));
            last=maxi(last,resSelLastAmino(s));
        }
        if(frst>=0 && last-frst>=minLen){
            sb.a(p).a('/').a(frst+1);
            if(frst!=last) sb.a('-').a(last+1);
            sb.a('\n');
        }
    }
    return sb;
}
/* public static ResidueSelection[]resSelPlusSelected(boolean strictType,ResidueSelection[]ss){ */
/*     Collection<ResidueSelection>v=null; */
/*     for(int type:strictType?new int[]{SOBJECT_RESAN,SOBJECT_SEQFEAT,SOBJECT_RESSEL}: new int[]{SOBJECT_RESSEL}){ */

/*         final Object[]aa=selectedResidueSelections(type); */
/*         if(cntainsAtLeastOne(ss,aa)) adAllUniq(aa,v==null?v=new ArrayList(): v); */
/*     } */
/*     return v==null && ss!=null?ss: toArry(v,ResidueSelection.NONE); */
/* } */

@*SARRAYeq_RESSEL_TYPES_STRICT
SOBJECT_RESAN SOBJECT_SEQFEAT SOBJECT_RESSEL=RESSEL_TYPE_STRICT
SOBJECT_RESSEL=
*@
public static ResidueSelection[]resSelPlusSelected(int strict,ResidueSelection[]ss){
    Collection<ResidueSelection>v=null;
    for(int type:intArrys(SARRAYeq_RESSEL_TYPES_STRICT)[strict]){
        final Object[]aa=selectedResidueSelections(type);
        if(cntainsAtLeastOne(ss,aa)) adAllUniq(aa,v==null?v=new ArrayList(): v);
    }
    return v==null && ss!=null?ss: toArry(v,ResidueSelection.NONE);
}

static ResidueSelection[]resSelRmDuplicates(ResidueSelection[]resAnno){
    final Collection v=new ArrayList();
    final ResidueSelection[]aa=resAnno.clone();
    ROFi0(aa.length){
        final Protein p=sp(aa[i]);
        if(p==null) continue;
        final Class clazz=aa[i].getClass();
        final String nam=nam(aa[i]);
        ROFj0(aa.length){
            final ResidueSelection ai=aa[i],aj=aa[j];
            final Protein pj=sp(aj);
            if(ai==null || ai==aj || p!=sp(aj)||clazz!=aj.getClass()||
               !eq(nam,nam(aj))||
               clazz==ResidueAnnotation.class && !resSelEqualsA((ResidueAnnotation)ai,(ResidueAnnotation)aj)||
               !resSelEqualAminoPos(ai,aj)||
               (SSTYLE_MASK&ai.getStyle())!=(SSTYLE_MASK&aj.getStyle())) continue;

            rmFromProt(aj,pj);
            adUniq(aj,v);
            aa[j]=null;
        }
    }
    if(sze(v)>0) awtc(AWTC_OPT_REPAINT,runCR(RUN_ALIPANEL_GET_PANE,aliPanel()));
    return toArry(v,ResidueSelection.NONE);
}

private static Polygon _arrowL,_arrowR;
private static Stroke _strokeDotted;
@*~RSC_TITLE_CHOOSE_RESAN_TO_EDITED
 Choose residue selections to be edited
*@
REFLECTION_PUBLIC_STATIC_VOID resSelEdit(Object a_or_aa_or_jlist){
    if(a_or_aa_or_jlist==null) REFLECTION_RETURN;
    if(a_or_aa_or_jlist instanceof ResidueAnnotation[]){
        switch(sze(a_or_aa_or_jlist)){
        case 0:REFLECTION_RETURN;
        case 1:resSelEdit(fstNotNull((Object[])a_or_aa_or_jlist));break;
        default:
            final Object jl=new ChJList(JLIST_ICON_ROW_HEIGHT|JLIST_DEFAULT_RENDERER,a_or_aa_or_jlist);
            final Runnable r=CPP_thrdMS1(resSelEdit,Strap,jl);
            new ChFrame(0,s(rsc(RSC_TITLE_CHOOSE_RESAN_TO_EDITED)))
                .ad(pnl(CNSEW,scrllpn(SCRLLPN_EBORDER|SCRLLPN_INHERIT_SIZE|SCRLLPN_TOOLS,jl),null,
                        pnl(VBHB,rsc(RSC_TITLE_CHOOSE_RESAN_TO_EDITED),pnl(new ChButton(BUTS_GO,null).cp(BUTTN_KEY_CLOSE,ALIAS_PARENT_WINDOW).cp(KEY_RUN_ON_CLICK,r)))))
                .shw(FRAME_AT_CLICK|FRAME_PACK|FRAME_ALWAYS_ON_TOP);
            setSelIdx(0,jl);
        }
    }else if(a_or_aa_or_jlist instanceof JList){
        for(Object o:selValues(a_or_aa_or_jlist)) resSelEdit(derefResan(o));
    }else{
        if(TABBEDPANES[TABBEDPANE_RESAN]==null) setMinSze(1,1,setTitiBid(BUT_C1(TITI_Resan),addActLiMain(TABBEDPANES[TABBEDPANE_RESAN]=new ChTabPane(TPANE_RIGHT|TPANE_COLLAPSE))));
        TABBEDPANES[TABBEDPANE_RESAN].addTab(CLOSE_ALLOWED,getPnl(a_or_aa_or_jlist));
        addDialog(TABBEDPANES[TABBEDPANE_RESAN]);
    }
    REFLECTION_RETURN;
}
public static ResidueAnnotation[]resSelToResan(int opt,Object[]ss){
    Collection vOrig=null,vA=null;
    ROFi0(sze(ss)){
        final ResidueSelection s=derefRessel(ss[i]);
        final Protein p=sp(s);
        if(p==null || s instanceof ResidueAnnotation){
            if(0!=(opt&TO_RESAN_ALSO_RETURN_UNCHANGED)){
                vA=adNotNullNew(s,vA);
                if(0!=(opt&TO_RESAN_EDIT)) resSelEdit(s);
            }
            continue;
        }
        final int it=instType(s);
        final ResidueAnnotation a=annotateSeqStyleRgbPosNameGrp(p,SSTYLE_LOWER_HALF,0,selectedPositionsToText(s),
                                                      addPfx("copied_from_",s),
                                                      it==RESSEL_IMPL_CURSOR?nam(s):"copied");
        if(getColrO(s)!=null) runCR1(RUN_SET_COLOR,a,getColrO(s));
        if(0!=(opt&TO_RESAN_EDIT)) resSelEdit(a);
        if(it==RESSEL_IMPL_SELECTED || it==RESSEL_IMPL_BACKBONE) rmFromParentProt(s);
        else vOrig=adNotNullNew(s,vOrig);
        vA=adNotNullNew(a,vA);
    }
    final int n=sze(vOrig);
    if(n>0 && dlgYesNo(plrl(n,"%N persistant annotated residue selection object%S %H been created.<BR>Remove the original amino acid selection%S?"))){
        for(ResidueSelection s:toArry(vOrig,ResidueSelection.NONE)) rmFromParentProt(s);
    }
    if(vA!=null){
        setNotSaved();
        strapEvtDispatch(EVT_RESIDUE_SELECTION_ADDED|SEVTMS*111);
    }
    return toArry(vA,ResidueAnnotation.NONE);
}
static int resSelHeight(int style,int charH){
    return
        (style&SSTYLE_MASK)==SSTYLE_UNDERLINE?2:
        style==SSTYLE_LOWER_HALF || style==SSTYLE_UPPER_HALF?charH/2-2:
        charH-4;
}
static int _resselMaxUL=RESSEL_MAX_UNDERLINE;
static int resSelYT(int style,int charH){
    return(style&SSTYLE_MASK)==SSTYLE_UNDERLINE?charH+3*STYLE_TO_LINE(style):
        style==SSTYLE_LOWER_HALF?charH/2-1:
        0;
}
public static boolean[]resSelToAliColumns(ResidueSelection[]ss){
    boolean[]bb=NO_boolean;
    if(ss!=null){
        for(ResidueSelection s:ss){
            final Protein p=sp(s);
            if(p!=null) bb=orBB(bb,resSelToAliColumnsZ(s.getSelectedAminoacids(),resSelAminoOffsetZ(s),p),bb,99);
        }
    }
    return bb;
}
private static boolean[]resSelToAliColumnsZ(boolean[]sel,int offset,Protein p){
    boolean[]bb=null;
    ROFi0(lstTrue(sel)){
        if(!sel[i]) continue;
        final int col=p.getResColumnAt(i+offset);
        (bb==null?bb=new boolean[col+1]: bb)[col]=true;
    }
    return bb!=null?bb: NO_boolean;
}
static void drawResidueSelectionZ(boolean amino,byte chr,Protein p,ResidueSelection[]ss,int ia0,Graphics g,Rectangle r,int[]cb){
    g2D.translate(x(r),y(r));
    if(ss!=null){
        for(ResidueSelection s:ss){
            if(!vis123isThere(VIS123_SEQUENCE,s)) continue;
            final int ia,offset;
            final boolean bb[],notShowingAll;
            if(amino==P_AMINO_ACIDS){
                final boolean[]selected=s.getSelectedAminoacids();
                notShowingAll=selected!=(bb=resSelPosDisplayed(s));
                ia=ia0;
                offset=resSelAminoOffsetZ(s);
            }else{
                notShowingAll=false;
                ia=ia0;
                if(s instanceof SelectorOfNucleotides){
                    bb=((SelectorOfNucleotides)s).getSelectedNucleotides();
                    offset=((SelectorOfNucleotides)s).getSelectedNucleotidesOffset()-p.getIntProperty(PROTEINI_NT_IDX_OFFSET);
                }else{offset=0; bb=null;}
            }
            final int iBB=ia-offset;
            if(bb==null || iBB<0 || bb.length<=iBB || !bb[iBB]) continue;
            int style=s.getStyle();
            final int yT=resSelYT(style,cb[RECTh]),height=resSelHeight(style,cb[RECTh]);
            final boolean terminus= bb.length==iBB+1 || !bb[iBB+1];
            final int rW=terminus?maxi(3,r.width-3): r.width;
            Object image=null;
            if(style==SSTYLE_CURSOR) style=SSTYLE_BACKGROUND;
            else if((style==SSTYLE_IMAGE || style==SSTYLE_IMAGE_LUCID) && null==(image=runCR1(RUN_GET_IMAGE,s,null))) style=SSTYLE_BACKGROUND;
            final Color color=image!=null&&(style==SSTYLE_IMAGE_LUCID||style==SSTYLE_IMAGE)?null: getColr(s);
            if(color!=null){
                switch(style&255){
                case SSTYLE_HIDDEN:
                    break;
                case SSTYLE_CIRCLE:
                    g.setColor(color);
                    for(int d=0,w=rW,h=cb[RECTh];d<4;d++){
                        g.drawOval((rW-w)/2,(cb[RECTh]-h)/2,w,h);
                        w-=3;h-=4;
                    }
                    break;
                case SSTYLE_DOTTED:
                    final Stroke stroke0=g2D.getStroke();
                    if(_strokeDotted==null) _strokeDotted=new BasicStroke(1f,BasicStroke_CAP_BUTT,BasicStroke_CAP_BUTT,1f,new float[]{1f,1f},0);
                    g2D.setStroke(_strokeDotted);
                    g.setColor(color);
                    ROFy0(height) g.drawLine(y%2,y,rW-1,y);
                    g2D.setStroke(stroke0);
                    break;
                case SSTYLE_UNDERLINE:
#define ARROW_LEN 4
#define D 4
                    g.setColor(color);
                    if(notShowingAll && (iBB==1 || iBB>1 && iBB+2==bb.length)){
                        if(_arrowL==null){
                            final Polygon ar=_arrowR=new Polygon(),al=_arrowL=new Polygon();
                            ar.addPoint(ARROW_LEN,0);
                            ar.addPoint(0,D);
                            ar.addPoint(0,-D);
                            ar.addPoint(ARROW_LEN,0);
                            al.addPoint(0,0);
                            al.addPoint(ARROW_LEN,D);
                            al.addPoint(ARROW_LEN,-D);
                            al.addPoint(0,0);

                        }
                        g.setColor(argbToColor(color.getRGB()|(100<<24)));
                        final int transX=iBB==1?0: rW-ARROW_LEN;
                        g.translate(transX,yT);
                        g.fillPolygon(iBB==1?_arrowR:_arrowL);
                        g.translate(-transX,-yT);
                    }else fillRectBig(g,0,yT,rW,2);
#undef ARROW_LEN
#undef D
                    break;
                case SSTYLE_IMAGE:
                case SSTYLE_LOWER_HALF:
                case SSTYLE_UPPER_HALF:
                case SSTYLE_BACKGROUND:
                    g.setColor(color);
                    fillRectBig(g,0,yT,rW,height);
                    break;
                default:
                }
            }
            {
                final int h=hght(image);
                if(h>0){
                    final int w=wdth(image),chars=w*3/h/2;
                    if(chars>0){
                        final int w2=w/chars;
                        if(chars<2) g.drawImage((Image)image,0,yT,rW,height,imgObserver());
                        else{
                            final int x1=w2*(ia%chars);
                            g.drawImage((Image)image,0,yT,rW,height,x1,0,x1+w2,h,imgObserver());
                        }
                    }
                }
            }
        }
    }
    if(chr!=0 && chr!=32){
        setColorRGB(0,g);
        final String draw=arry(SARRAYeq_STRGSLEN1)[chr&127];
        final int a=y(cb),x=x(cb);
        g.drawString(draw,x+0,a);
        g.drawString(draw,x+1,a+1);
        g.drawString(draw,x-1,a-1);
        g.drawString(draw,x-1,a+1);
        g.drawString(draw,x+1,a-1);
    }
    g.translate(-x(r),-y(r));
}
private static ResidueSelectionImpl _mouseOverSel;
public static void setMouseOverSequence(Protein p,int ia){
    if(ia<0) ia=-1;
    ResidueSelectionImpl s=_mouseOverSel;
    final Protein pPrev=sp(s);
    final int iaPrev=s!=null?s.getSelectedAminoacidsOffset(): -1;
    if(p!=pPrev || ia!=iaPrev){
        rmFromProt(s,pPrev);
        if(p!=null && ia>=0 && ia<p.countRes()){
            if(s==null) setColorRGB(RGBA_PINK,_mouseOverSel=s=new ResidueSelectionImpl(RESSEL_IMPL_MOUSE_OVER));
            resSelSetAminoSelected(SELECTION_ONLY,ia,ALIAS_POSITION_PLUS_1,s);
            addToProt(s,p);
        }
        strapEvtDispatch(EVT_RESIDUE_SELECTION);
    }
}
public static boolean resSelChangeSelectedAA(boolean[]sel,int offset,ResidueSelection s){
    if(s==null) return false;
    final boolean changed=!eqBoolArraysOffset(sel,offset,s.getSelectedAminoacids(),s.getSelectedAminoacidsOffset());
    if(changed){
        s.setSelectedAminoacids(sel,offset);
        strapIncMC(P_MC_RES_SELECTIONS,sp(s));
    }
    return changed;
}

public static boolean resSelSetAminoSelected(int mode,int from,int to,ResidueSelection s){
    if(s==null) return false;
    if(to==ALIAS_POSITION_PLUS_1) to=from+1;
    final Protein p=sp(s);
    from=maxi(from,firstResIdx(p));
    if(p!=null) to=mini(to,p.countRes()+firstResIdx(p));
    final boolean[]bb0=s.getSelectedAminoacids();
    final int offs0=s.getSelectedAminoacidsOffset();
    int offs=offs0;
    boolean[]bb=null;
    final int t1=fstTrue(bb0),t2=lstTrue(bb0)+1;
    if(to<=from){
        if(mode==SELECTION_ONLY && t1>=0){
            bb=NO_boolean;
            offs=0;
        }
    }else if(mode==SELECTION_ONLY){
        if(from!=t1+offs0 || to!=t2+offs0 || to-from!=countTrue(bb0)){
            bb=setTrue(0,to-from,to-from==bb0.length?bb0:null);
            offs=from;
        }
    }else if(mode==SELECTION_RM){
        for(int i=maxi(from-offs0,t1);i<to-offs0 && i<t2;i++) if(bb0[i]) (bb=bb0)[i]=false;
    }else if(mode==SELECTION_ADD){
        if(from<offs0 || to>bb0.length+offs0){
            bb=new boolean[maxi(t2+offs0,to)-(offs=mini(from,t1+offs0))];
            if(t1>=0) System.arraycopy(bb0,t1,bb,offs0+t1-offs,t2-t1);
        }
        FORi(from-offs,to-offs){
            if(!(bb!=null?bb:bb0)[i])  (bb==null?bb=bb0:bb)[i]=true;
        }
    }
    if(bb!=null){
        s.setSelectedAminoacids(bb,offs);
        strapIncMC(P_MC_RES_SELECTIONS,p);
        return true;
    }
    return false;
}
/* <<< ResidueSelection <<< */
/* ---------------------------------------- */
/* >>> ResSel Position to Column >>> */
public static boolean resSelEqualsA(ResidueAnnotation a1,ResidueAnnotation a2){
    if(a1.featureName()!=a2.featureName()) return false;
    long hc1=0,hc2=0;
    ResidueAnnotation.Entry[]ee1=a1.entries(),ee2=a2.entries();
    if(ee1.length!=ee2.length) return false;
    for(ResidueAnnotation.Entry e: ee1) hc1+=e.key().hashCode()+e.value().hashCode();
    for(ResidueAnnotation.Entry e: ee2) hc2+=e.key().hashCode()+e.value().hashCode();
    if(hc1!=hc2) return false;
    sortArry(ee1=ee1.clone(),null);
    sortArry(ee2=ee2.clone(),null);
    FORi(0,ee1.length){
        if(ee1[i].key()!=ee2[i].key()) return false;
        if(!ee1[i].value().equals(ee2[i].value())) return false;
    }
    return true;

}
/* <<< ResSel Position to Column  <<< */
/* ---------------------------------------- */
/* >>> Copy ResidueSelection >>> */
static ResidueAnnotation[]resSelCopyToSeq(int opt,ResidueSelection[]ss,Protein[]ppDest,String group,BA sbError){
    if(ARRAY_EMPTY(ss) || sze(ppDest)==0) return ResidueAnnotation.NONE;
    if(group==null) group="Copied";
    final Collection<ResidueAnnotation>v=new ArrayList();
    if(0!=(opt&COPY_ASK_NAME)){
        final Object cbSingle=countNotNull(ss)>1?cbox(plrl(ss.length,"Concatenate %N selection%S to one single selection")):null;
        final int iChoice=dlgOption(pnl(VB,cbSingle,plrl(ss.length,"Copy %N residue selection%S?")),
                                    rmNullS(new String[]{"Do not copy",
                                                addPfx("Copy to ",ppDest[0]),
                                                ppDest.length==1?null:plrl(ppDest.length,"To  %N  sequences")}));
        if(iChoice>0){
            opt|=COPY_ASK_NAME|COPY_REPORT | (isSlct(cbSingle)?COPY_SINGLE:0);
            if(iChoice!=2) ppDest=spp(ppDest[0]);
        }
    }
    if(0!=(opt&COPY_SINGLE)){
        for(Protein pDest:ppDest){
            final boolean[]selected=resSelMapPosZ(ss,pDest);
            if(fstTrue(selected)<0) continue;
            final String name=toStrgTrim(0!=(opt&COPY_ASK_NAME)?dlgInput("Please enter the name of the new residue selection","Unnamed"): "Unnamed");
            if(sze(name)==0) continue;
            final ResidueAnnotation
                a=annotateSeqStyleRgbPosNameGrp(pDest,SFLAG_NO_ADD|SSTYLE_LOWER_HALF,rgba(getColrO(ss[0]),RGBA_FOR_NULL),selectedPositionsToText(0,selected,firstResIdx(pDest),pDest),name,group),
                s0=derefResan(ss[0]);
            if(s0!=null){
            nextEntry:
                for(ResidueAnnotation.Entry e0: s0.entries()){
                    for(ResidueSelection s:ss){
                        if(s==null || s==ss[0]) continue;
                        boolean found=false;
                        if(s instanceof ResidueAnnotation){
                            for(ResidueAnnotation.Entry e: ((ResidueAnnotation)s).entries()){
                                if(e._ki!=IRESAN_POS && e.key()==e0.key() && e.value().equals(e0.value())){
                                    found=true;
                                    break;
                                }
                            }
                        }
                        if(!found) continue nextEntry;
                    }
                    a.addE(e0.isEnabled()?0:RESAN_ENTRY_DISABLED,e0.key(),e0.value());
                }
            }
            adNotNull(a,v);
        }
    }else{
        for(ResidueSelection s:ss){
            if(s==null) continue;
            final ResidueAnnotation aSrc=derefResan(s);
            for(Protein p0:ppDest){
                final Protein pDest=sp(p0),pSrc=sp(s);
                if(pDest==null) continue;
                 String nameSrc=orS(nam(s),s(s));
                if(pSrc==null){
                    if(sbError!=null) sbError.aa("Skipping selection ",nameSrc," because protein is NULL.\n");
                }else if(cntainsEl(s,pDest.resSel(SOBJECT_RESSEL_AND_RESAN))){
                    if(sbError!=null) sbError.aa("Skipping selection ",nameSrc," of sequence ").aa(pDest,": source and destination sequence are identical\n");
                }else if(sp(s)==pDest){
                    adUniq(s,v);
                }else{
                    final boolean[]newPos=resSelMapPosZ(new ResidueSelection[]{s},pDest);
                    if(fstTrue(newPos)>=0){
                        if(instType(s)==RESSEL_IMPL_SELECTED) nameSrc+="_"+selectedPositionsToText(s);
                        final ResidueAnnotation a=new ResidueAnnotation(pDest);
                        String feature=null;
                        if(aSrc!=null){
                            for(ResidueAnnotation.Entry e: aSrc.entries()) a.addE(e.isEnabled()?0:RESAN_ENTRY_DISABLED,e.key(),e.value());
                            feature=a.featureName();
                        }
                        setColrO(orO(getColrO(s),C(0xAAaa44)),a);
                        a.annoAdd(IRESAN_GROUP,strplc(STR_w_R,V3DVAR_PROTEIN,s(pSrc),group))
                            .annoAdd(IRESAN_POS,selectedPositionsToText(0,newPos,firstResIdx(pDest),pDest))
                            .annoAdd(IRESAN_NAME,feature!=null && !feature.equals(nameSrc)?feature+"_"+nameSrc: nameSrc!=null?nameSrc:shrtClasNamOrAlias(s))
                            .addE(RESAN_ENTRY_OVERRIDE,"Copied_from",nameSrc +" @ " +pSrc+( aSrc!=null?"!"+aSrc.value(IRESAN_POS):""));
                            a.setStyle(SSTYLE_LOWER_HALF);
                        v.add(a);
                    }
                }
            }
        }
    }
    final ResidueAnnotation[]aaCopied=toArry(v,ResidueAnnotation.NONE);
    if(aaCopied.length>0){
        mayBeAddResidueAnnotations(aaCopied);
        strapEvtDispatch(EVT_RESIDUE_SELECTION_ADDED|SEVTMS*111);
        if(0!=(opt&COPY_REPORT)) showInJListCreatedResan(aaCopied,null);
        if(0!=(opt&COPY_ANNIMATE)) animateAlignmentPositionS(aaCopied);
    }
    return aaCopied;
}
static ResidueAnnotation[]mayBeAddResidueAnnotations(ResidueAnnotation[]annotations){
    awtc(AWTC_SET_SELECTED_OFF,buttn(STOG_RESSEL_PROCEEDSAME));
    int allChoice=-1;
    final Collection<ResidueAnnotation>vAdded=new ArrayList();
    boolean deleted=false;
    for(ResidueAnnotation sNew:annotations){
        if(sNew==null) continue;
        final String name=sNew.getName();
        final Protein pDest=sp(sNew);
        if(pDest==null || name==null) continue;
        final ResidueAnnotation[]existingAnnotations=pDest.residueAnnotations();
        int nExisting=0;
        for(ResidueAnnotation s:existingAnnotations) if(sNew!=s && name.equals(s.getName())) nExisting++;
        if(nExisting>0){
            final int choice=allChoice>=0?allChoice: dlgOption(pnl(plrl(nExisting,strplc("@",name,rsc(RSC_RESAN_ASK_EXISTS)))),arry(SARRAYeq_RESAN_ASK_EXISTS));
            if(choice<0) continue;
            if(RESAN_EXISTS_CANCEL==choice) break;
            if(isCbSlct(STOG_RESSEL_PROCEEDSAME)) allChoice=choice;
            if(RESAN_EXISTS_SKIP==choice) continue;
            if(RESAN_EXISTS_REPLACE==choice){
                for(ResidueAnnotation s:existingAnnotations)
                    if(name.equals(s.getName())){
                        rmFromProt(s,pDest);
                        dispos(s);
                        deleted=true;
                    }
            }
        }
        addToProt(sNew,pDest);
        adUniq(sNew,vAdded);
    }
    if(deleted) strapEvtDispatch(EVT_RESIDUE_SELECTION_DELETED|SEVTMS*111);
    if(sze(vAdded)>0) strapEvtDispatch(EVT_RESIDUE_SELECTION_ADDED|SEVTMS*111);
    return toArry(vAdded,ResidueAnnotation.NONE);
}
public static ResidueAnnotation[]resSelDrop(boolean addToProtein,File[]ff,Protein[]ppAll){
    final ResidueAnnotation[]ss=new ResidueAnnotation[sze(ff)];
    final boolean[]uppr=chrClas(UPPR);
    FORi(0,ss.length){
        final BA txt=readBytes(ff[i]);
        if(sze(txt)==0) continue;
        final ResidueAnnotation a=new ResidueAnnotation(null);
        a.parseResan(txt,0,MAX_INT);
        final byte[]uc=toByts(a.value(IRESAN_DND_SELECTED_UC));
        if(ARRAY_EMPTY(uc)) continue;
        int bestScore=-1,bestI=-1;
        Protein bestP=null;
        for(Protein p:ppAll){
            final int score=idxOfUpperCase(uc,p.getResType(),true);
            if(bestScore<score){
                bestScore=score;
                bestI=idxOfUpperCase(uc,p.getResType(),false);
                bestP=p;
            }
        }
        {
            final int up1=nxt(0,chrClas(UPPR),uc);
            if(bestP==null || up1<0) continue;
            final boolean[]bb=new boolean[nxtBwd(0,chrClas(UPPR),uc)+1-up1];
            ROFj0(bb.length) bb[j]=isChrClas(uppr,uc,j+up1);
            setProt(bestP,a);
            a.annoAdd(IRESAN_POS,new BA(99).boolToText(bb,1+bestI+firstResIdx(bestP)," ","-"));
        }
        a.annoAdd(RESAN_ENTRY_OVERRIDE|IRESAN_DND_SELECTED_UC,null);
        if(addToProtein) addToProt(a,bestP);
        ss[i]=a;
    }
    return rmNullA(ss,ResidueAnnotation.class);
}

/* <<< Copy ResidueSelection <<< */
/* ---------------------------------------- */
/* >>> ResidueSelection ContextMenu >>> */
static String resSelToUpperCase(ResidueSelection s,String on,String off){
    final Protein p=sp(s);
    final byte[]aa=p==null?null:p.getResType();
    final int N=sze(aa);
    if(N==0) return null;
    final BA ba=new BA(aa.length+99);
    final boolean[]bb=s.getSelectedAminoacids();
    boolean prev=false;
    for(int OFFSET=s.getSelectedAminoacidsOffset()-firstResIdx(p),i=0;i<N;i++){
        final boolean b=iThBool(i-OFFSET,bb);
        if(b && !prev) ba.a(on);
        ba.a((char)(b?(aa[i]&~32): (aa[i]|32)));
        if(!b && prev) ba.a(off);
        prev=b;
    }
    return s(ba);
}
/* <<< ResidueSelection ContextMenu  <<< */
/* ---------------------------------------- */
/* >>> ResidueSelection by computation >>> */
#define GROUP "start_of_exons"
#define NAME "Exon"
private static void _markExonStart(Protein p,int[][]fftt,Collection v){
    for(ResidueAnnotation s:p.residueAnnotations()) if(GROUP.equals(s.value(IRESAN_GROUP)) && s.value(IRESAN_NAME).startsWith(NAME)) rmFromProt(s,p);
    FORi(0,fftt[0].length){
        final ResidueAnnotation s=new ResidueAnnotation(p)
            .annoAdd(RESAN_ENTRY_NT|IRESAN_POS,io(p.isReverseComplement()?p.countNucleotides()-fftt[0][i]: fftt[0][i]+1))
            .annoAdd(IRESAN_NAME,baClr(77).aa(NAME,1+i))
            .annoAdd(IRESAN_GROUP,GROUP);
        setColorRGB(0xFFFFAFAF,s);
        s.setStyle(SSTYLE_LOWER_HALF);
        addToProt(s,p);
        adNotNull(s,v);
    }
}
#undef GROUP
#undef NAME
/* <<< ResidueSelection by computation  <<< */
/* ---------------------------------------- */
/* >>> ResidueSelection NextAndPrevSelection >>> */
private static int _resselNxtprevCol,_resselNxtprevWhen;
#define _resselNxtprevP _X[75]
private static boolean[]_resselNxtBuf=new boolean[999];
public static void resselNxtprevGo(int id,ResidueSelection[]ss){
    boolean[]bb=_resselNxtBuf;
    clr(_resselNxtBuf);
    ROFi0(sze(ss)){
        final Protein p=sp(ss[i]);
        if(p!=null){
            final boolean[]aa=ss[i].getSelectedAminoacids();
            final int b0=ss[i].getSelectedAminoacidsOffset()-firstResIdx(p);
            ROFk0(lstTrue(aa)+1){
                if(aa[k]){
                    if(id==BID_OFFSET_PREV && k+1<aa.length && aa[k+1]||
                       id==BID_OFFSET_NEXT && k>0 && aa[k-1]) continue;
                    final int col=p.getResColumnAt(k+b0);
                    if(col>=0) (SZE(bb)<=col?bb=chSze(bb,col+333): bb)[col]=true;
                }
            }
        }
    }
    final Protein[]pp=_ppAtColZ(_resselNxtprevCol,ss);
    Protein p=sp(_resselNxtprevP);
    //   final int xiP=idxOf(p,pp);
    int col=_resselNxtprevCol;
    if(_resselNxtprevWhen<_strapWhenCursor){
        col=strapCursor(GET_CURSOR_COLUMN);
        p=strapCursorProtein();
    }
    final int col0=col;
    _resselNxtprevWhen=timeOn();
    if(id==BID_OFFSET_PREV){
        while(col>=0 && !iThBool(col,bb)) col--;
        if(null==(p=col!=col0 && 0<=idxOf(p,_ppAtColZ(col,ss))?p: iThBool(col,bb)?iThProt(idxOf(p,pp)-1,pp): null)){
            while(col>=0 && !(iThBool(--col,bb))){}
            p=derefProt(lstEl(_ppAtColZ(col,ss)));
        }
    }
    if(id==BID_OFFSET_NEXT){
        while(col<bb.length && !iThBool(col,bb)) col++;
        if(null==(p=col!=col0 && 0<=idxOf(p,_ppAtColZ(col,ss))?p: iThBool(col,bb)? iThProt(idxOf(p,pp)+1,pp): null)){
            while(col<bb.length && !iThBool(++col,bb)){}
            p=iThProt(0,_ppAtColZ(col,ss));
        }
    }
    {
        final boolean success=p!=null && p.columnToIndex(0,col)>=0;
        if(id==BID_OFFSET_FIRST || id==BID_OFFSET_PREV && !success) p=iThProt(0,_ppAtColZ(col=fstTrue(bb),ss));
        if(id==BID_OFFSET_LAST  || id==BID_OFFSET_NEXT && !success) p=derefProt(lstEl(_ppAtColZ(col=lstTrue(bb),ss)));
    }
    final int iA=p!=null?p.columnToIndex(0,col): -1;
    if(iA>=0){
        _resselNxtprevP=wref(p);
        _resselNxtprevCol=col;
        animateAlignmentPositionZ(p,iA);
        final AliPanel alip=aliPanel();
        final ResidueSelection s=(ResidueSelection)iThEl(0,p.aaSelectionsAtZ(iA,ALIAS_POSITION_PLUS_1,0));
        if(alip!=null && s!=null){
            runCR(RUN_ALIPANEL_OUTLINE_SB_OFF,alip);
            final int
                off=s.getSelectedAminoacidsOffset()-firstResIdx(p),
                fst=off+fstTrue(s.getSelectedAminoacids()),
                lst=off+lstTrue(s.getSelectedAminoacids()),
                row=alip.findRow(p);
            int[]rect=null;
            if(fst>=0 && lst>=fst && row>=0){
                alip.scrRectToVis(0,rect=alip.rowCol2rect(row,p.getResColumnAt(fst),runCR(RUN_ALIPANEL_GET_PANE,alip),null));
                if(lst-fst<10) rect[RECTw]=x(alip.rowCol2rect(row,p.getResColumnAt(lst)+1,runCR(RUN_ALIPANEL_GET_PANE,alip),null))-x(rect);
            }
            addMarchingAnt(ANTS_SET|ANTS_SEARCH,runCR(RUN_ALIPANEL_GET_PANE,alip),rect,C(0xFFffFF),C(0xFF0000));
        }
    }
}
private static Protein[]_ppAtColZ(int col,ResidueSelection[]ss){
    final Collection v=new ArrayList(sze(ss));
    ROFi0(sze(ss)){
        final Protein p=sp(ss[i]);
        if(p!=null && isResSelAminoSelectedZ(p.columnToIndex(0,col),ss[i])) adUniq(p,v);
    }
    final Protein[]pp=spp(v);
    sortVisibleOrder(pp);
    return pp;
}
/* <<< ResidueSelection NextAndPrevSelection  <<< */
/* ---------------------------------------- */
/* >>> Dialogs >>> */
#undef NAME

 static Customize resanExamples(Object key){
        if((key=s(key))==null) return null;
        if(strstr(STR_IC,KRESAN_TEXSHADE,key)>=0) key=DialogTEXshade.class;
        {
            final int i=bidForClass(key);
            if(i>0) return bidCustomize(i,RSC_MULTI_EXAMPLE);
        }

        //@*SARRAYeq_CUSTOM_FOR_IRESAN
        //         CUSTOM_examplesBackground=IRESAN_BG_IMAGE CUSTOM_examples3D=IRESAN_VIEW3D CUSTOM_examplesNote=IRESAN_NOTE CUSTOM_examplesRemark=IRESAN_REMARK CUSTOM_examplesBalloon=IRESAN_BALLOON CUSTOM_examplesEvidence=IRESAN_EVIDENCE CUSTOM_examplesAtoms=IRESAN_ATOMS
//*@
        //      return Customize.customize(iThInt(resanKeyToUniqIdx(toStrgIntrn(key)),intArry(SARRAYeq_CUSTOM_FOR_IRESAN)));

        final int ki=resanKeyToUniqIdx(toStrgIntrn(key));
        return Customize.customize(
                                   ki==IRESAN_BG_IMAGE?CUSTOM_examplesBackground:
                                   ki==IRESAN_VIEW3D?CUSTOM_examples3D:
                                   ki==IRESAN_NOTE?CUSTOM_examplesNote:
                                   ki==IRESAN_REMARK?CUSTOM_examplesRemark:
                                   ki==IRESAN_BALLOON?CUSTOM_examplesBalloon:
                                   ki==IRESAN_EVIDENCE?CUSTOM_examplesEvidence:
                                   ki==IRESAN_ATOMS?CUSTOM_examplesAtoms:
                                   CUSTOMIZE_ID_NO_ERROR);
    }
