@*SARRAYeq_SEQFEAT_COLUMNS_TT
#define TT Left-Click to select the residue annotation.<BR>Selected annotations are indicated in the alignment pane by marching ants.<BR>Right-click for context menu.
 The color of all annotations with the that name<BR>TT=SEQFEAT_COL_COLOR Name<BR>TT=SEQFEAT_COL_NAME Number of sequence features with the respective feature name=SEQFEAT_COL_FEAT_COUNT Enable underlining in alignment pane=SEQFEAT_COL_CB_SEQ Enable highlighting in 3D-Backbone=SEQFEAT_COL_CB_3D Enable export to MS-Word and HTML=SEQFEAT_COL_CB_HTML Enable export to Jalview=SEQFEAT_COL_CB_JALVIEW List of Web addresses where the information has been loaded from=SEQFEAT_COL_WEB Jump to first,previous, next or last amino acid=SEQFEAT_COL_NAVI
#undef TT
*@

@*SARRAYeq_SEQFEAT_COLUMNS
 Name=SEQFEAT_COL_NAME #=SEQFEAT_COL_FEAT_COUNT CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)Sequence=SEQFEAT_COL_CB_SEQ CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)3D-backbone=SEQFEAT_COL_CB_3D CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)MS-Word, HTML=SEQFEAT_COL_CB_HTML CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)Jalview-Export=SEQFEAT_COL_CB_JALVIEW CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)Web link=SEQFEAT_COL_WEB Navigation=SEQFEAT_COL_NAVI
*@

private static int _seqFeatTipRow,_seqfeatRow;
CPP_PRIVATE static ChJTable _seqfeatTable;
#define _seqfeatProgressDasV IF_DAS(vNoClr(254))
/* ---------------------------------------- */
/* >>> Table >>> */
private Protein[]seqfeatProteins(){return isCbSlct(STOG_SEQFEAT_ONLY_SELECTED)?selectedProteins():strapVisibleProteins();}
private static int _seqfeatColumn2visibleWhere(int F){
    return
        F==SEQFEAT_COL_CB_3D?VIS123_STRUCTURE:
        F==SEQFEAT_COL_CB_HTML?VIS123_HTML:
        F==SEQFEAT_COL_CB_SEQ?VIS123_SEQUENCE:
        F==SEQFEAT_COL_CB_JALVIEW?VIS123_JALVIEW:0;
}

private Collection featuresAtRow(Collection v,int...rows){
    if(v==null) v=vClr(15);
    final String[]ft=_seqfeatNames;
    for(Protein p:seqfeatProteins()){
        for(ResidueAnnotation a:p.residueAnnotations()){
            final String fn=a.featureName();
            if(fn!=null) for(int r:rows) if(ft.length>r && r>=0 && fn==ft[r]) adNotNull(a,v);
        }
    }
    return v;
}
private static void seqfeatUpdateTable(int optDelay){
    if(awtc(AWTC_OPT_REVALIDATE|optDelay,_seqfeatTable)!=null && seqfeatUpdateAndCountRows()>0) awtc(AWTC_SET_ENABLED,_seqfeatTable);
}
private static void seqfeatChanged(){
        strapIncMC(MCA_SEQUENCE_FEATURES_V,null);
        strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
        awtc(AWTC_OPT_REPAINT,_seqfeatTable);
}
/* <<< Table <<< */
/* ---------------------------------------- */
/* >>> Panel >>> */
//IF_DAS(buttn(SEQFEAT_SBUT_DAS)
@*~RSC_DIA_SEQFEAT_TEXT_ADVANCED1
 load from <i>HTMLDOC_BUTTON:SBUT_SEQFEAT_SEQFILES!</i> <i>HTMLDOC_BUTTON:SBUT_SEQFEAT_UniprotFtr!</i><BR><BR>
 What if broad ranges of residues would be underlined:<BR>
 <i>HTMLDOC_BUTTON:STOG_SEQFEAT_Arrows!</i><BR><BR>
 What if there is e.g. "Modified_residue" and "Phosphotyrosine" at the same position:<BR>
 <i>HTMLDOC_BUTTON:TOG_COMBINE_SEQ_FEATURES!</i><BR><BR>
 <i>HTMLDOC_BUTTON:STOG_SEQFEAT_Visibility!</i><BR>
 The BioDAS has become unavailable in 2015. UniProt and Catalytic Site Atlas are available.
*@
public static void seqfeatShowPanel(){
    if(_seqfeatPnl==null){
        ROFi0(9) _seqfeatPrgBars[i]=guiCmpnt(GUICMPNT_NEW_PRGRSS_BAR);
        _seqfeatNavi=navigationPreviousNext(SBUT_SEQFEAT_NEXT_PREV|NAVIGATION_PREV_NEXT_WITH_EDITOR_COMPONENT,_main,"Go to * selected residue");
        //        pcp(KOPT_NOT_PAINTED_IF_DISABLED,"",
            addActLiMain(
                     _seqfeatTable=new ChJTable(JLIST_NO_REORDER|JLIST_EXX_ROW_HEIGHT,
                                                new ChTableModel(JLIST_DEBUG,arry(SARRAYeq_SEQFEAT_COLUMNS),strapInstance(STRAPGUI_TABLE_MODEL_SEQFEAT)).editable(0xFF<<SEQFEAT_COL_CB_AAA))
                     .headerTip(arry(SARRAYeq_SEQFEAT_COLUMNS_TT)));
        if(seqfeatUpdateAndCountRows()==0) awtc(AWTC_SET_DISABLED,_seqfeatTable);
        {
            final Comparator[]cc=new Comparator[SEQFEAT_COL_WEB+1];
            final javax.swing.table.TableRowSorter ts=new javax.swing.table.TableRowSorter(_seqfeatTable.getModel());
            ROFi0(cc.length) if(null!=(cc[i]=comparator(COMPARE_COLOR))) ts.setComparator(i,cc[i]);
            _seqfeatTable.setRowSorter(ts);
        }
        _seqfeatTable.setDefaultRenderer(Object.class,_seqfeatRenderer=newRenderer(RNDRER_COLORED_FIELD_CAN_TOGGLE));
        _seqfeatTable.getTableHeader().setDefaultRenderer(_seqfeatRenderer);
        _seqfeatTable.setDefaultEditor(Object.class,_seqfeatRenderer);
        _seqfeatChoiceAll=setTip(io(RSC_SBALLOON_SEQFEAT_CHOICE_SHOW_WHICH_TT),addActLiMain(new ChJCombo(arry(SARRAYeq_SEQFEAT_CHOICE_SHOW_WHICH))));
        seqfeatSetButText();
        final Object pAdvanced=pnl(VBHB,rsc(RSC_DIA_SEQFEAT_TEXT_ADVANCED1));
        _seqfeatPnl=pnl(CNSEW,scrllpn(SCRLLPN_SIZE_56x24,addLiMain(LSTNR_MOMO|LSTNR_MO|LSTNR_KEY,rtt(_seqfeatTable))),
                        pnl(CNSEW,
                            "<H2>Sequence Features from UniProt</H2>",
                            null,
                            pcp(KEY_ENABLED_IF_ENABLED|PCP_OPT_WREF,_seqfeatTable,
                                pnl(pcpKey(KOPT_NOT_PAINTED_IF_DISABLED),buttn(STOG_SEQFEAT_ONLY_SELECTED),_seqfeatChoiceAll)),
                            pnl(buttn(CUSTOM_seqFeatureColors).rover(IC_CUSTOM),buttn(BUTTN_CLASS_HELP_SMALL|RSC_HELP_SEQFEAT))),
                        pnl(CNSEW,pnl(VBHB,pnl(HB,buttn(SBUT_SEQFEAT_ButDefault)," "," ",IF_DAS(buttn(CUSTOM_preferedDasSources).rover(IC_CUSTOM))"#",pnlTogglOpts(TOGGL_PNL_Options,pAdvanced)),
                                      null,
                                      pAdvanced),
                            pnl(VB,_seqfeatPrgBars),
                            specifcLstnrWithChilds(MOLI_REPAINT_ON_ENTER_AND_EXIT,_seqfeatLabMsg=pnl(" "))));
        _seqfeatSetWidth();
        IF_DAS(thrdCR(_SEQFEAT_RUN_REG|THRDCR_START,strapInstance(STRAPGUI_TABLE_MODEL_SEQFEAT)));;
    }
    addDialog((Component)setTitiBid(BUT_C1(TITI_ResanFromServices),_seqfeatPnl));
}
private static void _seqfeatSetWidth(){
    final boolean details=isCbSlct(STOG_SEQFEAT_Visibility);
    int headerH=EX;
    ROFc0(SEQFEAT_COL_ZZZ){
        if(c==SEQFEAT_COL_NAME) continue;
        final int w=
            _seqfeatColumn2visibleWhere(c)>0 || c==SEQFEAT_COL_WEB?(details?EX*2: 0):
            c==SEQFEAT_COL_FEAT_COUNT?5*EM:
            c==SEQFEAT_COL_NAVI?prefW(_seqfeatNavi):
            EX*2;
        _seqfeatTable.setColWidth(w,c);
        _seqfeatTable.setColWidth(w,c);
        if(details) headerH=maxi(headerH,prefH(labl(arry(SARRAYeq_SEQFEAT_COLUMNS)[c])));
    }
    _seqfeatTable.getColumnModel().setColumnMargin(details?1:0);
    setPrefSze(1,headerH+EX,_seqfeatTable.getTableHeader());
}
/* <<< Panel <<< */
/* ---------------------------------------- */
/* >>> Event >>> */
private static void seqfeatSetButText(){
    if(_seqfeatTable!=null) setTxt(plrl(selectedOrVisibleProteins(1).length,"Load and underline residue annotations of %N sequence%S"),buttn(SBUT_SEQFEAT_ButDefault));
}
/* <<< Event <<< */
/* ---------------------------------------- */
/* >>> Names >>> */
private static int _seqfeatNamesMC;
static int seqfeatUpdateAndCountRows(){
    if(DIFF_MC(_seqfeatNamesMC,Protein.MC_GLOBAL[MCA_SEQUENCE_FEATURES_V]+Protein.MC_GLOBAL[MCA_PROTEINS_V])){
        final Collection v=setClr(224);
        for(Protein p:strapVisibleProteins()){
            for(ResidueSelection s:p.resSel(SOBJECT_RESSEL_AND_RESAN)){
                if(sobjectType(s)==SOBJECT_SEQFEAT && vis123isThere(VIS123_SEQUENCE,s)) adNotNull(((ResidueAnnotation)s).featureName(),v);
            }
        }
        _seqfeatNames=toStrgArray(0,v);
        seqfeatUpdateTable(AWTC_AFTER_100);
    }
    return _seqfeatNames.length;
}
/* <<< Names <<< */
/* ---------------------------------------- */
/* >>> ChRunnable  >>> */
#define MAX_LEN 200
REFLECTION_PUBLIC_STATIC Runnable sftrLoad(int opt,Protein[]pp,CountDown cdID){
    if(OPT_RETURN_THREAD(opt)) return CPP_thrdMS(sftrLoad,Strap,io(opt),pp,cdID);
    //#define newPrgrss(Object_src,v,CharSequence_msg) new Object[]{io(v),CharSequence_msg,Object_src}
    final BA logTxt=new BA(99).aPlrl(pp.length," UniProt GFF annotations for %N sequence%S ...");
    final int LOG_E=logTxt.end()-3;
    final Map<String,BA>m1=new HashMap();
    final Collection<String>vAlready=new HashSet();
    final Object[]logPrgrss={_main,strapInstance(STRAPGUI_TABLE_MODEL_SEQFEAT)};
    runCR1(RUN_SET_PROGRESS,logPrgrss,newPrgrss(Strap.class,0,logTxt));
    final boolean[]ready=new boolean[pp.length];
    //long time=currentTimeMillis();
    while(true){
        sleepMS(555);
        final boolean idsDone=countDownDone(cdID);
        BA sb=null;
        for(int count=0,i=pp.length;--i>=0;){
            final Protein p=pp[i];
            if(p!=null){
                ROFt0(REFS_ZZZ){
                    if(t!=0&&t!=REFS_BY_IDENT) continue;
                    String[]ids; CPP_synchronized(SYNC_ADD_ID) {ids=p.getRefs(t);}
                    for(String db_id:ids){
                        if(db_id!=null && /*db_id.indexOf('_')<0 &&*/ vAlready.add(db_id)){
                            final BA txt=(BA)_mapGFF.get(db_id);
                            if(txt!=null)  m1.put(db_id,txt);
                            else if(db_id.startsWith("UNIPROT:")){
                                if(sb==null) sb=new BA(MAX_LEN+30);
                                sb.a("accession%3A").aWithoutPfx("UNIPROT:",db_id).a("+or+");
                                ready[i]=true;
                                count++;
                            }
                        }
                    }
                }
            }
            if(sze(sb)>(i==0?0:MAX_LEN)){
#define url iPath2(iURL_UNIPROT_GFF_EQ,sb).del("+or+")
                final BA txt=readBytes(url);
                if(txt!=null) gffFromFileOrServer(0,"GFF_UNIPROT:*",txt,null,m1);
                runCR1(RUN_SET_PROGRESS,logPrgrss,newPrgrss(Strap.class,countTrue(ready)*100/pp.length,logTxt.setEnd(LOG_E).aa(' ',count)));
                baOut(DEBUG_LONGER).aa(" sftrLoad url="+ANSI_GREEN,url,ANSI_RESET+"\n"+ANSI_FG_GREEN,txt).aln(ANSI_RESET);
                clr(sb);
                sftrPutLoaded(m1,pp);
#undef url
            }
        }
        if(idsDone) break;
    }
    //sftrPutLoaded(m1,pp);
    runCR1(RUN_SET_PROGRESS,logPrgrss,newPrgrss(Strap.class,100,logTxt.setEnd(LOG_E).a("done")));
    return null;
}
#undef MAX_LEN
/* P25787 UniProtKB Modified residue 24 24 . . . Note=Phosphotyrosine */
/* <<< Threads <<< */
/* ---------------------------------------- */
/* >>> Filter >>> */
private static ResidueSelection[]seqfeatFilter(int type,ResidueSelection[]ss0,Protein[]pp){
    if(ss0==null) return ResidueSelection.NONE;
    ResidueSelection[]ss=ss0;
    ROFi0(ss.length){
        final ResidueSelection s=ss[i];
        final Protein p=sp(s);
        if(p==null || !vis123isThere(type,s) || pp!=null&&!cntainsEl(p,pp)){
            if(ss==ss0) ss=ss0.clone();
            ss[i]=null;
        }
    }
    return rmNullA(ss,ResidueSelection.class);
}
/* <<< Filter <<< */
/* ---------------------------------------- */
/* >>> Variables >>> */
REFLECTION_PUBLIC_STATIC_VOID seqfeatVaribales(ResidueAnnotation[]aa){
    BA ba=null;
@*SARRAY_seqfeatVaribales_TD_DiseasePolymorphismUnclassified
     <TD>Disease|<TD>Polymorphism|<TD>Unclassified
*@
    for(ResidueAnnotation a:aa){
        for(ResidueAnnotation.Entry e: a.entries()){
            if(IRESAN_REMARK!=e._ki || !e.value().startsWith("FTId=VAR")) continue;
            if(null!=(ba=readBytes(dlUrlDays(hrefToUrlString(HREF_WEB_LINK,e.value()),isPrprty(IS_CACHE_READ)?SEQFEAT_MAX_DAYS:0),ba))){
                {
                    final int i=strstr(STR_IC,arry(SARRAY_seqfeatVaribales_TD_DiseasePolymorphismUnclassified),ba);
                    if(0<i){
                        final String type=wordAt(LETTR,ba,i+4).toUpperCase();
                        a.annoAdd(IRESAN_NAME,chrAt(0,type)=='U'?type+"_"+type: type).setFeatureSrc(SEQFEAT_SRC_FILE);
                        if(idxOfStrg(0,type,_seqfeatNames)<0) _seqfeatNames=adToStrgs(type,_seqfeatNames,0);
                        seqfeatUpdateTable(AWTC_AFTER_200);
                    }
                }
                final int from=strstr(STR_IC|STR_AFTER,"<TD><B>From ",ba.bytes(),0,ba.end());
                if(from>0){
                    final int colon=strchr(',',ba,from,mini(ba.end(),from+30));
                    if(colon>0) a.annoAdd(IRESAN_NAME,wordAt(LETTR_DIGT,ba,colon+2));
                }
            }
        }
    }
    REFLECTION_RETURN;
}
/* <<< Variables <<< */
/* ---------------------------------------- */
/* >>> Variables >>> */
#if CPP_WITH_DAS
REFLECTION_PUBLIC_STATIC_VOID seqfeatFindUP(Protein[]pp){
    final BA sb=new BA(999).aln("Assigned uniprot IDs");
    for(Protein p:pp) if(p!=null) sb.aa(p,"  acc=",p.seqId(BLAST4ID_DB_UNIPROT),"  by-sequence=").joinSpc(p.getRefs(REFS_BY_IDENT)).aln();
    shwTxtInW("Assigned UniProt IDs",sb);
    awtc(AWTC_SET_ENABLED,SBUT_SEQFEAT_ButUP);
    REFLECTION_RETURN;
}
#endif //CPP_WITH_DAS
