//getUniprotID( Protein uniprotNeedID( BLAST4ID_EVEN_IF_HAS_ID
// Strap
// BLAST4ID_EVEN_IF_HAS_ID
/* (NUM 1)  RETURN_THREAD */

#define MIN_LEN 16
#define OVERLAP 7

public static Collection blast4idV(int opt,Protein p){
    if(p==null) return null;
    synchronized(SYNC_blast4idV){
        Collection[]vv=(Collection[])p.getProperty(PROTEINO_BLAST4ID_VV);
        if(vv==null) p.setProperty(PROTEINO_BLAST4ID_VV,vv=new Collection[(BLAST4ID_DB_MASK>>>BLAST4ID_DB_SHIFT)+1]);
        final int i=(opt&BLAST4ID_DB_MASK)>>>BLAST4ID_DB_SHIFT;
        if(vv[i]==null) vv[i]=new ArrayList();
        return vv[i];
    }
}
private static boolean _blast4idTestReady(int opt,Protein[]pp,ChRunnable tellReady){
    boolean ready=true;
    final int db=(opt&BLAST4ID_DB_MASK)>>>BLAST4ID_DB_SHIFT;
    ROFi0(pp.length){
        final Protein p=pp[i];
        if(p!=null){
            if(db==BLAST4ID_DB_RECURS_PDB){
                if(null==p.getProperty(PROTEINO_RECURS_PDB_RESULT)) ready=false;
                else{
                    pp[i]=null;
                    runCR1(RUN_RECURS_PDB_DONE,tellReady,p);
                }
            }else{
                final Collection v=blast4idV(opt,p);
                CPP_synchronized(recordSync(v,"_blast4idTestReady")){
                    if(0<sze(v) || (opt&BLAST4ID_EVEN_IF_HAS_ID)==0 && p.seqId(GETSEQID_ALSO_BY_IDENTITY|db)!=null) pp[i]=null;
                    else ready=false;
                }
            }
        }
    }
    return ready;
}
REFLECTION_PUBLIC_STATIC Runnable blast4id(int opt,Protein[]pp,ChRunnable notify){
    if(OPT_RETURN_THREAD(opt)) return CPP_thrdMS(blast4id,Strap,io(opt),pp,notify);
    if(0==(opt&BLAST4ID_NOT_FETCH_SEQUENCE)) startThrd(uniprotDlAllKnownSequences(RETURN_THREAD,pp));
    final int blaster=(opt&BLAST4ID_BLASTER_MASK)>>>BLAST4ID_BLASTER_SHIFT,db=(opt&BLAST4ID_DB_MASK)>>>BLAST4ID_DB_SHIFT;
    final String pfx;
    final BA log;
    if(db==BLAST4ID_DB_RECURS_PDB){
        pfx=ANSI_BLUE+ANSI_FG_GREEN+"recursivePdb"+ANSI_RESET+" ";
        log=baLog(LOG_BLAST4SEQ);
    }else{
        pfx=ANSI_BLUE+ANSI_FG_GREEN+"BLAST4ID"+ANSI_RESET+" ";
        log=baLog(LOG_BLAST);
    }
    if(blaster==SEQ_BLASTER_TRY_ALL){
        log.aa(pfx,ANSI_INVERSE,"Entered ",pp).aln(ANSI_RESET);
        CPP_synchronized(recordSync(pfx,"blast4id")){/*X (1) Cache  (2) Local (3) Remote */
            final Protein[]qq=pp.clone();
            if(!_blast4idTestReady(opt,qq,notify)){
                if(db==BLAST4ID_DB_UNIPROT){
                    pepMatchUniprot(BLAST4ID_CACHE_ONLY,qq);
                    _blast4idTestReady(opt,qq,notify);
                    startThrd(pepMatchUniprot(RETURN_THREAD,qq.clone()));
                }
                final CountDown[]cd=new CountDown[SEQ_BLASTER_ZZZ];
                if(isPrprty(IS_CACHE_READ)) for(int b=SEQ_BLASTER_ZZZ;--b>SEQ_BLASTER_AAA;) blast4id(opt|BLAST4ID_CACHE_ONLY|(b<<BLAST4ID_BLASTER_SHIFT),qq,notify);
                for(int b=SEQ_BLASTER_ZZZ;--b>SEQ_BLASTER_AAA;) if(isBlastdbSet(b)==CTRUE) blast4id(opt|(b<<BLAST4ID_BLASTER_SHIFT),qq,notify);
                for(int b=SEQ_BLASTER_ZZZ;--b>SEQ_BLASTER_AAA;) if(isBlastdbSet(b)==0) countDownIncRunDec("blast4id",blast4id(opt|RETURN_THREAD|(b<<BLAST4ID_BLASTER_SHIFT),qq,notify),cd[b]=new CountDown0(iConst(SARRAYeq_BLAST_CMD,b)));
                for(int waited=1; !_blast4idTestReady(opt,qq,notify)&&!countDownAllDone(cd);waited++){
                    sleepMS(3333);
                    log.aa(pfx," Waited ",waited*3333/1000).aln(" sec.");
                }
            }
        }
        if(db!=BLAST4ID_DB_RECURS_PDB && 0==(opt&BLAST4ID_NOT_FETCH_SEQUENCE)) uniprotDlAllKnownSequences(0,pp);
    }else if(isBlastdbSet(blaster)!=CFALSE){
        ROFiP0(pp.length){
            _blast4idTestReady(opt,pp,notify);
            final Protein p=pp[blaster==SEQ_BLASTER_WEB_EBI?pp.length-1-iP:iP];
            if(p==null) continue;
            final String seq=p.getResTypeSUC();
            if(db==BLAST4ID_DB_RECURS_PDB){/*X Find 3D-structure for sequence */
                final byte[]found=new byte[sze(seq)];
                final Collection vID=new HashSet();
                ROFt0(9){/*X part */
                    int from=-1,to=-1;
                    if(p.countResidues()>MIN_LEN){
                        for(int i=0;i<=found.length;i++){
                            if(i==found.length || found[i]!=0){
                                if(from>=0 && i-from>MIN_LEN){
                                    to=i;
                                    break;
                                }
                                from=to=-1;
                            }else if(from<0) from=i;
                        }
                        if(from<0||to-from<MIN_LEN) break;
                    }else{
                        t=from=0;
                        to=p.countResidues();
                    }
                    final String part=seq.substring(from=maxi(0,from-OVERLAP),to=mini(seq.length(),to+OVERLAP));
                    boolean success=false;
                    SequenceBlaster b=new SequenceBlaster((0==(opt&BLAST4ID_CACHE_ONLY)?0:BLAST_CACHE_ONLY)|
                                                          (10<<BLAST_SHIFT_NUMALI),
                                                          blaster,part,
                                                          "pdb",
                                                          s(new BA(99).aa(p,'/').aFromDashTo(1+from,1+to)));
                    Collection vB=(Collection)p.getProperty(PROTEINO_RECURS_PDB_BLASTS);
                    if(vB==null) p.setProperty(PROTEINO_RECURS_PDB_BLASTS,vB=NEW_VECTOR());
                    vB.add(b);
                    runCR1(RUN_RECURS_PDB_STARTED,notify,p);
                    if(b.blastAlignments().length==0) vB.remove(b);
                    else{
                        for(TYPE_BLASTALIGNMENT h:b.blastAlignments()){
                            int start=MAX_INT,end=-1;
                            for(TYPE_BLASTALIGNMENT a:b.blastAlignments()) {
                                if(atoi(a[BLASTAL_HIT_NUM])==atoi(h[BLASTAL_HIT_NUM])){
                                    start=mini(start,atoi(a[BLASTAL_Q_B]));
                                    end=maxi(end,atoi(a[BLASTAL_Q_E]));
                                }
                            }
                            if(start>=0 && start<end){
                                start+=from;
                                end+=from;
                                final byte[]seqM=(byte[])h[BLASTAL_H_SEQ],seqQ=(byte[])h[BLASTAL_Q_SEQ];
                                final String id=addPfx("PDB:",((String)h[BLASTAL_ID]).replace(':','_'));
                                if(vID.add(id)){
                                    final Object[]rr=new Object[RECURS_PDB_ZZZ];
                                    rr[RECURS_PDB_ARRAY_ID]=ARRAY_ID_RENDERED_BY_PROVIDER;
                                    rr[RECURS_PDB_PROVIDE_RENDERER_COMPONENT]=_main;/*X runCR(PROVIDE_RENDERER_COMPONENT...) invoked on rr[1] */
                                    rr[RECURS_PDB_PROTEIN]=wref(p);
                                    rr[RECURS_PDB_BLASTER]=b;
                                    rr[RECURS_PDB_PDBID]=id;
                                    rr[RECURS_PDB_IDATA]=new int[]{start,end,CPP_NUMERATOR(alignmentIdentity(seqM,seqQ,0,MAX_INT)),mini(sze(seqM),sze(seqQ))};
                                    Collection<Object[]>v;
                                    synchronized(SYNC_RECURS_PDB_RESULT){
                                        if(null==(v=(Collection)p.getProperty(PROTEINO_RECURS_PDB_RESULT))) p.setProperty(PROTEINO_RECURS_PDB_RESULT,v=new ArrayList());
                                        v.add(rr);
                                    }
                                }
                                runCR1(RUN_RECURS_PDB_DONE,notify,p);
                                Arrays.fill(found,start,mini(end,found.length),(byte)CTRUE);
                                success=true;
                            }
                        }
                    }
                    if(!success) Arrays.fill(found,from,to,(byte)CFALSE);
                }
            }else{/*X END Find 3D-structure for sequence --- BEGIN find UniProt ID */
                final BA sb=new BA(99),sbTmp=new BA(99);
                String[]ss=null;
                final String
                    cacheClas=s(clr(sb).aa("BLAST4ID",'_',canonicalSeqDB(0,iConst(SARRAYeq_BLAST4ID_DB,db)))),cacheClasFailed=s(sb.a("_FAILED")),
                    cacheKey=cacheKeyForSeqAsStrg(seq,clr(sb));
                if(isPrprty(IS_CACHE_READ)){
                    BA result=CacheResult.getValue(cacheClas,cacheKey,clr(sb));
                    if(null!=result || null!=(result=CacheResult.getValue(cacheClasFailed,cacheKey,clr(sb))))  ss=sze(result)<3?NO_String:splitTkns(result);
                }
                if(0==(opt&BLAST4ID_CACHE_ONLY)){
                    {
                        final BA txt=clr(sbTmp).aa(pfx,' ',iConst(SARRAYeq_BLAST_CMD,blaster),' ',iConst(SARRAYeq_BLAST4ID_DB,db),' ',p," ...");
                        baLog(LOG_BLAST4SEQ).aln(txt);
                        IF_GUI(runCR1(RUN_SET_PROGRESS,_main,newPrgrss(Strap.class,(pp.length-iP)*100/(pp.length+1),txt)));
                    }
                    final SequenceBlaster b=new SequenceBlaster((BLAST_NO_GAPS|
                                                                  100<<BLAST_SHIFT_NUMALI)|
                                                                 (1<<BLAST_SHIFT_SENSITIVITY)|
                                                                 (9<<BLAST_SHIFT_WORDSIZE),
                                                                 blaster,
                                                                seq,
                                                                iConst(SARRAYeq_BLAST4ID_DB,db),s(p));

                    ss=new String[b.blastAlignments().length];
                    clr(sb);
                    int count=0;
                    for(TYPE_BLASTALIGNMENT a:b.blastAlignments()){
                        if(db==BLAST4ID_DB_SIMILAR_PDB || 0<=strstr(0,seq,(byte[])a[BLASTAL_H_SEQ])){
                            ss[count++]=s(clr(sbTmp).a(iConst(SARRAYeq_BLAST4ID_DB,db)).a(delLstCmpnt('-',a[BLASTAL_ID])).aa('!',atoi(a[BLASTAL_H_B])-1));
                            if(db==BLAST4ID_DB_SIMILAR_PDB) sbTmp.aa(",F=",a[BLASTAL_H_B],",T=",a[BLASTAL_H_E],",f=",a[BLASTAL_Q_B],",t=",a[BLASTAL_Q_E],",pos=",a[BLASTAL_POSITIVES],",id=",a[BLASTAL_IDENTITY],",b=",a[BLASTAL_BITS],",s=",a[BLASTAL_SCORE]);
                            sb.aa(sbTmp,'\t');
                            break;
                        }
                    }
                    if(count==0) sb.a('x');
                    CacheResult.putValue(0,count==0?cacheClasFailed:cacheClas,cacheKey,sb.a('x'));
                    baLog(LOG_BLAST4SEQ).aa(pfx,iConst(SARRAYeq_BLAST4ID_DB,db),' ');
                    if(sze(ss=rmNullS(ss))>0){
                        baLog(LOG_BLAST4SEQ).aln(GREEN_SUCCESS);
                        if(0==(opt&BLAST4ID_NOT_FETCH_SEQUENCE)) uniprotDlAllKnownSequences(0,pp);
                    }else baLog(LOG_BLAST4SEQ).aln(RED_FAILED);
                }
                final Collection v=blast4idV(opt,p);
                if(sze(ss)>0){
                    CPP_sync(SYNC_ADD_ID){
                        adAllUniq(ss,v);
                        if(db!=BLAST4ID_DB_SIMILAR_PDB) for(String s:ss) p.addSeqRef(ADD_SEQREF_BY_IDENT,s);
                    }
                }
            }
        }
    }
    return null;
}
#define vFETCHED_ALREADY setNoClr(356)
REFLECTION_PUBLIC_STATIC Runnable uniprotDlAllKnownSequences(int opt,Protein[]pp){
    if(OPT_RETURN_THREAD(opt)) return CPP_thrdMS(uniprotDlAllKnownSequences,Strap,io(opt),pp);
    final Collection v=setNoClr(357);
    CPP_synchronized(recordSync(v,"uniprotDlAllKnownSequences")){
        clr(v);
        ROFiP0(sze(pp)){
            final Protein p=pp[iP];
            if(p!=null){
                adAll(p.getRefs(REFS_OTHER),v);
                adAll(p.getRefs(0),v);
                for(String s:toStrgArray(0,blast4idV(BLAST4ID_DB_UNIPROT,p))) v.add(delFromChar('!',s));
            }
        }
        if(sze(v)>0){
            v.removeAll(vFETCHED_ALREADY);
            dbfetchFetchSeqs(DBFETCH_SKIP_EXISTING,toStrgArray(0,v));
            vFETCHED_ALREADY.addAll(v);
        }
    }
    return null;
}
#undef vFETCHED_ALREADY
#undef MIN_LEN
#undef OVERLAP
