/* http://www.ebi.ac.uk/ws/services/WSDbfetchDoclit?wsdl  */
private static String dbfetchPreferredFormat(String db){
    return(db=canonicalSeqDB(0,db))==null?null: db==DB_UNIPROT?"uniprot": db==DB_EMBL?"embl": db==DB_NCBI?"gb": "fasta";
}
public static File dbfetchDbColonID2file(String entry){
    final String db=canonicalSeqDB(0,entry);
    final int colon=strchr(':',entry);
    if(colon<0||db==null||entry==null||sze(entry)>66) return null;
    final Map<String,File>map=db==DB_NCBI?mapSoft(288):mapSoft(289);
    File f=map.get(entry);
    if(f==null) map.put(entry,f=dbfetchId2file(db,entry.substring(colon+1),null));
    return f;
}
public static File dbfetchId2file(String database,String id,String format){
    if(sze(format)==0) format=dbfetchPreferredFormat(database);
    if(id==null||sze(id)>33 || database==null||sze(database)>33) return null;
    return newFile(iFile(DIR_STRAP_DB_FETCH),s(new BA(99).a('/').aFilter(FILTER_TO_UPPER,database).del(':').a('_').aFilter(FILTER_NO_MATCH_TO_US|FILENM,id).aa('.',format)));
}
REFLECTION_PUBLIC_STATIC Runnable dbfetchFetchSeqs(int opt,String[]tokens){
    if(sze(tokens)>0){
    if(OPT_RETURN_THREAD(opt)) return CPP_thrdMS(dbfetchFetchSeqs,Strap,io(opt),tokens);
    final Collection<String>vQuery=new HashSet();
    ROFi0(4){
        clr(vQuery);
        final String db=i==0?DB_NCBI:i==1?DB_EMBL:i==2?DB_UNIPARC:DB_UNIPROT;
        for(String dbColonId:tokens){
            if((dbColonId=canonicalSeqidColonDB(dbColonId))==null) continue;
            if(dbColonId.startsWith(db) && chrAt(sze(db),dbColonId)==':'){
                final String noPipe=delFromChar('|',dbColonId),id=delToLstChr1(':',noPipe);
                if((opt&DBFETCH_SKIP_EXISTING)!=0&&
                   (sze(dbfetchId2file(db,id,dbfetchPreferredFormat(db)))>=PROTEIN_MIN_FILE_SZE || sze(file(hrefToUrlString(HREF_PROTEIN_FILE,noPipe)))>=PROTEIN_MIN_FILE_SZE)){
                    continue;
                }
                vQuery.add(id);
            }
        }
        _dbfetchDownload(db,toStrgArray(0,vQuery),dbfetchPreferredFormat(db));
    }
    }
    return null;
}
#define DBFETCH_MAXNUM 30
#define _dbfetchSetAlreadyLoaded mapNoClr(213)
#define _EMBL 1
#define _FASTA 2
#define _GENBANK 3
#define _DBS 4
@*SARRAYeq_SEQUENCE_FORMAT_STARTS_WITH
 >=_FASTA LOCUS =_GENBANK ID =_EMBL
*@
private static void _dbfetchDownload(String db,String[]allIDs,String format0){
    if((db=canonicalSeqDB(0,db))==null || sze(allIDs)==0) return;
    synchronized(mkIdObjct(330,db)){
        Collection<String>vDone=(Collection)_dbfetchSetAlreadyLoaded.get(db);
        if(vDone==null) _dbfetchSetAlreadyLoaded.put(db,vDone=new HashSet());
        final String format=orS(format0,dbfetchPreferredFormat(db));
        for(int fromIdx=0;fromIdx<allIDs.length;){
            final Collection v=new ArrayList();
            for(int i=fromIdx;i<allIDs.length && sze(v)<DBFETCH_MAXNUM;i++){
                if(!vDone.contains(allIDs[i]) && sze(dbfetchId2file(db,allIDs[i],format))==0 && allIDs[i]!=null) v.add(allIDs[i]);
                fromIdx=i+1;
            }
            final String[]IDs=toStrgArray(0,v);
            if(IDs.length>0){
                final BA ba;
                {
                    final String url=db==DB_NCBI?iUrl(iURL_NCBI_EUTILS_CGI):s(iPath2(iURL_EBI_DBFETCH_DB_EQ,db).aa("&format=",format,"&id=").join(',',IDs));
                    final BA data=db==DB_NCBI?new BA(999).a("db=protein&retmode=text&rettype=gb&").aWWW("id",new BA(0).joinSpc(IDs)):null;
                    baLog(LOG_FETCH_SEQ_FILES).aln().aa(ANSI_FG_BLUE,url).aln(ANSI_RESET).aln(data);
                    ba=data!=null?serverRspns(url,data,null):readBytes(url);
                }
                //IF_MEIN_DEBUG(wrte(WRTE_REPORT_STDOUT,file("~/m1/dbfetch.txt"),ba));
                baLog(LOG_FETCH_SEQ_FILES).a("Downloaded ").formatSize(sze(ba)).aln();
                if(ba!=null && !isErrorBA(ba)){
                    final byte[]T=ba.bytes();
                    final String[]STARTS=arry(SARRAYeq_SEQUENCE_FORMAT_STARTS_WITH),ACC=splitTkns('|',"AC |ACCESSION ");
                    int mode=0;
                    ROFi0(_DBS) if(strStarts(STARTS[i],T)) mode=i;
                    if(mode==0) baLog(LOG_FETCH_SEQ_FILES).aa(RED_ERROR,"Not starting with any of  ").joinSpc(STARTS).aln(ANSI_FG_GRAY).aln(ba).aln(ANSI_RESET);
                    else{
                        int entries=-1;
                        while(true){
                            int iEntry=0;
                            final int ee[]=ba.eol();
                            FORiL(0,ee.length){
                                final int b=BOL0(iL,ee);
                                if(!(ee[iL]-b>7&&strEquAt(0,STARTS[mode],T,b))) continue;
                                final int end=strstr(STR_E,mode==_FASTA?"\n>":"\n//",T,b,ba.end());
                                if(end<0) break;
                                if(entries>=0){
                                    final Collection vID=new ArrayList();
                                    for(String id:IDs){
                                        final int pos=strstr(STR_IC|STR_w,id,T,b,end);
                                        if(pos>0){
                                            final int a=strchrBwd('\n'|STR_E,T,pos,b-1)+1;
                                            if(strEquAt(0,STARTS[mode],T,a)||strEquAt(0,ACC,T,a)) vID.add(id);
                                        }
                                    }
                                    if(sze(vID)==0){
                                        final BA log=new BA(333).addSend(baLog(LOG_FETCH_SEQ_FILES)).addSend(baLog(LOG_OUT)).aa(RED_WARNING," Downloaded text does not contain any of the IDs: ").joinSpc(IDs);
                                        if(entries==IDs.length) log.aa("\nAnyway, Taking ",IDs[iEntry]).aPlrl(entries," because the number of entries is %N.");
                                        else log.aa(ANSI_FG_RED+" #entries=",entries,ANSI_RESET);
                                        log.a("\n"+ANSI_FG_GRAY);
                                        FORjL(iL,ee.length){
                                            final int b1=jL==0?0:ee[jL-1]+1;
                                            if(b1>end) break;
                                            if(strEquAt(0,STARTS,T,b1)||strEquAt(0,ACC,T,b1)) log.aFT(T,b1,ee[jL]).aln();
                                        }
                                        log.aln(ANSI_RESET).send();
                                        if(entries==IDs.length) vID.add(IDs[iEntry]);
                                    }
                                    for(String id:toStrgArray(0,vID)){
                                        final File f=wrte(dbfetchId2file(db,id,format),new BA(T,b,end));
                                        baLog(LOG_FETCH_SEQ_FILES).aa(" Wrote ",end-b," bytes ").aFile(f).aln();
                                        if(sze(f)>9) vDone.add(id);
                                    }
                                }
                                iEntry++;
                            }
                            if(entries<0) entries=iEntry; else break;
                        }
                    }
                }
            }
        }
    }
}
#undef _EMBL
#undef _FASTA
#undef _SOAP
#undef _GENBANK
#undef _DBS

/* Testing: cd $STRAP_SRC; cppSetDebug 1; makeStrapJar15.sh -s;Pack200.sh /var/www/strap/strap.jar */
/* Linux:   cp $STRAP_SRC/strap.jar ~/.StrapAlign/; touch -t 1611302233  ~/.StrapAlign/strap.jar; $STRAP_SRC/web/install2/strap.sh */
