#if 0
/**
   http://research.bioinformatics.udel.edu/peptidematch/docs/userguide.htm#batch_rest
   http://research.bioinformatics.udel.edu/peptidematch/index.jsp

   ##Query peptide: GKLVQIEH...SGSYFSWKASAMGKNVSNAKTFLEKRYTE
   ##Number of matched proteins: 9
   #Protein AC	Protein ID	Protein Name	Length	Organism	Matched Range(s)	Proteomic Databases	IEDB
   A0A078GC31	A0A078GC31_BRANA [tr]	Proteasome subunit alpha type	235	Brassica napus (Rape) [3708]	17-180
   A0A0D3ARN4	A0A0D3ARN4_BRAOL [tr]	Proteasome subunit alpha type	235	Brassica oleracea var. oleracea [109376]	17-180
   A0A178WA13	A0A178WA13_ARATH [tr]	Proteasome subunit alpha type	235	Arabidopsis thaliana (Mouse-ear cress) [3702]	17-180
   A0A1J3GYL4	A0A1J3GYL4_NOCCA [tr]	Proteasome subunit alpha type	235	Noccaea caerulescens (Alpine penny-cress) (Thlaspi caerulescens) [107243]	17-180
   also see tachyon

   wget -O /dev/stdout 'http://research.bioinformatics.udel.edu/peptidematch/webservices/peptidematch_rest?format=tab&query=GDSQYSFSLTTFSPSGKLVQIEHALTAVGSGQTSLGIKASNGVVIATEKKLPSILVDEASVQKIQHLTPNIGVVYSGMGPDFRVLVRKSRKQAEQYLRLYKEPIPVTQLVRETATVMQEFTQSGGVRPFGVSLLVAGYDDKGPQLYQVDPSGSYFSWKASAMGKNVSNAKTFLEKRYTEDMELDDAIHTAILTLKEGFEGEISSKNIEIGKIGADKVFRVLTPAEIDDYLAEVE,DRGYSFSLTTFSPSGKLVQIEYALAAVAAGAPSVGIKASNGVVLATEKKQKSILYDEQSVHKIEPITKHIGMVYSGMGPDYRVLVRRARKLAQQYFLVYQEPIPTGQLVQRVASVMQEYTQSGGVRPFGVSLLIAGWDEDRPYLFQSDPSGAYFAWKATAMGKSYVNGKTFLEKRYNEDLELEDAIHTAILTLKESFEGQMTEENIEVGICNEAGFRRLSPAEVKDYLAAIA,ERYSFSLTTFSPSGKLVQLEYALAAVSGGAPSVGIIASNGVVIATENKHKSPLYEQHSVHRVEMIYNHIGMVYSGMGPDYRLLVKQARKIAQTYYLTYKEPIPVSQLVQRVATLMQEYTQSGGVRPFGVSLLICGWDNDRPYLYQSDPSGAYFAWKATAMGKNAVNGKTFLEKRYSEDLELDDAVHTAILTLKEGFEGKMTADNIEIGICDQNGFQRLDPASIKDYLASIP,GYSFSLTTFSPSGKLVQIEYALAAVAGGAPSVGIKAANGVVLATEKKQKSILYDERSVHKVEPITKHIGLVYSGMGPDYRVLVHRARKLAQQYYLVYQEPIPTAQLVQRVASVMQEYTQSGGVRPFGVSLLICGWNEGRPYLFQSDPSGAYFAWKATAMGKNYVNGKTFLEKRYNEDLELEDAIHTAILTLKESFEGQMTEDNIEVGICNEAGFRRLTPTEVKDYLAAIA,YSFSLTTFSPSGKLVQIEYALAAVAGGAPSVGIKAANGVVLATEKKQKSILYDERSVHKVEPITKHIGLVYSGMGPDYRVLVHRARKLAQQYYLVYQEPIPTAQLVQRVASVMQEYTQSGGVRPFGVSLLICGWNEGRPYLFQSDPSGAYFAWKATAMGKNYVNGKTFLEKRYNEDLELEDAIHTAILTLKESFEGQMTEDNIEVGICNEAGFRRLTPTEVRDYLAAIA'

   wget -O /dev/stdout 'http://research.bioinformatics.udel.edu/peptidematch/webservices/peptidematch_rest?format=tab&query=AAVEEGIVLGGGCALLR,SVQYDDVPEYK'

   wget -O - --no-check-certificate 'https://research.bioinformatics.udel.edu/peptidematch/webservices/peptidematch_rest?format=tab' --post-data 'format=tab&uniref100=n&query=MATERYSFSLTTFSPSGKLVQLEYALAAVS'
*/
#endif //0
#define MAX_NUM_SEQUENCES 13
REFLECTION_PUBLIC_STATIC Runnable pepMatchUniprot(int opt,Protein[]proteins){
    final Protein[]pp=proteins.clone();
    if(OPT_RETURN_THREAD(opt)) return CPP_thrdMS(pepMatchUniprot,Strap,io(opt),pp);
        if(isPrprty(IS_CACHE_READ)){
            FORiP(0,pp.length){
                if(pp[iP]!=null&&_pepMatchParse(true,pp[iP],CacheResult.getValue(TITLE_PEPTIDE_MATCH,cacheKeyForSeqAsStrg(pp[iP],baClr(165)),baClr(73)))) pp[iP]=null;
            }
        }
        if(0==(opt&BLAST4ID_CACHE_ONLY)){
            while(fstNotNull(pp)!=null && !isPrprty(IS_SHUTTING_DOWN)) _pepMatchFew(opt,pp);
        }

    return null;
}
private static void _pepMatchFew(int opt,Protein[]proteins){
    final BA query=new BA(MAX_NUM_SEQUENCES*300);
    final Protein[]pp=new Protein[MAX_NUM_SEQUENCES];
    for(int iP=0,count=0;iP<proteins.length && count<MAX_NUM_SEQUENCES;iP++){
        final Protein p=proteins[iP];
        if(p==null || p.seqId((0!=(opt&BLAST4ID_EVEN_IF_HAS_ID)?GETSEQID_ONLY_BY_IDENTITY:GETSEQID_ALSO_BY_IDENTITY)|BLAST4ID_DB_UNIPROT)!=null) continue;
        proteins[iP]=null;
        query.a0((pp[count++]=p).getResTypeUC()).a(',');
    }
    if(sze(query.del(','))>0){
        //baLog(LOG_PEPMATCH).aa("\n"+ANSI_INVERSE+TITLE_PEPTIDE_MATCH+ANSI_RESET+"\n",pp,"\nQuery = "+ANSI_FG_GRAY,query).aln(ANSI_RESET);
        BA txt;
        synchronized(iUrl(iURL_PEPTIDEMATCH)){
            txt=serverRspns(iUrl(iURL_PEPTIDEMATCH),new BA(999).aWWW("query",query),onlyOnce(14)?baLog(LOG_PEPMATCH):null);
            //wrte(file("~/m1/pepMatch.txt"),txt);
            //final BA txt=readBytes(file("~/m1/pepMatch.txt"));
        }
        if(txt!=null){
            final byte[]T=txt.bytes();
            final BA seq=new BA(0);
            final int ee[]=txt.eol();
            int count=0,start=-1;
            FORiL(0,ee.length){
                final int b=BOL(iL,ee,txt),e=ee[iL];
                if(e-b>17 && T[b]=='#' && strEquAt(0,"##Query peptide: ",T,b)){
                    start=iL;
                    seq.set(T,b+17,e);
                }
                if(e-b<2){
                    if(start>=0){
                        final BA entry=new BA(T,start==0?txt.begin():ee[start-1]+1,e);
                        if(isPrprty(IS_CACHE_WRITE)) CacheResult.putValue(0,TITLE_PEPTIDE_MATCH,cacheKeyForSeqAsStrg(seq,baClr(74)),entry);
                        for(Protein p:pp) _pepMatchParse(false,p,entry);
                        count++;
                    }
                    start=0;
                }
            }
            baLog(LOG_PEPMATCH).aa(ANSI_FG_BLUE,iUrl(iURL_PEPTIDEMATCH)).aln(ANSI_RESET).a(count==0?RED_FAILED:GREEN_SUCCESS).aPlrl(count," Contains %N result%s").aln();
        }
        CPP_GUI_CACHE_SAVE();
    }
}
#define tmp baClr(106)
private static boolean _pepMatchParse(boolean err,Protein p,BA txt){
    if(p==null||sze(txt)==0) return false;
    final byte[]T=txt.bytes();
    final int[]ee=txt.eol();
    baLog(LOG_PEPMATCH).aa(ANSI_INVERSE+"Parse PeptideMatch ",p,"\n"+ANSI_RESET+ANSI_FG_GREEN,txt).aln(ANSI_RESET);
    if(!strEquAt(0,p.getResTypeUC(),T,txt.begin()+17)){
        if(err) baLog(LOG_PEPMATCH).aa(RED_ERROR,"No match ",p," = ").aln(p.getResTypeUC()).aFT(T,txt.begin(),ee[0]).aln();
        return false;
    }

    final int TABS[]=new int[7];
    FORiL(1,ee.length){
        final int b=ee[iL-1]+1,e=ee[iL];
        if(T[b]!='#' && tabulatrs('\t',T,b,e,TABS)>3){
            final String ac=s(tmp.a("UNIPROT:").aFT(T,b,TABS[0]));
            if(null==MAP_UniProt2Swiss.get(ac))  MAP_UniProt2Swiss.put(ac,s(tmp.a("UNIPROT:").aFT(T,TABS[0]+1,strchr(STR_E|'[',T,TABS[0],TABS[1])).delBlanksR()));
            if(TABS[2]-TABS[1]>2 && null==MAP_UniProt2Name.get(ac)) MAP_UniProt2Name.put(ac,s(T,TABS[1]+1,TABS[2]));
            final int offset=atoi(T,TABS[4]+1)-1;
            IF_MEIN_DEBUG(if(offset<0) assrt());;
            p.addSeqRef(ADD_SEQREF_BY_IDENT|offset,ac);
        }
    }
    return true;
}
#undef tmp
#undef MAX_NUM_SEQUENCES
