@*SARRAYeq_TITLE_FOR_BID
 Added DNA and RNA structures=M_P_ASSOCIATE_NUCL
*@
@*SARRAYeq_TEXT0_FOR_BID
 Predictions from amino acid sequences will not be reported here.=M_P_LIST_SECSTRU
*@
@*RSC_HINT_SEQ_FILE_DND_CTXT
 <SUB>Hint: Use drag-and-drop to load the sequence files into the alignment pane.<BR>Right click for context menu.</SUB>
*@
final int mcSel=modic(strapSelectedObjectsV());
final ContextObjects co=(ContextObjects)_data[DATA_SXM_ContextObjects];
final Protein[]selPP;
{
    Protein[]pp=(Protein[])co._v(CHAINTYPE_PEP).asArray();
    if(pp.length==0) pp=spp(strapCursorProtein());
    selPP=pp;
}
ResidueSelection[]selSS=(ResidueSelection[])co._v(SOBJECT_RESSEL_AND_RESAN).asArray();
final int mID=_idata[IDATA_SXM_TYPE];
switch(id){
    CASE_ARG(RUN_SET_COLOR,Object,color){
        runCR1(RUN_SET_COLOR,selPP,color);
        runCR1(RUN_SET_COLOR,selSS,color);
        BREAK;
    }
    CASE_ARG(RUN_IS_OBJECT_ENABLED,Object,o){/*X  RRRRRRRRRR ContextMenu  RUN_IS_OBJECT_ENABLED RRRRRRRRRR */
        final int bid=evtBid(o);
        boolean e=false,c=false;
        if(mID==SOBJECT_V3D){
            for(View3d v:(View3d[])co._v(SOBJECT_V3D).asArray()){
                final Simple3DCanvas simple=derefZ(v3dCanvas(v),Simple3DCanvas.class);
                switch(bid){
                case M_PV_NATIVE_MB:c=true; e=v.getProperty(VIEW3D_GET_JMENUBAR)!=null;break;
                case M_PV_CTRL:c=true; e=ctrlPnl(v)!=null;break;
                case M_PV_AOT_OFF:
                case M_PV_AOT:c=true; e=v.getProperty(VIEW3D_GET_FRAME_TITLE)!=null;break;
                case M_PV_CUSTOMIZE:c=true; e=sze(toArrayOfCustomize(v))>0;break;
                case M_PV_SCREENSHOT:c=true; e=null!=v3dCanvas(v) && !v3dFlag(VIEW3D_FLAG_OPENGL,v);break;
                case M_PV_WIKI_DnD:
                case M_PV_LIST_SEQFT:
                case M_PV_LIST_RESAN:
                case M_PV_LOG_GENERIC:
                case M_PV_SELECT_AMINO:c=true; e=simple==null;break;
                case M_PV_DEFAULT_VIEWER:
                case M_PV_BACKBONE_DIFF_COLOR:
                case M_PV_BACKBONE_DIFF_COLOR_JMOL:c=true; e=simple!=null;break;
                default:
                    switch(bid){
/*                     case M_PV_INFO:{ */
/* /\* final String label=addPfx("Using ",simple!=null?"the backbone 3D view":shrtClasNamOrAlias(v)); *\/ */
/* /\* for(Object m:oo(gcp(KEY_MENU_ITEMS,o))) setTxt(label,derefZ(m,AbstractButton.class)); *\/ */
/*                         setTxt(addPfx("Using ",simple!=null?"the backbone 3D view":shrtClasNamOrAlias(v)),gcp(KEY_MENU_ITEMS,o)); */
/*                         break; */
/*                     } */
                    case M_PV_LAB_CTXT:c=true; e=v3dFlag(VIEW3D_FLAG_HAS_CONTEXTMENU,v);break;
                    case M_PV_STRAP_MB:c=true; e=!(isCbSlct(STOG_MULTI_MBARS)||isMac());break;
                    }
                    if(null!=gcp(_KOPT_ONLY_SIMPLE_3D,o)) {c=true; e=simple!=null;}
                    {
                        final String cmd3D=gcps(M_KEY_V3DCMD,o);
                        if(cmd3D!=null){
                            int w0=v3dCmdInLine(gcps(_V3D_KEY_CMD,o));
                            if(w0==0) pcp(_V3D_KEY_CMD,toStrgN(iConst(SARRAY_STRAP_SCRIPT_CMD,w0=v3dCmdInLine(cmd3D))),o);
                            return w0==0||v3dIsSupporting(w0,v)?TRUEr:FALSEr;
                        }
                    }
                    final View3d[]vv=v3dVV(v);
                    for(int iV=sze(vv); !e && --iV>=-1;){
                        final View3d v2=iV<0?v:vv[iV];
                        {
                            final int iList=gcpi(M_KEY_STRAPL,v2);
                            if(iList>0){
                                c=true;
                                e=0<sze(strapInstance(iList));
                                continue;
                            }
                        }
                        final Protein p=sp(v2);
                        if(p==null) continue;
                        final boolean
                            isPreview=runCR(RUN_SIMPLE3D_IS_PREVIEW,simple)!=null || gcp(V3D_KOPT_IS_PREVIEW,v2)!=null,
                            hiddenN=simple==null && (p.subsetStart()>0 || null!=p.getPdbID(PDBID_INFERRED)),
                            hiddenC=simple==null && (p.isSubset() || null!=p.getPdbID(PDBID_INFERRED));
                        switch(bid){
                        case M_PV_SAVE:
                        case M_PV_LOG_NATIVE:
                        case M_PV_LOAD:
                        case SBUT_STRAP_ZIP:
                        case M_PV_LABEL:
                            //case M_PV_SCRIPT:
                        case M_PV_SELECT_HET:
                        case M_PV_SELECT_NUC:
                        case M_PV_SELECT_ATOMS_G:
                        case M_PV_SELECT_ATOMS:c=true; e=simple==null;break;
                        case M_SEL_SELECT_SHEET:
                        case M_SEL_SELECT_HELIX:
                        case M_SEL_SELECT_HELIX_SHEET:c=true; e=simple==null && p.getResidueSecStrType()!=null;break;
                        case M_PV_SELECT_N:c=true; e=hiddenN;break;
                        case M_PV_SELECT_C:c=true; e=hiddenC;break;
                        case M_PV_HIDE_NC:
                        case M_PV_SELECT_NC:c=true; e=hiddenN||hiddenC;break;
                        case M_PV_SUPER_UNDO:c=true; e=!isPreview && gcp(M_KEY_SUPER_UNDO,p)!=null;break;
                        case M_PV_BACKBONE_HIDE_DIST_HET:
                        case M_PV_BACKBONE_SHOW_HIDE_HET:c=true; e=simple!=null && p.getMolecules(CHAINTYPE_NUC_OR_HET).length>0;break;
                        case M_PV_SUPER_STOP:
                        case M_PV_SUPER_GO:
                        case M_PV_SUPER_CMPLX_GO:c=true; e=!isPreview;break;
                        case M_PV_SUPER_HOME:c=true; e=!isPreview && !isUnitOrNull(p.getRotationAndTranslation());break;
                        }
                    }/*X for v2*/
                }
                if(e) break;
            }/*X for v2*/
        }/*X SOBJECT_V3D*/
        if(mID==CHAINTYPE_HET){
            final int nH=sze(co._v(CHAINTYPE_HET));
            if(bid==M_X_LIST){c=true; e=nH>0;}
            if(bid==M_H_CLOSE || bid==M_H_DEL || bid==M_H_VIEW3D){
                for(Protein h:(Protein[])co._v(CHAINTYPE_HET).asArray()){
                    if(bid==M_H_CLOSE) {c=true; e=h.getOneOwner()!=null;}
                    if(bid==M_H_DEL || bid==M_H_VIEW3D) {c=true; e=h.getFile()!=null;}
                    if(e) break;
                }
            }
        }/*X CHAINTYPE_HET*/
        if(mID==CHAINTYPE_PEP){
            c=true;
            e=null!=fstComplies(selPP,gcpi(M_KEY_FLAGS,o));
        }
        if(mID==SOBJECT_RESSEL_AND_RESAN){
            for(ResidueSelection s:selSS){
                switch(bid){
                case M_SEL_WRITE_PDB:c=true; e=hasCalpha(sp(s));break;
                case M_SEL_SEND_V3D:c=true; e=sp(s)!=null && sp(s).get3dViews().length>0;break;
                case M_X_COLOR:c=true; e=sobjectType(s)!=SOBJECT_SEQFEAT;break;
                case M_SEL_REPORT_INCLUDED:c=true; e=sobjectType(s)==SOBJECT_SEQFEAT&&s instanceof ResidueAnnotation&&sze(((ResidueAnnotation)s).includedFeatures())>0;break;
                case M_SEL_DIALOG_ACTIVATE:c=true;break;
                case M_SEL_DEACTIVATE:e=runCR(RUN_IS_ENABLED,s)==TRUEr;break;
                case M_SEL_ACTIVATE:c=true; e=runCR(RUN_IS_ENABLED,s)==FALSEr;break;
                case M_SEL_RM_CURS:c=true; e=s!=null;break;
                case M_SEL_FLAGS_SHOW_HIDE:c=true;e=sxmMayShowHide(false,o,s);break;
                }
                if(e) break;
            }
        }/*X SOBJECT_RESSEL_AND_RESAN*/
        RETURN(!c?null: e?TRUEr:FALSEr);
    }
/* RRRRRRRRRR ContextMenu RRRRRRRRRR */
    CASE_ARGV(PROVIDE_FILES){
        if(mID==CHAINTYPE_PEP){
            final Collection v=vClr(6);
            synchronized(recordSync(v,"PEP PROVIDE_FILES")){
                clr(v);
                for(Protein p:selPP) adUniq(p.getFile(),v);
                return toArry(v,NO_File);
            }
        }
        BREAK;
    }
    CASE_ARG(RUN_WINDOW_BECOME_INVISIBLE,Object,window){
        inEDTms(thrdCR(_RUN_SET_V3D,this),99);/*X  Otherwise the menus are not reacting */
        BREAK;
    }
 }/*X switch id ContextMenu*/
#define ev arg
if(RUN_M_EVT(id)){/*X  RRRRRRRRRR ContextMenu Event RRRRRRRRRR */
    final Object q=evtSrc(ev);
    final int bid=evtBid(ev);
    String[]execPara=null;
    Object[]selXX=null;
    final BA sb=baClr(78);
    if(mID==SOBJECT_V3D){
        Simple3DCanvas simple=null;
        final Collection<Protein>vAllPP=NEW_VECTOR();
        if(bid==M_PV_SELECT_ATOMS_G||bid==M_PV_SELECT_AMINO||bid==M_PV_LABEL||bid==M_PV_SELECT_ATOMS)v3dOpenDialogSelect(bid);
        for(View3d pv:(View3d[])co._v(SOBJECT_V3D).asArray()){
            final Protein p=sp(pv),pp[]=v3dPP(pv);
            if(p==null) continue;
            if(v3dCanvas(pv) instanceof Simple3DCanvas) simple=(Simple3DCanvas)v3dCanvas(pv);
            adAllUniq(pp,vAllPP);
            if(bid==M_PV_AOT || bid==M_PV_AOT_OFF) wndw(bid==M_PV_AOT?WNDW_DO_AOT_ON:WNDW_DO_AOT_OFF,pv.getProperty(VIEW3D_GET_FRAME_TITLE));
            else if(bid==M_PV_SUPER_GO || bid==M_PV_SUPER_CMPLX_GO){
                if(sze(pp)<2){
                    new BA(333).aPlrl(sze(pp),"Superposition requires at least\ntwo proteins in the same 3D-view.\n\nBut only %N protein is in this view\n\n")
                        .a(v3dCanvas(pv)==null?"":"Use WIKI:Drag_and_drop to load at least one more sequence.\n\nWatch <i>HTMLDOC_BUTTON:BUTS_MOVIE_Drag_protein_to_3D!</i>").special(BA_ERROR);
                }else if(!_isSuperimposing || dlgYesNo("It seems that a superposition job is already running.<BR>Start new job anyway?")){
                    strapEvtDispatch(EVT_COMPUTATION_STARTED|SEVTMS);
                    final Collection v=new ArrayList();
                    for(Protein prot:pp){
                        if(hasCalpha(prot)){
                            final Matrix3D m3d=prot.getRotationAndTranslation();
                            v.add(pcp(M_KEY_SUPER_UNDO,m3d!=null?m3d:new Matrix3D(),prot));
                        }
                    }
                    if(bid==M_PV_SUPER_CMPLX_GO) for(Protein prot:spp(v)) rmAll(prot.getProteinsSameComplex(),v);
                    startThrd(superimposeProteins(bid==M_PV_SUPER_CMPLX_GO?RETURN_THREAD|SUPERIMP_COMPLEX_BEST|SUPERIMP_EVENT:SUPERIMP_EVENT,v,null));
                }
            }
            {
                int later=0;
                ROFi0(pp.length){
                    if(bid==M_PV_SUPER_UNDO || bid==M_PV_SUPER_HOME){
                        pp[i].setRotationAndTranslation(bid==M_PV_SUPER_HOME?null: derefZ(gcp(M_KEY_SUPER_UNDO,pp[i]),Matrix3D.class));
                        later=EVT_PROTEIN_3D_MOVED|SEVTMS;
                    }
                }
                strapEvtDispatch(later);
            }
            if(bid==M_PV_SUPER_STOP) interruptAll();
            if(bid==M_PV_SCREENSHOT) flushPngAndHtmlInBrowser(0,newFile(iFile(DIR_SCREENSHOTS),addSfx(".png",shrtClasNamOrAlias(pv))),v3dCanvas(pv));
            switch(bid){
            case M_PV_WIKI_DnD:buttn(SBUT_HOWTO_DnD_RESSEL).doClick();break;
                //case M_PV_INFO:showHelp(clazz(pv)); putln(DEBUG_NOW+" showHelp ");break;
            case M_PV_HELP:showHelp(View3d.class);break;
            case M_PV_CTRL:shwCtrlPnl(0,s(new BA(99).aa(sp(pv)," @ ",shrtClasNamOrAlias(pv))),pv);break;
            case M_PV_CUSTOMIZE:customizeAddDialog(pv);break;
            case M_PV_LOG_NATIVE:v3dShowLog('N',pv);break;
            case M_PV_LOG_GENERIC:v3dShowLog('G',pv);break;
            case M_PV_SAVE:for(Object o:v3dLog(0,pv,null).getSendTo()) runCR(RUN_LOGGER_SAVE,o);break;
            case M_PV_LOAD:
                if(_v3dFC==null){
                    runCR1(RUN_FCHOOSER_addFilter,_v3dFC=newFileChooser(PRPRTY_FC_StrapPopup|FCHOOSER_CLOSE),delToLstChr1('.',nam(iFile(F_V3D_LOG_FILE))));
                    runCR1(RUN_FCHOOSER_setCurrentDirectory,_v3dFC,iFile(F_V3D_LOG_FILE));
                    addActLiMain(_v3dFC);
                }
                ChFrame.frame(FRAME_ALWAYS_ON_TOP|FRAME_PACK|CLOSE_CtrlW_ESC,"Choose a script input file",pcp(KEY_PROTEIN_VIEWER,pv,_v3dFC)).shw(FRAME_CENTER);
                break;
            }
            {
                final int iList=gcpi(M_KEY_STRAPL,q);
                if(iList>0){
                    final Object jl=straplJList(LSTMDL_FLAG_CREATE|LSTMDL_FLAG_TWO_JLIST|iList);
                    Object south=gcp(KEY_SOUTH_PANEL,jl);
                    if(south==null){
                        if(iList==LSTMDL3D_HET || iList==LSTMDL3D_NUCL || iThBool(iList,boolArry(RSC_INTS_LSTMDL3D_TYPES_SEL))) south=labl(delPfx("-",butTxt(MENUHINT_CLICKING_RESSEL)));
                        else if(iList==LSTMDL3D_PROTEINS){
                            final Object
                                b=pcp(_KEY_JLIST,wref(jl),buttn(SBUT_V3D_CLOSE)),
                                msg=newHtmlPane(0,getHlp(AbstractView3dCanvas.class));
                            south=pnl(VBPNL,b,pnl(HBL,"Hint:  Proteins or residue selections can be dragged here. ",pnlTogglOpts(TOGGL_PNL_Explain|TOGGL_PNL_OPT_PACK,msg)),msg);
                            pcp(JLIST_KEY_ENABLE_IF_SELECTED|PCP_OPT_ADD_TO_ARRAY|PCP_OPT_WREF,b,jl);
                            runCR1(RUN_NEW_DROPTARGET,this,pcp(KEY_DROP_TARGET_REDIRECT|PCP_OPT_ARRAY_RECURSIVE,jl,childsR(south,Component.class)));
                        }
                        pcp(KEY_SOUTH_PANEL,south,jl);
                    }
                    //setMinSze(33,33,jl);
                    shwTxtInW(FRAME_AT_CLICK|CLOSE_CtrlW_ESC|FRAME_SCROLLPANE,txtForTitle(q),jl);
                    v3dEnableDisable();
                }
            }
            switch(bid){
            case M_PV_STRAP_MB:setStrapMenuBar(null,0,0); setToolpane(null);break;
            case M_PV_GENERIC_MB:
            case M_PV_NATIVE_MB:pcp(V3D_KEY_WHICH_MENU,io(bid),v3dCanvas(pv)); v3dSetPV(V3D_FOCUSED,pv);break;
            case M_H_CLOSE:v3dClosePP(selValues(gcp(_KEY_JLIST,q)),pv);break;
            case M_PV_OPEN_IN:
            case M_PV_DEFAULT_VIEWER:{
                final Object c3d=bid==M_PV_DEFAULT_VIEWER?sclDefaultForInterface(INTRFC_View3d):gcp(KEY_View3d,q);
                if(sze(pp)>5 && !dlgYesNo(plrl(sze(pp),"Open %N 3D view%S?"))) continue;
                if(c3d!=null){
                    final View3d pvNew=v3dOpen((IS_CTRL_EV(ev)?V3D_OPEN_VERBOSE:0)|
                                               (isCbSlct(STOG_V3D_SEND_ANNO)?V3D_OPEN_SEND_ALL_ANNOTATIONS:0)|
                                               (simple!=null&&isCbSlct(STOG_V3D_SEND_INIT)?V3D_OPEN_INIT_SCRIPT:0)|
                                               (runCR(RUN_SIMPLE3D_IS_PREVIEW,simple)!=null?V3D_OPEN_EACH_PROTEIN_OWN_COLOR: 0),pp,c3d,null);
                    if(runCR(RUN_SIMPLE3D_IS_PREVIEW,simple)!=null){
                        final View3d[]vvNew=v3dVV(pvNew);
                        for(View3d v0:v3dVV(pv)){
                            for(View3d v:vvNew){
                                if(sp(v)==sp(v0)){
                                    v3dTransform3D(((Simple3D)v0)._mxPreview,v);
                                    pcp(V3D_KOPT_IS_PREVIEW,"",v);
                                }
                            }
                        }
                    }
                    for(Object v:v3dLog(0,pv,"").getSendTo()){
                        if((v=deref(v)) instanceof ChLogger){
                            final File f=iFile(FSUFFIX_txt);
                            ((ChLogger)v).save(0,f);
                            IF_MEIN_DEBUG(baOut(ANSI_FG_GREEN+"IF_MEIN_DEBUG_Clone_3D_View ").aFile(f).aln(ANSI_RESET));
                            v3dLoadSession(V3D_SESSION_NO_ASK,pvNew,f);
                        }
                    }
                }
                break;
            }
            case M_PV_LOG_NATIVE:
            case M_PV_LOG_GENERIC:{
                final BA ba=v3dLog(bid==M_PV_LOG_GENERIC?0:V3D_LOG_NATIVE,pv,"");
                if(ba!=null) for(Object v:ba.getSendTo()) if((v=deref(v)) instanceof ChLogger) ChFrame.frame(CLOSE_CtrlW_ESC,gcps(KEY_TITLE,v),getPnl(v)).shw();
                break;
            }
                //case M_PV_SCRIPT: v3dShowScript();break;
            }
            {/*X  --- Selections --- */
                final Object cmd=evtCmd(ev);
                Object select=chrAt(0,cmd)=='$' || chrAt(0,cmd)=='-'&&chrAt(1,cmd)=='9'?cmd:null;
#if CPP_DEACTIVATED
                if(bid==LBUT_SEL_I){
                    final boolean[]bb=selection3dToBoolZ((Selection3D[])gcp(KEY_SEL_ATOM,pv),p,null);
                    ROFi0(sze(select=bb)) bb[i]=!bb[i];
                }
#endif //CPP_DEACTIVATED
                if(bid==M_SEL_SELECT_HELIX || bid==M_SEL_SELECT_SHEET || bid==M_SEL_SELECT_HELIX_SHEET){
                    final byte[]ss=p.getResidueSecStrType();
                    if(!ARRAY_EMPTY(ss)){
                        final boolean[]bb=new boolean[mini(p.countRes(),ss.length-p.subsetStart())];
                        ROFi0(bb.length) bb[i]=strchr(ss[i+p.subsetStart()],cmd,4,MAX_INT)>=0;
                        select=bb;
                    }
                }
                final Selection3D[]ss3D=
                    select instanceof boolean[]?boolToSelection3D(0,(boolean[])select,0,p,""):
                    select instanceof String?textToSelection3D((String)select,p):
                    null;
                if(ss3D!=null){
                    v3dSetPV(V3D_FOCUSED,pv);
                    v3dSetSelection3D(0,ss3D,"",pv);
                }
            }
            final String cmd3D=gcps(M_KEY_V3DCMD,q);
            if(cmd3D!=null && cmd3D!=V3DCMD_color) v3dSendCommand(IS_SHIFT_EV(ev)?strplc(STR_w_R," on"," off",cmd3D): cmd3D,pv);
        }/*X for(View3d pv*/
        if(bid==M_PV_EDIT_INITSCRIPT) for(Object o:oo(sclClassesV(INTRFC_View3d))) customizeAddDialog(bidCustomize(bidForClass(o),RSC_MULTI_INIT));
        if(bid==M_PV_BACKBONE_SHOW_HIDE_HET)  dlgShowMsg("At the bottom of the 3D-panel, activate \"List proteins\"");
        if(bid==M_PV_BACKBONE_DIFF_COLOR_JMOL || bid==M_PV_BACKBONE_DIFF_COLOR){
            runCR1(RUN_SIMPLE3D_EACH_CHAIN_ONE_COLOR,simple,io(bid==M_PV_BACKBONE_DIFF_COLOR_JMOL?CHAINCOLOR3D_AS_CHAIN:0));
            runCR(RUN_ENABLE_DISABLE,awtc(AWTC_OPT_REPAINT,simple));
        }
        if(bid==M_PV_BACKBONE_HIDE_DIST_HET) runCR1(RUN_SIMPLE3D_SET_HIDE_DISTANT_DNA,simple,q);

    }/*X SOBJECT_V3D*/
    if(mID==CHAINTYPE_HET && sze(selXX=co._v(CHAINTYPE_HET).asArray())>0){
        //if (bid==M_H_CLOSE && ARRAY_EMPTY(selectedProteins()) && !dlgYesNo(plrl(sze(selXX),"Remove from proteins:<BR>No proteins selected. Remove the %N"+_sxmTitle+"%S from any protein"))) return null;
        for(Protein h:spp(selXX)){
            if(bid==M_H_VIEW3D) for(File f:(File[])runCR(RUN_PROVIDE_DND_FILES,h)) if(sze(f)>0) shwTxtInW(FRAME_STAGGER|FRAME_SCROLLPANE,null,f);
            if(bid==M_H_CLOSE||bid==M_H_DEL){
                int later=0;
                for(Protein p:!ARRAY_EMPTY(selectedProteins())?selectedProteins():strapProteins()) if(rmFromProt(h,p)) later=EVT_HET_OR_NT_STRUCTURE_ADDED_OR_REMOVED|SEVTMS;
                strapEvtDispatch(later);
                if(bid==M_H_DEL) renamFile(h.getFile(),fileJoinSlsh("./trash",nam(h.getFile())));
            }
            break;
        }
    }/*X CHAINTYPE_HET*/
    if(mID==SOBJECT_RESSEL_AND_RESAN){
        selXX=selSS;
        toDelList(bid==M_SEL_DEL?selSS:bid==M_SEL_DEL_DUPS?resSelRmDuplicates(selSS):null);
        switch(bid){
        case M_SEL_SELECT:adAllUniq(selSS,strapSelectedObjectsV());break;
        case M_SEL_DESELECT:rmAll(selSS,strapSelectedObjectsV());break;
        case M_SEL_GET_HIDDEN:viewTree(null);break;
            //case M_X_COLOR: strapEvtDispatch(EVT_RESIDUE_SELECTION_COLOR|SEVTMS);break;
        case M_SEL_SEND_V3D:v3dApplyResSel_I(V3D_RESSEL_SAME_PROTEIN|V3D_RESSEL_NO_WIRE,selSS,(View3d[])null);break;
        case M_SEL_STYLE:ChFrame.frame(FRAME_PACK|FRAME_ALWAYS_ON_TOP,"Style",sxmItem(M_SEL_PAN_STYLE)).shw(FRAME_AT_CLICK|FRAME_DRAG);break;
        case M_SEL_COPY2SEQS:resSelCopyToSeq(COPY_REPORT,selSS,(Protein[])pleaseSelect(CHAINTYPE_PEP,selectedProteins()),null,null);break;
            //case M_SEL_ADD_ANNO:if(selSS.length>0) ChFrame.frame(FRAME_CENTER|FRAME_PACK,"add row",new AddAnnotation(selSS)).shw(0);break;
        case M_SEL_ADD_ANNO:if(selSS.length>0) ChFrame.frame(FRAME_CENTER|FRAME_PACK,"Add row",runCR1(RUN_SET_RESSEL,mkInstanceBid(BUT_C1(AddAnnotation)),selSS)).shw(0);break;
        case M_SEL_EDIT:resSelToResan(TO_RESAN_EDIT|TO_RESAN_ALSO_RETURN_UNCHANGED,selSS);break;
        case M_SEL_CROP:runCR1(RUN_SET_RESSEL,addDialogBid(BUT_C1(DialogRenameSeqs)),selSS);break;
        case M_SEL_SHOW_FROM_TO:shwTxtInW(txtForTitle(q),resSelListFromTo(selSS,0,new BA(999)));break;
        case M_SEL_CLIPBRD_FROM_TO:resSelListFromTo(selSS,1,sb);break;
        case M_SEL_WRITE_PDB:{
            final Collection vP=new ArrayList(),vTxt=new ArrayList();
            for(ResidueSelection s:selSS) adUniq(sp(s),vP);
            for(Protein p:spp(vP)){
                final boolean[]selected=new boolean[p.countRes()];
                clr(sb).aa("REMARK protein=",p).aln();
                for(ResidueSelection s:selSS){
                    if(p==sp(s)){
                        if(!p.isProteinStructure()) sb.aa("REMARK ",p," no C-alpha - skipped\n");
                        else{
                            p.getAtomXYZ();
                            final boolean[]bb=s.getSelectedAminoacids();
                            final int offsetZ=resSelAminoOffsetZ(s);
                            ROFi0(mini(selected.length,bb.length+offsetZ)) if(i>=offsetZ && bb[i-offsetZ]) selected[i]=true;
                        }
                    }
                }
                final File f=file(iPathExt(DIR_STRAPOUT_SELECTED_AS_PDB,p,FSUFFIX_pdb));
                strapInstance(SEQWRITER_PDB).getProteinText(SEQW_COMPLETE_PDB,p,new Matrix3D[]{p.getRotationAndTranslation()},selected,clr(vTxt));
                wrte(WRTE_REPORT_STDOUT,f,sb.aa("REMARK ",f).aln().join0(vTxt));
            }
            break;
        }
        }
        // if(bid==M_SEL_CLIPBRD_FROM_TO) sb.aa(p,'/').aFromDashTo(resSelFirstAmino(s)+1,resSelLastAmino(s)+1).aln();
        int countInc=0,later=0;
        Protein pPrev=null;
        FORiS(0,selSS.length){
            final ResidueSelection s=selSS[iS];
            final Protein p=sp(s);
            final boolean[]bb=s.getSelectedAminoacids();
            final int offsetZ=resSelAminoOffsetZ(s);
            switch(bid){
            case ACTION_SELECTION_CHANGED:
                if(q==sxmItem(M_SEL_PAN_STYLE)){
                    s.setStyle(getSlctIdx(q));
                    later=EVT_RESIDUE_SELECTION_COLOR|SEVTMS;
                }
                break;
            case M_SEL_CURSOR2LAST:
            case M_SEL_CURSOR2FIRST:{
                final int iA=offsetZ+(bid==M_SEL_CURSOR2FIRST?fstTrue(bb): lstTrue(bb));
                setCursorResidueIdx(p,iA);
                animateAlignmentPositionZ(p,iA);
                break;
            }
            case M_SEL_SHOW_TEXT:
                if(p!=null) {
                    if(p!=pPrev) sb.aln().aln(pPrev=p);
                    sb.aa("  ",runCR1(RUN_GET_RENDERER_TXT,s,NULL_AS_INT)).aln(ANSI_RESET);
                    ROFt0(3){
@*SARRAYeq_ResselReportPos_Header
                         Indices start at 0:=0
                         Indices start at 1:=1
                         PDB-numbers:=2
*@
                        if(t==2&&!p.isProteinStructure()) continue;
                        sb.an(' ',4).aa(iConst(SARRAYeq_ResselReportPos_Header,t),' ');
                        FORi(0,bb.length){
                            if(bb[i]){
                                if(t==2) p.resnAsText(0,i+offsetZ,sb); else sb.a(i+offsetZ+t);
                                sb.a(", ");
                            }
                        }
                        sb.del(", ").aln();
                    }
                }
                break;
            case M_SEL_DEL:rmFromProt(s,p); dispos(s); later=EVT_RESIDUE_SELECTION|SEVTMS;break;
            case M_SEL_AD_CURS:
            case M_SEL_RM_CURS:
                if(p!=null && resSelSetAminoSelected(bid==M_SEL_AD_CURS&&IS_NOT_SHIFT_EV(ev)?SELECTION_ADD:SELECTION_RM,p.columnToIndex(0,strapCursor(GET_CURSOR_COLUMN))+firstResIdx(p),ALIAS_POSITION_PLUS_1,s))
                    later=EVT_RESIDUE_SELECTION|SEVTMS;
                break;
            case M_SEL_UCASE:
            case M_SEL_LCASE:
                if(p!=null){
                    final byte[]aa=p.getResidueType();
                    ROFi0(p.countRes()) if(iThBool(i-offsetZ,bb)) if(bid==M_SEL_UCASE) aa[i]&=~32; else aa[i]|=32;
                    p.setResidueType(aa);
                    later=EVT_RESIDUE_SELECTION|SEVTMS;
                }
                break;
            case M_SEL_EXEC:{
                if(execPara==null) execPara=new String[selSS.length];
                final Object[]dd=(Object[])_data[DATA_SXM_DialogExecuteOnFile];
                if(dd[bid]==null) dd[bid]=new DialogExecuteOnFile(CUSTOM_execResidueSelection);
                execPara[iS]=resSelToUpperCase(s,ANSI_FG_RED,ANSI_RESET);
                break;
            }
            case M_SEL_REPORT_INCLUDED:
                if(s instanceof ResidueAnnotation){
                    final String[]inc=sobjectType(s)!=SOBJECT_SEQFEAT?null: toStrgArray(0,((ResidueAnnotation)s).includedFeatures());
                    if(sze(inc)!=0) sb.an('\n',0<countInc++?2:0).aa(ANSI_INVERSE,runCR1(RUN_GET_RENDERER_TXT,s,io(RENDER_FOR_JLIST)),ANSI_RESET).aln().joinLns(inc);
                    if(iS==selSS.length-1) shwTxtInW("Included sequence features",sb);
                }
                break;
            case M_SEL_CLIPBRD_NAME:sb.aa(p,'/',nam(s),'\n');break;
            case M_SEL_CLIPBRD_RESN:sb.aa(p,'/').boolToText(s.getSelectedAminoacids(),1+firstResIdx(p)+offsetZ,",","-").aln();break;
            case M_SEL_CLIPBRD_SEQU:resSelSequenceAsString(s,sb).aln();break;
            case M_SEL_ACTIVATE:runCR(RUN_SET_ENABLED,s); later=EVT_RESIDUE_SELECTION|SEVTMS;break;
            case M_SEL_DEACTIVATE:runCR(RUN_SET_DISABLED,s); later=EVT_RESIDUE_SELECTION|SEVTMS;break;
            case ACTION_COLOR_CHANGED:if(getColrO(q)!=null && sobjectType(s)!=SOBJECT_SEQFEAT) {setColrO(getColrO(q),s);later=EVT_RESIDUE_SELECTION_COLOR|SEVTMS;} break;
            case M_SEL_FLAGS_SHOW_HIDE:if(sxmMayShowHide(true,q,s)) later=EVT_RESIDUE_SELECTION|SEVTMS;break;
            }
        }/*X for s*/
        strapEvtDispatch(later);
/* Dialogs */
        if(bid==M_SEL_DIALOG_ACTIVATE) dialogResanActAndDeact(0,null);
        final int iBut=idxOf(q,_data);
        if(iBut==DATA_DiaAnnoActDeact_ButActiv||iBut==DATA_DiaAnnoActDeact_ButDeact||iBut==DATA_DiaAnnoActDeact_ButDel) dialogResanActAndDeact(iBut,selSS);
        if(iBut==DATA_DiaAnnoActDeact_filter){
            setEnbld(!isSlct(q),_data[DATA_DiaAnnoActDeact_ComboKeys]);
            awtc(AWTC_OPT_REPAINT,_data[DATA_DiaAnnoActDeact_ComboKeys]);
        }
    }/*X SOBJECT_RESSEL_AND_RESAN*/
    if(mID==CHAINTYPE_PEP){
        selXX=selPP;
        {
            final int t=
                bid==M_P_LIST_HETS?CHAINTYPE_HET:
                bid==M_P_LIST_NUCL?CHAINTYPE_NUC:
                bid==M_P_LIST_RESAN?SOBJECT_RESAN:
                bid==M_P_LIST_SEQFT?SOBJECT_SEQFEAT:
                bid==M_P_LIST_RESEL?SOBJECT_RESSEL: -1;
            if(t>=0) showChildObjects(t,selPP);
        }
        File[]ffResult=null;
        switch(bid){
        case M_P_SPLIT_CHAINS:{
            final Collection<File>v=new ArrayList();
            for(Protein p:selPP) adUniq(p.getFile(),v);
            runCR1(RUN_SPLIT_PDB_CHAINS,_main,v);
            break;
        }
        case M_P_HL_DIFF:showDifferringResidues(selPP);break;
/* if(bid==LBUT_NEIGHB) {runCR1(RUN_COMPUTE,addDialogSetClassAndSequences(BUT_C1(DialogNeighbors),null,selPP),null);} */
        case M_P_SEL_SEND_V3D:{
            boolean success=false;
            for(Protein p:selPP) success|=v3dApplyResSel(V3D_RESSEL_COMMANDS|V3D_RESSEL_COLOR|V3D_RESSEL_NO_WIRE|V3D_RESSEL_SET_FOCUSED_PV,p.residueAnnotations(),p.get3dViews(),null);
            if(!success) error("No 3D-commands sent");
            break;
        }
        case M_P_PARSE_GB:runCR1(RUN_COMPUTE,addDialogSetClassAndSequences(BUT_C1(DialogGenbank),null,selPP),null);break;
        case M_P_SET_NOT_TRANSLATED:
            if(dlgYesNo(plrl(proteinsThatComply(IF_NT,selPP).length,"Discard all reading frame and intron/exon information of %N sequence%S?"))){
                for(Protein p:selPP) p.setExons(null,false);
                strapEvtDispatch(EVT_NUCL_TRANSLATION);
            }
            break;
        case M_P_DELETE:
        case M_P_CLOSE:
            if(bid==M_P_CLOSE || dlgYesNo(pnl(VBPNL,selPP.length<5?new BA(99).joinLns(selPP):"",pnl(plrl(selPP.length,"Kill the %N sequence%S and move their files to "),"./trash/"," ?")))){
                strapRemoveProteins(bid==M_P_DELETE,selPP);
                setCursorColumn(io(strapCursor(GET_CURSOR_ROW)),strapCursor(GET_CURSOR_COLUMN));
            }
            break;
        case M_P_RESCUE_DELETED:viewFile(iFile(DIR_TRASH));break;
        case M_P_BACKTRANSLATE:
            if(selPP.length>0){
                final ChJCombo combo=new ChJCombo(arry(SARRAYeq_CODON_USAGE_ORGANISMS));
                if(dlgYesNo(pnl(VBPNL,"The back-translated sequence files will be written to",mkdrsErr(iFile(DIR_STRAPOUT_TO_DNA)),"Codon usage of ",combo," Backtranslate the selected proteins?"))){
                    final Codonusage usage=backtransCodonUsage(intValueC(combo));
                    if(usage!=null){
                        ROFiP0((ffResult=new File[selPP.length]).length){
                            final byte[]nt=backtranslate(selPP[iP].getResType(),selPP[iP].countRes(),usage,false);
                            ROFi0(nt.length) if(i%3==0) nt[i]&=~32; else nt[i]|=32;
                            ffResult[iP]=wrte(file(iPathExt(DIR_STRAPOUT_TO_DNA,selPP[iP],FSUFFIX_toDNA)),baClr(79).aa('>',selPP[iP],'\n',nt).aln());
                        }
                    }
                }
            }
            break;
        case M_P_CROP:
        case M_P_RENAME:runCR1(RUN_SET_SEQUENCES,addDialogBid(BUT_C1(DialogRenameSeqs)),selPP);break;
        case M_P_EXPORT_DND:ChFrame.frame(0,txtForTitle(q),rsc(RSC_HELP_EXPLAIN_EXPORT_BY_DND)).shw(FRAME_AT_CLICK|FRAME_PACK);break;
        case M_P_CLIPBRD_NAME:sb.joinSpc(selPP);break;
        case M_P_VIEW_BACKBONE:runCR1(RUN_NEW_SIMPLE_3D,_main,selPP);break;
        case M_P_HIDE:strapSetSequenceIsInAlignment(CFALSE*99,selPP);break;
        case M_P_IDX_OFFSET:dialogFirstIdx(DIA_FSTIDX_SHOW,selPP);break;
        case M_P_EDIT_EXONS:
            baLog(LOG_MSG).send();
            if(sze(selPP)==0) baLog(LOG_MSG).a(RED_ERROR).aln(rsc(RSC_MSG_NoSeqSel));
            else{
                final Collection v=new ArrayList();
                for(Protein p:selPP) if(p!=null&& p.hasExons()) _markExonStart(p,p.exons(),v);
                if(sze(v)==0) baLog(LOG_MSG).a(RED_ERROR).aln("No exons and introns in proteins");
                else{
                    strapEvtDispatch(EVT_RESIDUE_SELECTION_ADDED|SEVTMS*111);
                    showInJListCreatedResan(oo(v),null);
                }
            }
            break;
        }
        if(fstNotNull(ffResult)!=null) showInJListCreatedFiles(bid,ffResult,rsc(RSC_HINT_SEQ_FILE_DND_CTXT));
        //shwTxtInW(FRAME_AT_CLICK,txtForTitle(q),pcp(KEY_SOUTH_PANEL,rsc(RSC_HINT_SEQ_FILE_DND_CTXT),new ChJList(JLIST_OPTIONS_FILES|JLIST_DEFAULT_RENDERER, ffResult)));
        if(bid==M_P_LIST_NAME) sobjectsTitle(selPP,sb).aln().joinLns(selPP).a("\n\n");
        int later=0;
        final int maxL=sze(nam(longestName(selPP)));
    loopP:
        FORiP(0,selPP.length){
            final Protein p=selPP[iP];
            final int indent=maxL-sze(s(p));
            switch(bid){
            case M_P_AA_COMPOSITION:
                if(p.countRes()>0){
                    final byte[]aa=p.getResType();
                    ROFt0(2){/*X isAbsolute*/
                        sb.an(' ',indent).a(p).an(' ',3);
                        FOR_C_A_TO_Z(){
                            int count=0;
                            ROFi0(p.countRes()) if((aa[i]&~32)==c) count++;
                            if(t>0) sb.aInt(count,5); else sb.aFloat(100f*count/p.countRes(),3,1);
                            sb.a((char)c);
                        }
                        sb.aln();
                    }
                    sb.aln();
                }
                break;

            case M_P_RESET3D:p.setRotationAndTranslation(null); later=EVT_PROTEIN_3D_MOVED|SEVTMS;break;
            case M_P_EXEC_NAMES:
            case M_P_EXEC_SEQ:
            case M_P_EXEC_GAPPED:{
                if(execPara==null) execPara=new String[selPP.length];
                execPara[iP]=s(bid==M_P_EXEC_NAMES?strplc(0," ","%20",s(p.getFile())):
                               bid==M_P_EXEC_SEQ?new BA(99).aa(p,'\t').a0(bid==M_P_EXEC_SEQ?p.getResType(): p.getGappedSequence(false)):
                               null);
                final Object[]dd=(Object[])_data[DATA_SXM_DialogExecuteOnFile];
                if(dd[bid]==null) dd[bid]=new DialogExecuteOnFile(bid==M_P_EXEC_NAMES?CUSTOM_execSequenceFile:bid==M_P_EXEC_SEQ?CUSTOM_execAminoSeq: CUSTOM_execGappedSeq);
                break;
            }

            case M_P_REPORT_REVCOMPL:{
                if(ffResult==null) ffResult=new File[selPP.length];
                wrte(ffResult[iP]=file(iPathExt(DIR_STRAPOUT_RC,p,FSUFFIX_rc)),new BA(999).aa('>',p,".rc\n",nucReverseComplement(p.getCharSequence(),MAX_INT),"\n\n"));
                break;
            }
            case M_P_READING_FRAME:
                if(iP==0 && selPP.length>6 && !dlgYesNo(plrl(selPP.length,"Edit %N nucleotide sequences?"))) break loopP;
                runCR1(RUN_DIA_DNA_ADD_SEQUENCE,addDialogBid(BUT_C1(DialogEditDna)),p);
                break;
            case M_P_ED_FILE:
                if(iP==0 && selPP.length>1 && !dlgYesNo(plrl(selPP.length,"Edit %N sequences?"))) break loopP;
                editFile(0,p.getFile());
                break;
            case M_P_NEW_RESAN:{
                if(iP==0 && selPP.length>1 && !dlgYesNo(plrl(selPP.length,"Create residue annotations for %N sequences?"))) break loopP;
                final int pos=firstResIdx(p)+(strapCursorProtein()==p?indexOfAminoAcidAtCursorZ(p)+1:10);
                resSelEdit(annotateSeqStyleRgbPosNameGrp(p,SSTYLE_LOWER_HALF,0,new int[]{pos,pos+10},"Unnamed","Groupname"));
                break;
            }
            case M_P_CLOSE_BACKBONE:dispos(p.get3dViews());break;
            case M_P_BALLOON_MSG:{
                if(iP==0 && selPP.length>1 && !dlgYesNo(plrl(selPP.length,"Edit balloon text for %N sequences?"))) break loopP;
                editFile(EDITFILE_CREATE,fileOfProtein(FP_BALLON,p));
                break;
            }
            case M_P_DISSOCIATE_NUCL:p.detach3DStructure(); later=EVT_ATOM_XYZ|SEVTMS;break;
            case M_P_SELECT_SEQFT:
            case M_P_SELECT_RESAN:
            case M_P_SELECT_RESEL:
                for(ResidueSelection s:p.resSel(SOBJECT_RESSEL_AND_RESAN)){
                    final int t=sobjectType(s);
                    if(t==SOBJECT_RESAN && bid==M_P_SELECT_RESAN || t==SOBJECT_RESSEL_AND_RESAN && bid==M_P_SELECT_SEQFT||
                       t==SOBJECT_RESSEL && bid==M_P_SELECT_RESEL){
                        if(IS_SHIFT_EV(ev)) strapSelectedObjectsV().remove(s);
                        else strapSelectedObjectsV().add(s);
                    }
                }
                break;
            case M_P_LIST_XREFS:sb.aa(ANSI_INVERSE,p).aln(ANSI_RESET).aln(p.seqData(SEQ_DATA_OVERVIEW)).delBlanksR().a("\n\n");break;
            case M_P_LIST_SECSTRU:{
                sb.a(p);
                final byte[]ss=p.getResidueSecStrType();
                if(ss==null) sb.an('?',3);
                else{
                    final boolean[]bb=new boolean[ss.length];
@*SARRAY_HELICES_EXTENDED_OTHER
                     HELICES|EXTENDED|OTHER
*@
                    for(int st=p.subsetStart(),s=0;s<3;s++){
                        ROFi0(mini(ss.length-st,p.countRes())) bb[i]="HEC".charAt(s)==ss[i+st];
                        sb.aa("\n  ",iConst(SARRAY_HELICES_EXTENDED_OTHER,s),' ',selectedPositionsToText(0,bb,0,p));
                    }
                    sb.a("\n\n");
                }
                break;
            }
            case M_P_CLIPBRD_FA:sb.a('>').aln(p).aln(p.getResType());break;
            case M_P_ASSOCIATE_NUCL:{
                final int mc=p.mc(P_MC_HETERO_V);
                final Protein[]nn=p.getMolecules(CHAINTYPE_NUC);
                nextH:
                for(Protein n:readAddToPep(null,readPepOrNuc(PROTPARS_AS_DNA_OR_RNA,null,p.getFile()))){
                    for(Protein n2:nn) if(eqStr(n2.getChain(),n.getChain())) continue nextH;
                    addToProt(n,p);
                }
                if(mc!=p.mc(P_MC_HETERO_V)){
                    sb.aln(p);
                    strapEvtDispatch(EVT_SEQUENCE_ICON|SEVTMS);
                }
                break;
            }
            case M_P_MFA_NOGAP:sb.aa('>',p,'\n').aFold(60,p.getResType(),0,strLen(p.getResType())).a1('\n').aln();break;
            case M_P_LIST_ID:
                sb.an(' ',indent).a(p).and(" "+ANSI_FG_BLUE+"pdb"+ANSI_RESET+" = ",p.getPdbID(PDBID_ID));
                FORt(0,REFS_ZZZ){
@*SARRAYeq_REFS_BY_IDENT_REFS_OTHER
                     By Identity=REFS_BY_IDENT Accession=0 Refs=REFS_OTHER
*@
                    sb.aa("  "+ANSI_FG_BLUE,iConst(SARRAYeq_REFS_BY_IDENT_REFS_OTHER,t)," "+ANSI_RESET+"[ ");
                    for(String s:p.getRefs(REFS_BY_IDENT)){
                        String swiss=(String)MAP_UniProt2Swiss.get(s);
                        if(swiss!=null&&swiss.startsWith(s)) {s=swiss; swiss=null;}
                        sb.a(s).and(" +",derefZ(p.refSeqOffset(false,s),Integer.class)).and("=",swiss).a("  ");
                    }
                    sb.del(' ').a(']');
                }
                sb.a("\n\n");
                break;
            case M_P_LIST_HEADER:sb.aa('>',p,'\n',p.getProperty(P_COMPOUND)).a("\n\n");break;
            case M_P_CMPLX_LIST_PARTS:sb.an(' ',indent).aa(p,' ').joinSpc(p.getProteinsSameComplex()).aln("\n");break;
            case M_P_REPORT_CODING:{
                final byte[]bb=p.triplets();
                if(bb!=null){
                    for(int i=0,i3=0;i<bb.length;i++){
                        if(i3==0) bb[i]&=~32; else bb[i]|=32;
                        if(++i3==3) i3=0;
                    }
                    sb.aln(p).aFold(50,bb,0,strLen(bb)).a("\n\n");
                }
                break;
            }
            case ACTION_COLOR_CHANGED:
                if(getColrO(q)!=null){
                    setColrO(getColrO(q),p);
                    later=EVT_SEQUENCE_ICON|SEVTMS;
                }
            }
        }
        strapEvtDispatch(later);
/* 00000000000000000000000000000000000000000000 */
    }/*X CHAINTYPE_PEP*/
    if(sze(sb)>0){
        if(bid==M_P_CLIPBRD_FA||bid==M_P_CLIPBRD_NAME||bid==M_SEL_CLIPBRD_FROM_TO||bid==M_SEL_CLIPBRD_NAME||bid==M_SEL_CLIPBRD_RESN||bid==M_SEL_CLIPBRD_SEQU) toClpbd(sb);
        else{
            if(M_TA[bid]==null){
                M_TA[bid]=bid==M_P_LIST_XREFS||bid==M_P_LIST_ID?new ChTextView(new BA(999)):new ChTextArea("");
#if CPP_DEACTIVATED
                if(bid==M_P_REPORT_CODING||bid==M_P_REPORT_REVCOMPL||bid==M_P_BACKTRANSLATE) pcp(KOPT_CONTAINS_NT,"",M_TA[bid]);
#endif //CPP_DEACTIVATED
            }
            if(M_TA[bid] instanceof ChTextArea) ((ChTextArea)M_TA[bid]).a(sb);
            else ((ChTextView)M_TA[bid]).ba(true).a(sb);
            shwTxtInW(orS(iConst(SARRAYeq_TITLE_FOR_BID,bid),txtForTitle(q)),
                      pcp(KEY_SOUTH_PANEL,
                          pnl(wrte(iFile(bid==M_P_MFA_NOGAP?FSUFFIX_fasta:FSUFFIX_txt),sb.and(iConst(SARRAYeq_TEXT0_FOR_BID,bid),"\n\n").a1('\n'))),
                          highlightSeqsInTA(0,M_TA[bid])));
        }

    }
    if(bid==M_X_LIST) showInJList(SHOWINJLIST_IN_JFRAME,selXX,new BA(99).aa(iConst(SARRAYeq_STRAP_OBJECT_TITLE,mID),' ',++_sxmCountJList),null);
    if(execPara!=null) runCR1(RUN_APPS_SHOW,iThEl(bid,_data[DATA_SXM_DialogExecuteOnFile]),execPara);
 }
#undef ev
if(mID==SOBJECT_V3D){/*X  RRRRRRRRRR ContextMenu V3D RRRRRRRRRR */
    switch(id){
        CASE_ARGV(_RUN_SET_V3D) v3dSetPV(V3D_FOCUSED,v3dGetPV(V3D_FOCUSED));BREAK;
        CASE_ARGV(RUN_GET_MENUBAR){
            final View3d vv[]=(View3d[])co._v(SOBJECT_V3D).asArray(),pv=vv.length==1?vv[0]:null;
            RETURN!v3dIsActive(pv)?null: _data[DATA_SXM_GENERIC_MB]==null?_data[DATA_SXM_GENERIC_MB]=toMenuBar(0,sxmV3dGeneric(true),null): _data[DATA_SXM_GENERIC_MB];
        }
    }
    if(mcSel!=modic(strapSelectedObjectsV())) strapEvtDispatch(EVT_OBJECTS_SELECTED|SEVTMS);
 }
