package charite.christo.strap;
import charite.christo.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
import org.biojava.bio.structure.*;
import org.biojava.bio.structure.align.ce.*;
import org.biojava.bio.structure.align.model.AFPChain;
@*H
 <BR><B>Publication:</B> PUBMED:11125099 PUBMED:9796821

 This is the Java based implementation of CE/CL superposition.
 Ported from C++ to Java by Andreas Prlic.
*@
#if 0
/*
  java test.biojava3.TestStructure

  http://biojava.org/wiki/CVS_to_SVN_Migration
  svn co svn://code.open-bio.org/biojava/biojava-live/trunk biojava-live

  export BIOJAVA_LIVE=/local/java/bioinf/biojava-live
  export JAR=~/.StrapAlign/jars/Structure_biojava.jar
  rm $JAR $JAR.pack.gz
  rm -r tmpClasses
  mkdir tmpClasses
  CP=$(echo $BIOJAVA_LIVE/[a-z]*[a-z]/src/main/java| tr ' ' ':')
  javac -cp $CP -O -source 1.5 -target 1.5  $BIOJAVA_LIVE/structure/src/main/java/demo/DemoCE.java -d tmpClasses

  pushd tmpClasses
  jar -cf $JAR org
  popd

  pack200 $JAR.pack.gz $JAR

  scp  $JAR.pack.gz $STRAP_DIR_B/otherPackages
  scp  $JAR.pack.gz $STRAP_DIR_B/lite

  #java demo.DemoCE

  zip -0 -r
*/
#endif //0
public class Superimpose_CE_ChRunnable implements ChRunnable{
    static{
/*Provoke_ClassNotFoundException*/
        @SuppressWarnings("unused")Class xUnused=StructureImpl.class;
    }
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARG(RUN_COMPUTE,Object,pp){
                final Protein pR=iThProt(0,pp),pM=iThProt(1,pp);
                AFPChain afpChain=null;
                {
                    try{
                        afpChain=new CeMain().align(StructureTools.getAtomCAArray(toBiojavaStructureCA(pR,null)),
                                                    StructureTools.getAtomCAArray(toBiojavaStructureCA(pM,null)),
                                                    new CeParameters());
                    }catch(Throwable ex){return ex;}
                }
                final double[]r[]=afpChain.getBlockRotationMatrix()[0].getArray(),translation=afpChain.getBlockShiftVector()[0].getCoords();
                final Matrix3D m3d=new Matrix3D(r[0][0],r[1][0],r[2][0],translation[0],
                                                r[0][1],r[1][1],r[2][1],translation[1],
                                                r[0][2],r[1][2],r[2][2],translation[2]);
                final byte[][]gg=SequenceAlignerImpl.insertWhereNoCoordinates(afpChain.getAlnbeg1(),
                                                                              toByts(afpChain.getAlnseq1()),afpChain.getAlnbeg2(),
                                                                              toByts(afpChain.getAlnseq2()),pR,pM);
                final TYPE_ALIGN_RESULT result=new Object[ALIGNRESULT_ZZZ];
                result[ALIGNRESULT_GAPPED]=gg;
                result[ALIGNRESULT_MATRIX]=m3d;
                result[ALIGNRESULT_RMSD]=meinFloatObject((float)afpChain.getChainRmsd());
                result[ALIGNRESULT_SCORE]=meinFloatObject((float)afpChain.getProbability());
                RETURN result;
            }
        }
        return null;
    }
    private static StructureImpl toBiojavaStructureCA(Protein p,boolean[]selectedAminos){
        final float[]xyz=p.getResidueCalphaXYZ(null);
        final byte[]rr=p.getResType();
        StructureImpl s=null;
        final BA baTmp=new BA(99);
        final String key=toStrgIntrn(clr(baTmp).a("$$CE$$").boolToText(selectedAminos).aa('_',p.mc(P_MC_CALPHA)));
        synchronized(SYNC_SuperimposeCE){
            s=(StructureImpl)gcp(key,p);
        }
        if(s==null){
            final Chain[]chains={new ChainImpl()};
            for(int a=0,i3=3*p.subsetStart(),iMax=mini(p.subsetEnd()-p.subsetStart(),xyz.length/3-p.subsetStart());a<iMax; a++,i3+=3){
                if(selectedAminos!=null && !(selectedAminos.length>a && selectedAminos[a])) continue;
                if(!Float.isNaN(xyz[i3])){
                    final AminoAcidImpl amino=new AminoAcidImpl();
                    try{
                        amino.setPDBName(clr(baTmp).aBytesAdj(toThreeLetterCode(rr[a]),3).toString());
                    }catch(Throwable ex){stckTrc(125,ex);}
                    final Atom ca=new AtomImpl();
                    ca.setCoords(new double[]{xyz[i3],xyz[i3+1],xyz[i3+2]});
                    ca.setPDBserial(a);
                    ca.setName("CA");
                    amino.addAtom(ca);
                    amino.setAminoType(new Character((char)rr[a]));
                    chains[0].addGroup(amino);
                }
            }
            (s=new StructureImpl()).addModel(java.util.Arrays.asList(chains));
            synchronized(SYNC_SuperimposeCE){
                pcp(key,newSoftRef(s),p);
            }
        }
        return s;
    }
}
