package charite.christo.strap;
import charite.christo.*;
import static charite.christo.strap.Strap.*;
import static charite.christo.ChUtils.*;
#define THIS_CLASS(a) BUT_C_##ValueOfImpl##_##a
#define tmp() baClr(82)
@*H THIS_CLASS(VALUE_COUNT_RESIDUES)
 This class counts the amino acids in a protein.
*@
@*H THIS_CLASS(VALUE_SOLVENT_ACCESS)
 The solvent accessibility. Requires the program mkdssp in the execution path.
*@

// SDialogs_DIA_PLOT_Inc SDialogs_TAB_PLOT_Inc
// /home/c/strapSrc/src/noGui/charite/christo/strap/cpp_java_rsc_strap.h :68:#define DIA_BAR_CHART 17
// UpdateEnumerations_mkButtonsListTiti_Inc.java
// CompileEverything AbstractValueOfResidue PredictionFromSequenceImpl SARRAYeq_IMPLEMENTATIONS_FOR_INTERFACE

//BUT_C1(FastaParser) BUT_C1(CIFParser) BUT_C1(PDBParser) BUT_C1(Strap) BUT_C1(SwissprotParser) BUT_C1(DSSP_Parser) BUT_C1(SBD_Parser) BUT_C1(XML_SequenceParser)
/* (NUM1 0) */
#define _ctrl _oo[0]
#define _color _oo[1]
#define _pp _oo[2]
#define _p _oo[3]
#define _native _oo[4]
#define _fileAsObject _oo[5]
#define _fileMsg _oo[6]
#define _entropyFrequ _oo[7]
#define _OO_ZZZ 8
#define _file ((java.io.File)_fileAsObject)
/* (NUM1 0) */
#define _mc _ii[0]
#define _mcQ _ii[1]
#define _disposed _ii[2]
/* (NUM1 3) */
#define _hydrophobWindow _ii[3]
/* (NUM1 3) */
#define _fileDataset _ii[3]
#define _fileStarted _ii[4]
#define _fileLM _ii[5]
#define _II_ZZZ 7
/* (NUM1 3) */
#define _entropyGapMode _ii[3]

public class ValueOfImpl implements HasMC,ChRunnable,ValueOfAlignPosition,ValueOfResidue,ValueOfProtein{
    private final int _it,_ii[]=new int[_II_ZZZ];
    private double[]_v;
    REFLECTION_PUBLIC ValueOfImpl(int it){_it=it;}
    final Object[]_oo=new Object[_OO_ZZZ];

#include "ValueOfImpl_AlignmentEntropy_Inc.java"
    CPP_RUN_ID_ARG(){
#define ev arg
#define bid evtBid(ev)
        if(id==RUN_M_actionPerformed||id==RUN_M_stateChanged){
            final Object q=evtSrc(ev);
            if(_it==VALUE_TEXTFILE || _it==VALUE_HYDROPHOBICITY){
                if(_it==VALUE_TEXTFILE){
                    if(bid==SBUTS_RESVALUE_FROM_FILE_EDIT) editFile(0,_file);
                    if(q instanceof ChJCombo) _fileDataset=getSlctIdx(q);
                    _fileAsObject=null;
                }
                if(_it==VALUE_HYDROPHOBICITY){
                    if(q instanceof ChJCombo) _hydrophobScale=getSlctIdx(q);
                    if(q instanceof ChJSlider) _hydrophobWindow=intValueC(q);
                }
                _v=null;
                _mcQ++;
                strapEvtDispatch(EVT_VALUE_OF_ALIGN_POSITION|SEVTMS*111);
            }
            if(_it==VALUE_ENTROPY){
                if(q==_entropyCombo){
                    _entropyGapMode=getSlctIdx(q);
                    _mcQ++;
                }
                strapEvtDispatch(EVT_VALUE_OF_ALIGN_POSITION|SEVTMS*111);
            }
        }
#undef ev
        switch(id){
            CASE_ARGV(RUN_RESET) _v=null; _mcQ++;break;
            CASE_ARGV(RUN_GET_INSTANCE_TYPE) return io(_it);
            CASE_ARGV(RUN_DISPOSE) _disposed=CTRUE;return TRUEr;
            CASE_ARG(RUN_SET_SEQUENCES,Protein[],pp){
                if(_it==VALUE_ENTROPY){
                    _pp=pp;
                    _v=null;
                    strapEvtDispatch(EVT_VALUE_OF_ALIGN_POSITION|SEVTMS*111);
                    return TRUEr;
                }
                BREAK;
            }
            CASE_ARG(RUN_SET_PROTEIN,CPP_AS_OBJECT(Protein),p){
                if(_it==VALUE_HYDROPHOBICITY||_it==VALUE_COUNT_RESIDUES||_it==VALUE_SOLVENT_ACCESS||_it==VALUE_TEXTFILE){
                    if(_p!=p){
                        _v=null;
                        _p=p;
                        _fileAsObject=null;
                        strapEvtDispatch(EVT_VALUE_OF_ALIGN_POSITION);
                        return TRUEr;
                    }
                }
                BREAK;
            }
            CASE_ARGV(RUN_GET_SEQUENCES) return _pp;
            CASE_ARGV(RUN_GET_PROTEIN) return _p;
/* Ctrl */
            //CASE_ARG(RUN_SET_SHARED_INSTANCE,Object,o) _shared=o;BREAK;
            //CASE_ARGV(RUN_GET_SHARED_INSTANCE) return _shared;
            CASE_ARG(RUN_GET_SHARED_CTRL_PNL,Object,supported){
                if(_it==VALUE_HYDROPHOBICITY){
                    if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                    if(_ctrl==null){
                        final ChJSlider sl=new ChJSlider(CHJSLIDER_ValueOfImpl_HYDROPHOB_WINDOW,this);
                        _ctrl=pnl(VB,"Window size (default is 9) ",setPrefSze(EM*60,prefH(sl),sl)," ","Hydrophobicity scale ",new ChJCombo(arry(SARRAYeq_Hydrophobicity_SCALES),this));
                    }
                }
                if(_it==VALUE_ENTROPY){
                    if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                    if(_ctrl==null) _ctrl=pnl(HBL,"How should gaps be treated ?",_entropyCombo=new ChJCombo(arry(SARRAYeq_AENTROPY_GAP_MODE),this));
                }
                RETURN(_ctrl);
            }
            CASE_ARGV(RUN_GET_COLOR){
                return _color;
            }
            CASE_ARG(RUN_SET_COLOR,Object,color){
                _color=color; RETURN(TRUEr);
            }
            CASE_ARGV(RUN_GET_NATIVE_EXE){
                return _native;
            }
/* Impl Specific */
            CASE_ARG(RUN_AENTROPY_SET_GAPMODE,Object,intObj){
                _entropyGapMode=xatoi(intObj);
                BREAK;
            }
            CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
                if(_it==VALUE_ENTROPY && evtType[0]==EVT_ALIGNMENT) strapEvtDispatch(EVT_VALUE_OF_ALIGN_POSITION|SEVTMS*111);
                RETURN TRUEr;
            }
        }
        if(_it==VALUE_TEXTFILE){
#include "ValueOfImpl_ResidueValuesTextfile_Inc.java"
        }
        return null;
    }
    OVERRIDE_PUBLIC int mc(){return maxi(_mc,_mcQ);}
    OVERRIDE_PUBLIC double[]getValues(){
        if(_it==VALUE_ENTROPY){
            final Protein[]pp=spp(this);
            return fstNotNull(pp)==null?null:_entropyValues(pp);
        }
        final Protein p=sp(this);
        if(p==null) return null;
        if(_it==VALUE_HYDROPHOBICITY){
#include "ValueOfImpl_Hydrophobicity_Inc.java"
            return _v;
        }
        if(_it==VALUE_HYDROPHOBICITY_TOPPRED){
            if(_native==null) _native=mkInstanceBid(BUT_C1(TM_Helix_Toppred_for_hydrophobicity));
            if(DIFF_MC(_mc,_mcQ+p.mc(P_MC_RES_TYPE)) || _v==null) _v=(double[])runCR1(_RUN_GET_TOPPRED_HYDROPHOBICITY,_native,p.getResType());
            return _v;
        }
        if(_it==VALUE_SOLVENT_ACCESS){
            if(_v==null || _mc!=p.mc(P_MC_ACCESSIBILITY)){
                final float[]ac=p.getResidueAccessibility1(RESIDUE_ACCESSIBILITY_COMPUTE);
                if(ac==null)_v=NO_double;
                else{
                    final int s=p.subsetStart();
                    _mc=p.mc(P_MC_ACCESSIBILITY);
                    double[]vv=redim(_v,p.subsetEnd()-s,99);
                    ROFi0(p.subsetEnd()-s) vv[i]=i+s<ac.length?ac[i+s]:Double.NaN;
                    _v=vv;
                }
            }
            return _v;
        }
        if(_it==VALUE_TEXTFILE)return (double[])runCR1(_RUN_VALUE_IMPL_VALUES,this,p);
        return null;
    }
    OVERRIDE_PUBLIC double getValueOfProtein(int opt,Protein p){
        if(p!=null&&_it==VALUE_COUNT_RESIDUES) return p.countRes();
        return Double.NaN;
    }
    private int _hydrophobScale=KYTE_DOOLITTLE;
}
#undef THIS_CLASS
#undef tmp
