@*H THIS_CLASS(VALUE_ENTROPY)
 A profile of the sequence variability of the multiple sequence alignment is displayed.
 The variability is calculated with the formula by Shannon.
 Gaps are treated as a 21th amino acid.
*@
@*SARRAYeq_AENTROPY_GAP_MODE
 Skip alignment columns with gaps=AENTROPY_SKIP_GAPS
 A gap is the 21st amino acid=AENTROPY_GAP_IS_21TH_AMINO_ACID
 A gap is a different amino acid=AENTROPY_GAP_IS_A_DIFFERENT_AMINO_ACID
*@
#define _entropyCombo _X[81]
private double[]_entropyValues(Protein[]pp){
    int mc=_mcQ;
    for(Protein p:pp) mc+=p.mc(P_MC_GAPPED_SEQ);
    if(DIFF_MC(_mc,mc)||_v==null){
        final int posMax=maxColumn(pp);
        final double entropyMax=Math.log(pp.length)*pp.length,entropy[]=new double[posMax+1];
        int[]freq=(int[])_entropyFrequ;

        if(freq==null) _entropyFrequ=freq=new int['Z'+1];
        FORi(0,posMax){
            java.util.Arrays.fill(freq,0);
            FORiP(0,pp.length){
                final int iA=pp[iP].columnToIndex(0,i),c=iA<0?32:(byte)(pp[iP].getResTypeAt(iA)&~32);
                if(c<='Z') ++freq[c];
            }
            int insgesamt=0;
            FOR_C_A_TO_Z() insgesamt+=freq[c];
            double entro=0;
            if(insgesamt>0){
                FOR_C_A_TO_Z()
                    if(freq[c]>0 && (_entropyGapMode==AENTROPY_GAP_IS_21TH_AMINO_ACID || c!=' ')){
                        final double p=freq[c]/(double)insgesamt;
                        entro-=p*Math.log(p);
                    }
/* A gap is like a new amino acid occurring once */
                if(_entropyGapMode==AENTROPY_GAP_IS_A_DIFFERENT_AMINO_ACID && freq[' ']>0){
                    final double p=1f/insgesamt;
                    entro-=freq[' ']*p*Math.log(p);
                }
            }
            if(_entropyGapMode==AENTROPY_SKIP_GAPS && freq[' ']>0) entropy[i]=Double.NaN;
            else entropy[i]=entro/entropyMax;
        }
        _v=entropy;
    }
    return _v;
}
