@*H THIS_CLASS(VALUE_HYDROPHOBICITY)
 http://gchelpdesk.ualberta.ca/servers/HydrophobicityProfiler/HydrophobicityProfiler.php
*@
/* Translated from http://gchelpdesk.ualberta.ca/servers/HydrophobicityProfiler/HydrophobicityProfiler.php */
/* http://www.biologie.uni-hamburg.de/b-online/library/genomeweb/GenomeWeb/prot-transmembrane.html */
/* Related links: Description of hydrophobicity scales: http://www.clcbio.com/index.php?id=43 */
/* (NUM1 0) */
#define KYTE_DOOLITTLE 0
#define HOPP_WOODS 1
#define JANIN 2
#define ROSE 3
#define EISENBERG 4
#define ENGELMAN 5
#define CORNETTE 6
#define METHODS 7
@*SARRAYeq_Hydrophobicity_SCALES
 Kyte-Doolittle=KYTE_DOOLITTLE Hopp-Woods=HOPP_WOODS Janin=JANIN Rose=ROSE Eisenberg=EISENBERG Cornette=CORNETTE Engelman=ENGELMAN
*@
@*SARRAYeq_Hydrophobicity_Data
 180 0 250 -350 -350 280 -40 -320 450 0 -390 380 190 -350 0 -160 -350 -450 -80 -70 0 419 -90 0 -130 0=KYTE_DOOLITTLE
 -50 0 -100 300 300 -250 0 -50 -180 0 300 -180 -130 20 0 0 20 300 30 -40 0 -150 -340 0 -230 0=HOPP_WOODS
 30 0 90 -60 -70 50 30 -10 70 0 -180 50 40 -50 0 -30 -70 -140 -10 -20 0 60 30 0 -40 0=JANIN
 74 0 91 62 62 88 72 78 88 0 52 85 85 63 0 64 62 64 66 70 0 86 85 0 76 0=ROSE
 62 0 29 -90 -74 119 48 -40 138 0 -150 105 64 -78 0 12 -85 -253 -18 -5 0 108 81 0 26 0=EISENBERG
 160 0 200 -920 -820 370 100 -300 310 0 -880 280 340 -480 0 -20 -410 -1230 60 120 0 260 190 0 -70 0=ENGELMAN
 20 0 410 -310 -180 440 0 50 480 0 -310 570 419 -50 0 -220 -280 140 -50 -190 0 469 100 0 320 0=CORNETTE
*@
final byte[]seq=p.getResType();
if(_v==null||  DIFF_MC(_mc,_mcQ+_mc+p.mc(P_MC_RES_TYPE))){
    final double[]dd=_v=new double[p.countRes()];
    if(_hydrophobWindow==0)_hydrophobWindow=HYDROPHOB_WINDOW_INIT;
    final int scale[]=intArrys(SARRAYeq_Hydrophobicity_Data)[_hydrophobScale],w2=(_hydrophobWindow+1)/2;
    ROFi0(dd.length){
        final int to=mini(dd.length,i+w2+1);
        int sum=0;
        FORj(maxi(i-w2,0),to) sum+=iThIntOr((seq[j]|32)-'a',scale,0);
        dd[i]=sum/(double)(w2*2);
    }
 }

#undef CORNETTE
#undef EISENBERG
#undef ENGELMAN
#undef HOPP_WOODS
#undef JANIN
//#undef KYTE_DOOLITTLE
#undef METHODS
#undef ROSE
