@*H THIS_CLASS(VALUE_TEXTFILE)
 A plain text file containing floating point numbers separated by space or comma must be provided by the user.
 Strap reads these numbers and assigns them to the residues of the protein.
 The decimal point is a dot.  Undefined values
 should be coded as NaN ("Not A Number").
*@
// ValueOfImpl

/* <<< getValues <<< */
/* ---------------------------------------- */
/* >>> Threading >>> */
    if(_fileMsg==null) _fileMsg=new BA(99);
    switch(id){
        CASE_ARG(_RUN_VALUE_IMPL_VALUES,Protein,p){
            if(_fileStarted++==0) thrdCR(RUN_VALUE_TEXTFILE_LOOP|THRDCR_START,this);
            if(_fileAsObject==null) _fileAsObject=file(tmp().aa("residueData/",_p,'.',_fileDataset));
            if(sze(_fileAsObject)==0){
                _v=null;
                if(_fileDataset==0){
                    final BA sb=tmp();
                    FORi(0,50)sb.aa("0.",i%10).aln();
                    wrte(_file,sb);
                }
            }
            if(DIFF_MC(_fileLM,(int)(_file.lastModified()-TIME_MS_2019))||_v==null){
                _mc++;
                final double[]vv=_v=new double[p.countRes()];
                final ChTokenizer tok=new ChTokenizer(SPC).setText(readBytes(_fileAsObject));
                FORi(0,vv.length) vv[i]=tok.nextToken()?tok.asFloat():Double.NaN;

            }
            if(clr((BA)_fileMsg).aFile(_fileAsObject).mc()!=_mcQ){
                _mcQ=((BA)_fileMsg).mc();
                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_ctrl);
            }
            RETURN(_v);

        }
        CASE_ARGV(RUN_VALUE_TEXTFILE_LOOP){
            while(_disposed!=CTRUE){
                sleepMS(111);
                if(_fileAsObject!=null && DIFF_MC(_fileLM,(int)(_file.lastModified()-TIME_MS_2019))){
                    _v=null;
                    strapEvtDispatch(EVT_VALUE_OF_ALIGN_POSITION);
                }
            }
            break;
        }
        CASE_ARG(RUN_GET_CTRL_PNL,Object,supported){
            if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
            if(_ctrl==null) {
                final String ss[]=new String[12];
                ROFi0(12) ss[i]=s(i);
                _ctrl=pnl(CNSEW,setBG(DEFAULT_BACKGROUND,new ChTextView(_fileMsg)),pnl("dataset: ",new ChJCombo(ss,this)," ",newBut(SBUTS_RESVALUE_FROM_FILE_EDIT,this)));
            }

            return _ctrl;
        }
    }
