@*~RSC_SCRIPT_COMMANDS
url_alias alias1=url1 alias2=url2 ...
 H Aliases for URLs to be used in balloon texts for sequences and annotations
 E alias_for_url WIKTIONARY:=http://en.wiktionary.org/wiki/
 E balloon WIKTIONARY:happy, sequence

feature_colors name=color1,color2 name=color
 E feature_colors Modified_residue=#FF2222,#FF0000 Phosphorylated_residue=#AAaa00 Glycosylated_residue=#00ffFF
 H Assignment of colors to sequence feature names.
 H The first color is for black background and the other optional color is for white paper.
 H All residue selections with one of those names will be treated as sequence features.

new_selection  residues, sequencName/selectionName
 E new_selection 1-20, my_protein/N-terminus
 E new_selection 10:-20: 30:, my_protein/a_selection
 H A residue selection for the given sequence is created.
 H The name of the selection is given after the slash.
 H The residue subset can use the natural numbering starting at 1 or the PDB resn.
 H The PDB resn is recognized by the colon according to the Rasmol convention.

new_nucleotide_selection nucleotides, rotein/selectionName
 H Same syntax as new_selection.
 H Positions refer to the nucleotide sequence that the protein was translated from.

set_alignment_type_N
 H The alignment type is explicitely set to nucleotide sequence alignment
 H This affects following "nt_sequence" commands such that the coding sequence is not translated.

set_alignment_type_CN
 H The alignment type is explicitely set to coding nucleotide sequences

set_alignment_type_P
 H The alignment type is explicitely set to amino acid sequence alignment. "P" stands for peptide.



set_alignment_type_P
 H See set_alignment_type_N


3D_native viewer-type [jmol|astex|pymol] , 3D-command
 E 3D_native jmol, 3D_label "This label appears only under Jmol"
 E 3D_native astex, 3D_label "This label appears only under Astex"
 H The command is send only under the condition, that the current 3D view is of the given type.
 H This allows for native commands that are spicific to certain viewer types but not understood in other 3D-viewers.

echo bla bla bla
 H The text is printed to standard output (console) or to a file specified with -scriptOutput=filePath
 E echo Hello world

print_sequences
 H Prints a list of all sequences to standard output (console) or to a file specified with -scriptOutput=filePath

print_selections sequences
 H Prints a list of all residue selections of the sequences

print_3D_transformation proteins
 H Prints the 3x3 rotation matrix and translation vector of the given proteins.
 H

superimpose proteins
 H Superimposes the proteins. The reference protein is the one that is most similar to all others
 E superimpose *

align sequences
 H Aligns the sequences
 E align *



uniprot_features proteins
 H Loads the GFF files and underlines the sequence features.
 H The UniProt ID may be defined in the sequence file.
 H It can be searched automatically (find_uniprot_id) or set explicitely (accession_id)
 E find_uniprot_id *
 E uniprot_features *
 H Also see DAS_features and GFF

GFF file_or_GFF-line
 H Loads the GFF files and underlines the sequence features
 H Fields: 1=Sequence  3=Name 4=Start-Position 5=End-Position 9=Attributes
 H The fields are separated by tabulator character or vertical bar.
 H A dot marks empty content.
 E GFF P25787	UniProtKB	Modified residue	24	24	.	.	.	Note=Phosphotyrosine
 E GFF http://server/path/myGffFile.gff
 H Also see DAS_features


load list of URLs or database IDs or absolute file paths
 H The sequences are loaded

aa_sequence amino acid sequence, sequence name
 H Defines a protein by amino acid sequence. The sequence may have gaps "-".
 E aa_sequence -VLSAAERAQVKAAWGKI--QAGAHGAEALERMFLGFPTTKTYPF, Xenopus


nt_sequence [coding] nucleotide sequence, sequence name
 H Defines a nucleotide sequence. Syntax like aa_sequence.
 H Only if the alignment type has been specified with either command set_alignment_type_N or set_alignment_type_CN, the sequence is not translated to amino acids.



balloon_text Text, list of sequences and residue selections
 H Defines the mouse-over text
 H HTML code is assumed, if lower case tags are found.
 H In this case greater-than, less-then and ampersand characters need to be HTML encoded.
 E balloon_text bla bla, sequence1

set_taxonomy, list of sequences
 H The taxonomy data is assigned to the given sequences.
 H It is umportant for taxonomy_group commands which create respective sequence groups.
 E Eukaryota;Metazoa;Craniata;Vertebrata;Euteleostomi;Mammalia;Primates;Hominidae;Homo,  sequences1
 E taxonomy_group Primates, *

taxonomy_group list of groups, list of sequences
 H Defines sequence groups according to taxonomy.
 H They can be used in the menu "Sequence groups" of the HTML output.
 E taxonomy_group Vertebrata Viruses Eukaryota Bacteria Archaea Fungi Mammalia, *
 H Also see sequence_group

sequence_group NameOfGroup, list of sequences
  H Defines sequence groups.
  H They can be used in the menu "Sequence groups" of the HTML output.
  E sequence_group Alpha, HBA.*
  E sequence_group Beta,  HBB.*
  H Also see taxonomy_group

secondary_structure character-sequence, protein
 E secondary_structure ---HHHHHH---HHHHH---EEEEEEEEEE----EEEEEE, Xenopus

set_residue_index_offset number, sequence
 H Change the numbering of residues

set_nucleotide_index_offset number, protein
 H Change the numbering of coding nucleotides in an amino acid sequence
 H A positive value shifts all nucleotide selections to the left

clip_N_term sequence-slash-position
 H The entire alignment is truncated left at the specified position.
 H If slash and position number are omitted, the first residue of that sequence is used.
 H Residue selections can be given by name.
 H If more than one object is specified, then the most left one is used.
 E clip_N_term sequence1/100
 E clip_N_term sequence1/nameOfResidueSelection
 E clip_N_term sequence1

clip_C_term sequence-slash-position
 H See clip_N_term

set_ruler_secondary_structure theProtein
 H The protein should have secondary structure information.
 H A ruler is drawn above or below the alignment.
 H Helices are red and beta sheets are yellow.

set_conservation_threshold number
 H Number is in the range of -100 to 100. Positive numbers the threshold in percent up from where conserved residues are emphasized. Negative numbers define the minimal diversity.
 E set_conservation_threshold 70

let $variable=Text which may contain white space and any printable ASCII character
 H Variable declaration similar as in programming languages like BASIC.
 H Quotes are not required.
 E let $x=protein/selection
 E new_selection 20-30, $x
 E color #00ff00, $x

set_characters_per_line number
 H Number of letters per line for non-interactive mode with command line export options -toHTML, -toClustal and -toMSF.
 E set_characters_per_line 60

set_color hash-sign-hex-rgb, sequences or residue selections
 H The color of residue selections or sequences can be changed.
 H The color of a protein is used for the rendered 3D view.
 H If the color has 8 instead of 6 hexadecimal digits, the last two digits are the transparency.
 E color #00FF00, sequence1
 E color #00FF0066, sequence1

set_color_mode color-type
 H Residue colors.
 H white|black|charge|hydropathy|chemical|nucleotide|zappo|taylor
 E set_color_mode hydropathy

bg_color  residue-set=hex-color residue-set=hex-color, sequence
 H The color of individual residues is set.
 H PDB residue numbers can be refered to by appending a colon to the position number.
 E bg_color 20-30=#00FF00, sequence1
 E bg_color 20:-30:=#00FF00, sequence2


open_3D  ViewID, protein1 protein2 ...
 H The given proteins are opened in a 3D-viewer.
 H ViewID is an identifier which allows this view to be refered to by the commands select_3D and close_3D.

add_compound hetero-compound or nucleotide-chain, protein1 protein2
 E add_compound  PDB:1gd2_A PDB:1gd2_B, 1gd2_E.pdb
 H Hetero-compounds or nucleotide chains are added.
 H For HTML output only nucleotide chains of the same PDB id are regarded.

use_aligner t_coffee
 H Set t_coffee as the default aligner. Possible arguments: clustalw, t_coffee, amap, clustalw, dialign, dialignt, kalign, mafft, muscle, probcons2

use_aligner3D mapsci
 H Set mapsci as the default aligner. Possible arguments: ce, mapsci, matt, mustang, native_ce, smolign, tm_align


use_aligner_p t_coffee
 H Set t_coffee as the default aligner allowing profiles. Possible arguments: clustalw, t_coffee


accession_id id, sequence
 E accession_id UNIPROT:HSLV_ECOLI, hslv_ecoli
 H The accession ID for a sequence is set.
 H Providing the accession ID allows direct access to BioDAS services.

add_annotation attribut=value, selection_name
 H An entry consisting of a key such as "Remark" or "Balloon" and a value such as a free text is added to the named selection.
 H Only the following attributes are supported for the HTML-output:
 H  - Balloon (Free text or HTML),
 H  - Color (e.g. #FF0000),
 H  - Style (UNDERLINE or BACKGROUND),
 H  - 3D_view (A 3D-command), Atoms (dot - PDB atom name like .CA or .CB or .N)
 H          .CA.CB  means C-alpha or C-beta.
 H          .C* means means any Carbon.
 E add_annotation Balloon=My text, myProtein.pdb/myAnnotation1,
 E add_annotation Balloon="<HTML><BODY>My text with <B>bold</B> or <U>underline</U></BODY></HTML>", myProtein.pdb/myAnnotation1,

set_annotation key=value, selection_name
 H like add_annotation but already existing entries with this key are deleted.

remove_xref reference, sequence

add_xref reference, sequence
 H Adding a sequence ID for that sequence.
 H While a sequence has only one accession ID, it can have several cross references e.g. from the RefSeq, UniProt and PDB.
 E add_xref PDB:1NED, hslv_ecoli

translate_cds coding sequence expression, myProtein
 E cds join(10 20..30), protein
 E cds complement(join(10 20..30)), myProtein
 E cds 1.., myProtein
 E cds 2, myProtein
 H The protein myProtein is given as a genomic sequence.
 H This command specifies, how the DNA is translated into protein.
 H Either it takes a CDS expression (which is recognized by the dot dot)
 H or a number or range of numbers which refer to the n-th CDS expression[s] in the Embl or GB file.

close sequence1 sequence2 ...
 H The sequences are removed from the view.
 H The remain on the hard disk.

DAS_features list of DAS services, list of proteins
 E DAS_features CSA%20-%20extended uniprot cbs_total netphos netoglyc, UNIPROT:P29590
 H Position specific annotations are loaded from the DAS services and underlined in the alignment.
 H Unfortunately, most BioDAS servers and the registry is not available any more.
 H Also see uniprot_features

delete residue_selection1 residue_selection2 ...
 H The specified residue selection is removed.


gaps x--xxxxxx-xxx-xxxxxx-xx-x, sequence
 H Gaps are inserted into the sequence.

icon URL-or-absolute_file_path, sequence
 E icon http://www.bioinformatics.org/strap/images/dog.png, protein
 E icon NULL, protein
 E icon data:image/gif;base64,R0lGODlhGgAaAIABADMzM////yH5BAEKAAEALAAAAAAaABoAAAI5jI+py+0Po0SgWmpry9nwq3yimIwmh51nqo5s+71wd8yuPIc2Xe7AZnvkIK3JauJBIVlLXfMJjUIKADs=, 4 5
 H The protein icon is displayed in the alignment row at the left.

project_coordinates PDB ID, protein
 E project_coordinates PDB:1BOR_A, UNIPROT:P29590
 E project_coordinates AUTO, UNIPROT:P29590
 E project_coordinates NULL, UNIPROT:P29590
 H The 3D coordinates are inferred into the protein.
 H With AUTO, the  most similar PDB entry is determined automatically.

rotate_translate  xx  xy  xz    yx  yy  yz    zx  zy  zz   translation_x  translation_y  translation_z, protein
 H The protein is moved in 3D space.
 H If a protein is given instead of a 3x3 matrix and translation vector then the transformation of that protein is used.
 H  Also see command "superimpose".
 E -0.51  -0.69   0.50   0.22   0.45   0.86  -0.82   0.55  -0.80     91.15 25.13  55.68, protein
 E  NULL, protein

rotate_translate_protein_complex  xx  xy  xz  yx  yy  yz  zx  zy  zz  translation_x  translation_y  translation_z, protein
 H Works similar as  rotate_translate.
 H In addition, if protein is part of a multiprotein complex,
 H then also all peptide chains of the complex are  rotated and translated.


3D_spheres [on/off]
 H Display the currently selected amino acids or atoms as spheres.

3D_cartoon  [on/off]
 H Display the currently selected amino acids as spheres.

3D_center
 H Center the view to the currently selected amino acids or atoms.

3D_center_amino
 H Center the view to all peptide chains.

3D_color html-color
 E 3D_color #ff0000
 H The color for the selected atoms is given as a 6 digit hexadecimal number.
 H First 2 digits Red, middle 2 digits Green and last 2 digits Blue.

3D_dots [on/off]
 H Draws dots around the selected atoms.

3D_label "text"
 H Sets a text label for the selected atoms.

3D_label_color color
 E 3D_label_color #ff0000
 H Color for text labels created with 3D_label.

3D_lines [on/off]
 H Displays the selected atoms as lines.

3D_mesh [on/off]
 H Draws a mesh around the selected atoms.

3D_object_delete Object-name.
 H Delets an object such as a surface.

3D_ribbons [on/off]
 H Display the currently selected amino acids as ribbons.

3D_rotate X angle
 H Rotate angle (degree not radiant) around axis X,  Y or Z.

3D_sa_surface [on/off]
 H Creates a surface object.
 H The color is specified in a previous 3D_surface_color-command.

3D_surface [on/off/#HexColor]
 H Creates a surface object.
 H The color is given as a  hexadecimal number with a leading #-sign.
 H This hexadecimal has 6 or 8 digits. If 8 digits, then the first two digits are transparency.

3D_script_panel
 H Opens the native script panel of that viewer.

3D_select expression
 E 3D_select 69.CA
 E 3D_select NADH
 H Selects atoms or amino acids in the active 3D view.


3D_sticks [on/off]
 H Displays the selected atoms as stick.

3D_zoom  percentage
 E 3D_zoom 200%

3D_highlight_selected_atoms [milliseconds]
 E 3D_highlight_selected_atoms 2000
 H The selected atoms are highlighted.

3D_highlight_selected_amino_acids [milliseconds]
 E 3D_highlight_selected_amino_acids 2000
 H The cAlpha atoms of the selected residues are highlighted.










#if CPP_WITH_GUI

wait_for command
 H waits for the command to be finished which has been previously started with bg
 E bg align *
 E ... some script lines ...
 E wait_for align

tree sequences
 H Displays a phylogenetic tree
 E tree *

STRAP_to_front
 H The application frame as top level window

iconify
 H The application frame is iconfied

ants residues
 H Draws a rubber band rectangle around all given residue selections
 E sequence1/20-30  sequence2/22-40

box residue
 H Same as ants

close_3D view ID, proteins
 H Removes the proteins from the 3D view. If no proteins are given, the 3D view is closed.

hide sequences
 H The sequences are removed from the current alignment but remain in memory.

unhide sequences
 H Sequences previoulsly hidden with hide are put back into the alignment

put_property key=value, sequences
 E put_property NOT_USE_STRUCTURE_FOR_ALIGNMENT=true,  *
 E put_property NOT_USE_STRUCTURE_FOR_ALIGNMENT=NULL,  *


close_wire proteins
 H Closes the 3D backbone representations

use_3D_viewer jmol
 H Set jmol as the default 3D-viewer. Possible arguments: astex, pymol, jmol.



select_3D 3D-ViewID, proteins or residue selections
 E select_3D  ViewID
 E select_3D  ViewID, subtilisin
 E select_3D  ViewID, subtilisin/100-200
 H Subsequent commands starting with "3D_" such as "3D_select" act on the selected 3D-view, protein (and residue selection).
 H The first argument is the identifier of a 3D-view (See open_3D).
 H The second argument is optional and is one or several proteins in this view or residue selections.
 H Instead of referring to a particular  view ID, the constant strings, an asterisk "*" can be used.
 H Leaving the view ID blank, refers to the view that has the focus.
 H Note that the command "select_3D" and "3D_select" are different.

below_row row-number or sequence, list of sequences
 H Change the order of sequences in the alignment.

to_row row-number or sequence, list of sequences
 H Change the order of sequences in the alignment.

cursor sequence/residue
 H The alignment cursor is set to a residue of a sequence.
 H The name of a residue selection can be given instead.

scroll_to sequence/residue [sequence/residue ... ]
 H The alignment is scrolled such that residues of interest come into sight.

select sequence1 sequence2 ... residue_selection1 ...
 H selected sequences are highlighted in the row header.
 H selected residue selections are indicated by marching ants.

unselect sequence1 sequence2 ... residue_selection1 ...
 H deselects sequences or residue selections.

3D_biomolecule
 E 3D_biomolecule 0x2  *, PDB:1a34
 H The macromolecular assemblies (i.e. biological units) are given as a decimal or hexadecimal number which is a bit masks.
 H For example 0x8 means the assembly 3 since 2^3=8.
 H -1 means the asymmetrical unit.

define_protein_complex protein1 protein2 ...
 H A multiprotein complex consisting of several chains is formed.
 H By default, chains of the same PDB entry form a complex.
 H See superimpose_multiprotein_complexes.

superimpose_protein_complexes protein1 protein2 ...
 H Multiprotein complexes as whole are superimposed upon each other.
 H See define_protein_complex

wire protein1 protein2 ...
 H Show 3D protein trace

#endif //CPP_WITH_GUI
*@
