#if 0
cur="${COMP_WORDS[COMP_CWORD]}"
https://se.ifmo.ru/~ad/Documentation/Bash_Shell/bash3-APP-D.html
#endif //0

@*~RSC_BASH_COMPLETE_HELP
# Bash smart auto completion means:  Hitting the tab-key completes command line options
# See https://www.wikipedia.org/wiki/Command-line_completion
# Activate by sourcing the bash script

PLACEHOLDER_SPACE source PLACEHOLDER_BASH_COMPLETION_FILE

## Activate permanently:

PLACEHOLDER_SPACE fgrep -q  PLACEHOLDER_BASH_COMPLETION_FILE ~/.bashrc || echo '. PLACEHOLDER_BASH_COMPLETION_FILE' >> ~/.bashrc
*@

@*~RSC_BASH_COMPLETE

#if CPP_WITH_MEIN_DEBUG
#define TO_LOG(a) echo -e a >>/mnt/tmpfs/completion.log
echo >/mnt/tmpfs/completion.log
echo 'tail -f /mnt/tmpfs/completion.log'
#else
#define TO_LOG(a)
#endif //CPP_WITH_MEIN_DEBUG
export _strap_defined=x
_strap() {
    if [[ ${COMP_WORDS[0]} == *java ]]; then
        local notStrap=1
        for ((i=0;i<COMP_CWORD;i++)); do
            local w="${COMP_WORDS[i]}"
            [[ "$w" == charite.christo.strap.Strap || "${w##*/}" == strap.jar ]] && notStrap=0
        done
        if ((notStrap));then
            _java $@ 2>/dev/null
            return $?
        fi
    fi
    COMPREPLY=()
    local v=
    local xx=
    local ff=0
    local dd=0
    local pfx=
    local cur
    _get_comp_words_by_ref -n = cur &>/dev/null
    TO_LOG('\n\n \e[7m cur='$cur' \e[0m')
    TO_LOG('COMP_LINE='$COMP_LINE)
    local SDB='UNIPROT: EMBL: GENBANK: PDB: PFAM: UNIPROT:hslv_ecoli UNIPROT:P0A7B8 EMBL:M57965 GENBANK:M57965 GENBANK:AAB57759 GENBANK:AAC20075|Rat GENBANK:AAB57759|Mouse GENBANK:NP_727350|Fly PFAM:PF06446 PFAM:PF00097 PDB:1ryp PDB:1ryp_E UNIPROT:O73672'
    COMP_WORDBREAKS=${COMP_WORDBREAKS//:}
    local eq=${cur#*=}
    case $cur in
       PAR_load_NQ*) v="$SDB";;
       PAR_align_NQ*) v="$SDB";;
       PAR_alignAndRearange_NQ*) v="$SDB";;
        JV*) v='JVM_-Xmx300M JVM_-ea JVM_-DproxyHost= JVM_-DproxyPort='; ff=1;;
       PAR_GEOMETRY_NQ*) v='1400x900+100+10 999x444+11+22';;
       CPP_UNSTRINGIZE(PFXPAR_script)=*)
            if [[ $cur == PFXPAR_script=h* ]]; then
                local u=http://www.bioinformatics.org/strap
                local s=$u/scripts
                local u3=$u/PDF/2003
                v="$s/HbA_alignment.txt $s/HbA_with3D.txt $u3/PMID12595256/1.txt $u3/PMID12595256/6.txt $u/dataFiles/scriptExamples/toHTML1.txt"
            fi
            xx='!*.@(txt|strap|script)'
            ;;
#if CPP_WITH_MEIN_DEBUG
        -script_=*) v=$(find $STRAP_SRC/web/ -name '*.strap' -or -name '*.txt' | sed "s|^$HOME|~|1"|sort);;
#endif //CPP_WITH_MEIN_DEBUG
        PLACEHOLDER_BASH_COMPLETION_LIST;;
        -*|-) COMPREPLY=($(compgen -o nospace -W PLACEHOLDER_PRG_OPTS -- $cur));;

        @*) xx='!*.@(txt|text|list)';pfx=@; eq=${cur#@};;

        *) ff=1;;
    esac

    isScript=0
    if [[ "$COMP_LINE" == *-script*([a-zA-Z0-9_])=\'*([a-zA-Z0-9_])  ]]; then
        eq=${cur##*\'}
        pfx=${cur%\'*}\'
        isScript=1
    fi
    if [[ "$COMP_LINE" == *-script*([a-zA-Z0-9_])=\"*([a-zA-Z0-9_])  ]]; then
        eq=${cur##*\"}
        pfx=${cur%\"*}\"
        isScript=1
    fi
    if ((isScript)); then
        TO_LOG("....................... -script=quote ueber COMP_LINE cur=$cur")
        xx=
        ff=0
        v=PLACEHOLDER_BASH_COMPLETION_SCRIPT_COMMANDS
    fi
    TO_LOG("cur=$cur eq=$eq ff=$ff dd=$dd xx=$xx pfx=$pfx v=$v COMPREPLY=${COMPREPLY[@]}")
    [[ -n "$v"  ]] && COMPREPLY=("${COMPREPLY[@]}" $(compgen -W "$v" --  $eq))
    if [[ -n "$xx" ]]; then
        ff=0
        dd=1
        COMPREPLY=("${COMPREPLY[@]}" $(compgen -f -P "$pfx" -X "$xx" -- $eq))
    fi
    ((ff)) && COMPREPLY=( "${COMPREPLY[@]}" $(compgen -f  -P "$pfx" -- $eq))
    ((dd||ff)) && COMPREPLY=( "${COMPREPLY[@]}" $(compgen -d  -P "$pfx" -- $eq))
    TO_LOG("COMPREPLY=${COMPREPLY[@]}")
}

complete -F _strap -o nospace s8stdout java strap.sh strap_{alignment,base} strap_to_{fasta,multiple_fasta,word,msf,clustal,clustal,html} PLACEHOLDER_BASH_COMPLETION_MY_ALIASES

#if CPP_WITH_MEIN_DEBUG
echo -n -e '\e[41m'
fgrep 'P'LACE  "${BASH_SOURCE[0]}"
fgrep 'P'AR_  "${BASH_SOURCE[0]}"
echo -e '\e[0m'
#endif //CPP_WITH_MEIN_DEBUG

*@
