
/*
  reset; java util.CkDragURLs
  The following Manually:
  Q63ED2
  s6stdout -align='https://www.ncbi.nlm.nih.gov/sites/entrez?Db=gene&Cmd=ShowDetailView&TermToSearch=3026713&ordinalpos=1&itool=EntrezSystem2.PEntrez.Gene.Gene_ResultsPanel.Gene_RVDocSum'

  DRAG_http://www.ensembl.org/id/ENSG00000139292
  http://www.ensembl.org/Homo_sapiens/geneview?gene=ENSG00000171791;db=core

  http://img.jgi.doe.gov/cgi-bin/w/main.cgi?section=GeneDetail&page=genePageMainFaa&gene_oid=643619770

  https://www.ncbi.nlm.nih.gov/RefSeq/key.html#accessions

  https://www.ncbi.nlm.nih.gov/gene/2099
  http://www.genecards.org/cgi-bin/carddisp.pl?gene=ESR1
  http://pubchem.ncbi.nlm.nih.gov/summary/summary.cgi?cid=5281
  http://www.sbg.bio.ic.ac.uk/phyre2/phyre2_output/f64d7597f18a5b1a/aligs/c3bdlA_.1.alig.html

*/
private static void Tests_UrlToDB_Inc()throws Exception{
    _heading("Tests_UrlToDB_Inc");
    String[]lines={
/* --- Ncbi --- */
        "https://www.ncbi.nlm.nih.gov/Structure/cdd/cddsrv.cgi?uid=176392 CDD:176392",
        "https://www.ncbi.nlm.nih.gov/protein/AAA16326  NCBI_AA:AAA16326",
        "http://www.ncbi.nlm.nih.gov/protein/AAA16326  NCBI_AA:AAA16326",
        "https://www.ncbi.nlm.nih.gov/nuccore/153266840 NCBI_NT:153266840 ",
        "https://www.ncbi.nlm.nih.gov/protein/153266841?report=genbank&log$=protalign&blast_rank=1 NCBI_AA:153266841 ",
        "http://www.ensembl.org/Xenopus_tropicalis/Gene/Summary?t=ENSXETT00000058303 ENSXETT00000058303",
        "https://www.ncbi.nlm.nih.gov/Structure/mmdb/mmdbsrv.cgi?uid=3107  MMDB:3107",
        "https://www.ncbi.nlm.nih.gov/Structure/pdb/1SBC PDB:1SBC",
/* ---  https://www.ncbi.nlm.nih.gov/Structure/mmdb/mmdbsrv.cgi?uid=62809 --- */
        "https://www.ncbi.nlm.nih.gov/sites/entrez?SUBMIT=y&db=structure&orig_db=structure&term=2PRT   PDB:2PRT",
        "http://www.rcsb.org/pdb/cgi/explore.cgi?pdbId=2PRT PDB:2PRT",
        "http://oca.weizmann.ac.il/oca-bin/ocashort?id=1I2M PDB:1I2M",
        "https://www.ncbi.nlm.nih.gov/Structure/mmdb/mmdbsrv.cgi?ShowOp=VastSum&uid=62809   NCBI_NEIGHBOR:62809",
/* --- expasy --- */
        "http://us.expasy.org/cgi-bin/niceprot.pl?P38721 UNIPROT:P38721 ",
        "http://www.expasy.org/cgi-bin/get-sprot-raw.pl?Q7RMZ6 UNIPROT:Q7RMZ6",
        "http://www.expasy.org/cgi-bin/get-full-entry?[SWISS_PROT-ID:'PSA1_HUMAN'] UNIPROT:PSA1_HUMAN",
        "http://www.expasy.org/cgi-bin/get-full-entry?[TREMBL-ID:'Q16411_HUMAN'] UNIPROT:Q16411_HUMAN",
        "http://swissmodel.expasy.org/repository/smr.php?sptr_ac=Q5EA13&csm=9F36D23325D247C7 UNIPROT:Q5EA13",
/* --- uniparc --- */
        "http://www.uniprot.org/uniparc/UPI00017E440 UPI:UPI00017E440",
        "http://www.uniprot.org/uniref/UniRef90_Q4RYQ7  UR090:UniRef90_Q4RYQ7",

/* --- ncbi --- */

        "https://www.ncbi.nlm.nih.gov/nucleotide/55749778 NCBI_NT:55749778",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=nucleotide&val=116710987 NCBI_NT:116710987",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?txt=on&id=NM_000267&db=Nucleotide&view=def&SendTo=t NCBI_NT:NM_000267",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?WebEnv=0vWWhGvCe&db=nucleotide&qty=1&c_start=1&list_uids=NM_000267&uids=&dopt=gb&dispmax=5&atpresent=1&ef_STS=64&ef_Exon=512& NCBI_NT:NM_000267",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=protein&val=6995996  NCBI_AA:6995996",
        "https://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Search&doptcmdl=GenPept&db=Protein&term=136092  NCBI_AA:136092",

        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=NM_021175 REFSEQ:NM_021175",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=NP_066998 REFSEQ:NP_066998",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=NM_214384.1 REFSEQ:NM_214384",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=156938889 REFSEQ:156938889",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=XM_001115474.1 REFSEQ:XM_001115474",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=NP_066998 REFSEQ:NP_066998",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=NM_000267&view=def&sendto=t REFSEQ:NM_000267",
        "https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=M57965&view=def&sendto=t REFSEQ:M57965",

        "http://prodomweb.univ-lyon1.fr/prodom/current/cgi-bin/request.pl?db_ent0=PD013756  PRODOM:PD013756",
        "http://www.ebi.ac.uk/msd-srv/msdlite/atlas/summary/1ryp.html   PDB:1ryp",
        "http://www.ebi.ac.uk/msd-srv/msdlite//atlas?id=1ryp&page=visualization  PDB:1ryp",
        "http://www.pdb.org/pdb/download/downloadFile.do?fileFormat=fastachain&compression=NO&structureId=2Z73&chainId=A PDB:2Z73:A",

        "http://gibk26.bse.kyutech.ac.jp/cgi-bin/jouhou/3D/bin/entry_pdb.sh?ENTRY=1b97&DISP=0 PDB:1b97",
        "http://www.pdb.org/pdb/download/downloadFile.do?fileFormat=fastachain&compression=NO&structureId=2Z73&chainId=A PDB:2Z73:A",
        "https://www.ncbi.nlm.nih.gov/Structure/pdb/1MEY PDB:1MEY",
        "http://www.cathdb.info/cgi-bin/Pdb.pl?pdb_code=1avo PDB:1avo",
        "https://www.ncbi.nlm.nih.gov/nuccore/157454?ordinalpos=1&itool=EntrezSystem2.PEntrez.Sequence.Sequence_ResultsPanel.Sequence_RVDocSum NCBI_NT:157454",
        "https://www.ncbi.nlm.nih.gov/protein/37222206?ordinalpos=1&itool=EntrezSystem2.PEntrez.Sequence.Sequence_ResultsPanel.Sequence_RVDocSum#sequence_37222206 NCBI_AA:37222206",
        "https://www.ncbi.nlm.nih.gov/protein/37222206?egalWasJetztKommt NCBI_AA:37222206",
        "http://www.ncbi.nlm.nih.gov/protein/37222206?egalWasJetztKommt NCBI_AA:37222206",

/* UNIPROT */
        "http://srs.embl.de/srs/showEntryView.do?entryId=PDB:1A2C&pCon=&pQ=q6&ppQ=q6&num=1&total=270&sF=&sD=0&pV=PDBconcise&pDB=&pC=&pCT=&pSt=1&pSz=30&pCN=  PDB:1A2C",
        "http://srs.embl.de/srs/showEntryView.do?entryId=UNIPROT:Q96M98&p UNIPROT:Q96M98",
        "http://howdy.jst.go.jp/HOWDYCL//HOWDY.pl?Cls=GenBank&Key=UKEY&Val=ac008537 GB:ac008537",
        "http://www.uniprot.org/uniprot/PSB6_YEAST UNIPROT:PSB6_YEAST",
        "http://www.pir.uniprot.org/cgi-bin/upEntry?id=Q6X7J5 UNIPROT:Q6X7J5",
        "http://www.ebi.ac.uk/Tools/dbfetch?db=uniprotkb&style=raw&id=V8KBS9_ECOLX UNIPROT:V8KBS9_ECOLX",
        "http://www.uniprot.org/blast/?about=P05026-1 UNIPROT:P05026",
        "http://www.uniprot.org/uniparc/?query=uniprot:P14415&direct=yes UNIPROT:P14415",
/* PDB */
        "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-exx[pdb-id:1YYF_C] PDB:1YYF",

        "http://www.pdb.org/pdb/files/1RYP.pdb.gz PDB:1RYP",
        "http://eds.bmc.uu.se/cgi-bin/eds/uusfs?pdbCode=1GEU PDB:1GEU",

        "http://service.pdbj.org/mine/Detail?PDBID=1prn&PAGEID=Summary  PDB:1prn",
        "http://pdbj.org/mine/summary/1tib PDB:1tib",
        "http://pdbj.org/mine/structural_details/1tib PDB:1tib",

        "http://www.rcsb.org/pdb/download/downloadFile.do?fileFormat=pdb&compression=NO&structureId=1SBC PDB:1SBC",
        "http://pdb.rcsb.org/pdb/explore.do?structureId=1ZRO PDB:1ZRO",
        "http://pdbjs3.protein.osaka-u.ac.jp/xPSSS/xPSSSSearch?search_type=pdbid_search&query=2VGF PDB:2VGF",
        "http://dx.doi.org/10.2210/pdb1ckw/pdb PDB:1ckw",
        "http://www.rcsb.org/pdb/cgi/explore.cgi?job=download&pdbId=1oyw&page=&pid=&opt=show&format=PDB&header=3 PDB:1oyw",
        "http://www.fli-leibniz.de/cgi-bin/Piet/PDBsend.pl?code=1eh7&header=1  PDB:1eh7",
        "http://pfam.sanger.ac.uk/structure?id=2a73 PDB:2a73",
        "http://pfam.sanger.ac.uk/protein/Q8LKK4_CHLRE  UNIPROT:Q8LKK4_CHLRE",
        "http://www.ebi.ac.uk/pdbe-srv/view/entry/1l9v/summary PDB:1l9v",
        "http://www.ebi.ac.uk/pdbe/entry/pdb/1l9v PDB:1l9v",
                                                     "http://www.ebi.ac.uk/pdbe/pisa/cgi-bin/piserver?token=1po5  PDB:1po5",

/* PDBe */
        "http://www.ebi.ac.uk/pdbe/searchResults.html?display=both&term=B2R773 UNIPROT:B2R773",
/* --- Meine eigenen --- */
        "http://www.bioinformatics.org/strap/lite/strap.php?load=PDB:1TQF&blabla PDB:1TQF",
        "http://www.bioinformatics.org/strap/lite/strap.php?load=UNIPROT:hslv_ecoli&blabla UNIPROT:hslv_ecoli",

/* --- Viperdb --- */
        "http://viperdb.scripps.edu/cgi-bin/viper_coord.cgi?VDB=1m4x VIPERDB:1m4x",
        "http://viperdb.scripps.edu/info_page.php?VDB=1m4x VIPERDB:1m4x",
        "http://www.charite.de/bioinf/strap/strap.php?online=on&align=VIPERDB:1dzl%7C%7C%7C%7C%7C2 VIPERDB:1dzl",
/* jp */
        "http://www.genome.ad.jp/dbget-bin/www_bget?ptr+461394 KEGG_AA:ptr+461394",
        "http://www.genome.jp/dbget-bin/www_bget?btk+BT9727_1829 KEGG_AA:btk+BT9727_1829",
        "http://www.genome.jp/dbget-bin/www_bget?ptr+461394  KEGG_AA:ptr+461394",
/* --- EBI --- */
        "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-e+[UNIPARC-refdbsv:EAW64625.1]%3eparent UNIPARC:EAW64625",
        "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-id+1RXq31Xs1fh+-e+[EMBL:'FG971470']+-qnum+1+-enum+1 EMBL:FG971470",
        "http://www.ebi.ac.uk/cgi-bin/expasyfetch?U13683 EMBL:U13683",
        "http://www.ebi.ac.uk/Tools/expasyfetch?U13683 EMBL:U13683",
        "srsbin/cgi-bin/wgetz?-e_[EMBL_features-id:U13683 EMBL:U13683",

/* --- EBI --- */
        "http://www.ebi.ac.uk/pdbsum/1d5r PDB:1d5r",
        "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-e+[uniprot-ProteinID:EAW64625]+-noSession UNIPROT:EAW64625",
        "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-e+[UNIPROT-acc:P19235] UNIPROT:P19235",

        "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-e+[emblcds-id:EAW64625]+-noSession EMBLCDS:EAW64625",
        "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?[interpro-AccNumber:IPR013284]+-e INTERPRO:IPR013284",
        "https://www.ebi.ac.uk/interpro/entry/IPR013284 INTERPRO:IPR013284",
/* --- Brenda  */
        "javascript:Blast2('Q4R6F3') UNIPROT:Q4R6F3",
        "javascript:Sequence2('P21163') UNIPROT:P21163",
        "javascript:Sequence2('HSLV_SHIFL') UNIPROT:HSLV_SHIFL",
        "javascript:Pdb('1pgs') PDB:1pgs",
        "javascript:fasta_seq_func('1sbc') PDB:1sbc", //PDBj
        "javascript:summaryP('1DO0') PDB:1DO0",
        "javascript:JSToPIDBEntry('2uv8',0) PDB:2uv8", // Pisa EBI
        "javascript:gotoView('detailPage','','1vyr'); PDB:1vyr", //MSD ligand
/* --- TCDB --- */
        "http://www.tcdb.org/tcdb/fasta.php?anum=P52002 UNIPROT:P52002",

/* PFAM */
        "http://pseudofam.pseudogene.org/pages/psfam/showFams.jsf?genome=0&format=family&id=PF06180 PFAM:PF06180",
        "http://pfam.sanger.ac.uk/family?acc=PF07654 PFAM:PF07654",
        "http://pfam.xfam.org/family?acc=PF06446 PFAM:PF06446",

        "http://pfam.sanger.ac.uk/family/PF01167 PFAM:PF01167",
        "http://pfam.xfam.org/family/PF06446 PFAM:PF06446",
        "http://pfam.xfam.org/family?acc=PF01325 PFAM:PF01325",
        "http://pfam.sanger.ac.uk/family?entry=PF02171 PFAM:PF02171",
        "http://www.ebi.ac.uk/goldman-srv/pandit/pandit.cgi?action=browse&fam=PF00227 PFAM:PF00227",

/* BioMyn */
        "http://biomyn.de/?mid=Q86UR5&ispc=UniProtKB  UNIPROT:Q86UR5",
/* SYSTERS_CLUSTER http://systers.molgen.mpg.de/cgi-bin/nph-fetchcluster.pl?PFAM=cNMP_binding */
        "http://systers.molgen.mpg.de/cgi-bin/nph-fetchcluster.pl?CLNR=142165 SYSTERS_CLUSTER:142165",
        "http://systers.molgen.mpg.de/cgi-bin/nph-fileout.pl?nr=137880&method=f  SYSTERS_CLUSTER:137880",

/* EMBL */
/* --- Arabidopsis --- */
        //            "http://arabidopsis.org/servlets/TairObject?type=locus&name=AT1G62600 XXXXX",
    };
    // lines=new String[]{"https://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=NM_214384.1 GB:NM_214384"};
            int count=0;
    for(String line:lines){
        StringTokenizer st=new StringTokenizer(line, " ");
        final String url=st.nextToken(), ref=st.nextToken();
        final String h=hrefToDbColonID(url);
        baOut(null).format10(count++,3).aa(' ',url,"  ==> ").aln(h);
        if(!ref.equals(h)) baOut(RED_WARNING).aln(line+" h="+h);
    }

}

#if 0
/*
  Spaeter Implementieren
  ---------------------
  NCBI Sequence Cluster https://www.ncbi.nlm.nih.gov/Structure/cdd/cddsrv.cgi?uid=28947
  DRAG_http://www.phytozome.net/genePage.php?search=1&searchText= transcriptid:17314241&crown&method=0&detail=1
  DRAG_http://www.phytozome.net/genePage.php?crown&method=0&search=1&detail=1&searchText=transcriptid:16927582
  https://www.ncbi.nlm.nih.gov/gene/100485924

  http://www.sbg.bio.ic.ac.uk/services.html
  http://v3-0.toxodb.org/cgi-bin/toxodb/ToxoBlast/blast.pl
  In ModView sind einige potentielle

  http://modbase.compbio.ucsf.edu/modbase-cgi/index.cgi !!!!!!!!!!!!!!!

  http://howdy.jst.go.jp/HOWDYCL//HOWDY.pl?Cls=GenBank&Key=UKEY&Val=ac008537

  http://scop.mrc-lmb.cam.ac.uk/scop/search.cgi?search_type=scop&key=d1chvs_



  DRAG_http://www.plantgdb.org/BdGDB/cgi-bin/findRecord.pl?id=Bradi5g18530.1

*/

/*
  BIRCH <http://home.cc.umanitoba.ca/~psgendb/>
  EMBOSS <http://emboss.org/>
  wEMBOSS Portal <http://www.wemboss.org/>
  WSBAW <http://www.alphaworks.ibm.com/tech/wsbaw>
  SciCraft <http://www.scicraft.org/>
  Scitegic <http://scitegic.com/products_services/pipeline_pilot.htm>
  Pegasys <http://bioinformatics.ubc.ca/pegasys/>
  ANGIS <http://www.angis.org.au/>
  W2H <http://www.w2h.dkfz-heidelberg.de/>
  Pise <http://www-alt.pasteur.fr/~letondal/Pise/>
  SRS <http://www.biowisdom.com/solutions_srs.htm>

  >

  // ftp://ftp.jcvi.org/pub/data/Microbial_Genomes/OMNIOME/annotation_dbs/OMNIOME.seq.Z

  http://www.yeastgenome.org/cgi-bin/gbrowse/scproteome/?src=scproteome&name=YBL016W  email geschrieben
  https://www.ncbi.nlm.nih.gov/UniGene/seq.cgi?ORG=Ssc&SID=20116309
  http://swissmodel.expasy.org/workspace/index.php?func=getFile&file=getModellingFile&userid=qeegtut@gmail.com&prjid=P000020&token=4d096f2046e8987e8435a8c4c9afb4b0&key=a4052af679448b466cdb1cdb6e019f0b&model=4&type=normal&show=text
  http://swissmodel.expasy.org/workspace/index.php?func=img&userid=qeegtut@gmail.com&prjid=P000020&pic=img_model_overview&model=4&token=4d096f2046e8987e8435a8c4c9afb4b0&key=a4052af679448b466cdb1cdb6e019f0b
  http://swissmodel.expasy.org/workspace/index.php?func=getFile&file=getModellingFile&userid=qeegtut@gmail.com&prjid=P000020&token=4d096f2046e8987e8435a8c4c9afb4b0&key=a4052af679448b466cdb1cdb6e019f0b&model=4&type=normal&show=download
  http://swissmodel.expasy.org/workspace/index.php?func=getFile&file=getModellingFile&userid=qeegtut@gmail.com&prjid=P000015&token=61923eece3e12b806c42a7ce0eb9cdb4&key=291ed4fea0900c3eb6b862a1da8e7ba2&model=1&type=normal&show=deepview

  ------------------------------------------------------
*/
#endif //0
// (JavaMainFile)
