
public static void Tests_strEquAt_Inc(){

    _heading("Tests_strEquAt_Inc");
    goEqu(0, "23", "23",0,                              true);
    goEqu(0, "23", "12",1,                              false);

    goEqu(0, "23","123456",1,                           true);

    goEqu(0, "23","123",1,                              true);

    goEqu(0, "23", "123",0,                             false);

    goEqu(0, "ab","abc",0,                               true);
    goEqu(STR_IC, "AB", "abc",0,                         true);
    goEqu(STR_IC, "ab", "ABC",0,                         true);
    goEqu(STR_IC, "AB", " abc",1,                         true);
    goEqu(STR_IC, "ab", " ABC",1,                         true);

    goEqu(STR_IC|STR_w, "ab","ABC",0,                    false);
    goEqu(STR_IC|STR_w_L, "ab","ABC",0,                    true);

    goEqu(STR_IC|STR_w, "bc","ABC",1,                    false);
    goEqu(STR_IC|STR_w_R, "bc","ABC",1,                    true);

    goEqu(STR_IC|STR_w, "BC","BC", 0, true);

    goEndWith(0,".txt", "1234.txt", true);
    goEndWith(0,".TXT", "1234.txt", false);
    goEndWith(STR_IC,".TXT", "1234.txt", true);
    goEndWith(STR_IC,".txt", "1234.TXT", true);

    goEndWith(STR_IC,".txt", "1", false);

    goEndWith(0, new String[]{".gif",".png"}, "file.png", true);
    goEndWith(0, new String[]{".gif",".png"}, "file.PNG", false);

    goEndWith(0, new String[]{".gif",".png"}, "file.png", true);

    //goStartWith(STR_IC, "", "0", true);
    //goEndWith(STR_IC,"", "0", true);

    goStartWith(STR_IC, "/home/", "/home/file.png", true);
    goStartWith(STR_IC, "/home/", "/HOME/FILE.PNG", true);
    goStartWith(STR_w, "ab", "abc", false);
    goStartWith(STR_w, "ab", "ab ", true);
    goStartWith(STR_w, "ab", "ab", true);
    goStartWith(0, "", "file.png", true);
    goStartWith(STR_IC, "/home/", file("file.png"), true);

    putln("Test_equls OK #"+_count);
}

static void goEqu(int opt,final Object needle,final String haystack,int start,boolean result){
    puts (" "+_count++);
    for(Object n:debugToAllTextTypes(0,needle)){
        for(Object h:debugToAllTextTypes(0,haystack)){
            for(int specific=2;--specific>=0;){
#define M(N,H) if(n instanceof N && h instanceof H) res=strEquAt(opt,(N)n,(H)h,start)
                boolean res=false;
                if(specific==0){
                    M(Object,Object);
                } else{
                    M(String,String);
                    else M(String,byte[]);
                    else M(byte[],String);
                    else M(byte[],byte[]);
                    else continue;
                }
                if(result!=res){
                    final BA sb=debugOptionsToTxt(opt,"STR_",baOut(ANSI_INVERSE+"strEquAt( "))
                        .aa(" SPECIFIC=",specific,' ',debugTextType(n),", ",debugTextType(h)," ) ",ANSI_RESET)
                        .aa("n=",toStrg(n),"<  h=",toStrg(h),"<   @",start)
                        .aa("Soll=",result).aln();
                    System.exit(9);
                }
            }
        }
    }
}
#undef M
static void goEndWith(int opt,Object needle,Object haystack,boolean result){
    puts (" "+_count++);
    for(Object n:debugToAllTextTypes(0,needle)){
        for(Object h:debugToAllTextTypes(0,haystack)){
            for(int specific=2;--specific>=0;){
#define M(N,H) if(n instanceof N && h instanceof H) res=strEnds(opt,(N)n,(H)h)
                boolean res=false;
                if(specific==0){
                    M(Object,Object);
                } else{
                    M(String,String);
                    else M(String,byte[]);
                    else M(byte[],String);
                    else M(byte[],byte[]);
                    else continue;
                }
                if(result!=res){
                    final BA sb=debugOptionsToTxt(opt,"STR_",baOut(ANSI_INVERSE+"strEnds( "))
                        .aa(" SPECIFIC=",specific," ",debugTextType(n),", ",debugTextType(h)," ) ",ANSI_RESET)
                        .aa("n=",n,"<  h=",h,"<")
                        .aa("soll=",result).aln();
                    System.exit(9);
                }
            }
        }
    }
}
#undef M
static void goStartWith(int opt,Object needle,Object haystack,boolean result){
    puts (" "+_count++);
    for(Object n:debugToAllTextTypes(0,needle)){
        for(Object h:debugToAllTextTypes(0,haystack)){
            for(int specific=2;--specific>=0;){
#define M(N,H) if(n instanceof N && h instanceof H) res=strStarts(opt,(N)n,(H)h)
                boolean res=false;
                if(specific==0){
                    M(Object,Object);
                } else{
                    M(String,String);
                    else M(String,byte[]);
                    else M(byte[],String);
                    else M(byte[],byte[]);
                    else continue;
                }
                if(result!=res){
                    if(result!=res){
                        final BA sb=debugOptionsToTxt(opt,"STR_",baOut(ANSI_INVERSE+"startWith( "))
                            .aa(" ",debugTextType(n),", ",debugTextType(h)," ) ",ANSI_RESET)
                            .aa("n=",n,"<  h=",h,"<")
                            .aa("soll=",result).aln();
                        System.exit(9);
                    }
                }
            }
        }
    }
}
#undef M
