public static void Tests_strrplc_Inc(){
    _heading("Tests_strrplc_Inc");
    /* sameSize */
    go("1234 xyz 5678",0,  "abc", "xyz",  "1234 abc 5678");

    go("1234 xyz 5678",0,  "abc", "xyz",  "1234 abc 5678",5,8);
    go("1234 xyz 5678",STR_IC,  "abc", "xyz",  "1234 abc 5678");
    go("1234 xyz 5678",STR_IC,  "ABC", "xyz",  "1234 abc 5678");
    go("1234 xyz 5678",STR_IC,  "abc", "xyz",  "1234 ABC 5678");

    go("1234 xyz 5678",STR_w,   "abc", "xyz",  "1234 abc 5678");
    /* Keine Ersetzung */
    go("1234xabc 5678",STR_w,   "abc", "xyz",  "1234xabc 5678");
    go("1234 abc 5678",0,       "abc", "xyz",  "1234 abc 5678",6,8);
    go("1234xabc 5678",STR_w,   "a", "x",  "1234xabc 5678");
    go("1234 abc 5678",0,       "abc", "xyz",  "1234 abc 5678",5,7);

    /* sameSize */
    go("1234 xyz 5678",0,  "abc", "xyz",  "1234 abc 5678");

    go("1234 xy 5678",0,  "abc", "xy",  "1234 abc 5678",5,8);
    go("1234 xy 5678",STR_IC,  "abc", "xy",  "1234 abc 5678");
    go("1234 xy 5678",STR_IC,  "ABC", "xy",  "1234 abc 5678");
    go("1234 xy 5678",STR_IC,  "abc", "xy",  "1234 ABC 5678");

    go("1234 xy 5678",STR_w,   "abc", "xy",  "1234 abc 5678");
    /* Keine Ersetzung */
    go("1234xabc 5678",STR_w,   "abc", "xy",  "1234xabc 5678");
    go("1234 abc 5678",0,       "abc", "xy",  "1234 abc 5678",6,8);
    go("1234xabc 5678",STR_w,   "a", "x",  "1234xabc 5678");
    go("1234 abc 5678",0,       "abc", "xy",  "1234 abc 5678",5,7);

    putln("Test_rplc OK #"+_count);
}
static void go(String result,int opt,String pattern,String replacement,String text,int f,int t){
    puts(" "+ _count++);
    for(Object p:debugToAllTextTypes(0,pattern)){
        for(Object r:debugToAllTextTypes(0,replacement)){
            for(Object x:debugToAllTextTypes(0,text)){
                //if (!testString(p) || !testString(r) || !testString(t)) continue;
                if(!(x instanceof CharSequence)) continue;
                CharSequence res=strplc(opt,p,r,x,f,t);
                if(!result.equals(toStrg(res))){
                    debugOptionsToTxt(opt,"STRPLC_",debugOptionsToTxt(opt,"STR_",baOut(ANSI_INVERSE).aa("strplc(",ANSI_RESET)))
                        .aa(debugTextType(p),", ",debugTextType(r),", ",debugTextType(x)).aa(" f=",f," t=",t,") "+ANSI_RESET+"\n")
                        .aa("pattern=",p,"<   replacement=",r,"<   text=",x,"<\n")
                        .aa("soll=",result,"   ist=",res,'\n')
                        .aa("strstr=",strstr(opt,pattern,text,f,t)).aln().aa("# ",_count).aln();
                    System.exit(9);
                }
            }
        }
    }
}
static void go(String result,int opt,String pattern,String replacement,String text){
    go( result,opt,pattern,replacement,text,0,MAX_INT);

}
