package charite.christo.test;
import charite.christo.strap.*;
import charite.christo.*;
import java.util.*;
import java.io.File;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;

/*  @author Christoph Gille  java  -ea charite.christo.strap.StrapScriptInterpreterTest b1_SaccharomycesCerevisiae.pdb */
public class StrapScriptInterpreterTest{
    private static File _f;
    public static void main(String[]argv)throws Exception{
        setPrgPrmtrs(argv);
        setPrgOptOn(iPAR_EXCEPTION_NO_UPLOAD);
        readWriteRead(true,readBytes(_f=file(argv[0])));
        System.exit(0);
    }

/*
      SCRIPT_close_strap="close_strap",
      cat $STRAP_SRC/src/noGui/charite/christo/strap/ChConstants_StrapInc.java | grep '^ *SCRIPT_'|sed -e '
      /SCRIPT/ !d
      s/^ * //1
      s/=.*.//1
      ' | tr '\n' ','
*/
    public static void checkCommands()throws IllegalAccessException{
        final String[]cc=joinArrys(JOINARRAYS_UNIQ,null,SI_CMDS_NOGUI, SI_CMDS_GUI, String.class);
        Arrays.sort(cc);
        final java.lang.reflect.Field[]fields=ChConstants.class.getDeclaredFields();
        for(java.lang.reflect.Field f:fields){
            final String n=f.getName();
            if(!n.startsWith("SCRIPT_") || f.getType()!=String.class) continue;
            final String val=(String)f.get(null);
            final boolean ok=idxOf(val, cc)>=0;
            if(!ok) baOut(val).a(' ').aln(ok);
        }
        FORi(0,cc.length-1){
            if(cc[i].equals(cc[i+1])) baOut("Doppelt ").aln(cc[i]);
        }
    }

    public static BA readWriteRead(boolean again, BA pdbText){
        final Protein p=newProteinInstance(0,pdbText);
        //putln(" residueAnnotations()="+p.residueAnnotations().length);
        final BA txt=new BA(0).join0(sequenceInStrapFormat(SEQW_CALPHA_ATOMS,p,null,null));
        putln(txt);
        putln("\n============================\n");
        if(again){
            final BA newTXT=readWriteRead(false,txt);
            newTXT.delBlanksR();
            txt.delBlanksR();
            final int differs=differs(newTXT,txt);
            if(differs>=0){
                baOut(RED_ERROR).aa(" Ungleich at ",differs,"  ").aFile(_f).aln();
                final int from=1+strchrBwd('\n'|STR_E,txt,differs-1,-1);
                final int to=strchr('\n'|STR_E,txt,differs+1,MAX_INT);
                baOut("").aFromDashTo(from,to).a(" ").a(txt,from,to).aln();
                baOut("").aFromDashTo(from,to).a(" ").a(newTXT,from,to).aln();
            }
            if(sze(newTXT)!=sze(txt)){
                baOut(RED_ERROR).aa(" Ungleiche Groesse ",sze(newTXT),'/',sze(txt),"  ").aFile(_f).aln();
            }

        }
        return txt;
    }

    public static int differs(BA a1, BA a2){
        final byte[]T1=a1.bytes(), T2=a2.bytes();
        FORi(0,mini(a1,end(),a2.end())){
            int c1=T1[i];
            int c2=T2[i];
            if(is(LETTR,c1)) c1|=32;
            if(is(LETTR,c2)) c2|=32;
            if(c1!=c2) return i;
        }

        return -1;
    }
}
