package charite.christo;
import static charite.christo.ChUtils.*;
/** @author Christoph Gille */
public class Bitset{
#if CPP_WITH_GUI
    public static boolean set(boolean onOff,int f,int t,int[][]fftt){
        if(f<0) f=0;
        if(f>=t) return false;
        int[]ff=fftt[0],tt=fftt[1];
        int L=ff.length,bF=0,bT=L;
        while(bF<L && tt[bF]<=f) bF++;
        while(bT>0 && ff[bT-1]>=t) bT--;
        IF_MEIN_DEBUG(final boolean debug=false);;
        if(bT<bF) assrt();
        boolean changed=false;
        FORb(bF,bT){
            if(onOff){
                if(f<ff[b]) {ff[b]=f; changed=true;}
                if(t>tt[b]) {tt[b]=t; changed=true;}
            }else{
                if(f<=ff[b] && tt[b]<=t){
                    IF_MEIN_DEBUG(if(debug) putln("Block weg"));;
                    tt[b]=ff[b]=MIN_INT;
                    changed=true;
                }else if(ff[b]<f && t<tt[b]){
                    IF_MEIN_DEBUG(if(debug) putln("Block teilen"));;
                    (ff=chSze(ff,L+1))[L]=t;
                    (tt=chSze(tt,L+1))[L]=tt[b];
                    tt[b]=f;
                    changed=true;
                }else if(t<tt[b]){
                    IF_MEIN_DEBUG(if(debug) putln("Blockanfang r"));;
                    ff[b]=t;
                    changed=true;
                }else if(f>ff[b]){
                    IF_MEIN_DEBUG(if(debug) putln("Blockende l"));;
                    tt[b]=f;
                    changed=true;
                }
            }
        }
        if(onOff && bT==bF){
            (ff=chSze(ff,L+1))[L]=f;
            (tt=chSze(tt,L+1))[L]=t;
            changed=true;
        }
        if(changed){
            fftt[0]=ff;
            fftt[1]=tt;
            tidy(fftt);
        }
        return changed;
    }
#endif //CPP_WITH_GUI
    public static int[][]tidy(int[][]fftt){
        while(true){
            sort(fftt);
            int[]ff=fftt[0],tt=fftt[1];
            boolean changed=false;
            FORi(0,ff.length-1){
                if(ff[i]>tt[i]) baOut(RED_WARNING).aln(" Bitset ff[i]>tt[i] ");
                if(tt[i]>=ff[i+1]){/*X  Vereinigen */
                    //final int debugCount=countTrue(Bitset.toBool(fftt));

                    ff[i+1]=ff[i];
                    if(tt[i+1]<tt[i]) tt[i+1]=tt[i];
                    ff[i]=tt[i]=0;
                    // if(debugCount!=countTrue(Bitset.toBool(fftt))){
                    // final int f=ff[i],t=tt[i],f1=ff[i+1],t1=tt[i+1];
                    //     putln(RED_WARNING+f+"-"+t+"  "+f1+"-"+t1+"  ");
                    // }
                    changed=true;
                    break;
                }
            }
            if(!changed) break;
        }
        return fftt;
    }
    public static void sort(int[][]fftt){
        int[]ff=fftt[0],tt=fftt[1];
        final long[]buf=longsSoft(286,ff.length);
        CPP_synchronized(recordSync(buf,"Bitset.sort")){
            int count=0;
            FORi(0,ff.length){
                if(ff[i]<tt[i]){
                    if(ff[i]<0) assrt();
                    if(tt[i]<0) assrt();
                    buf[count++]=RANGE_FROM_TO(ff[i],tt[i]);
                }
            }
            java.util.Arrays.sort(buf,0,count);
            if(ff.length!=count) {fftt[0]=ff=new int[count]; fftt[1]=tt=new int[count];}
            FORi(0,count){
                ff[i]=(int)(buf[i]>>>RANGEFROM_SHIFT);
                tt[i]=(int)(buf[i]&RANGETO_MASK);
                // if(i>0){
                //     if(ff[i-1]>ff[i]){
                //         putln(buf[i-1]+"/ "+ff[i-1]+"-"+tt[i-1]+"  "+buf[i]+"/ "+ff[i]+"-"+tt[i]);
                //     }
                // }
            }
        }
    }

#if CPP_DEACTIVATED
    public static boolean[]toBool(int fftt[][]){
        final int[]ff=fftt[0],tt=fftt[1];
        if(tt.length==0) return NO_boolean;
        int max=0;
        ROFi0(ff.length)if(tt[i]>max) max=tt[i];
        final boolean[]bb=new boolean[max];
        ROFi0(ff.length){
            if(ff[i]<0) assrt();
            if(tt[i]<0) assrt();
            if(tt[i]<ff[i]) assrt();
            java.util.Arrays.fill(bb,ff[i],tt[i],true);

        }
        return bb;
    }
#endif //CPP_DEACTIVATED
#if CPP_WITH_GUI
    public static boolean notEmpty(int fftt[][]){
        if(fftt!=null){
            final int[]ff=fftt[0],tt=fftt[1];
            ROFi0(ff.length) if(ff[i]<tt[i]) return true;
        }
        return false;
    }
    public static int[][]fromBool(boolean[]bb){
        int ff[]=new int[9],tt[]=new int[9],count=0;
        FORi(0,bb.length){
            if(bb[i]){
                if(ff.length<=count) {ff=chSze(ff,count+10); tt=chSze(tt,count+10);}
                ff[count]=i;
                while(i<bb.length && bb[i]) i++;
                tt[count++]=i;
            }
        }
        return new int[][]{chSze(ff,count),chSze(tt,count)};
    }
    public static boolean get(int pos,int[][]fftt){
        if(fftt==null) return false;
        for(int ff[]=fftt[0],tt[]=fftt[1],i=ff.length;--i>=0  && tt[i]>pos;) if(ff[i]<=pos) return true;
        return false;
    }
#endif //CPP_WITH_GUI

    public static int count(int pos,int[][]fftt){
        if(fftt==null) return 0;
        final int[]ff=fftt[0],tt=fftt[1];
        int count=0;
        for(int i=0;i<ff.length && ff[i]<pos;i++) count+=(tt[i]<pos?tt[i]:pos)-ff[i];
        return count;
    }
    public static int countAll(int[][]fftt){
        if(fftt==null) return 0;
        final int[]ff=fftt[0],tt=fftt[1];
        int count=0;
        ROFi0(ff.length) count+=tt[i]-ff[i];
        return count;
    }
    public static int selected2block(int selIdx,int[][]fftt){
        if(fftt==null) return 0;
        final int[]ff=fftt[0],tt=fftt[1];
        for(int count=0,i=0;i<ff.length;i++) if((count+=tt[i]-ff[i])>selIdx) return i;
        return -1;
    }
    public static BA toText(int[][]fftt,boolean compl,BA sb){
        if(sb==null) sb=new BA(99);
        if(compl) sb.a("complement(");
        toText(fftt,sb);
        if(compl) sb.a(')');
        return sb;

    }
    private static BA toText(int[][]fftt,BA sb){
        if(sb==null) sb=new BA(99);
        final int[]ff=fftt[0],tt=fftt[1];
        FORi(0,ff.length){
            final int f=ff[i],t=tt[i];
            if(i>0) sb.a(',');
            sb.a(f+1);
            if(f<t-1) sb.a("..").a(t);
        }
        return sb;
    }

    public static int[][]parseBitset(Object s,int openEnd){
        final boolean[]digt=chrClas(DIGT),no_digt=chrClas(-DIGT);
        final byte[]T=toByts(s);
        final ChTokenizer tok=toknzr(332,COMMA_PARENTHESES).setText(T,nxt(0,chrClas(DIGT),T),MAX_INT);
        int ff[]=new int[9],tt[]=new int[9],count=0;
        while(tok.nextToken()){
            final int
                idx1=tok.from(),
                e=tok.to(),
                idx2=idx1<e && 0>nxt(no_digt,T,idx1,e)?idx1:
                maxi(strstr(STR_AFTER,"..",T,idx1,e),strstr(STR_AFTER,">",T,idx1,e));/*X  strstr performance !*/

            if(idx2<0) continue;
            final int from=atoi(T,idx1,e)-1,to=openEnd>0 && !isChrClas(digt,T,idx2)?openEnd:atoi(T,idx2,e);
            if(from<0 || from>=to) continue;
            int f=from,t=to;
            if(ff.length<=count) {ff=chSze(ff,count+10); tt=chSze(tt,count+10);}
            ff[count]=f;
            tt[count++]=t;
        }
        clr(tok);
        final int[][]fftt=new int[][]{ff,tt};
        tidy(fftt);
        return fftt;
    }

}
