package charite.christo;
import static charite.christo.ChUtils.*;
import java.io.*;
/* An input stream that decompresses from the BZip2 format (without the file */
/* header chars) to be read as any other stream. */
/* The decompression requires large amounts of memory. Thus you */
/* should call the {@link #close() close()} method as soon as */
/* possible, to force CBZip2InputStream to release the */
/* allocated memory.  See {@link CBZip2OutputStream */
/* CBZip2OutputStream} for information about memory usage. */
/* CBZip2InputStream reads bytes from the compressed */
/* source stream via the single byte {@link java.io.InputStream#read() */
/* read()} method exclusively. Thus you should consider to use a */
/* buffered source stream. */
/* Instances of this class are not threadsafe. */
/* License:  The Apache Software License, V 1.1 */
#define baseBlockSize 100000
#define MAX_ALPHA_SIZE 258
#define MAX_CODE_LEN 23
#define RUNA 0
#define RUNB 1
#define N_GROUPS 6
#define G_SIZE 50
#define N_ITERS 4
#define MAX_SELECTORS (2+(900000/G_SIZE))
#define NUM_OVERSHOOT_BYTES 20
#define EOF 0
#define START_BLOCK_STATE 1
#define RAND_PART_A_STATE 2
#define RAND_PART_B_STATE 3
#define RAND_PART_C_STATE 4
#define NO_RAND_PART_A_STATE 5
#define NO_RAND_PART_B_STATE 6
#define NO_RAND_PART_C_STATE 7
#define MK_RNUMS() if(_rNums==null) _rNums=intArry(RSC_BZIP2_IN_STREAM_RNUM)
#define initialiseCRC() _globalCrc=0xffffffff
#define bsGetUByte() ((char)bsR(8))
#define bsGetInt()  (((((bsR(8)<<8)|bsR(8))<<8)|bsR(8))<<8)|bsR(8)
#define SETUP_NORAND 0
#define SETUP_RAND 1
public final class CBZip2InputStream extends FilterInputStream{
    private static int[]_rNums,_crc32Table;
    private void updateCRC(int inCh){
        if(_crc32Table==null)_crc32Table=intArry(RSC_BZIP2_IN_STREAM_CRC);
        //baOut(DEBUG_NOW+"RSC_BZIP2_IN_STREAM_CRC=").aln(rsc(RSC_BZIP2_IN_STREAM_CRC));
        //baOut(DEBUG_NOW+" _crc32Table ").aIntArray(_crc32Table,0,MAX_INT).aln().a("L=").a(_crc32Table.length).aln().special(DIE_NOW);
        int temp=(_globalCrc>>24)^inCh;
        if(temp<0)temp=256+temp;
        _globalCrc=(_globalCrc<<8)^_crc32Table[temp];
    }
    private int
        _tt[],
        _globalCrc,
        _last,/*X Index of the last char in the block,so the block size==last+1. */
        _origPtr,/*X Index in zptr[] of original string after sorting. */
/* always: in the range 0 .. 9. The current block size is 100000*this number.  */
        _blockSize100k,
        _bsBuff,
        _bsLive,
        _currentChar=-1,
        _nInUse,
        _currentState=START_BLOCK_STATE,_storedBlockCRC,_storedCombinedCRC,_computedBlockCRC,_computedCombinedCRC;
    private boolean _blockRandomised;
    private int
        _su_count,
        _su_ch2,
        _su_chPrev,
        _su_i2,
        _su_j2,
        _su_rNToGo,
        _su_rTPos,
        _su_tPos;
    private char _su_z;
    private byte[]_ll8;
    private final boolean[]_inUse=new boolean[256];
    private final byte[]_seqToUnseq=new byte[256],_selector=new byte[MAX_SELECTORS],_selectorMtf=new byte[MAX_SELECTORS],_recvDecodingTables_pos=new byte[N_GROUPS];
    private final int[]_unzftab=new int[256],_limit[]=new int[N_GROUPS][MAX_ALPHA_SIZE],_base[]=new int[N_GROUPS][MAX_ALPHA_SIZE],_perm[]=new int[N_GROUPS][MAX_ALPHA_SIZE],_minLens=new int[N_GROUPS],_cftab=new int[257];
    private final char[]_yy=new char[256],_temp_charArray2d[]=new char[N_GROUPS][MAX_ALPHA_SIZE];
    public CBZip2InputStream(InputStream in)throws IOException{
        super(in);
        initialiseCRC();
        if(in.read()!='B'||in.read()!='Z'||in.read()!='h'||(_blockSize100k=in.read()-'0')<1||_blockSize100k>9)throw ioexceptn(IOEXCEPT_ILLEGAL_BLOCKSIZE,this);
        initBlock();
    }
    OVERRIDE_PUBLIC int read(byte[]dest,int offs,int len)
        throws IOException{
        if(offs<0||len<0||offs+len>dest.length)throw ioexceptn(IOEXCEPT_INDEXOUTOFBOUNDS,this);
        int destOffs=offs;
        for(int HI=offs+len,b;destOffs<HI&&(b=read())>=0;)dest[destOffs++]=(byte)b;
        return destOffs==offs?-1:destOffs-offs;
    }
    OVERRIDE_PUBLIC int read()throws IOException{
        final int ret=_currentChar;
        switch (_currentState){
        case EOF:return -1;
        case START_BLOCK_STATE:
        case RAND_PART_A_STATE:throw ioexceptn(IOEXCEPT_ILLEGAL_STATE,this);
        case RAND_PART_B_STATE:{
            MK_RNUMS();
            if(_su_ch2!=_su_chPrev){
                _currentState=RAND_PART_A_STATE;
                _su_count=1;
                setupPartA(SETUP_RAND);
            }else if(++_su_count>=4){
                _su_z=(char)(_ll8[_su_tPos]&0xff);
                _su_tPos=_tt[_su_tPos];
                if(_su_rNToGo==0){
                    _su_rNToGo=_rNums[_su_rTPos]-1;
                    if(++_su_rTPos==512)_su_rTPos=0;
                }else _su_rNToGo--;
                _su_j2=0;
                _currentState=RAND_PART_C_STATE;
                if(_su_rNToGo==1) _su_z^=1;
                setupPartC(SETUP_RAND);
            }else{
                _currentState=RAND_PART_A_STATE;
                setupPartA(SETUP_RAND);
            }
            break;
        }
        case RAND_PART_C_STATE:setupPartC(SETUP_RAND);break;
        case NO_RAND_PART_A_STATE:throw ioexceptn(IOEXCEPT_ILLEGAL_STATE,this);
        case NO_RAND_PART_B_STATE:setupNoRandPartB();break;
        case NO_RAND_PART_C_STATE:setupPartC(SETUP_NORAND);break;
        default:throw ioexceptn(IOEXCEPT_ILLEGAL_STATE,this);
        }
        return ret;
    }
    private void initBlock()throws IOException{
        final char magic0=bsGetUByte();
        if(magic0==0x17&&bsGetUByte()==0x72&&bsGetUByte()==0x45&&bsGetUByte()==0x38&&bsGetUByte()==0x50&&bsGetUByte()==0x90){
/*.end_of_file*/
            _storedCombinedCRC=bsGetInt();
            _currentState=EOF;
            _ll8=null;
            if(_storedCombinedCRC!=_computedCombinedCRC)ioexceptn(IOERROR_CRC_ERROR,this);
        }else if(magic0!=0x31||bsGetUByte()!=0x41||bsGetUByte()!=0x59||bsGetUByte()!=0x26||bsGetUByte()!=0x53||bsGetUByte()!=0x59){
            _currentState=EOF;
            throw ioexceptn(IOEXCEPT_BAD_BLOCK_HEADER,this);
        }else{
            _storedBlockCRC=bsGetInt();
            _blockRandomised=bsR(1)==1;
/* Allocate data here instead in constructor,so we do not allocate it if the input file is empty. */
            if(_ll8==null)_ll8=new byte[_blockSize100k*baseBlockSize];
            // currBlockNo++;
            {/*X getAndMoveToFrontDecode()throws IOException{*/
                _origPtr=bsR(24);
                recvDecodingTables();
                final byte[]ll8=_ll8;
                final int limitLast=_blockSize100k*100000;
/* Setting up the unzftab entries here is not strictly necessary,but it does save having to do it later */
/* in a separate pass,and so saves a block's worth of cache misses. */
                ROFi0(256)_unzftab[_yy[i]=(char)i]=0;
                final int eob=_nInUse+1;
                int groupNo=0,groupPos=G_SIZE-1,nextSym=getAndMoveToFrontDecode0(0),bsBuff=_bsBuff,bsLive=_bsLive,last=-1,zt=_selector[groupNo]&0xff;
                int[]base_zt=_base[zt],limit_zt=_limit[zt],perm_zt=_perm[zt];
                int minLens_zt=_minLens[zt];
                while(nextSym!=eob){
                    if((nextSym==RUNA)||(nextSym==RUNB)){
                        int s=-1;
                        for(int n=1;;n<<=1){
                            if(nextSym==RUNA)s+=n;
                            else if(nextSym==RUNB)s+=n<<1;
                            else break;
                            if(groupPos==0){
                                groupPos=G_SIZE-1;
                                base_zt=_base[zt=_selector[++groupNo]&0xff];
                                limit_zt=_limit[zt];
                                perm_zt=_perm[zt];
                                minLens_zt=_minLens[zt];
                            }else groupPos--;
                            int zn=minLens_zt;
                            // Inlined:
                            // int zvec=bsR(zn);
                            while(bsLive<zn){
                                final int c=in.read();
                                if(c>=0){
                                    bsBuff=(bsBuff<<8)|c;
                                    bsLive+=8;
                                    continue;
                                }
                                throw ioexceptn(IOEXCEPT_UNEXPECTED_END_OF_STREAM,this);
                            }
                            int zvec=(bsBuff>>(bsLive-zn))&((1<<zn)-1);
                            bsLive-=zn;
                            while(zvec>limit_zt[zn]){
                                zn++;
                                while(bsLive<1){
                                    final int c=in.read();
                                    if(c>=0){
                                        bsBuff=(bsBuff<<8)|c;
                                        bsLive+=8;
                                        continue;
                                    }
                                    throw ioexceptn(IOEXCEPT_UNEXPECTED_END_OF_STREAM,this);
                                }
                                bsLive--;
                                zvec=(zvec<<1)|((bsBuff>>bsLive)&1);
                            }
                            nextSym=perm_zt[zvec-base_zt[zn]];
                        }
                        final byte ch=_seqToUnseq[_yy[0]];
                        _unzftab[ch&0xff]+=s+1;
                        while(s-->=0)ll8[++last]=ch;
                        if(last>=limitLast)throw ioexceptn(IOEXCEPT_BLOCK_OVERRUN,this);
                    }else{
                        if(++last>=limitLast)ioexceptn(IOEXCEPT_BLOCK_OVERRUN,this);
                        final char tmp=_yy[nextSym-1];
                        _unzftab[_seqToUnseq[tmp]&0xff]++;
                        ll8[last]=_seqToUnseq[tmp];
                        if(nextSym<=16){
                            for(int j=nextSym-1;j>0;)_yy[j]=_yy[--j];
                        }else System.arraycopy(_yy,0,_yy,1,nextSym-1);
                        _yy[0]=tmp;
                        if(groupPos==0){
                            groupPos=G_SIZE-1;
                            base_zt=_base[zt=_selector[++groupNo]&0xff];
                            limit_zt=_limit[zt];
                            perm_zt=_perm[zt];
                            minLens_zt=_minLens[zt];
                        }else groupPos--;
                        int zn=minLens_zt;
                        // Inlined:
                        // int zvec=bsR(zn);
                        while(bsLive<zn){
                            final int c=in.read();
                            if(c>=0){
                                bsBuff=(bsBuff<<8)|c;
                                bsLive+=8;
                                continue;
                            }
                            throw ioexceptn(IOEXCEPT_UNEXPECTED_END_OF_STREAM,this);
                        }
                        int zvec=(bsBuff>>(bsLive-zn))&((1<<zn)-1);
                        bsLive-=zn;
                        while(zvec>limit_zt[zn]){
                            zn++;
                            while(bsLive<1){
                                final int c=in.read();
                                if(c>=0){
                                    bsBuff=(bsBuff<<8)|c;
                                    bsLive+=8;
                                    continue;
                                }else throw ioexceptn(IOEXCEPT_UNEXPECTED_END_OF_STREAM,this);
                            }
                            zvec=(zvec<<1)|((bsBuff>>--bsLive)&1);
                        }
                        nextSym=perm_zt[zvec-base_zt[zn]];
                    }
                }
                _last=last;
                _bsLive=bsLive;
                _bsBuff=bsBuff;
            }/*X getAndMoveToFrontDecode()*/
            initialiseCRC();
            _currentState=START_BLOCK_STATE;
        }
/* setupBlock()throws IOException */
        if(_ll8!=null){
            if(_tt==null||_tt.length<_last+1)_tt=new int[_last+1];
            _cftab[0]=0;
            System.arraycopy(_unzftab,0,_cftab,1,256);
            for(int i=1,c=_cftab[0];i<=256;i++)_cftab[i]=(c+=_cftab[i]);
            for(int i=0,last=_last;i<=last;i++)_tt[_cftab[_ll8[i]&0xff]++]=i;
            if(_origPtr<0||_origPtr>=_tt.length)throw ioexceptn(IOEXCEPT_CORRUPT_INPUT,this);
            _su_tPos=_tt[_origPtr];
            _su_count=_su_i2=0;
            _su_ch2=256;/*X  not a char and not EOF */
            if(_blockRandomised){
                _su_rNToGo=_su_rTPos=0;
                setupPartA(SETUP_RAND);
            }else setupPartA(SETUP_NORAND);
        }
    }
    private int bsR(int n)throws IOException{
        int bsLive=_bsLive,bsBuff=_bsBuff;
        if(bsLive<n){
            do{
                final int c=in.read();
                if(c<0)throw ioexceptn(IOEXCEPT_UNEXPECTED_END_OF_STREAM,this);
                bsBuff=(bsBuff<<8)|c;
                bsLive+=8;
            }while(bsLive<n);
            _bsBuff=bsBuff;
        }
        return (bsBuff>>(_bsLive=bsLive-n))&((1<<n)-1);
    }
    private boolean bsGetBit()throws IOException{
        if(_bsLive<1){
            final int c=in.read();
            if(c<0)throw ioexceptn(IOEXCEPT_UNEXPECTED_END_OF_STREAM,this);
            _bsBuff=(_bsBuff<<8)|c;
            _bsLive+=8;
        }
        return ((_bsBuff>>(--_bsLive))&1)!=0;
    }

    private static void hbCreateDecodeTables(int[]limit,int[]base,int[]perm,char[]length,int minLen,int maxLen,int alphaSize){
        for(int i=minLen,pp=0;i<=maxLen;i++){
            for(int j=0;j<alphaSize;j++)if(length[j]==i)perm[pp++]=j;
        }
        for(int i=MAX_CODE_LEN;--i>0;)base[i]=limit[i]=0;
        for(int i=0;i<alphaSize;i++)base[length[i]+1]++;
        for(int i=1,b=base[0];i<MAX_CODE_LEN;i++)base[i]=b+=base[i];
        for(int i=minLen,vec=0,b=base[i];i<=maxLen;i++){
            final int nb=base[i+1];
            limit[i]=(vec+=nb-b)-1;
            b=nb;
            vec<<=1;
        }
        for(int i=minLen+1;i<=maxLen;i++)base[i]=((limit[i-1]+1)<<1)-base[i];
    }
    private void recvDecodingTables()throws IOException{
        {
            int inUse16=0;
/* Receive the mapping table */
            for(int i=0;i<16;i++)if(bsGetBit())inUse16|=1<<i;
            ROFi0(256)_inUse[i]=false;
            for(int i=0;i<16;i++){
                if((inUse16&(1<<i))!=0)for(int j=0;j<16;j++)if(bsGetBit())_inUse[(i<<4)+j]=true;
            }
        }
        {
            int nInUse=0;
            for(int i=0;i<256;i++)if(_inUse[i])_seqToUnseq[nInUse++]=(byte)i;
            _nInUse=nInUse;
        }
        final int alphaSize=_nInUse+2,nGroups=bsR(3),nSelectors=bsR(15);
        for(int i=0;i<nSelectors;i++){
            int j=0;
            while(bsGetBit())j++;
            _selectorMtf[i]=(byte)j;
        }
/* Undo the MTF values for the selectors. */
        ROFi0(nGroups)_recvDecodingTables_pos[i]=(byte)i;
        for(int i=0;i<nSelectors;i++){
            int v=_selectorMtf[i]&0xff;
            final byte tmp=_recvDecodingTables_pos[v];
            while(v>0){
                // nearly all times v is zero,4 in most other cases
                _recvDecodingTables_pos[v]=_recvDecodingTables_pos[v-1];
                v--;
            }
            _selector[i]=_recvDecodingTables_pos[0]=tmp;
        }
/* Now the coding tables */
        for(int t=0;t<nGroups;t++){
            int curr=bsR(5);
            final char[]len_t=_temp_charArray2d[t];
            for(int i=0;i<alphaSize;i++){
                while(bsGetBit())curr+=bsGetBit()?-1:1;
                len_t[i]=(char)curr;
            }
        }
        // finally create the Huffman tables
        for(int t=0;t<nGroups;t++){
            int minLen=32,maxLen=0;
            final char[]len_t=_temp_charArray2d[t];
            ROFi0(alphaSize){
                final char l=len_t[i];
                if(l>maxLen)maxLen=l;
                if(l<minLen)minLen=l;
            }
            hbCreateDecodeTables(_limit[t],_base[t],_perm[t],_temp_charArray2d[t],minLen,maxLen,alphaSize);
            _minLens[t]=minLen;
        }
    }
    private int getAndMoveToFrontDecode0(int groupNo)throws IOException{
        final int zt=_selector[groupNo]&0xff,limit_zt[]=_limit[zt];
        int zn=_minLens[zt],zvec=bsR(zn),bsLive=_bsLive,bsBuff=_bsBuff;
        while(zvec>limit_zt[zn]){
            zn++;
            while(bsLive<1){
                final int c=in.read();
                if(c>=0){
                    bsBuff=(bsBuff<<8)|c;
                    bsLive+=8;
                    continue;
                }
                throw ioexceptn(IOEXCEPT_UNEXPECTED_END_OF_STREAM,this);
            }
            zvec=(zvec<<1)|((bsBuff>>--bsLive)&1);
        }
        _bsLive=bsLive;
        _bsBuff=bsBuff;
        return _perm[zt][zvec-_base[zt][zn]];
    }
    private void setupPartA(int t)throws IOException{
        MK_RNUMS();
        if(_su_i2<=_last){
            _su_chPrev=_su_ch2;
            int su_ch2=_ll8[_su_tPos]&0xff;
            if(t==SETUP_RAND){
                _su_tPos=_tt[_su_tPos];
                if(_su_rNToGo==0){
                    _su_rNToGo=_rNums[_su_rTPos]-1;
                    if(++_su_rTPos==512)_su_rTPos=0;
                }else _su_rNToGo--;
                _currentChar=_su_ch2=(su_ch2^=(_su_rNToGo==1)?1:0);
                _currentState=RAND_PART_B_STATE;
            }else{
                _currentChar=_su_ch2=su_ch2;
                _su_tPos=_tt[_su_tPos];
                _currentState=NO_RAND_PART_B_STATE;
            }
            _su_i2++;
            updateCRC(su_ch2);
        }else{
/* endBlock()*/
            _computedBlockCRC=~_globalCrc;
            // A bad CRC is considered a fatal error.
            if(_storedBlockCRC!=_computedBlockCRC){
                // make next blocks readable without error
                // (repair feature,not yet documented,not tested)
                _computedCombinedCRC=((_storedCombinedCRC<<1)|(_storedCombinedCRC>>>31))^_storedBlockCRC;
                ioexceptn(IOERROR_CRC_ERROR,this);
            }
            _computedCombinedCRC=((_computedCombinedCRC<<1)|(_computedCombinedCRC>>>31))^_computedBlockCRC;
            initBlock();
        }
    }
    private void setupPartC(int t)throws IOException{
        if(_su_j2<_su_z){
            updateCRC(_currentChar=_su_ch2);
            _su_j2++;
            if(t==SETUP_NORAND)_currentState=NO_RAND_PART_C_STATE;
        }else{
            if(t==SETUP_RAND)_currentState=RAND_PART_A_STATE;
            _su_i2++;
            _su_count=0;
            setupPartA(t);
        }
    }
    private void setupNoRandPartB()throws IOException{
        if(_su_ch2!=_su_chPrev){
            _su_count=1;
            setupPartA(SETUP_NORAND);
        }else if(++_su_count>=4){
            _su_z=(char)(_ll8[_su_tPos]&0xff);
            _su_tPos=_tt[_su_tPos];
            _su_j2=0;
            setupPartC(SETUP_NORAND);
        }else{
            setupPartA(SETUP_NORAND);
        }
    }
}
#undef EOF
#undef G_SIZE
#undef MAX_ALPHA_SIZE
#undef MAX_CODE_LEN
#undef MAX_SELECTORS
#undef NO_RAND_PART_A_STATE
#undef NO_RAND_PART_B_STATE
#undef NO_RAND_PART_C_STATE
#undef NUM_OVERSHOOT_BYTES
#undef N_GROUPS
#undef N_ITERS
#undef RAND_PART_A_STATE
#undef RAND_PART_B_STATE
#undef RAND_PART_C_STATE
#undef RUNA
#undef RUNB
#undef START_BLOCK_STATE
#undef baseBlockSize
#undef initialiseCRC
