package charite.christo;
import static charite.christo.ChUtils.*;
/**   A fast Tokenizer   @author Christoph Gille */
public class ChTokenizer{
    private byte[]_T;
    private int _pos,_E,_f,_t;
    private final boolean[]_delim;
    private String _asStr;
#if CPP_DEACTIVATED
    public int countTokens(){
        final int oldPos=_pos;
        int count=0;
        while(nextToken()) count++;
        _pos=oldPos;
        return count;
    }
#endif //CPP_DEACTIVATED
    public int asBits(){return charsToBitsSkipSpc(_T,_f,_t-_f);}
    public byte[]bytes(){return _T;}

    public ChTokenizer setText(BA ba) {if(ba!=null) setText(ba.bytes(),ba.begin(),ba.end()); return this;}
    public ChTokenizer setText(byte[]T,int b,int e){
        _asStr=null; _f=_t=-1; _T=T; _pos=b; _E=e;
        if(_T!=null && _T.length<_E) _E=_T.length;
        return this;
    }
    public ChTokenizer(int cc) {this(chrClas(cc));}
    public ChTokenizer(boolean[]charClass) {_delim=charClass;}

    public boolean eq(String s){
        return s!=null && _f>=0 && _t-_f==s.length() &&  strEquAt(0,s,_T,_f);
    }
    public int from(){return _f;}
    public int to(){return _t;}
    public boolean tokEquals(int strOpt,String s){
        return s!=null && s.length()==_t-_f && strEquAt(strOpt,s,_T,_f);
    }
    public boolean nextToken(){
        _asStr=null;
        final byte[]T=_T;
        if(T==null || _pos<0) {_f=_t=0;return false;}
        final int end=mini(T.length,_E);
        while(_pos<end && T[_pos]>=0 && _delim[T[_pos]]) _pos++;
        if(_pos>=end) {_f=_t=0;return false;}
        _f=_pos++;
        while(_pos<end && !(T[_pos]>=0 && _delim[T[_pos]])) _pos++;
        _t=_pos;
        if(_f>=0 && _f<_t && _t<=end){
            if(T[_f]=='"' && T[_t-1]=='"') {_f++;_t--;}
            return true;
        }
        return false;
    }
    IF_GUI(public String nextAsString(){return nextToken()?asString():null;})
#if CPP_DEACTIVATED
    public String remainingAsString(boolean trim){
        if(!nextToken()) return null;
        final int e=mini(SZE(_T),_E);
        return _f<0 || _f>e?null: trim?toStrgTrim(_T,_f,e): byts2strg(_T,_f,e);
    }
#endif //CPP_DEACTIVATED
    public String asString(){
        String s=_asStr;
        if(s==null) s=_asStr=s(_T,_f,_t);
        return s;
    }
    public byte asChar(){return iThByte(_f,_T);}
    //    public byte[]asBytes(){return newByts(_T,_f,_t);}
    public int asInt(){return (int)asLong(false);}

    public long asLong(boolean allowHex){
        final byte[]T=_T;
        int e=T==null?-1:mini(T.length,_t),f=nxt(0,chrClas(-SPC),T,_f,e);
        if(f<0 || f>=(e=eolTrim(T,f,e))) return INT_NAN;
        if(allowHex&&e-f>2&&T[f]=='0'&&(T[f+1]|32)=='x') return hexToLong(T,f+2,e);
        if(T[f]=='+') f++;
        //if ( f>=e || !is(DIGT_DASH,T,f) || f+1<e && !(cntainsOnly(DIGT,T,f+1,e))) return INT_NAN;
        if(f>=e || !isChrClas(DIGT_DASH,T,f) || 0<=nxt(chrClas(-DIGT),T,f+1,e)) return INT_NAN;
        return atol(T,f,e);
    }
    public double asFloat(){
        final int
            e=_T==null?-1: mini(_T.length,_t),
            f=nxt(0,chrClas(-SPC),_T,_f,e),
            t=f<0?0:eolTrim(_T,f,e);
        return f>=0 && isFloat(_T,f,t)?atof(_T,f,t): Double.NaN;
    }
}
