public static byte[]triplets2aa(boolean cutTerminalX,byte[]cds,int L){
    if(cds==null) return null;
    ASSIGN_LE_LENGTH(L,cds);
    if(cutTerminalX && (L-=L%3)>0 && triplet2a(L-3,cds)=='X') L-=3;
    final byte[]aa=new byte[mini(cds.length,L)/3];
    for(int i=0,i3=0;i<aa.length; i++,i3+=3) aa[i]=triplet2a(i3,cds);
    return aa;
}
private static byte triplet2a(int i,byte[]cds){
    byte[]t2a=_tripletToAmino;
    if(t2a==null){
        _initTriplet();
        t2a=_tripletToAmino;
    }
    return t2a[ (XACTG01234[127&cds[i]]<<6) | (XACTG01234[127&cds[i+1]]<<3) | (XACTG01234[127&cds[i+2]]) ];
}
// ----------------------------------------
static{
    final byte[]c=COMPLEMENT_BASE;
    c['a']=(byte)'t'; c['t']=c['u']=(byte)'a'; c['c']=(byte)'g'; c['g']=(byte)'c';
    c['A']=(byte)'T'; c['T']=c['U']=(byte)'A'; c['C']=(byte)'G'; c['G']=(byte)'C';
    c['.']=(byte)'.';
}

// ----------------------------------------
/** standard codon translation table  triplet2aa['T']['G']['G'] returns W for Tryptophan */

@*RSC_triplet2a
 GCT GCC GCA GCG
 B
 TGT TGC
 GAT GAC
 GAA GAG
 TTT TTC
 GGT GGC GGA GGG
 CAT CAC
 ATT ATC ATA
 J
 AAA AAG
 TTG TTA CTT CTC CTA CTG
 ATG
 AAT AAC
 O
 CCT CCC CCA CCG
 CAA CAG
 CGT CGC CGA CGG AGA AGG
 TCT TCC TCA TCG AGT AGC
 ACT ACC ACA ACG
 U
 GTT GTC GTA GTG
 TGG
 X
 TAT TAC
*@
private static byte[]_tripletToAmino;
private static void _initTriplet(){
    {
        final int[]nn=XACTG01234;
        nn['A']=nn['a']=1;
        nn['C']=nn['c']=2;
        nn['T']=nn['t']=nn['U']=nn['u']=3;
        nn['G']=nn['g']=5;
    }
    final byte[]r=new byte[(7<<6)+(7<<3)+7];
    Arrays.fill(r,(byte)'X');
    final BA sb=rsc(RSC_triplet2a);
    final byte[]T=sb.bytes();
    final int eol[]=sb.eol();
    ROFiL0(eol.length)
        for(int e=eol[iL],i=BOL0(iL,eol);i<e; i+=4)
            r[(XACTG01234[T[i]]<<6)+(XACTG01234[T[i+1]]<<3)+XACTG01234[T[i+2]]]=(byte)(iL+'A');
    _tripletToAmino=r;
}
