#define INIT_BITS 9
#define TBL_CLEAR 0x100
#define TBL_FIRST 0x101
#define EXTRA 64
#define LZW_MAGIC   0x1f9d
#define HDR_MAXBITS  0x1f
#define HDR_EXTENDED 0x20
#define HDR_FREE      0x40
#define HDR_BLOCK_MODE 0x80
#define uncomressReset(bitPos) System.arraycopy(data,(bitPos>>3),data,0,end-(bitPos>>3));end-=(bitPos>>3)
//#define _debugPrint(a) baOut(ANSI_MAGENTA+"Uncompress "+ANSI_RESET).aln(a)
#define _debugPrint(a)

/* https://jsms.com.br/svn/tags/initial/HTTPClient/UncompressInputStream.java */
#define _uncompressDotZWarn(code) ioexceptn(code,f)
private static BA _uncompressDotZ(byte[] data,int L,File f){
    _debugPrint(" t1="+unsignedInt(data[0]));
    if((unsignedInt(data[0])<<8)+unsignedInt(data[1])!=LZW_MAGIC){
        _uncompressDotZWarn(IOEXCEPT_NOT_IN_COMPRESS_FORMAT);
        return null;
    }
/* read in header byte */
    _debugPrint(" t="+unsignedInt(data[2]));
    final boolean block_mode=(unsignedInt(data[2])&HDR_BLOCK_MODE)>0;
    final int maxbits=unsignedInt(data[2])&HDR_MAXBITS;
    {
        final int err=maxbits>UNCOMPRESS_MAX_BITS?IOEXCEPT_MAXBITS:
            (unsignedInt(data[2])&HDR_EXTENDED)>0?IOEXCEPT_HEADER_EXTENSION_BIT_SET:
            (unsignedInt(data[2])&HDR_FREE)>0?IOEXCEPT_HEADER_BIT_6_SET:0;
        if(err!=0){
            _uncompressDotZWarn(err);
            return null;
        }
    }
    _debugPrint("BLOCK MODE: "+block_mode);
    _debugPrint("max bits:   "+maxbits);
    byte finchar=0,buf[]=new byte[L/2+999];
    int off=0,n_bits=INIT_BITS,oldcode=-1,bit_pos=0,maxcode=(1<<INIT_BITS)-1,bitmask=maxcode,stackp=1<<maxbits,free_ent=block_mode?TBL_FIRST:256;
    final int tab_prefix[]=new int[stackp];
    final byte[]tab_suffix=new byte[stackp],stack=new byte[stackp];
    ROFi0(255)tab_suffix[i]=(byte)i;
    // loop,filling local buffer until enough data has been decompressed
    int got=L-3,end=got;
    System.arraycopy(data,3,data,0,got);
 main_loop:do{
        //if(end<EXTRA&& (got=in.read(data,end,data.length-1-end))>0)end+=got;
        if(end<EXTRA) got=-1;
        final int bit_in=(got>0)?(end-end%n_bits)<<3:(end<<3)-(n_bits-1);
        _debugPrint(" Continue main_loop "+got);
        while(bit_pos<bit_in){
            // check for code-width expansion
            if(free_ent>maxcode){
                bit_pos=(bit_pos-1)+(n_bits<<3)-(bit_pos-1+(n_bits<<3))%(n_bits<<3);
                n_bits++;
                maxcode=(n_bits==maxbits)?(1<<maxbits):(1<<n_bits)-1;
                _debugPrint("Code-width expanded to "+n_bits);
                bitmask=(1<<n_bits)-1;
                uncomressReset(bit_pos);
                bit_pos=0;
                continue main_loop;
            }
            // read next code
            int code=(((data[(bit_pos>>3)]&0xFF)|((data[(bit_pos>>3)+1]&0xFF)<<8)|
                       ((data[(bit_pos>>3)+2]&0xFF)<<16))>>(bit_pos&0x7))&bitmask;
            bit_pos+=n_bits;
            // handle first iteration
            if(buf.length<off+2+stack.length) buf=chSze(buf,off+stack.length+1000);
            if(oldcode==-1){
                if(code>=256) _uncompressDotZWarn(IOEXCEPT_CORRUPT_INPUT);
                buf[off++]=finchar=(byte)(oldcode=code);
                continue;
            }
            // handle CLEAR code
            if(code==TBL_CLEAR&&block_mode){
                Arrays.fill(tab_prefix,0,256,0);
                free_ent=TBL_FIRST-1;
                bit_pos=(bit_pos-1)+(n_bits<<3)-(bit_pos-1+(n_bits<<3))%(n_bits<<3);
                n_bits=INIT_BITS;
                bitmask=maxcode=(1<<INIT_BITS)-1;
                _debugPrint("Code tables reset");
                uncomressReset(bit_pos);
                bit_pos=0;
                continue main_loop;
            }
            // setup
            final int incode=code;
            stackp=stack.length;
            // Handle KwK case
            if(code>=free_ent){
                if(code>free_ent) _uncompressDotZWarn(IOEXCEPT_CORRUPT_INPUT);
                stack[--stackp]=finchar;
                code=oldcode;
            }
            // Generate output characters in reverse order
            while(code>=256){
                stack[--stackp]=tab_suffix[code];
                code=tab_prefix[code];
            }
            buf[off++]=finchar=tab_suffix[code];
            // And put them out in forward order
#define s_size (stack.length-stackp)
            System.arraycopy(stack,stackp,buf,off,s_size);
            off+=s_size;
#undef s_size
            // generate new entry in table
            if(free_ent<(1<<maxbits)){
                tab_prefix[free_ent]=oldcode;
                tab_suffix[free_ent]=finchar;
                free_ent++;
            }
            oldcode=incode;
        }
        uncomressReset(bit_pos);
        bit_pos=0;
        _debugPrint(" end loop");
    }while(got>0);
    return new BA(buf,0,off);
}
//#if CPP_DEACTIVATED_MAIN
//UncompressInputStream
//    java test.Uncompress
public static void main(String argv[]) throws Exception {
    final boolean bz2=true;
    for(String a:argv){
        if(a.indexOf(':')>=0)continue;
        final File f=file(a),compressed=file("~/m1/compress/testCompress/"+nam(f)+(bz2?".bz2":".Z"));
        baOut("").aFile(f).a(' ').aFile(compressed).aln();
        final BA txt1=readBytes(a),txt2=readBytes(compressed);
        //putln(txt2);
        baOut("    ").aFile(compressed).aa(' ',sze(txt1),' ',sze(txt2),' ').aln(txt1==null||txt2==null?ANSI_RED+"NULL"+ANSI_RESET:txt1.hashCode()==txt2.hashCode()?GREEN_SUCCESS:RED_FAILED);
    }
}
//#endif //CPP_DEACTIVATED_MAIN

#undef _debugPrint
#undef EXTRA
#undef HDR_BLOCK_MODE
#undef HDR_EXTENDED
#undef HDR_FREE
#undef HDR_MAXBITS
#undef INIT_BITS
#undef LZW_MAGIC
#undef TBL_CLEAR
#undef TBL_FIRST
