package charite.christo;
import java.awt.Image;
import java.io.File;
import static charite.christo.ChUtils.*;
//<BR><BR><B>List currently images:</B> <i>HTMLDOC_BUTTON:SBUT_TABLE_ICONS!</i>.
public class ImgUtils IF_GUI(extends java.awt.image.RGBImageFilter) implements ChRunnable,java.awt.image.ImageObserver{

#if CPP_WITH_GUI
#define _mapBase64 mapNoClr(363)
/* <<<  <<< */
/* ---------------------------------------- */
/* >>> Instances of this class serve as RGBImageFilter >>> */
    int _filterType,_filterRGB=0xff;
    OVERRIDE_PUBLIC int filterRGB(int x,int y,int rgb){
        int
            b=(rgb>>>0)&255,
            g=(rgb>>>8)&255,
            r=(rgb>>>16)&255;
        final int a=(rgb>>>24)&255;
        switch(_filterType){
        case IMGFILTER_BLACK_TO_TRANSPARENT:return r<9&&g<9&&b<9?0:rgb;
        case IMGFILTER_WHITE_TO_TRANSPARENT:return r>222&&g>222&&b>222?0:rgb;
        case IMGFILTER_INVERT_COLORS:return(255-b)|((255-g)<<8)|((255-r)<<16)|(a<<24);
        case IMGFILTER_GRAY:{
            int v=(r+g+b)/3;
            if(v>255) v=255;
            return v|(v<<8)|(v<<16)|(a<<24);
        }
        case IMGFILTER_BRIGHTER_4:{
#define fBrighter 4f
            if((b=(int)(b*fBrighter))>255) b=255;
            if((g=(int)(g*fBrighter))>255) g=255;
            if((r=(int)(r*fBrighter))>255) r=255;
            return b|(g<<8)|(r<<16)|(a<<24);
#undef fBrighter
        }
        case IMGFILTER_MONOCHROME:{
            final int s=(r+g+b)/3,f=_filterRGB;
            b=(s*((f)&255))>>8;
            g=(s*((f>>>8)&255))>>8;
            r=(s*((f>>>16)&255))>>8;
            return b|(g<<8)|(r<<16)|(a<<24);
        }
        case IMGFILTER_RED:return ((((3*256-(r+g+b))/3)&0xFF)<<16)|(a<<24);
        }
        return 0;
    }
/* <<< RGBImageFilter <<< */
/* ---------------------------------------- */
/* >>>  >>> */

#endif //CPP_WITH_GUI

#define isJpg (bg==0)
    public static java.awt.image.BufferedImage getScaled(Image im,int w,int h,int bg){
        if(im==null) return null;
        final java.awt.image.BufferedImage scaled=new java.awt.image.BufferedImage(w,h,isJpg?BufferedImage_TYPE_INT_RGB:BufferedImage_TYPE_INT_ARGB);
        final java.awt.Graphics2D g=scaled.createGraphics();
        g.setRenderingHint(java.awt.RenderingHints.KEY_INTERPOLATION,java.awt.RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if(bg!=0){
            g.setColor(new java.awt.Color(bg,true));
            g.fillRect(0,0,w,h);
        }
        g.drawImage(im,0,0,w,h,0,0,imgW(im),imgH(im),imgObserver());
        return scaled;
    }
#undef isJpg
    public static int imgH(Object i){
        return i==null?0:
            i instanceof java.awt.image.BufferedImage?((java.awt.image.BufferedImage)i).getHeight():
            i instanceof Image?((Image)i).getHeight(imgObserver()):
            i instanceof javax.swing.Icon?((javax.swing.Icon)i).getIconHeight():
            0;
    }
    public static int imgW(Object i){
        return i==null?0:
            i instanceof java.awt.image.BufferedImage?((java.awt.image.BufferedImage)i).getWidth():
            i instanceof Image?((Image)i).getWidth(imgObserver()):
            i instanceof javax.swing.Icon?((javax.swing.Icon)i).getIconWidth():
            0;
    }
    CPP_RUN_ID_ARG(){
        switch(id){
#if WRITE_CONCATENATED_JAVA||defined RUN_ImgUtilsW
            CASE_ARG(RUN_ImgUtilsW,Object,im) RETURN(new int[]{imgW(im)});
            CASE_ARG(RUN_ImgUtilsH,Object,im) RETURN(new int[]{imgH(im)});
#endif //WRITE_CONCATENATED_JAVA||defined RUN_ImgUtilsW
            CASE_ARGV(RUN_ImgUtilsGetScaled,java.awt.Image,im,int[],w_h_bg){
                final int[]wh=w_h_bg;
                RETURN(getScaled(im,wh[0],wh[1],wh[2]));
            }
#if WRITE_CONCATENATED_JAVA||defined RUN_ImgUtilsW
            CASE_ARG(RUN_ImgUtilsRead,File,f){
                try{return javax.imageio.ImageIO.read(f);}catch(Exception ex){}
                BREAK;
            }
            CASE_ARGV(RUN_ImgUtilsWrite,java.awt.image.BufferedImage,i,String,type,File,f){
                try{
                    javax.imageio.ImageIO.write(i,type,f);
                    return TRUEr;
                }catch(Exception ex){}
                BREAK;
            }
#endif //WRITE_CONCATENATED_JAVA||defined RUN_ImgUtilsW
#if WRITE_CONCATENATED_JAVA||defined RUN_ImgUtilsBase64ToIcon
            CASE_ARGV(RUN_ImgUtilsBase64ToIcon,String,data,File[],f){
                String DATAI=null;
                if(!strStarts(DATAI="image/",data) && !strStarts(DATAI="data:image/",data)) return null;
                Object ic=_mapBase64.get(data);
                if(ic==null){
                    final int base64=strstr(STR_AFTER,"base64,",data);
                    final BA decoded=base64<0?null: decode64(toByts(data),base64,MAX_INT);
                    ic=decoded==null?null:new javax.swing.ImageIcon(toByts(decoded));
                    if(imgW(ic)>0 && f!=null){
                        final String ext=data.substring(DATAI.length(),nxt(0,chrClas(-LETTR),data,DATAI.length(),MAX_INT));
                        f[0]=file(iPath2(DIR_PRGDATA_BASE64,ext).aa('/',data.hashCode(),'.',ext));
                        if(sze(f[0])==0) wrte(f[0],decoded);
                    }
                    if(imgW(ic)<=0){
                        ic=ALIAS_ERROR;
                        baOut(RED_WARNING).a("failed to decode ").aln(data);
                    }
                    _mapBase64.put(data,ic);
                }
                RETURN(ic);
            }
#endif //WRITE_CONCATENATED_JAVA||defined RUN_ImgUtilsBase64ToIcon
#if WRITE_CONCATENATED_JAVA||defined RUN_ImgUtilsIm2ic
            CASE_ARG(RUN_ImgUtilsIm2ic,Image,i){
                final javax.swing.ImageIcon ic=new javax.swing.ImageIcon();
                ic.setImage(i);
                RETURN(ic);
            }
#endif //WRITE_CONCATENATED_JAVA||defined RUN_ImgUtilsIm2ic
        }
        return null;
    }

/* <<<  <<< */
/* ---------------------------------------- */
/* >>>  >>> */
    OVERRIDE_PUBLIC_IF boolean imageUpdate(Image img,int infoflags,int x,int y,int width,int height) {return true;}

}
