package charite.christo;
import java.util.*;
import java.io.File;
import static charite.christo.ChUtils.*;
/* This Collection acts as a List with unique not-null elements. */
/* However, if initialized with UNIQL_AS_HashSet, it is  a HashSet. See newHashSet() */
/* It has a modification counter and can be converted into a reusable array. */
#if CPP_WITH_CHECK_CODE
#define _SUPER(expr) expr
#define _OR_SUPER(expr) _v.expr
#else
#define _SUPER(expr) super.expr
#define _OR_SUPER(expr) IF_GUI((_v!=null?_v.expr:super.expr)) UNLESS_GUI(super.expr)
#endif //CPP_WITH_CHECK_CODE

#if CPP_WITH_UNIQULIST_CHECK_HASHSET
private Collection _set;
#define IF_HASHSET(expr)  (_set==null||_set.expr&&)
private void checkHashSet(){
    if(_set==null) return;
    boolean err=_set.size()!=size();
    IF_MEIN_DEBUG(for(int i=size(); !err && --i>=0;) if(!_set.contains(get(i))) err=true);;
    if(err){
        baOut(RED_WARNING).aa("\nUniqueList _set=",_set,"\nthis=").aln(this);
        MEIN_ASSRT();
        _set.retainAll(this);
        _set.addAll(this);
    }
}
#else
#define IF_HASHSET(expr)
#endif //CPP_WITH_UNIQULIST_CHECK_HASHSET

public final class UniqueList<T>UNLESS_CHECK_CODE(extends Vector<T>) implements IF_CHECK_CODE(List<T>,)IF_GUI(HasWRef,ChRunnable,)HasMC{
    private static boolean _error;
    private int _mc,_arrayMC;
    private final Class _clazz;
    private Object IF_GUI(_renderer,_label,_ic,)_array;//,_nodeId
    public final int _opt;
    public UniqueList(int opt){
        _opt=opt;
        final Class c=iClass(opt);
        _clazz=c!=null?c:Object.class;
        IF_GUI(_v=0!=(opt&UNIQL_AS_HashSet)?new HashSet():null);
    }
#if CPP_WITH_GUI||CPP_WITH_CHECK_CODE
    private IF_GUI(final) Collection<T>_v;
#endif //CPP_WITH_GUI||CPP_WITH_CHECK_CODE
#if CPP_WITH_GUI

    CPP_CODE_HasWRef();
#endif //CPP_WITH_GUI
    OVERRIDE_PUBLIC int mc(){return _mc;}
    OVERRIDE_PUBLIC boolean equals(Object o) {return o==this;}
    @Override public int hashCode(){return System.identityHashCode(this);}
/* <<< Instance <<< */
/* ---------------------------------------- */
/* >>> Non-modifying methods for Collection  >>> */
    OVERRIDE_PUBLIC int size(){
        IF_GUI(runHooks(UNIQL_HOOK_ACCESS));;
        return _OR_SUPER(size());
    }
    OVERRIDE_PUBLIC boolean isEmpty(){return size()==0;}
    OVERRIDE_PUBLIC Object[]toArray(){
        if(size()>0) return _OR_SUPER(toArray());
        if(_emptyArray==null) _emptyArray=(T[])emptyArry(_clazz);
        return _emptyArray;
    }
    OVERRIDE_PUBLIC <T>T[]toArray(T[]a) {return _OR_SUPER(toArray(a));}
    OVERRIDE_PUBLIC boolean containsAll(Collection<?> c) {return sze(c)==0||_OR_SUPER(containsAll(c));}
    OVERRIDE_PUBLIC CPP_sync boolean contains(Object o){
        if(size()==0) return false;
        IF_GUI(if(_v!=null) return _v.contains(o));
#if CPP_WITH_UNIQULIST_CHECK_HASHSET
        if(0!=(_opt&UNIQL_USE_HASH_SET)){
            if(_set==null) (_set=new HashSet()).addAll(this);
            IF_UNIQULIST_CHECK_HASHSET(checkHashSet());
            return _set.contains(o);
        }
#endif //CPP_WITH_UNIQULIST_CHECK_HASHSET
        return indexOf(o)>=0;
    }
/* <<< Non-modifying methods for Collection <<< */
/* ---------------------------------------- */
/* >>> Modifying methods for Collection >>> */
    OVERRIDE_PUBLIC CPP_sync boolean retainAll(Collection c){
        if(IF_HASHSET(retainAll(c)) _OR_SUPER(retainAll(c))){
            changed();
            return true;
        }
        return false;
    }
    OVERRIDE_PUBLIC boolean removeAll(Collection<?> c){
        if(IF_HASHSET(removeAll(c)) _OR_SUPER(removeAll(c))){
            changed();
            return true;
        }
        return false;
    }
    OVERRIDE_PUBLIC CPP_sync void clear(){
        if(size()>0){
            IF_GUI(if(_v!=null) _v.clear(); else) {UNLESS_CHECK_CODE(super.clear());}
            IF_UNIQULIST_CHECK_HASHSET(clr(_set));
            changed();
        }
    }
    OVERRIDE_PUBLIC CPP_sync boolean add(T s){
        if(s!=null&&
            !(0==(_opt&UNIQL_NOT_UNIQUE)&&contains(s))&&
            IF_HASHSET(add(s))
            _OR_SUPER(add(s))){
            IF_MEIN_DEBUG(if(s instanceof java.util.zip.ZipFile) assrt());
            changed();
            return true;
        }
        return false;
    }
    OVERRIDE_PUBLIC boolean addAll(Collection<? extends T>c) {return IF_GUI(_v!=null?_v.addAll(c):) addAll(MAX_INT,c);}
    OVERRIDE_PUBLIC CPP_sync boolean remove(Object o){
        IF_GUI(if(_v!=null) return _v.remove(o));;
        boolean changed=false;
        IF_UNIQULIST_CHECK_HASHSET(if(IF_HASHSET(remove(o))true)){
            while(null!=remove(indexOf(o))) changed=true;
        }
        return changed;
    }
/* <<< Collection <<< */
/* ---------------------------------------- */
/* >>> Specific for java.awt.List >>> */
    OVERRIDE_PUBLIC CPP_sync T get(int i){
        if(i<0||i>=size()) return null;
        try{
            return _SUPER(get(i));
        }catch(Throwable e){return null;}
    }
#define RET_IX_OF(a) return o instanceof File||o instanceof java.net.URL||o instanceof BA||o instanceof String?_SUPER(a):-1
    OVERRIDE_PUBLIC int indexOf(Object o){
        final Object[]oo=_getData();
        if(oo==null) return _SUPER(indexOf(o));
        final int t=mini(oo.length,size());
        int i=idxOf(o,oo,0,t);
        if(i>=0) return i;
        RET_IX_OF(indexOf(o));
    }
/* OVERRIDE_PUBLIC int lastIndexOf(Object o) { */
/*     final Object[]oo=_getData(); */
/*     if(oo==null) return _SUPER(lastIndexOf(o)); */
/*     final int t=mini(oo.length,size()); */
/*     ROFi0(t) if(oo[i]==o) return i; */
/*     RET_IX_OF(lastIndexOf(o)); */
/* } */
    OVERRIDE_PUBLIC CPP_sync T remove(int i){
        final T removed=i>=0&&i<size()?_SUPER(remove(i)):null;
        if(removed!=null){
            IF_UNIQULIST_CHECK_HASHSET(if(_set!=null) _set.remove(removed));
            changed();
        }
        return removed;
    }
    OVERRIDE_PUBLIC boolean addAll(int pos,Collection<? extends T>c){
        final int L=sze(c),size=size();
        if(L==0) return false;
        Collection cAdd=c;
        if(0==(_opt&UNIQL_NOT_UNIQUE) && !(size==0&&(c instanceof UniqueList||c instanceof Set))){
            (cAdd=new HashSet(c)).removeAll( IF_CHECK_CODE(null) UNLESS_CHECK_CODE(IF_GUI(_v!=null?_v:)this));
        }

        _SUPER(addAll(mini(pos,size),cAdd));
        if(size!=size()){
            IF_UNIQULIST_CHECK_HASHSET(if(_set!=null) _set.addAll(c));
            changed();
            return true;
        }
        return false;
    }
    OVERRIDE_PUBLIC CPP_sync void add(int i,T s){
        if(s!=null && IF_HASHSET(add(s))true){
            if(i<0) i=0;
            if(i<size()) try{_SUPER(add(i,s));}catch(Throwable e){_SUPER(add(s));}
            else _SUPER(add(s));
            changed();
        }
    }
    OVERRIDE_PUBLIC CPP_sync T set(int i,T o){
        if(o==null||i>=size()||i<0) return null;
        final T oi=UNLESS_CHECK_CODE(super.set(i,o)) IF_CHECK_CODE(null);
        if(oi!=o){/*X  no check,otherwise Collections.sort does not work */
            IF_UNIQULIST_CHECK_HASHSET(if(_set!=null) {_set.remove(oi); _set.add(o);});;
            changed();
        }
        return oi;
    }
/* <<< Specific for java.awt.List <<< */
/* ---------------------------------------- */
/* >>>  Implemented by java.util.Vector  and java.util.ArrayList >>> */
#if CPP_WITH_CHECK_CODE
    OVERRIDE_PUBLIC int lastIndexOf(Object o) {return 0;}
    OVERRIDE_PUBLIC List<T>subList(int from,int to) {return null;}
    OVERRIDE_PUBLIC ListIterator<T>listIterator(){return null;}
    OVERRIDE_PUBLIC ListIterator<T>listIterator(int i) {return null;}
    OVERRIDE_PUBLIC Iterator<T>iterator(){return null;}
#endif //CPP_WITH_CHECK_CODE
/* <<< Implemented by java.util.Vector <<< */
/* ---------------------------------------- */
/* >>> asArray >>> */
    private T[]_emptyArray;
    private Object[]_getData(){
#if !CPP_WITH_CHECK_CODE
        if(_error) return null;
        try{
            return super.elementData;
        }catch(Throwable ex){
            _error=true;
            MEIN_ASSRT();
        }
#endif //!CPP_WITH_CHECK_CODE
        return null;
    }

    public CPP_sync T[]asArray(){
        final int size=size();
        if(size==0){
            if(_emptyArray==null) _emptyArray=(T[])emptyArry(_clazz);
            return _emptyArray;
        }
        Object[]a=(Object[])deref(_array);
        if(DIFF_MC(_arrayMC,_mc)||a==null||a.length!=size){
            a=(Object[])java.lang.reflect.Array.newInstance(_clazz,size);
            try{
                IF_GUI(if(0!=(_opt&UNIQL_AS_HashSet)) _v.toArray(a); else)
                _SUPER(toArray(a));
            }catch(Throwable ex){baOut(CAUGHT_IN).aa("\nUniqueList ",_clazz).aln(ex);}
            final Object[]noNull=rmNullA(a,_clazz);
            if(a!=noNull) while(remove(null)){}
            _array=newSoftRef(a=noNull);
        }
        return(T[])a;
    }
/* <<< asArray <<< */
/* ---------------------------------------- */
/* >>> Modified >>> */
    void changed(){
        _mc++;
        _array=null;
        IF_GUI(if(_hooks!=null && _hooks[UNIQL_HOOK_CHANGE]!=null) runHooks(UNIQL_HOOK_CHANGE));;
        IF_UNIQULIST_CHECK_HASHSET(checkHashSet());;
    }
/* <<< Modified <<< */
/* ---------------------------------------- */
/* >>> Hooks >>> */
#if CPP_WITH_GUI
    private ChRunnable[][]_hooks;
    private int[][]_hooksID;
    public void addHookCR(int id,ChRunnable r,int type){
        if(r!=null){
            if(_hooks==null) {_hooks=new ChRunnable[2][]; _hooksID=new int[2][];}
            _hooksID[type]=adToIntArry2(id,_hooksID[type],0);
            _hooks[type]=adToArry(0,r,_hooks[type],ChRunnable.class);
        }
    }
    private void runHooks(int type){
        if(_hooks!=null&&_hooks[type]!=null) ROFi0(_hooks[type].length) _hooks[type][i].run(_hooksID[type][i],this);
    }
/* <<< Hooks <<< */
/* ---------------------------------------- */
/* >>> Thread >>> */
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(PROVIDE_TEXT_FOR_SORTING) return _label;
            CASE_ARG(RUN_GET_RENDERER_TXT,int,opt) RETURN(_baClrTip().aa(_label,'#',size()));
            CASE_ARGV(RUN_GET_ICON) return _ic;
            CASE_ARG(RUN_SET_ICON,Object,ic) _ic=ic;RETURN(this);
            CASE_ARG(RUN_SET_TREE_VALUE,Object,r) _renderer=r;RETURN(TRUEr);
#if CPP_DEACTIVATED
            CASE_ARGV(PROVIDE_JTREE_NODE_ID) return sze(_label)>0?_label: _nodeId==null?_nodeId=io(hashCode()): _nodeId;
#endif //CPP_DEACTIVATED
            CASE_ARGV(RUN_PROVIDE_TREE_VALUE) return _renderer;
            CASE_ARG(RUN_SET_TEXT,Object,x) _label=x;RETURN(this);
            CASE_ARGV(RUN_GET_NAME)
                CASE_ARGV(RUN_GET_TEXT) return _label;
        }
        return null;
    }
#endif //CPP_WITH_GUI
/* <<< Thread <<< */
/* ---------------------------------------- */
/* >>> Main >>> */
    // java charite.christo.UniqueList
#if CPP_DEACTIVATED_MAIN
    public static void main(String[]argv)throws Exception{
        setNoGui(argv);
        final Object u=url(iURL_STRAP_SLASH);
        _main(0);
    }
    private static void _main(int set){
        if(false){
            final UniqueList v=new UniqueList(set|iCLASS_Object);
            v.add("Apfel");
            v.add("Birne");
            v.add(new String("Apfel"));
            v.add(url(iURL_STRAP_SLASH));
            v.add(new File("/home/"));
            //v.remove(new File("/home"));
            baOut("v=").a(v.get(1)).aln();
            baOut("v=").a(v.toArray()).aln();
            baOut("v=").joinSpc(v).aln();
        }

        final UniqueList v=new UniqueList(set|iCLASS_Object);
        baOut("mc=").aa(v,' ',v.mc(),' ',modic(v)).aln();
        v.add("Apfel");
        baOut("mc=").aa(v,' ',v.mc(),' ',modic(v)).aln();
        v.add("Apfel");
        baOut("mc=").aa(v,' ',v.mc(),' ',modic(v)).aln();

    }
#endif //CPP_DEACTIVATED_MAIN

#if CPP_WITH_MEIN_DEBUG
    private static int _instCount;{_instCount++;}
    public String toString(){return s(new BA(99).aa(" UL#",_instCount,super.toString()));}
#endif //CPP_WITH_MEIN_DEBUG
}
//http://java.sun.com/j2se/1.5.0/docs/guide/collections/reference.html  Collections
