package charite.christo.strap;
import charite.christo.*;
import java.io.File;
import java.util.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;

/* If the class is not extended then it serves for 3D visualization in exported HTML-pages. See ChAstex. */
/*      (highlight-regexp "v3dRgbRemove(\\|v3dGetRibbons(\\| v3dUpdateRibbons(\\|v3dChangeRibbonColor(" 'hi-yellow)  AbstractView3d */
//   http://openastexviewer.net/web/OpenAstexViewer.jar
//   http://openastexviewer.net  http://www.astex-therapeutics.com/
@*SARRAYeq_V3D_SUPPORTED_COMMANDS
iV3DCMD_select iV3DCMD_select_rm iV3DCMD_select_add iV3DCMD_select_cut iV3DCMD_select_save iV3DCMD_select_restore iV3DCMD_set_rotation_translation iV3DCMD_zoom iV3DCMD_rotate iV3DCMD_center iV3DCMD_background iV3DCMD_spheres iV3DCMD_lines iV3DCMD_sticks iV3DCMD_ribbons iV3DCMD_color iV3DCMD_surface iV3DCMD_surface_color iV3DCMD_change_object_color iV3DCMD_cartoon iV3DCMD_label iV3DCMD_object_delete iV3DCMD_center_amino iV3DCMD_highlight_selected_atoms iV3DCMD_highlight_selected_amino_acids iV3DCMD_reset=V3D_ASTEX
iV3DCMD_background iV3DCMD_biomolecule iV3DCMD_reset iV3DCMD_highlight_selected_atoms iV3DCMD_highlight_selected_amino_acids=V3D_SIMPLE
*@
public class AbstractView3d implements View3d,HasWRef{
    private Object _flags;
    private Protein _p;
    private int _type,_supported[];
    private Collection<String>_chainsOnlyOnce;
    private long _surfaceColor=RGBA_NONE;
/* ---------------------------------------- */
#if CPP_WITH_GUI
    PUBLIC_SUPERCLASS float[]_xyzORIG;
    private Object _canvas;
#endif //CPP_WITH_GUI

#if CPP_WITH_GUI&&!CPP_WITH_CHECK_CODE
#define canvasProxy() ((ChRunnable)_canvas)
#else
#define canvasProxy() null
#endif //CPP_WITH_GUI&&!CPP_WITH_CHECK_CODE
/* >>> Properties >>> */
    public AbstractView3d(int type IF_GUI(,Object cloadClass)){
        _type=type;
        //IF_GUI(_canvas=cloadJars!=null?cloadJavaClassWithJar(cloadOpt,clasNamOrAlias(cloadClass),cloadJars):cloadClass);;
        IF_GUI(_canvas=cloadClass instanceof Integer?cloadJavaClassWithJar(xatoi(cloadClass)):cloadClass);;
    }
    private final Object[]PROPERTIES=new Object[AVIEW3D_PROPERTIES_L];
    OVERRIDE_PUBLIC final void setProperty(int id,Object value) {PROPERTIES[id]=value;}
    OVERRIDE_PUBLIC final Object getProperty(int id){
        switch(id){
#if CPP_WITH_GUI
        case VIEW3D_GET_ATOM_SELECTION_EXAMPLE:return _type==V3D_ASTEX?"atom CA CB":null;
        case VIEW3D_GET_CANVAS:return runCR(RUN_VIEW3D_GET_CANVAS,canvasProxy());
        case VIEW3D_GET_JMENUBAR:return runCR(RUN_VIEW3D_GET_JMENUBAR,canvasProxy());
#endif //CPP_WITH_GUI
        case VIEW3D_GET_SUPPORTED_COMMANDS:{
            if(_supported==null) _supported=intArrys(SARRAYeq_V3D_SUPPORTED_COMMANDS)[_type];
            return _supported;
        }
        case VIEW3D_GET_FLAGS:
            if(_flags==null) _flags=io(_type==V3D_ASTEX?VIEW3D_FLAG_RIBBON_COLOR_NO_CHANGE|VIEW3D_FLAG_NEEDS_UPDATE_SURFACES_WHEN_ROTATED:0);
            return _flags;
        }
        return deref(PROPERTIES[id]);
    }
/* <<< Properties <<< */
/* ---------------------------------------- */
/* >>> getProtein >>> */
    CPP_FINAL_RUN_ID_ARG(){
        switch(id){
            CASE_ARG(RUN_INTERPRET_COMMAND,Object,strg){
                final String command=toStrgTrim(strg);
                if(command==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                final Protein p=sp(this);
                if(p==null || nxt(0,chrClas(LETTR),command)<0) return null;
                if(command.indexOf('\n')>=0) assrt();
                final int cmd=v3dCmdInLine(command);
                final String command1=toStrgTrim(v3dReplaceVars(cmd>0?V3D_GENERIC:_type,command,p));
                if(v3dForHtml(this)!=null){
                    v3dLog(0,this,command1);
                    ROFt0(V3D_NUM){
                        if(scriptForHtml(t)==null) continue;
                        _type=t;
                        final BA nativ=v3dIsSupporting(cmd,this)?generic2native(command1):null;
                        if(sze(nativ)>0){
                            v3dLog(V3D_LOG_NATIVE,this,nativ);
                            scriptForHtml(t).add(baClr(167).a(nativ).a1('\n').newBytes());
                        }
                    }
                }else{
#if CPP_WITH_GUI
                    if(cmd==iV3DCMD_highlight_selected_amino_acids || cmd==iV3DCMD_highlight_selected_atoms){
                        if(getProperty(AVIEW3D_CAN_TRACK_SELECTION3D)==null) v3dLog(0,this,new BA(RED_WARNING).aa("Skipped because unknown selection ",command));
                        else{
                            Selection3D[]aa=(Selection3D[])getProperty(AVIEW3D_GET_SELECTION3D);
                            boolean ok=true;
                            if(sze(aa)>0){
                                aa=aa.clone();
                                if(cmd==iV3DCMD_highlight_selected_amino_acids) v3dChangeSelection3D(IF_GUI(true,)aa,"CA");
                                ok=null!=runCR(RUN_AVIEW3D_HIGHLIGHT_ATOMS,canvasProxy(),aa,CPP_CAST(Simple3D)this);
                            }
                            if(ok) return TRUEr;
                        }
                    }
#endif //CPP_WITH_GUI
                    BA send=generic2native(command1);
                    if(send!=null||sze(send=toBA(command1))>0){
                        v3dLog(V3D_LOG_NATIVE,this,send);
                        IF_GUI(if(sze(send)>0) runCR(RUN_AVIEW3D_INTERPRET,canvasProxy(),send,/*(Simple3D)*/this));;
                    }
                }
                BREAK;
            }
            CASE_ARGV(RUN_GET_PROTEIN) RETURN _p;
#if CPP_WITH_GUI
            CASE_ARGV(RUN_CLOSE_HOOK)
                CASE_ARGV(RUN_DISPOSE){
                if(gcpSetToTrue(KOPT_DISPOSED,this)==null){
                    final BA sb=new BA(99);
                    if(_type==V3D_ASTEX) sb.aa("molecule remove '",getProperty(VIEW3D_GET_PNAME),"';");
                    if(sze(sb)>0) runCR1(RUN_INTERPRET_COMMAND,this,sb);
                    strapEvtDispatchWithSrc(EVT_V3D_CLOSED,this);
                    final AbstractView3dCanvas canvas=derefZ(canvasProxy(),AbstractView3dCanvas.class);
                    if(canvas!=null){
                        rmElmntFromV(this,canvas._vPV);
                        if(sze(canvas._vPV)==0) closC(0,runCR(RUN_VIEW3D_GET_CANVAS,canvas));
                        runCR(RUN_AFTER_DISPOSE,canvas);
                    }
                }
                RETURN TRUEr;
            }
#endif //CPP_WITH_GUI
        }
        return null;
    }
    OVERRIDE_PUBLIC_IF final boolean init3d(int opt,Protein p,View3d inSameView){
        setProperty(VIEW3D_GET_PNAME,v3dProtName(_p=p));
        final AbstractView3d same=(AbstractView3d)inSameView,wsv=v3dForHtml(this);
        IF_GUI(Object canvas=null);;
        if(same!=null){
            IF_GUI(canvas=same._canvas);;
            setProperty(VIEW3D_GET_SHARED_VIEWS,same.getProperty(VIEW3D_GET_SHARED_VIEWS));
            setProperty(VIEW3D_GET_SHARED_MAP,same.getProperty(VIEW3D_GET_SHARED_MAP));
            setProperty(AVIEW3D_GET_RECORD_GENERIC_COMMANDS,same.getProperty(AVIEW3D_GET_RECORD_GENERIC_COMMANDS));
            _chainsOnlyOnce=same._chainsOnlyOnce;
        }else{
            _chainsOnlyOnce=new HashSet();
            {
                int i=-1;
                ROFk0(iCLASS_ZZZ) if(iClass(k)==getClass()){i=k;break;}
                setProperty(VIEW3D_GET_SHARED_VIEWS,new UniqueList(i>=0?i:iCLASS_View3d));
            }
            setProperty(VIEW3D_GET_SHARED_MAP,new HashMap());
            if(wsv!=null) setProperty(AVIEW3D_GET_RECORD_GENERIC_COMMANDS,new ArrayList());
            IF_GUI(if((canvas=_canvas) instanceof Class) canvas=mkInstance(0,canvas));;
        }
        ((Collection)PROPERTIES[VIEW3D_GET_SHARED_VIEWS]).add(this);
        IF_GUI(_canvas=canvas);;
        v3dSameViewV(this).add(this);
        IF_GUI(if(_type!=V3D_SIMPLE)){
            if(wsv!=null){
                ROFt0(V3D_NUM) adNotNull(commandLoad(t).newBytes(),wsv.scriptForHtml(t));
            }else runCR1(RUN_INTERPRET_COMMAND,this,commandLoad(_type));
        }
        IF_GUI(runCR1(RUN_AVIEW3D_TO_CANVAS,canvas,this));;
        return true;
    }
    private BA commandLoad(int type){
        final BA url=baClr(171);
#if CPP_PRG_AA
        final String pdbId=_p.getPdbID(PDBID_INFERRED|PDBID_ID);
        if(prgOptOn(iPAR_aa3dViaPHP) && pdbId!=null){ /*X -aa3dViaPHP nicht in aaZip.php,aber in aaCompute()  */
            final BA u=baClr(162).aa("PDB:",pdbID(pdbId),'\t');
            Collection<String>v=adUniqNew(orS(pdbChain(pdbId),_p.getChain()),null);
            for(Protein h:_p.getMolecules(CHAINTYPE_NUC)) v=adUniqNew(h.getChain(),v);
            for(String a:toStrgArray(TO_SARRAY_SORT,v)) u.aa(a,'-');
            u.del('-').a('\t');
            final Matrix3D mx=_p.getRotationAndTranslation();
            if(mx!=null) mx.toText(0,null,u);
            url.a(AA_GET_DOT_PHP+"?"+HTTP_GET_STRUCTUREFILE+"=").aFilter(FILTER_URL_ENCODE,u.trim()).a("&format=.pdb.gz");
        } else
#endif //CPP_PRG_AA
            if(_p.getAtomXYZ()!=null){/*X  Flags as ChAstexCanvas */
                final File fXYZ=pdbFileWrite(SEQW_NO_OCCUPANCY|SEQW_HETEROS|SEQW_NT_STRUCTURE|SEQW_SHORT_ATOM_LINES|SEQW_GZ|SEQW_SIDE_CHAIN_ATOMS,spp(_p));
#if CPP_PRG_AA
                if(prgOptOn(iPAR_urlsAsFilename) && fXYZ!=null){/*X -urlsAsFilename in aaZip.php */
                    lnkOrCpy(0,fXYZ,file(nam(fXYZ)));
                    url.a(nam(fXYZ));
                } else
#endif //CPP_PRG_AA
                    url.aFilePathOrURL(fXYZ,(File)getProperty(AVIEW3D_SET_WEB_DIR));
            }
        final BA sb=baClr(99);
        if(sze(url)>0){
            if(type==V3D_ASTEX) sb.aa("molecule load '",getProperty(VIEW3D_GET_PNAME),"' '",url).aln("';");
        }
        return sb;
    }
/* <<< getProtein <<< */
/* ---------------------------------------- */
/* >>> generic2specific  >>> */
    private int _secstruDone;
    private final BA generic2native(String command){
#define baTmp() baClr(100)

        IF_GUI(if(this instanceof Simple3D) return toBA(command));;
        final Protein p=sp(this);
        if(p==null || sze(command=toStrgTrim(command))==0) return null;
        int cmd=v3dCmdInLine(command);

        //#define KEY_LAST "APV$$L"
/* if(cmd==iV3DCMD_select) {  /\*X  E.g. 3D_select $ALL *\/ */
/*     final Object[]last=(Object[])v3dSharedMap(this).get(KEY_LAST); */
/*     if(last!=null && command.equals(last[0]) && last[1]==wref(p)) return send; */
/*     v3dSharedMap(this).put(KEY_LAST,new Object[]{command,wref(p)}); */
/* } */
        final BA send=baClr(101);
        if(cmd==0) return send.a(command);

        final Selection3D[]atoms=(Selection3D[])getProperty(AVIEW3D_GET_SELECTION3D);
        final int para=nxt(STR_E,chrClas(-SPC),command,sze(iConst(SARRAY_STRAP_SCRIPT_CMD,cmd)),999);
        final boolean off=command.endsWith(" off");
        final String
            objPfx=cmd==iV3DCMD_ribbons?"ribbon_": cmd==iV3DCMD_cartoon?"schematic_": cmd==iV3DCMD_surface?"surface_": null,
            objNam=objPfx!=null?s(baTmp().aa(objPfx,getProperty(VIEW3D_GET_PNAME),'_').aFilter(FILTER_SINGLE_US|FILTER_NO_MATCH_TO_US|LETTR_DIGT_US,!ARRAY_EMPTY(atoms)?v3dSelection3dToTextSameChain(-1,atoms):"unnamed")):
            cmd==iV3DCMD_change_object_color||cmd==iV3DCMD_object_delete?wordAt(command,para):
            null;/*X  declaredValue("-name",command);*/
        if(objPfx!=null && sze(atoms)==0 && getProperty(AVIEW3D_CAN_TRACK_SELECTION3D)!=null) return send;
        final long color1=v3dRgbInScript(command),color;
#if CPP_WITH_GUI
        if(objNam!=null && !off){
            final Map<String,Object[]>m=v3dGetRibbons(this);
            if(cmd==iV3DCMD_object_delete) m.put(objNam,null);
            else{
                Object[]d=m.get(objNam);
                if(d==null && cmd!=iV3DCMD_change_object_color){
                    m.put(objNam,d=new Object[V3D_RIBBON_NUM_FIELDS]);
                    d[V3D_RIBBON_NAME]=objNam;
                    d[V3D_RIBBON_COMMAND]=command;
                }
                if(d!=null) d[V3D_RIBBON_COLOR]=longObjct(color1);
                straplJList(LSTMDL_FLAG_UPDATE_NOW|LSTMDL3D_SURFACES);
            }
        }
#endif //CPP_WITH_GUI
        color=color1==RGBA_INHERIT?rgba(getColrO(p),RGBA_NONE):color1;
        if(cmd==iV3DCMD_native){
            final int komma=command.indexOf(',');
            if(komma<0) {baOut(RED_ERROR).aln("Komma missing in "+V3DCMD_native); return clr(send);}
            if(strstr(STR_IC,_type==V3D_ASTEX?"astex":null,command,0,komma)>0) return send.a(command.substring(komma+1)).a1(';');
            return clr(send);
        }else if(cmd==iV3DCMD_surface_color){
            _surfaceColor=color1;
        }else if(cmd==iV3DCMD_change_object_color){
            if(_type==V3D_ASTEX) objColor(color,objNam,send);
        }else if(cmd==iV3DCMD_spheres||cmd==iV3DCMD_lines||cmd==iV3DCMD_sticks){
            if(_type==V3D_ASTEX) send.aa("display ",cmd==iV3DCMD_spheres?"spheres": cmd==iV3DCMD_lines?"lines":"sticks",off?" off":" on"," current;");
        }else if(cmd==iV3DCMD_object_delete || objPfx!=null && off){
            if(_type==V3D_ASTEX) send.aa("object remove '",objNam,"';");
        }else if(cmd==iV3DCMD_background){
            if(_type==V3D_ASTEX) send.a("background 0x").aHex(color,6);
        }else if(cmd==iV3DCMD_ribbons){
            final String w=declaredValue("-width",command,0,MAX_INT,null);
            if(_type==V3D_ASTEX) send.aa("schematic -name '",objNam,"' -alltube true -ribbonwidth ").or(w,"20").a(" current;");
        }else if(cmd==iV3DCMD_cartoon){
            if(_type==V3D_ASTEX){
                if(_secstruDone++==0) send.aa("secstruc (molecule '",getProperty(VIEW3D_GET_PNAME)).aln("');");
                send.aa("schematic -name '",objNam,"' current;");
                objColor(color,objNam,send.a(';'));
            }
        }else if(cmd==iV3DCMD_center_amino){
            if(_type==V3D_ASTEX) send.a("center (aminoacid)");
        }else if(cmd==iV3DCMD_center){
            if(_type==V3D_ASTEX) send.a("center (sphere 20 around current)");
        }else if(cmd==iV3DCMD_color){
            if(_type==V3D_ASTEX) send.a("color 0x").aHex(color,6).a(" current;");/*X  was ist mit alpha anteil? */
        }else if(cmd==iV3DCMD_select_save){
            if(_type==V3D_ASTEX) send.a("define '").aFT(command,para,MAX_INT).a("' current;");
        }else if(cmd==iV3DCMD_select_restore){
            if(_type==V3D_ASTEX) send.a("select (group '").aFT(command,para,MAX_INT).a("')");
            setProperty(AVIEW3D_CAN_TRACK_SELECTION3D,null);
        }else if(cmd==iV3DCMD_select_add||cmd==iV3DCMD_select_rm||cmd==iV3DCMD_select_cut||cmd==iV3DCMD_select){
            if(cmd==iV3DCMD_select_add&&sze(atoms)==0) cmd=iV3DCMD_select;
            Selection3D[]ss3d=textToSelection3D(delChrSfx(';',command.substring(para)),p);
            if(!(ss3d.length==0&&(cmd==iV3DCMD_select_add||cmd==iV3DCMD_select_cut))){
                if(cmd==iV3DCMD_select_cut) setProperty(AVIEW3D_CAN_TRACK_SELECTION3D,null);
                else{
                    setProperty(AVIEW3D_CAN_TRACK_SELECTION3D,TRUEr);
                    if(cmd==iV3DCMD_select_add){
                        final Collection v=new ArrayList();
                        adAllUniq(atoms,v);
                        adAllUniq(ss3d,v);
                        ss3d=toArry(v,Selection3D.NONE);
                    }
                    setProperty(AVIEW3D_GET_SELECTION3D,ss3d);
                }

                if(ss3d.length==0){
                    if(_type==V3D_ASTEX) send.a("select none");
                }else{
/* final BA sbOtherChain=baClr(VCLR_NUMBERS); */
/* ROFi0(ss3d.length) { */
/*     final String chn=s3dChain(ss3d[i]); */
/*     if(chn!=null && !chn.equals(p.getChain())) { */
/*         if(_type==V3D_ASTEX) { */
/*             if(sbOtherChain.end()>0) sbOtherChain.a(" or "); */
/*             sbOtherChain.a('(').and("molecule '",s3dResidueName(ss3d[i]),"' and ").aa(" chain '",chn,"') "); */

/*         } */
/*         ss3d[i]=null; */
/*     } */
/* } */
                    if(_type==V3D_ASTEX){
                        send.a(cmd==iV3DCMD_select_add?"append ":cmd==iV3DCMD_select_rm?"exclude ":cmd==iV3DCMD_select_cut?"select (current) and ":"select ");
                        if(fstNotNull(ss3d)!=null) send.aa("(molecule '",getProperty(VIEW3D_GET_PNAME),'\'').and(" and chain '",p.getChain(),"'").and(" and ",v3dSelection3dToTextSameChain(V3D_ASTEX,ss3d)).a(") or ");
/* send.a(sbOtherChain); */
                        send.del(" or ");
                    }
                }
            }
        }else if(cmd==iV3DCMD_surface){
            long c=_surfaceColor;
            if(c==RGBA_NONE && (c=color)==RGBA_NONE) c=0xFFff00ff;
            if(_type==V3D_ASTEX)  objTransparency(c,objNam,send.aa("surface -solid true '",objNam,"' 0x").aHex(c&0xFFffFF,6).aln(" current;"));
        }else if(cmd==iV3DCMD_label){
            final BA txt=toBA(resSelReplaceVariableBB(baTmp().aFT(command,para,MAX_INT).trim(),
                                                      selection3dToBoolZ((Selection3D[])gcp(V3D_KEY_SEL_ATOM,this),p,null),firstResIdx(p),gcps(V3D_KEY_SEL_ID,this),p,null));
            IF_GUI(v3dRgbRemove(txt));;
            if(_type==V3D_ASTEX){
                send.a("label ");
                if(sze(txt)==0) send.a("clear");
                else{
                    if(color!=RGBA_NONE) send.a("<color=0x").aHex(color,6).aBYTES('>',' ');
                    send.a('"').aWithoutPfx("\"",txt).a1('"');
                }
                send.a(" current;");
            }
        }else{
            return null;
        }
        if(sze(send)==0) return send;
#if CPP_WITH_GUI
        if(objPfx!=null && sze(objNam)>0 && onlyOnceHC(319,objNam)){/*X  Allows manipulation of surface objects */
            if(_type==V3D_ASTEX) send.a1(';').aa("\ndefine '",V3D_PFX_SEL_OF_RIBBON,objNam,"' current;");
        }
#endif //CPP_WITH_GUI
        if(strstr(0,"  ",send)>=0){
            final BA tmp=baTmp().aFilter(FILTER_SINGLE_SPC,send.trim());/*X SEPARATE_LINES*/
            clr(send).a(tmp);
        }
        if(_type==V3D_ASTEX) send.replace(0," all and aminoacid "," aminoacid ").trim().a1(';');
        if(strstr(0,"select none;",send)>0 && onlyOnce(42)) errorEx(ALIAS_EXCEPTION,send);
        return send;
#undef baTmp
    }
    private static void objColor(long color, String obj, BA send){
        if(color!=RGBA_NONE) objTransparency(color,obj,send.aa("object '",obj,"' colour 0x").aHex(color&0xFFffFF,6).a(';').aln());
    }
    private static void objTransparency(long color, String obj, BA send){
        final int t=color==RGBA_NONE?0:(int)((color>>>24)&0xFF);
        if(t!=0xFF && t!=0) send.aa("object '",obj,"' transparency ",t,';').aln();
    }
/* <<< generic2specific <<< */
/* ---------------------------------------- */
/* >>> For Web. The class is not extended. >>> */
    public final void pseudoCommand(String s){
        final Object[]oo={_p,s};
        ROFt0(V3D_NUM) adNotNull(oo,scriptForHtml(t));
    }
    private final Collection[]_script3D=new List[V3D_NUM];
    private Collection scriptForHtml(int t){
        if(t!=V3D_ASTEX) return null;
        if(sp(this)==null) baOut(RED_WARNING).a(" scriptForHtml p=null").special(DIE_NOW);
        if(_script3D[t]==null){
            final Collection v=v3dSameViewV(this);
            ROFi0(sze(v)){
                final Collection script=((AbstractView3d)xiThEl(i,v))._script3D[t];
                if(script!=null) return script;
            }
            _script3D[t]=new ArrayList(99);
        }
        return _script3D[t];
    }
    public final void getNative(int t, BA code){
        final Collection script=_script3D[t];
        FORi(0,sze(script)){
            final Object x=xiThEl(i,script);
            if(x instanceof Object[]&& sze(x)==2){
                final Object p=xiThEl(0,x),s=xiThEl(1,x);/*X s is a String */
                if(p!=null && s!=null){
                    code.aa(s,((Protein)p).getIntProperty(PROTEINI_HTML_IDX),")\\x0A");
                    continue;
                }
            }
            code.aFilter(FILTER_JS_QUOTES_TO_HEX,x);
        }
    }
/* <<< For Web <<< */
/* ---------------------------------------- */
/* >>> Instance  >>> */

#if CPP_WITH_MEIN_DEBUG
    private static int _numInst;
    private final int _iInst=++_numInst;
    OVERRIDE_PUBLIC final String toString(){return _baClrToStrg().or(sp(this),"null").a('@').aShrtClasNam(this).aa('#',_iInst).toString();}
#endif //CPP_WITH_MEIN_DEBUG
    CPP_CODE_HasWRef();

/* <<< Instance  <<< */
/* ---------------------------------------- */
/* >>> Static Utils  >>> */
}
#undef canvasProxy
