#if CPP_PRG_AA
package charite.christo.strap;
import charite.christo.*;
import java.io.File;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;

/* Todo: Mehrere PDB,incrementelles update,score; */
/* @author Christoph Gille */
public final class FindPdbByBlat{
    private final Object _key=new Object();
    private final File _fa;
    public FindPdbByBlat(File faFile){
        _fa=faFile;
    }

    private static FindPdbByBlat[]_inst;
    public static FindPdbByBlat[]instances(){
        if(_inst==null) _inst=iFile(F_PDB_FA)!=null?new FindPdbByBlat[]{new FindPdbByBlat(iFile(F_PDB_FA))}:new FindPdbByBlat[0];
        return _inst;
    }
    public static String id(Protein p){
        for(FindPdbByBlat inst:instances()){
            final Object id=gcp(inst._key,p);
            if(id instanceof String && chrAt(0,id)!='?') return(String)id;
        }
        return null;
    }
    public static void compute(Protein[]pp){
        for(FindPdbByBlat i:instances()) i._compute(pp);
    }
    private void _compute(Protein[]pp){
        final int time=(int)(System.currentTimeMillis()/1000);
        final BA buffer=new BA(33);
        BA sb=null;
        boolean[]needCompute=null;
        ROFiP0(pp.length){
            final Protein p=pp[iP];
            if(p==null || gcp(_key,p)!=null) continue;
            if(isPrprty(IS_CACHE_READ)){
                BA val=aaCacheGet(FindPdbByBlat.class,cacheKeyForSeqAsStrg(p,clr(buffer)),clr(buffer));
                if(chrAt(0,val)=='?' && time-atoi(val,1)>30*60) val=null;/*X  val kann auch "?" sein. Dieses ist dann 30 min gueltig */
                if(val!=null){
                    pcp(_key,s(val),p);
                    continue;
                }
            }
            if(sb==null){
                sb=new BA(999);
                needCompute=new boolean[iP+1];
            }
            sb.aa(">s",iP).aln().a0(p.getResType()).aln().aln();
            needCompute[iP]=true;
        }
        if(sb!=null){
            final BA txt=rtExecV(0,new Object[]{
                    fileFindExecutable("blat"),
                        "-noHead",
                        "-prot",
                        _fa,
                        wrte(fileDel(iFile(F_PDB_BLAT_MFA)),sb),
                        fileDel(iFile(F_PDB_BLAT_OUT))
                        })==0?readBytes(iFile(F_PDB_BLAT_OUT)):null;

            String idErr=null;
            if(txt!=null){
                final String[]ids=idsFromBlat(false,pp,txt);
                ROFiP0(needCompute.length){
                    if(!needCompute[iP] || pp[iP]==null) continue;
                    final Protein p=pp[iP];
                    String id=ids[iP];
                    if(id==null){
                        if(idErr==null) idErr=new BA(22).aa('?',time).toString();
                        id=idErr;
                    }
                    aaCachePut(FindPdbByBlat.class,
                                  cacheKeyForSeqAsStrg(pcp(_key,id,p),null),
                                  toBA(id));
                    //p.aaToCache(FindPdbByBlat.class,toBA(id));
                }
            }
        }
    }
    static String[]idsFromBlat(boolean identical,Protein[]pp,BA txt){
        final String[]ids=new String[pp.length];
        if(txt!=null){
            final byte[]T=txt.bytes();
            final int[]eol=txt.eol(),TABS=new int[14],scores=identical?null:new int[pp.length];
            FORiL(0,eol.length){
                final int b=BOL0(iL,eol),e=eol[iL];
                if(e-b<1 || T[b]=='#' || tabulatrs('\t',T,b,e,TABS)<14) continue;
                final int match=atoi(T,b),iP=atoi(T,TABS[8]+2);

                if(iP>=pp.length || iP<0){
                    baOut(RED_ERROR).aa("FindPdbByBlat"," iP=").a(iP).a(" pp.length=").a(pp.length).a(' ').aFT(T,b,e).aln();
                    continue;
                }
                final Protein p=pp[iP];
                if(p==null || identical && p.countRes()!=match) continue;
                final String id=wordAt(T,TABS[12]+1);
                if(identical) ids[iP]=id;
                else if(ids[iP]==null || scores[iP]<match){
                    ids[iP]=id;
                    scores[iP]=match;
                }
            }
        }
        return ids;
    }

/* <<<  <<< */
/* ---------------------------------------- */
/* >>>  >>> */
#endif //CPP_PRG_AA
#if CPP_DEACTIVATED_MAIN
/*       java charite.christo.strap.FindPdbByBlat  ~/m1/*.swiss */

    public static void main(String[]argv)throws Exception{
        setNoGui(argv);
        final Protein[]pp=newProteinInstances(0,argv);
        compute(pp);
        for(Protein p:pp){
            putln(new BA(99).a(p).a('\t').aln(id(p)));
        }
        putln("FindPdbByBlat "); System.exit(0);
    }

#endif //CPP_DEACTIVATED_MAIN
}
