package charite.christo.strap;
import static charite.christo.ChUtils.*;
@*H
   Empty columns with a gap in each sequence are usually not displayed.
   <BR>Consider the following case:

   <PRE class="data">
   ASGATA  YTG
   ATGATG  YTA
   ASGGTAG FSG
   ^
   </PRE>
   This empty column is not displayed. The view shows:

   <PRE class="data">
   ASGATA YTG
   ATGATG YTA
   ASGGTAGFSG
   </PRE>

   When the sequence "ASGGTAGAFSG"
   was added to the multiple sequence alignment  the column would not be empty any more and would be visible.
   In the multiple sequence alignment panel is the following:

   <PRE class="data">
   ASGATA  YTG
   ATGATG  YTA
   ASGGTAG FSG
   ASGGTAGAFSG
   </PRE>

   This is the reason for the following phenomenon:
   When gaps are added to one sequence it might seem that gaps are erased
   in all other sequences instead.

*@
public final class Gaps2Columns{
    public int _countColumns;
    private Object _proteinsV;
    private Protein[]pp(){return charite.christo.strap.Strap.spp(_proteinsV);}
    public void setProteinsV(Object v,int[]mc){/*X @param v: List<Protein>,Protein[].*/
        _proteinsV=v;
        _mcGlobal=mc;
    }
    private boolean[]_noGap=new boolean[5];
    private int _w2nMC,_mcGlobal[],_wide2view[],_view2wide[];

    public int mc(){return _w2nMC;}
#if 0
    /**
     * Calculates the horizontal position (column) of all residues in the alignment.
     * from the number of gaps of each residue
     * Used for the default modus where  redundant gaps are suppressed.
     */
#endif //0
    public int[]computeWide2viewNoSync(Protein[]pp,int fromCol,int toCol){
        if(pp==null) return null;
        int maxCol=0;
        boolean[]noGap=_noGap;
        clr(noGap);
        for(Protein p:pp){
            if(p!=null){
                final int n=p.unsyncResCount(),gaps[]=p._resGap,nG=sze(gaps);
                int col=-1;
                FORi(0,n){
                    int g=i<nG?gaps[i]:0;
                    if(g<0) {assrt(); g=0;}
                    col+=g+1;
                    noGap=setIthBool(col,true,noGap,999);
                    /* if(noGap.length<=col) noGap=_noGap=chSze(noGap,maxi(999,33+col*3/2)); */
                    /* noGap[col]=true; */
                }
                if(maxCol<col) maxCol=col;
            }
        }
        int[]w2s=_wide2view;
        if(w2s==null || w2s.length<=maxCol+1 || w2s.length>maxCol+666) _wide2view=w2s=new int[maxCol+333];
        int col IF_GUI(=_deleted)=0;
        for(int i=0;i<=maxCol;i++){
            w2s[i]=col;
            if(noGap[i] || !(fromCol<=i && i<toCol)) col++;
            IF_GUI(else _deleted++);;
            //if (fromCol<=i && i<toCol) puts(noGap[i]?"X":"*");

        }
        if(noGap.length>maxCol+9999) _noGap=new boolean[maxCol+333];
        _countColumns=w2s[maxCol+1]=col++;
        int[]s2w=_view2wide;
        if(s2w==null || s2w.length<=col || s2w.length>col+666) _view2wide=s2w=new int[col+333];
        ROFi0(maxCol+1) s2w[w2s[i]]=i;/*X  ??? ArrayIndexOutOfBoundsException: 520878*/
        //if (pp.length>10000 && debugTime("computeWide2view duration=",time);
        return w2s;
    }
    public int[]wide2viewColumnNoSync(){
        final Protein[]pp=pp();
        if(DIFF_MC(_w2nMC,_mcGlobal==null?0:_mcGlobal[MCA_ALIGNMENT]+_mcGlobal[MCA_RES_COUNT_NOSYNC]) || _wide2view==null){
            computeWide2viewNoSync(pp,0,MAX_INT);
        }
        return _wide2view;
    }
#if CPP_WITH_GUI
    public int[]view2wideColumn(){
        wide2viewColumnNoSync();
        return _view2wide;
    }
#endif //CPP_WITH_GUI
    /* <<<  <<< */
    /* ---------------------------------------- */
    /* >>> static utils >>> */
    public static int[]computeColumns(int[]wide2view,int[]gaps,int nRes,int[]oldCols){
        final int cols[]=redim(oldCols,nRes,99),nW=sze(wide2view),nG=sze(gaps);
        int col=-1,lastCol=-1,i=0;
        for(;i<nRes;i++){
            int g=i<nG?gaps[i]:0;
            if(g<0) {assrt(); g=0;}
            col+=g+1;
            if(col>=nW) break;
            int newCol=wide2view[col];
            if(newCol<=lastCol) newCol=lastCol+1;
            lastCol=cols[i]=newCol;
        }
        for(;i<nRes;i++){
            int g=i<nG?gaps[i]:0;
            if(g<0) {assrt(); g=0;}
            col+=g+1;
            if(col<=lastCol) col=lastCol+1;
            lastCol=cols[i]=col;
        }
        return cols;
    }
    /* <<<  <<< */
    /*--------------------------------------- */
    /* >>> external Utils >>> */
#if CPP_WITH_GUI
    private int _deleted;
    public static int g2cEliminateCommonGaps(Protein[]pp,int fromCol,int toCol){
        final Gaps2Columns g2c=new Gaps2Columns();
        final int[]w2n=g2c.computeWide2viewNoSync(pp,fromCol,toCol);
        int[]cols=new int[999];
        for(Protein p:pp){
            final int nR=p.unsyncResCount(),gg[]=new int[nR];
            cols=computeColumns(w2n,p._resGap,nR,cols);
            FORi(0,nR){
                gg[i]=cols[i]-(i>0?cols[i-1]+1:0);
                if(gg[i]<0) assrt();
            }
            p.setResidueGap(gg);
        }
        return g2c._deleted;
    }
#endif //CPP_WITH_GUI
}
