package charite.christo.strap;
import charite.christo.*;
import java.io.*;
import static charite.christo.ChUtils.*;
import java.util.*;

public final class LocalSequenceDB{
#if CPP_WITH_LocalSequenceDB
    public final static int HASH_DIR=-1,HASH_FILE=-3,HASH_RANGE_FILE=-5,SECTIONS=20*1000,RANGE_BYTES=4+2;
    private final File _f;
    private final String _db;
    private final ExactMatch _em;
    private RandomAccessFile _raf,_rafH[]={null,null},_rafR[]={null,null};
    private final boolean[]_problem=new boolean[2];
    private LocalSequenceDB(String db,File f){
        _f=f;
        _db=db;
        _em=new ExactMatch(this);
    }

    public File hashFile(boolean anno,int section){
        final BA sb=baClr(102).a(_f).a(XMATCH_SFX_DIR).a(anno?"/hashAnno":"/hash");
        if(section==HASH_FILE){
            sb.a(".txt");
        }else if(section==HASH_RANGE_FILE){
            sb.a(".range");
        }else{
            sb.a(".tmp/");
            if(section!=HASH_DIR) sb.a(section);
        }
        return new File(sb.toString());
    }

    private static LocalSequenceDB[]_ii;
    public static CPP_sync LocalSequenceDB[]instances(){
        if(_ii==null){
            final String[]aa=splitTkns(',',prprty(iPAR_LOCAL_DB));
            final LocalSequenceDB[]ii=new LocalSequenceDB[aa.length];
            int count=0;
            for(String a:aa){
                final BA log=baOut(ANSI_INVERSE).aa("LocalSequenceDB ",ANSI_RESET+" ");
                final int colon=a.indexOf(':',2);
                if(colon<0){
                    log.a(RED_ERROR).aln("Error for option "+PAR_LOCAL_DB+"\nThe database file must be preceded by database colon.\n Example: "+PAR_LOCAL_DB+"=UNIPROT:/local/files/db/uniprot.fasta.gz").special(EXIT_NOW);
                    continue;
                }
                final File f=file(a.substring(colon+1));

                final LocalSequenceDB lsdb=new LocalSequenceDB(a.substring(0,colon+1),f);
                final File fGFFA=file(addSfx(XMATCH_SFX_GFFFA,f)),fHash=lsdb.hashFile(false,HASH_FILE);
                log.aFile(fGFFA).a(' ').aFile(fHash).aln();
                if(!prgOptOn(iPAR_FORMATDB) && (sze(fGFFA)==0 || 0==sze(fHash))){
                    baOut(RED_ERROR)
                        .aFile(fHash).a(' ').aFile(fGFFA)
                        .aln("\n  Error for option "+PAR_LOCAL_DB+"\nNeed create DB indices with command line option "+PAR_FORMATDB).special(DEBUG_EXIT);
                }else{
                    ii[count++]=lsdb;
                }
            }
            _ii=chSze(ii,count,LocalSequenceDB.class);
        }
        return _ii;
    }
/* <<< Constructor <<< */
/* ---------------------------------------- */
/* >>> Getters >>> */
    public File f(){return _f;}
    public String db(){return _db;}
    public ExactMatch exactMatch(){return _em;}
/* <<< Getters <<< */
/* ---------------------------------------- */
/* >>> Txt for ID >>> */
    BA getTextAtPos(long position,BA sb){
        RandomAccessFile raf=_raf;
        try{
            if(raf==null) _raf=raf=new RandomAccessFile(file(addSfx(XMATCH_SFX_GFFFA,_f)),"r");
            raf.seek(position);
            final ChInStream cis=new ChInStream(raf,999);
            final BA LINE=new BA(999);
            if(clr(sb)==null) sb=new BA(999);
            for(int iL=0;cis.readLine(clr(LINE));iL++){
                final char c0=LINE.charAt(0),c1=LINE.charAt(1);
                final boolean slashSlash=c0=='/' && c1=='/';
                if(iL>0 && (slashSlash || c0=='>')) break;
                if(!slashSlash) sb.aln(LINE);
            }
            return sb;
        }catch(IOException iox){
            _problem[0]=_problem[1]=true;
            stckTrc(135,iox);
        }
        return null;
    }

    public static CPP_sync  BA getTextForID(String dbColonId){
        if(dbColonId==null) return null;
        final int colon=dbColonId.indexOf(':');
        final String id=dbColonId.substring(colon+1);
        BA txt=null;
        for(LocalSequenceDB db:instances()){
            if(colon>0 && !dbColonId.startsWith(db._db)) continue;
            if((txt=db.getSeqAndAnnoTextMulti(false,new SeqWithID[]{new SeqWithID(id,null)},null))!=null) break;
        }
        return txt;
    }

    public static LocalSequenceDB instanceForDB(String dbColon){
        for(LocalSequenceDB i:LocalSequenceDB.instances()){
            if(i.db().equals(dbColon)) return i;
        }
        return null;
    }
/* <<< Txt For ID <<< */
/* ---------------------------------------- */
/* >>> Multi >>> */

    public static class SeqWithID implements Comparable{
        public SeqWithID(String id,CPP_AS_OBJECT(Protein)sequence){
            _seq=sequence;
            final int hc=(_id=delToLstChr1(':',id)).hashCode()%SECTIONS;
            _hash=hc<0?-hc:hc;
        }
        private final CPP_AS_OBJECT(Protein)_seq;
        private final String _id;
        private final int _hash;
        private long _compare,_filePos=-1;
        public int compareTo(Object o){
            final long y=((SeqWithID)o)._compare;
            return _compare<y?-1:_compare==y?0:1;
        }
    }

    public BA getSeqAndAnnoTextMulti(boolean onlyAnnotated,SeqWithID[]ss,ChRunnable notify){
        final BA buffer=new BA(333);
        final int iHash=onlyAnnotated?1:0;
        byte[]T=new byte[999];
        final boolean multi=notify!=null IF_MEIN_DEBUG(,debug=false);
        final int time1=multi?timeOn():0;
        if(multi){
            for(SeqWithID s:ss) s._compare=s._hash;
            Arrays.sort(ss);
        }

        final File fH=hashFile(onlyAnnotated,HASH_FILE);
        final File fR=hashFile(onlyAnnotated,HASH_RANGE_FILE);
        RandomAccessFile rafH=_rafH[iHash],rafR=_rafR[iHash];
        if(rafH==null && !_problem[iHash]){
            try{
                rafH=_rafH[iHash]=new RandomAccessFile(fH,"r");
                rafR=_rafR[iHash]=new RandomAccessFile(fR,"r");
            }catch(Exception ex){
                errorEx(ex,"LocalSequenceDB "," fH=",fH," fR=",fR);
                _problem[iHash]=true;
            }
        }
        // -------------------------------
        for(SeqWithID s:ss){
            int pos=0,len=0;
            String err=null,warn=null;
            try{
                try{
                    rafR.seek(RANGE_BYTES*s._hash);
                    rafR.readFully(T,0,RANGE_BYTES);
                    pos=(int)lEndian(T,0,4);
                    len=(int)lEndian(T,4,2);
                    rafH.seek(pos);
                    if(T.length<len) T=new byte[len*3/2];
                    rafH.readFully(T,0,len);
                    IF_MEIN_DEBUG(if(debug) baOut("LocalSequenceDB ").aa("pos=",pos," len=",len).aln());;
                }catch(Exception ex){
                    errorEx(ex);
                    err="Reading Hash";
                    continue;
                }

                if(len==0) {warn="No entries for hash "; continue;}
                if(T[0]!='\n') {err="Hash table does not start with \\n "; continue;}
                final byte[]id=toByts(s._id);
                final int c0=id[0],L=id.length,iTo=len-L-2;
                FORi(0,iTo){
                    if(T[i]=='\n' && T[i+1]==c0 && T[i+L+1]=='=' && strEquAt(0,id,T,i+1)){
                        s._filePos=hexToLong(T,i+L+2,len);
                        break;
                    }
                }
            } finally{
                if(err!=null || warn!=null){
                    baOut(warn!=null?RED_WARNING:RED_ERROR).a("LocalSequenceDB ").a(err).a(warn).aln();
                    baOut("hash=").a(s._hash).a(" len=").a(len).a(" pos=").a(pos).aln().aFT(T,0,len).aln().aln();
                }
            }
        }
        final int time2=multi?timeOn():0;
        if(multi){
            baOut(ANSI_STYLE_TIME+"seq for id "+ANSI_RESET).a("Positions in RandomAccessFile ").a(time2-time1).aln(" ms");
            for(SeqWithID s:ss) s._compare=s._filePos;
            Arrays.sort(ss);
        }
        final String[]buf1={null};
        for(SeqWithID s:ss){
            if(s._filePos>=0){
                final BA txt=getTextAtPos(s._filePos,buffer);
                if(multi) runCR(RUN_SEQDB_FOUND_SEQ4ID,notify,this,s._seq,txt,buf1);
                else return txt;
            }
        }
        if(multi){
            baOut(ANSI_STYLE_TIME+"seq for id "+ANSI_RESET).a("Read seq and anno ").a(timeOn()-time2).aln(" ms");
        }
        return null;
    }

    private static long lEndian(byte[]T,int pos,int num){
        long n=0;
        ROFi0(num){
            int b=T[pos+i];
            if(b<0) b+=256;
            n|=(b<<(i<<3));
        }
        return n;
    }
#endif //CPP_WITH_LocalSequenceDB
}
