package charite.christo.strap;
import charite.christo.*;
import java.io.*;
import java.util.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
import static java.lang.Math.*;
/* The class Protein provides a protein model with amino acid */
/* sequences and coordinates for c-alpha atoms. */
/* <h3>Important methods:</h3> */
/* <UL> */
/* <LI>countRes() Number of amino acids in the protein.</LI> */
/* <LI>getResType() One letter code sequence. Terminated by 0x00. */
/* </LI> */
/* </UL> */
/* int exonForAminoZ( {exonAtRes( */
/* http://www.rcsb.org/pdb/images/1iav_bio_r_80.jpg */
/* (NUM 1) */
#define FROMSRC_CHARSEQ (1<<2)
#define FROMSRC_XYZ (1<<3)
/* --- */
#define INF3D_BASE (1<<1)
#define INF3D_CAXYZ (1<<2)
#define INF3D_XYZ (1<<3)
#define BOUNDING_BOX_INVALID Short_MIN_VALUE
#define baTmp() baClr(157)
#define appliedCDS() INTS[PROTEINI_CDS]

public final class Protein implements HasWRef,ChRunnable{
    private final static int[]_tmpFromTo={0,0},TOKEN_FT=new int[88],EXONS_UNABLE_TO_PARSE[]={};
    public final static Protein[]NONE={};
    private boolean _triedDssp,_revCompl;
    CPP_PRIVATE Collection
        _vIds,_vRef,_vIdByIdent,/*X<String>*/
        _vComplex,
        _vCDS;/*X<String[]>*/
    private Map
#if CPP_WITH_GUI
        _mapDragfileModi,/*X<File,String>*/
        _serverMC,/*X<String,int[]>*/
#endif //CPP_WITH_GUI
        _resnHash;
    private int[]IF_GUI(_seqDataMC,)_resNum,_resNam32,_resAtomNum,_resAtomIdx,_resHasXyz,_resAtomNumOffsets[],_atom32[];
    final static int[]AMINOACID_ATOMS[]=new int[BASE_ACUG+'Z'][],MC_GLOBAL=new int[MCA_MAX];
    final static short[][]AMINOACID_ELEMENTS=new short[BASE_ACUG+'Z'][];
    private int IF_GUI(_hashCdMC,)
        _countR,_fromSrc,
        _siAminoIdx,_siAtomIdx,_siAtomSerial,
        _iFtrCount,
        _tokenIdx=MIN_INT,
        _ACTGNmc=-1,_actgn,_ntCount=-1,
        _subsS=INT_NAN,_subsE,
        _xyzByIDtried,
        _nameHC,
        _vIdByIdentMC;
    private long IF_GUI(_hashCd,_balloonWhen,)_hcXYZ,_iFtr[];
    private String
        IF_GUI(_balloon[],_seqData[],_namePymol,)
        IF_AA(_orgMnem,)
        _balloonDirect,
        _name=UNNAMED,
        _accID,
        _pdbIds[],
        _chainsByType[][],
        _chain;
    private Object IF_GUI(_icon,)_icon64,_iconURL,_color;private Object _charSeq;
    private byte[]_secStr,_insCode,_cAlphaTxt,_triplets,_pnCDS,_infXYZGapped[];
    private byte _infXYZTried;
    private float[]_cAlpha,_resAccess,_atomXYZ;
/* ---------------------------------------- */
    // >>> Instance >>> */
    public Protein(){
        IF_DEBUG_THREADS(recordSync(this,"new Protein"));;
        _initAtoms();
    }
#if CPP_WITH_GUI
    private final static Object[]HAYSTACKS1=new Object[99];
#define clearCache()  _cache=null;clr(_serverMC);
#endif //CPP_WITH_GUI
#if !CPP_WITH_GUI
#define clearCache() _cache=null;
    private boolean _triedZipCalpha;
#endif //!CPP_WITH_GUI
/* <<<  Instance <<< */
/* ---------------------------------------- */
/* >>> Atoms >>> */
/* Indices of the atoms each residue starts with. From position: bits 8-31,Num positions: bits 0-7 */
    public CPP_sync int[]getResidueAtomIdx(){
        getAtomXYZ(null);
        return _resAtomIdx;
    }

#define NBOX 6
    public static void oneBox(float[]src,int srcFrom,int srcTo,short[]target,int targetOffset){
        final int to6=targetOffset*NBOX,t3=min(srcTo*3,src.length),f3=Math.max(0,srcFrom*3);
        if(f3>=t3) return;
        ROFi0(3){
            float mi=Float.MAX_VALUE,ma=Float.MIN_VALUE;
            for(int a3=f3;a3<t3; a3+=3){
                final float v=src[a3+i];
                if(!(mi<v)) mi=v;
                if(!(ma>v)) ma=v;
            }
            if(mi<Short_MIN_VALUE+2 || ma>Short_MAX_VALUE-2){
                target[to6]=BOUNDING_BOX_INVALID;
                break;
            }
            target[to6+i]=(short)(mi+.5);
            target[to6+i+3]=(short)(ma+.5);
        }

    }
    private short[]residueBoundingBox(){
        final float[]XYZ=getAtomXYZ();
        if(XYZ==null) return null;
        final int[]idx=getResidueAtomIdx();
        final Object[]cached=cached();
        short[]box=(short[])cached[P_CACHE_BBOX];
        if(setMC(P_MC_BBOX,mc((P_MC_RES_TYPE_UC<<P_MC_SHIFT)|P_MC_MATRIX3D)) || box==null){
            final int nR=subsetEnd()-subsetStart();
            cached[P_CACHE_BBOX]=box=new short[nR*NBOX];
            FORa(0,nR){
                final int aFL=a+subsetStart(),f=idx.length<=aFL?0:idx[aFL];
                if(0<=f) oneBox(XYZ,f,f+getResidueElement(false,a).length,box,a);
            }
        }
        return box;
    }
    private static float squareDistancePointPoints(boolean yesNo,float x,float y,float z,float[]xyz2,int f2,int t2,float closest2){
        for(int i=f2;i<t2; i+=3){
            final float d0=xyz2[i]-x;
            if(Float.isNaN(d0)) continue;
            final float
                d1=xyz2[i+1]-y,
                d2=xyz2[i+2]-z,
                dist2=d0*d0+d1*d1+d2*d2;
            if(dist2<closest2){
                if(yesNo) return dist2;
                closest2=dist2;
            }
        }
        return closest2;
    }

    private static boolean boundingBoxesFurtherAway(float dist,short[]b1,int i1,short[]b2,int i2){
        return
            b2[i2]!=BOUNDING_BOX_INVALID&&
            b1[i1]!=BOUNDING_BOX_INVALID&&(b2[i2  ]-b1[i1+3]>dist || b1[i1  ]-b2[i2+3]>dist||
                                           b2[i2+1]-b1[i1+4]>dist || b1[i1+1]-b2[i2+4]>dist||
                                           b2[i2+2]-b1[i1+5]>dist || b1[i1+2]-b2[i2+5]>dist);
    }

    private static boolean pointAndBoundingBoxFurtherAway(float dist,float x,float y,float z,short[]b2,int i2){
        return b2[i2]!=BOUNDING_BOX_INVALID && (
                                                x-b2[i2+3]>dist || b2[i2  ]-x>dist||
                                                y-b2[i2+4]>dist || b2[i2+1]-y>dist||
                                                z-b2[i2+5]>dist || b2[i2+2]-z>dist);
    }
    public float residueSquareDistanceZ(int opt,int iFrom,int iTo,Object p_or_ressel,float maxDist,boolean[]selected){
        final Protein p2=sp(p_or_ressel);
        if(p2==null) return Float.NaN;
        final boolean cAlpha=INTS[PROTEINI_CHAINTYPE]==CHAINTYPE_PEP && 0!=(opt&(XYZ_DISTANCE_USE_CALPHA|(_atomXYZ==null?XYZ_DISTANCE_ACCEPT_CALPHA:0))) && getResidueCalphaXYZ(null)!=null;
        if(cAlpha) maxDist+=5;
        final float[]xyz2=p2.getAtomXYZ(),xyz=cAlpha?getResidueCalphaCurrent(): getAtomXYZ();
        if(xyz==null||xyz2==null) return Float.NaN;
        final int[]ix=cAlpha?null:getResidueAtomIdx(),ix2=p2.getResidueAtomIdx();
        final short[]b=cAlpha?null:residueBoundingBox(),b2=p2.residueBoundingBox();
        iTo=min(min(iTo,countResidues()),cAlpha?xyz.length/3: min(ix.length,b.length/NBOX));
        if((iFrom=max(0,iFrom))>=iTo) return Float.NaN;
        final int rsOffset;
        final boolean[]rsSelected;
        {
            final ResidueSelection s=derefRessel(p_or_ressel);
            if(s!=null){
                rsOffset=s.getSelectedAminoacidsOffset();
                rsSelected=s.getSelectedAminoacids();
            }else{
                rsOffset=0;
                rsSelected=null;
            }
        }
        float closest=maxDist,closest2=closest*closest;
        boolean ok=false;
        final boolean yesNo=0!=(opt&XYZ_DISTANCE_YES_OR_NO)||selected!=null;
        for(int i2To=min(min(sze(ix2),p2.countResidues()),b2.length/NBOX),i=iFrom,i3=3*i;i<iTo; i++,i3+=3){
            int f=0,t=0;
            float x=0,y=0,z=0;
            if(cAlpha){
                if(Float.isNaN(x=xyz[i3])) continue;
                y=xyz[i3+1];
                z=xyz[i3+2];
            }else{
                if((f=ix[i]*3)<0)continue;
                t=f+3*getResidueElement(false,i).length;
            }
            ROFj0(i2To){
                float newClosest2=closest2;
                final int f2=ix2[j]*3;
                if(f2<0)continue;
                final int t2=f2+3*p2.getResidueElement(false,j).length;
                if(rsSelected!=null && !iThBool(j+firstResIdx(p2)-rsOffset,rsSelected)) continue;
                if(cAlpha){
                    if(pointAndBoundingBoxFurtherAway(closest+0.5f,x,y,z,b2,j*NBOX)) continue;
                    IF_MEIN_DEBUG(if(t2>xyz2.length) baOut(RED_ERROR).aln("t2>xyz2.length. exit now"));;
                    newClosest2=squareDistancePointPoints(yesNo,x,y,z,xyz2,f2,t2,newClosest2);
                }else{
                    if(boundingBoxesFurtherAway(closest+1,b,i*NBOX,b2,j*NBOX)) continue;
                    for(int at=f;at<t; at+=3){
                        if(!Float.isNaN(x=xyz[at])){
                            final float dist2=squareDistancePointPoints(yesNo,x,xyz[at+1],xyz[at+2],xyz2,f2,t2,newClosest2);
                            if(dist2<newClosest2){
                                newClosest2=dist2;
                                if(yesNo) break;
                            }
                        }
                    }
                }
                if(newClosest2<closest2){
                    if(selected!=null){
                        if(i<selected.length) selected[i]=true;
                        break;
                    }
                    closest=(float)Math.sqrt(closest2=newClosest2);
                    if(yesNo) return closest;
                    ok=true;
                }
            }
        }
        return ok?closest:Float.NaN;
    }

/* <<< Atoms <<< */
/* ---------------------------------------- */
/* >>> DNA RNA >>> */
#if CPP_WITH_GUI
    public String getNameForPymol(){
        if(_namePymol==null) _namePymol=new BA(99).aBytesAdj(getResidueName32()[0],4).aInt(resnAt(RESIDUE_FULL,0),4).aa('_',getChain()).replaceChar(' ','_').toString();
        return _namePymol;
    }
#endif //CPP_WITH_GUI
    public BA appendNucColonChain(BA sb){
        final int t=INTS[PROTEINI_CHAINTYPE];
        if(t==CHAINTYPE_DNA||t==CHAINTYPE_RNA) sb.aa(t==CHAINTYPE_DNA?'D':'R',"NA:",getChain());
        else MEIN_ASSRT();
        return sb;
    }
#if CPP_DEACTIVATED
    public static Protein newHeteroCompoundByName(int name32,String name){
        final Protein p=new Protein();
        p.setResidueName32(new int[]{name32});
        p.setName(name);
        return p;
    }
#endif //CPP_DEACTIVATED
#if CPP_DEACTIVATED
    public static Protein newMoleculeBySrc(int pdbChainType,String chain,Object fileOrUrlOrId){
        final Protein p=new Protein();
        p.setIntProperty(PROTEINI_CHAINTYPE,pdbChainType);
        p.setChain(chain);
        p.setProperty(PROTEINO_PARSE_AGAIN_SRC,fileOrUrlOrId);
        return p;
    }
#endif //CPP_DEACTIVATED
/* AA: The side chain atoms are parsed only on demand */
/* GUI: pdb/cif-file Side chain atoms are initially parsed */
/* GUI: Planed: pdb/cif-files are reformated to strap-format. If read from strap-format, then initially only C-alpha */
#define SFX_STRAPFORMAT_XYZ ".XYZ"
    private void _fromSrc(int opt){
        final Object src=getProperty(PROTEINO_PARSE_AGAIN_SRC);
        if(src==null)return;
        opt&=~_fromSrc;
        _fromSrc|=opt;
        if(0!=(opt&FROMSRC_XYZ) && (_atomXYZ!=null||0==(_flags&PFLAG_HAS_XYZ))) opt&=~FROMSRC_XYZ;
        if(0!=(opt&FROMSRC_CHARSEQ) && deref(_charSeq)!=null) opt&=~FROMSRC_CHARSEQ;
        if(opt!=0){
#if CPP_PRG_AA
            if(strStarts("PDB:",src)){
                if(0!=(opt&FROMSRC_CHARSEQ)) sequenceParser(BUT_C1(StrapParser)).parse(0,getChain(),xyzArchiveGetTxt(F_RO_ARCHIVE_PDB,pdbID((String)src)),this);
                if(0!=(opt&FROMSRC_XYZ)){
                    sequenceParser(BUT_C1(StrapParser)).parse(0,getChain(),xyzArchiveGetTxt(F_RO_ARCHIVE_PDB_XYZ,pdbID((String)src)),this);
                }
            }
#endif //CPP_PRG_AA
            if(looks(LIKE_FILEPATH,src)){
                final ProteinParser parser1=(ProteinParser)getProperty(PROTEINO_PARSER);
                if(xatoi(runCR(RUN_GET_INSTANCE_TYPE,parser1))==SPARSER_STRAPFORMAT){
                    parser1.parse(0,getChain(),readBytes(0!=(opt&FROMSRC_XYZ)?file(addSfx(SFX_STRAPFORMAT_XYZ,src)):src),this);
                }else{
                    final BA txt=readBytes(file(src));
                    final int t=getIntProperty(PROTEINI_CHAINTYPE);
                    CPP_synchronized(SYNC_PDB){
                        for(ProteinParser parser:seqParsers())
                            if(null!=parser.parse(0,null,txt,null))
                                parser.parse((t==CHAINTYPE_DNA||t==CHAINTYPE_RNA?PROTPARS_AS_DNA_OR_RNA:PROTPARS_NAME_FROM_FA_HEADER),getChain(),txt,this);
                    }
                }
            }
        }
    }

/* <<< DNA RNA <<< */
/* ---------------------------------------- */
/* >>> Hetero Compound >>> */

    public CPP_sync boolean containsHeteroCompound(Object h){
        return h instanceof Protein && _vv!=null && cntainsEl(h,_vv[CHAINTYPE_NUC_OR_HET]);
    }
/* <<< Hetero Compounds <<< */
/* ---------------------------------------- */
/* >>> Residues >>> */

/** The original character sequence which can be aminos or nucleotides. Do not use this method.   */
    public CPP_sync void setCharSequence(byte[]tt){
        strapIncMC(P_MC_CHARSEQ,this);
        _charSeq=tt;
        clearCache();
        //IF_BLAST(_flags&=~(PFLAG_BLAST4ID_PDB|PFLAG_BLAST4ID_UNIPROT));;
        //IF_BLAST(setProperty(PROTEINO_BLAST4ID_VV,null));;
        _ntCount=-1;
    }

    private File fileSoftRef(){
        return(_flags&PFLAG_IS_IN_MSF)==0 && isTranslated() && getProperty(PROTEINO_PARSER)!=null?getFile():null;
    }
/**   The original character sequence which can be aminos or nucleotides.  Do not use this method.  */
    public CPP_sync byte[]getCharSequence(){
        byte[]seq=(byte[])deref(_charSeq);
        if(seq==null)_fromSrc(FROMSRC_CHARSEQ);
/* if(seq==null && _charSeq!=null && isTranslated()){ */
/*     final File f=fileSoftRef(); */
/*     final ProteinParser parser=(ProteinParser)getProperty(PROTEINO_PARSER); */
/*     if(f!=null && parser!=null){ */
/*         final Protein p=new Protein(); */
/*         parser.parse(PROTPARS_NO_RESSEL,null,readBytes(f),p); */
/*         _charSeq=newSoftRef(seq=p.getCharSequence()); */
/*     } */
/* } */
        return seq==null?NO_byte:seq;
    }
#if 0
/**
       Like getResidueType() but only the current subset.
       The sequence in one letter format.
       The byte array might be longer than countRes() which iss the number of residues in the proteins.
       In this case it is 0-terminated.
       Never ever obtain the length of the protein by getResType().length.
*/
#endif //0
    public CPP_sync byte[]getResType(){
        final byte[]fullLength=getResidueType();
        MC[P_MC_RES_TYPE]=_mcSubset+MC[P_MC_RES_TYPE_FULL];
        if(!isSubset()) return fullLength;
        final Object[]cached=cached();
        byte[]rt=(byte[])cached[P_CACHE_RESIDUES];
        if(rt==null) cached[P_CACHE_RESIDUES]=rt=copyOfBytes(fullLength,subsetStart(),subsetEnd());
        return rt;
    }
#if CPP_WITH_GUI
    public CPP_sync long getResTypeHC(){
        final byte[]bb=getResType();
        if(DIFF_MC(_hashCdMC,MC[P_MC_RES_TYPE]) || _hashCd==0) _hashCd=hashCdLUC(bb,0,MAX_INT);
        return _hashCd;
    }
#endif //CPP_WITH_GUI

/* Like getResType() but upper case. */
/* Unlike getResType() which returns a null terminated byte array,this method returns a byte array of length countRes(). */
    public CPP_sync byte[]getResTypeUC(){
        final byte[]aa=getResType();
        final int N=countRes();
        final Object[]cached=cached();
        byte[]AA=(byte[])cached[P_CACHE_RES_UC];
        if(setMC(P_MC_RES_TYPE_UC,MC[P_MC_RES_TYPE]) || AA==null || AA.length!=N){
            cached[P_CACHE_RES_UC]=AA=new byte[N];
            ROFi0(N) AA[i]=(byte)(aa[i]&~32);
        }
        return AA;
    }
    public CPP_sync String getResTypeSUC(){
        final byte[]aa=getResTypeUC();
        final Object[]cached=cached();
        String AA=(String)cached[P_CACHE_RES_STRG_UC];
        if(setMC(P_MC_RES_TYPE_STRG_UC,MC[P_MC_RES_TYPE_UC]) || AA==null){
            cached[P_CACHE_RES_STRG_UC]=AA=s(aa);
        }
        return AA;
    }
/** get the i-th amino acid or 0. The index starts at 0 */
    public CPP_sync byte getResTypeAt(int i){
        final byte[]aa=getResType();
        return 0<=i && i<aa.length && i<countRes()?aa[i]:0;
    }
/**  set the array of amino acids */
    public CPP_sync void setResidueType(Object seq){
        final boolean ok=nxt(0,chrClas(-LETTR),seq)<0;
        setCharSequence(toByts(ok?seq: new BA(0).aFilter(LETTR,seq)));
    }
/** number of residues,returns  getResType().length */
    public CPP_sync int countRes(){
        if(INTS[PROTEINI_CHAINTYPE]==CHAINTYPE_HET) return 1;
        final byte[]bb=getResType();
        final int cr=SZE(bb);
        if(_countR!=cr) {_countR=cr; strapIncMC(MCA_RES_COUNT_NOSYNC,null);}
        return cr;
    }
    int unsyncResCount(){return _countR;}
/** the chain denominators  of each residue  */

    public void setChain(String c){
        strapIncMC(P_MC_RESNUM,this);
        if(sze(c)==0) _chain=null;
        else if(!c.equals(_chain)) _chain=toStrgIntrn(c);
    }
    public String getChain(){return _chain;}

    public boolean aSecStru(BA sb){
        final byte[]ss=getResidueSecStrType();
        if(ss==null) return false;
        int L=-1;
        ROFi0(min(countResidues(),ss.length)){
            final byte c=ss[i];
            if(c==SECSTRU_NONE || IS_UPPER_OR_LOWER(c)){
                if(L<0 && i<subsetEnd()) L=i+1;
            }else{
                ss[i]=(byte)'-';
            }
        }
        {

            if(L<=subsetStart()) return false;
            sb.aFT(ss,subsetStart(),L);
        }
        return true;
    }
/* <<<  <<< */
/* ---------------------------------------- */
/* >>> resNum  >>> */
    public BA resnToIdxInTxt(BA txt){
        if(txt==null) return null;
        BA sb=null;
        final byte[]T=txt.bytes();
        final int b=txt.begin(),e=txt.end();
        int copiedTo=b;
        for(int i=b+1;i<e;i++){
            if(T[i]==':'){
                final String chain=pdbChainAt(T,i+1,e);
                final int chainL=sze(chain),nxt=i+1+chainL;
                if(chainL==0 || chain.equals(getChain())){
                    int d=i-1,nDigits=0,ins=INSCODE_IGNORE;
                    if(IS_UPPER(T[d])) ins=T[d--];
                    if(IS_UPPER(T[d])) ins=T[d--];
                    while(d>=b && IS_DIGIT(T[d])) {nDigits++;d--;}
                    if(nDigits>0){
                        if(!(d>=b && T[d]=='-' && (d==b||!isChrClas(LETTR_DIGT_US_COLON,T,d-1)))) d++;
                        if(sb==null) sb=new BA(e-b);
                        final int resn=atoi(T,d),ix=resnToIdx(RESIDUE_FULL,resn,(char)ins);
                        sb.aFT(T,copiedTo,d);
                        if(ix<0) sb.a("NaN"); else sb.a(ix+1+getIntProperty(PROTEINI_AA_IDX_OFFSET));
                        copiedTo=nxt;
                    }
                }
            }
        }
        return sb!=null?sb.aFT(T,copiedTo,e): txt;
    }
    private static boolean _eqInsCode(int insAtI,int ins){
        if(ins==' ') ins=INSCODE_WITHOUT;
        return ins==INSCODE_IGNORE || insAtI==ins || ins==INSCODE_WITHOUT && insAtI==0;
    }

#if CPP_WITH_MEIN_DEBUG
    public int resnToIdxErr(int resn,char insCode,int name,BA err){
        final int i=resnToIdx(RESIDUE_FULL,resn,insCode);
        final byte[]aa=getResType();
        final int rt=name==0?0:name<'z'?name: toOneLetterCode(name);
        if(i<0 || i>=aa.length || (name!=0 &&  (rt|32)!=(aa[i]|32))){
            for(Protein h:getMolecules(CHAINTYPE_HET)){
                if(h.getChain()==getChain() && h.getResidueName32()[0]==name) return RESN_TO_IDX_IS_HETERO;
            }
            err.aa(" resnToIdxErr(",resn,',').an(insCode,insCode>='A'?1:0).a(',').aBytes(name).aBytes(')'|('='<<8)).aa(i,'/',aa.length);
            if(i>=0) resnAsText(0,i,err.aBytes(' '|('='<<8)).aa(chrAt(i,aa),','));
            resnToSeries(0,err.a("  _resNum="));
            //err.a("  _resNum=").aIntArray(_resNum,0,MAX_INT);
        }
        return i;
    }
#endif //CPP_WITH_MEIN_DEBUG
    public CPP_sync int resnToIdx(int opt,int resn,char insCode){
        final int rn[]=_resNum,subsetStart=subsetStart(),subsetEnd=subsetEnd();
        if(insCode<'A') insCode=INSCODE_WITHOUT;
        if(rn==null){
            int ia=resn-1-getIntProperty(PROTEINI_AA_IDX_OFFSET);
            if(ia<0 || !_eqInsCode(iThByte(ia,_insCode),insCode)||
               0==(opt&RESIDUE_FULL) && (ia-=subsetStart)<0) return -1;
            return ia;
        }
        final int L=min(countResidues(),rn.length);
        if(0!=(_flags&PFLAG_RNUM_ASCENDING)){
            int i=Arrays.binarySearch(rn,0,L,resn);
            if(i>=0){
                while(i>0 && rn[i-1]==resn) i--;
                ROFt0(insCode==INSCODE_IGNORE&&_insCode!=null?2:1){/*X t=0/1 no insertion. If insCode==0 then first try with INSCODE_WITHOUT; then try again ignoring _insCode code */
                    for(;i<L && rn[i]==resn;i++){
                        if(!_eqInsCode(iThByte(i,_insCode),t>0?INSCODE_WITHOUT:insCode)) continue;
                        if(0!=(opt&RESIDUE_FULL)) return i;
                        else if(i>=subsetStart && i<subsetEnd) return i-subsetStart;
                    }
                }
            }
        }else{
            final int result=mapResnToI(MAP_RETRIEVE,resn,(byte)insCode,0);
            if(result==INT_NAN && insCode==INSCODE_IGNORE){
                ROFi0(L) if(rn[i]==resn) return i;
            }
            return result!=INT_NAN?result: -1;
        }
        return -1;
    }
    public int indexFromExpression(byte[]T,int f,int t){
        if(T==null||f<0) return -1;
        ASSIGN_LE_LENGTH(t,T);
        final int numE=nxt(STR_E,chrClas(-DIGT),T,chrAt(f,T)=='-'?1+f:f,t);
        if(numE==f) return -1;
        final int num=atoi(T,f,numE),colon=strchr(':',T,numE,min(t,numE+2));
        if(colon<0) return num-1;
        final char ins;
        if(colon==numE) ins=INSCODE_IGNORE;
        else if((ins=insCodeChar(chrAt(numE,T)))==0) return num-1;
        if(!eqStr(getChain(),pdbChainAt(T,colon+1,t))) return -1;
        return resnToIdx(0,num,ins)+firstResIdx(this);
    }
/**  Converts  String denominating a subset of residues  into a boolean array       E.g.  "1-3,5-6" ==>  XXX.XXX....    */
    public boolean[]residueSubsetAsBool(CPP_AS_OBJECT(CharSequence)expr,int[]returnMinIdx){
        returnMinIdx[0]=0;
        if(expr==null) return null;
        {
            final String otherId;
            final int f,t;
            CPP_synchronized(recordSync(_tmpFromTo,"residueSubsetAsBool")){
                otherId=declaredValue(RESAN_POS_REFERENCE,expr,0,MAX_INT,_tmpFromTo);
                f=_tmpFromTo[0];
                t=_tmpFromTo[1];
            }
            if(otherId!=null){
                final Object offset=refSeqOffset(true,otherId);
                final BA txt2=new BA(99).aFT(expr,0,f-10).aFT(expr,t,MAX_INT);
                final boolean[]bb;
                if(offset instanceof Integer){
                    bb=residueSubsetAsBool(txt2,returnMinIdx);
                    returnMinIdx[0]-=xatoi(offset);
                }else{
                    final Protein refP=((ReferenceSequence)offset).refP();
                    bb=refP==null?NO_boolean:((ReferenceSequence)offset).refIdx2Idx(refP.residueSubsetAsBool(txt2,_tmpFromTo),_tmpFromTo[0],returnMinIdx);
                }
                return bb;
            }
        }
        final ChTokenizer tok=toknzr(338,SPACE_COMMA).setText(resnToIdxInTxt(toBA(expr)));
        final int maxIdx=countResidues()+firstResIdx(this)+1;
        CPP_synchronized(SYNC_PARSE_SET){
            return parseSetGet(returnMinIdx[0]=(int)((parseSet(tok,0,maxIdx))>>RANGEFROM_SHIFT),MAX_INT);
        }
    }
/* <<<  <<< */
    public Object refSeqOffset(boolean create,String id){
        Map m=_mapRefSeqOffset;
        if(id==null || !create&&m==null) return null;
        if(m==null) m=_mapRefSeqOffset=new HashMap();
        Object offset=m.get(id);
        if(offset==null&&create)  m.put(id,offset=new ReferenceSequence(id,this));
        return offset;
    }
    public int resnAt(int opt,int idx){
        final int i=idx+(0!=(opt&RESIDUE_FULL)?0:subsetStart());
        if(i<0||i>=subsetEnd()) return INT_NAN;
        final int[]nn=_resNum;
        if(nn!=null&&i<nn.length) if(nn[i]!=INT_NAN) return nn[i];
        return i+1;
    }

    public BA resnAsText(int opt,int i,BA sb){
        final byte[]ii=0!=(opt&RESIDUE_NO_INS)?null:getResidueInsCode();
        final int rn=resnAt(opt,i);
        if(rn!=INT_NAN){
            sb.a(rn);
            if(ii!=null){
                final char ins=chrAt(i+(0!=(opt&RESIDUE_FULL)?0:subsetStart()),ii);
                if(ins!=0) sb.a(ins);
            }
            if(0==(opt&RESIDUE_NO_CHAIN))  sb.and(":",getChain());
        }
        return sb;
    }
/**  Set Numbers of each residue,as recorded in the PDB files.       NO_int or NO_byte to leave unchanged */
    private int mapResnToI(int mode,int rn,byte ic,int ia){
        Map m=_resnHash;
        if(_resnHash==null){
            _resnHash=m=new HashMap();
            final int resn[]=_resNum;
            ROFi0(resn.length){
                final int n=resn[i];
                if(n!=INT_NAN){
                    IF_MEIN_DEBUG(final int current=)mapResnToI(MAP_OVERWRITE,n,iThByte(i,_insCode),i);;
#if CPP_WITH_MEIN_DEBUG
                    if(INT_NAN!=current) ((BA)runCR(RUN_PDBCIF_LOG_WARN,sequenceParser(BUT_C1(PDBParser))))
                                             .aa("RESN_NOT_UNIQUE ",i,'/',current," rn=",n,chrAt(i,_insCode)).del('\0').aln().a(" rIns=").aln(_insCode);
#endif //CPP_WITH_MEIN_DEBUG
                }
            }
        }
        final Object key=IS_UPPER(ic)?longObjct(((long)rn<<8)|insCodeChar(ic)): io(rn);
        Object prev=mode==MAP_RETRIEVE || mode==MAP_NO_OVERWRITE?m.get(key):null;
        if(mode!=MAP_RETRIEVE && prev==null) prev=m.put(key,io(ia));
        return prev==null?INT_NAN:xatoi(prev);
    }

    private byte[]_setUniqueResn(int step,int ia,int[]resn,byte[]insCode){
        if(resn[ia]!=INT_NAN) assrt();
        int rn=resn[ia-step];
        byte ins=iThByte(ia-step,insCode);
        while(true){
            ins+=step;
            if(!IS_UPPER(ins)){
                rn+=step;
                ins=0;
            }
            if(mapResnToI(MAP_NO_OVERWRITE,rn,ins,ia)==INT_NAN){
                resn[ia]=rn;
                if(IS_UPPER(ins)){
                    if(insCode.length<=ia) insCode=chSze(insCode,ia+20);
                    insCode[ia]=ins;

                }
                break;
            }
        }
        return insCode;
    }
    public CPP_sync void setResn(int[]resn,byte[]insCode){
        _resnHash=null;
        if(sze(insCode)>0) _insCode=insCode;/*X  Already required for mapResnToI(..);*/
        if(resn!=null && resn!=NO_int){
            _resNum=resn;
            boolean ascending=true;
/* Fill INT_NAN backward using insCode */
            if(insCode==null) insCode=NO_byte;
            ROFi0(resn.length-1) if(resn[i]==INT_NAN && resn[i+1]!=INT_NAN) insCode=_setUniqueResn(-1,i,resn,insCode);

/* Fill INT_NAN forward using num or insCode */
            FORi(0,resn.length){
                final int v=resn[i],prev=i==0?INT_NAN:resn[i-1];
                if(v==INT_NAN && prev!=INT_NAN) _setUniqueResn(1,i,resn,insCode);
                if(ascending && prev>=v) ascending=false;
            }
            if(ascending) _flags|=PFLAG_RNUM_ASCENDING;
            else _flags&=~PFLAG_RNUM_ASCENDING;
            ROFi0(sze(insCode)) insCode[i]=(byte)insCodeChar(insCode[i]);
            strapIncMC(P_MC_RESNUM,this);
            clearCache();

        }
    }
    public CPP_sync byte[]getResidueInsCode(){return _insCode;}
    public CPP_sync int[]getResidueName32(){_fromSrc(FROMSRC_XYZ); return _resNam32;}
/**  Names of i-th residue,as recorded in the PDB files or -1.*/
    public CPP_sync int getResName32At(int i){
        final int nR=countRes();
        if(i<0||i>=nR) return INT_NAN;
        final int name32=iThIntOr(i+subsetStart(),_resNam32,0);
        return name32>0?name32:toThreeLetterCode(iThByte(i,getResType()));
    }
    public boolean resnToSeries(int from,BA sb){
        if(_resNum!=null){
            final int t=min(subsetEnd(),MAX_INT);
            seriesToTextN(STT_WRITE_LAST,_resNum,RANGE_FROM_TO(uintToLong(from),t),1,0,0,sb);
            return true;
        }else if(getChain()!=null){
            final int n1=resnAt(0,from);
            if(n1!=INT_NAN){
                if(n1!=1+from){
                    sb.aa("0=",n1);
                    return true;
                }
            }
        }
        return false;
    }
    public boolean toSeries(int what,int from,int to,BA sb){
        final byte[]ins=what==SERIES_INS?_insCode: what==SERIES_SECSTRU?_secStr:null;
        if(nxt(0,chrClas(LETTR),ins)>=0){
            final int f=subsetStart()+from,t=to==MAX_INT?subsetEnd(): min(subsetEnd(),to-from+f);
            seriesToTextC(S2T_US4SPC|S2T_INDEX1,ins,RANGE_FROM_TO(subsetStart(),t),sb);/*X subsetStart() never < 0 */
            return true;
        }
        return false;
    }
/* <<< resNum <<< */
/* ---------------------------------------- */
/* >>>  >>> */

/** set Names of each residue,as recorded in the PDB files. */
    public void setResidueName32(int[]rn) {_resNam32=rn;}
/* Atom number of the first atom of the amino acid. */
/* <PRE> */
/* ATOM  39607  CG  GLN V 195      18.039-150.197  79.532 */
/* </PRE> */
/* The atom number is 39607. */
    public CPP_sync int[]getResidueAtomNumber(){
        if(_resAtomNum==null) _fromSrc(FROMSRC_XYZ);
        return _resAtomNum;
    }
/** set atom numbers  of each residue,as recorded in the PDB files.*/
    // ----------------------------------------
/** Residue accessibility in square Angstroms */
    public float[]getResidueAccessibility1(int opt){
        if(opt!=0&&_resAccess==null) _resAccess=getAccessibility(0!=(opt&RESIDUE_ACCESSIBILITY_COMPUTE_AGAIN),spp(this));
        return _resAccess;
    }
/** Set accessibilities of residues */
    public CPP_sync void setResidueSolventAccessibility(float[]a){
        strapIncMC(P_MC_ACCESSIBILITY,this);
        _resAccess=a;
        clearCache();
    }
    // ----------------------------------------
/** Secondary structure (H,E,C) */
    public CPP_sync void setResidueSecStrType(byte[]a){
        if(a!=_secStr){
            ROFi0(sze(a)) if(a[i]==0) a[i]=SECSTRU_NONE;
            strapIncMC(P_MC_RES_SECSTRU,this);
            _secStr=a;
        }
    }
/** H=helix,C=coil,E=Extended,Sheet  */
    public CPP_sync byte[]getResidueSecStrType(){
        if(_secStr==null && !_triedDssp  IF_AA(&&!isPrprty(IS_AA_SETUP)) && countResidues()>10){
            _triedDssp=true;
            //            if(!hasXYZ(this) && hasXYZorPDBID(true)) assignSecStru(this);
            if(!hasXYZ(this) && getPdbID(PDBID_ANY_SIMILAR)!=null) assignSecStru(this);
        }
        return _secStr;
    }
/* <<< Sec Structure <<< */
/* ---------------------------------------- */
/* >>> Atom >>> */
@*RSC_ATOMS
     N CA C O CB a=ASCII_A
     N CA C O CB SG a=ASCII_C
     N CA C O CB CG OD1 OD2 a=ASCII_D
     N CA C O CB CG CD OE1 OE2 a=ASCII_E
     N CA C O CB CG CD1 CD2 CE1 CE2 CZ a=ASCII_F
     N CA C O a=ASCII_G
     N CA C O CB CG ND1 CD2 CE1 NE2 a=ASCII_H
     N CA C O CB CG1 CG2 CD1 a=ASCII_I
     N CA C O CB CG CD CE NZ a=ASCII_K
     N CA C O CB CG CD1 CD2 a=ASCII_L
     N CA C O CB CG SD CE a=ASCII_M
     N CA C O CB CG OD1 ND2 a=ASCII_N
     N CA C O CB CG CD a=ASCII_P
     N CA C O CB CG CD OE1 NE2 a=ASCII_Q
     N CA C O CB CG CD NE CZ NH1 NH2 a=ASCII_R
     N CA C O CB OG a=ASCII_S
     N CA C O CB OG1 CG2 a=ASCII_T
     N CA C O CB CG1 CG2 a=ASCII_V
     N CA C O CB CG CD1 CD2 NE1 CE2 CE3 CZ2 CZ3 CH2 a=ASCII_W
     N CA C O CB CG CD1 CD2 CE1 CE2 CZ OH a=ASCII_Y

     P OP1 OP2 O5, C5, C4, O4, C3, O3, C2, C1, N9 C8 N7 C5 C6 N6 N1 C2 N3 C4 d=ASCII_A
     P OP1 OP2 O5, C5, C4, O4, C3, O3, C2, C1, N1 C2 O2 N3 C4 N4 C5 C6 d=ASCII_C
     P OP1 OP2 O5, C5, C4, O4, C3, O3, C2, C1, N9 C8 N7 C5 C6 O6 N1 C2 N2 N3 C4 d=ASCII_G
     P OP1 OP2 O5, C5, C4, O4, C3, O3, C2, C1, N1 C2 O2 N3 C4 O4 C5 C7 C6 d=ASCII_T

     P OP1 OP2 O5, C5, C4, O4, C3, O3, C2, O2, C1, N9 C8 N7 C5 C6 O6 N1 C2 N2 N3 C4 r=ASCII_A
     P OP1 OP2 O5, C5, C4, O4, C3, O3, C2, O2, C1, N1 C2 O2 N3 C4 N4 C5 C6 r=ASCII_C
     P OP1 OP2 O5, C5, C4, O4, C3, O3, C2, O2, C1, N9 C8 N7 C5 C6 O6 N1 C2 N2 N3 C4 r=ASCII_G
     P OP1 OP2 O5, C5, C4, O4, C3, O3, C2, O2, C1, N1 C2 O2 N3 C4 O4 C5 C6 r=ASCII_U
*@
    public static void _initAtoms(){
        if(AMINOACID_ELEMENTS[ASCII_A]!=null)return;
        final BA txt=rsc(RSC_ATOMS|RSC_NO_SAVE).replaceChar(',','\'');
        final ChTokenizer tok=new ChTokenizer(SPC);
        final byte[]T=txt.bytes();
        final int eol[]=txt.eol(),buf[]=new int[33];
        FORiL(0,eol.length){
            final int b=BOL0(iL,eol),eq=strchr('=',T,b,eol[iL]);
            if(eq<0)continue;
            tok.setText(T,b,eq-1);
            int i=0;
            while(tok.nextToken()) buf[i++]=tok.asBits();
            final int k=atoi(T,eq+1)+(T[eq-1]=='d'?BASE_ACTG:T[eq-1]=='r'?BASE_ACUG:0),aa[]=AMINOACID_ATOMS[k]=copyOfInts(buf,0,i);
            final short[]ee=AMINOACID_ELEMENTS[k]=new short[aa.length];
            ROFj0(ee.length) ee[j]=(short)(aa[j]&127);
        }
    }
    private short[][]_elements;
/* Names (4 characters) of atoms,as recorded in the 3rd column of  PDB files. */
/* cAlpha= CA =&gt; 'C' + 'A'*256 +' ''*256*256+' '*256*256*256 */
    public int[]getResidueAtoms32(boolean onlyExplicite,int i){
        if(i<0)return null;
        int[][]aaa=_atom32;
        if(aaa==null){
            _fromSrc(FROMSRC_XYZ);
            if((aaa=_atom32)==null) aaa=_atom32=NO_ints;
        }
        return i<aaa.length&&aaa[i]!=null?aaa[i]:onlyExplicite?null:iThInts(iThByte(i,getResidueType()),AMINOACID_ATOMS);
    }
    public short[]getResidueElement(boolean onlyExplicite,int i){
        if(i<0)return null;
        short[][]eee=_elements;
        if(eee==null){
            _fromSrc(FROMSRC_XYZ);
            if((eee=_elements)==null) eee=_elements=NO_shorts;
        }
        short[]ee=i<eee.length?eee[i]:null;
        if(ee==null&&!onlyExplicite)ee=iThShorts(iThByte(i,getResidueType()),AMINOACID_ELEMENTS);
        return ee!=null?ee:NO_short;
    }
    public CPP_sync int[]getResidueAtomNumberOffsets(int i){
        if(i<0)return null;
        int[][]eee=_resAtomNumOffsets;
        if(eee==null){
            _fromSrc(FROMSRC_XYZ);
            if((eee=_resAtomNumOffsets)==null) eee=_resAtomNumOffsets=NO_ints;
        }
        return i<eee.length&&eee[i]!=null?eee[i]:null;
    }

    public String[][]chainsByType(){return _chainsByType;}
    public void setAtomSerial(int[]resAtomNum,int[][]resAtomNumOffsets){
        _resAtomNum=resAtomNum;
        _resAtomNumOffsets=resAtomNumOffsets;
    }
    public CPP_sync void setAtoms(float[]xyz,int[]residueAtomIdx,int at32[][],short element[][]){
        xyzAddNans(xyz,0,MAX_INT);
        _atomXYZ=xyz;
        _resAtomIdx=residueAtomIdx;
        _elements=element;
        _atom32=at32;
        if(xyz==null) _flags&=~PFLAG_HAS_XYZ; else _flags|=PFLAG_HAS_XYZ;
        strapIncMC(P_MC_ATOM_COORD_ORIG,this);
        clearCache();
    }
    public void setChainsByType(String[][]chainsByType){
        if((_chainsByType=chainsByType)!=null) _flags|=PFLAG_HAS_XYZ;
    }

    public CPP_sync float[]getAtomXYZ(){return getAtomXYZ(getRotationAndTranslation());}
    public CPP_sync float[]getAtomXYZ(Matrix3D m3d){
        _fromSrc(FROMSRC_XYZ);
        float[]ori=_atomXYZ;
        if(ori==null){
            if(_infXYZP!=null) _inferXYZ(INF3D_XYZ);
            ori=_atomXYZ;
        }
        if(ori==null||m3d==null) return ori;
        final Object[]cached=cached();
        float[]ff=(float[])cached[m3d==_m3d?P_CACHE_ATOM_COORD:P_P_CACHE_ATOM_COORD_PV];
        if(setMC(m3d==_m3d?P_MC_ATOM_COORD:P_MC_ATOM_COORD_PV,(m3d==_m3d?MC[P_MC_MATRIX3D]:0) + MC[P_MC_ATOM_COORD_ORIG]) || m3d!=_m3d&&_m3dPreview!=m3d || ff==null){
            cached[m3d==_m3d?P_CACHE_ATOM_COORD:P_P_CACHE_ATOM_COORD_PV]=ff=redim(ff,ori.length,0);
            m3d.transformPoints(ori,0,MAX_INT,ff);
            if(m3d!=_m3d) _m3dPreview=m3d;
        }
        return ff;
    }
/* <<< Atom <<< */
/* ---------------------------------------- */
/* >>> Header >>> */
    public static int _globFlags;
    private final Object[]OBJECTS=new Object[PROTEINO_NUM];
    public int _flags=PFLAG_IN_ALI;
    private final int[]INTS=new int[PROTEINI_ZZZ];
    {
        INTS[PROTEINI_ROW]=INTS[PROTEINI_CDS]=INTS[PROTEINI_HTML_IDX]=-1;
        INTS[PROTEINI_CHAINTYPE]=CHAINTYPE_PEP;
    }
    public int getRow(){return (_flags&PFLAG_IN_ALI)==0?-1: INTS[PROTEINI_ROW];}
    public void setProperty(int k,Object v){
        if(0!=(k&PROTEINO_FLAG_IF_EMPTY) && null!=iThEl(k,OBJECTS)) return;
        k&=0xFFFF;
        if(v instanceof String){
            if(sze(v)==0) v=null;
            else if(chrAt(0,v)=='u' && "unknown".equals(v)) v=null;
            else if(0!=(k&PROTEINO_FLAG_ADD)){
                final String[]ss=(String[])OBJECTS[k];
                if(idxOfStrg(0,(String)v,ss)<0) v=adToStrgs((String)v,ss,0);
            }
        }
        if(k==PROTEINO_EC) v=toStrgArray(0,v);/*X strgArry*/
        if(k<P_HEADER_NUM){
            IF_AA(if(k==P_ORGANISM_MNEMONIC) setOrganism(s(v)); else) OBJECTS[k]=s(v);;
        }else{
            OBJECTS[k]=v;
        }
    }
    public Object getProperty(int k){
        Object c=OBJECTS[k];
        if(k<P_HEADER_NUM && c==null){
            if(k==P_ORGANISM) return OBJECTS[P_ORGANISM_SC];
            else if(k==P_COMPOUND){
                final String[]cds=getCDS(appliedCDS());
                if(cds!=null) return orS(cds[PROTEIN_CDS_PRODUCT],cds[PROTEIN_CDS_PROTEIN]);
                if(c==null) for(String u:getRefs(REFS_BY_IDENT)) if(null!=(c=MAP_UniProt2Name.get(u))) break;
            }
        }
        return c;
    }
    public void setIntProperty(int k,int v){INTS[k]=v;}
    public int getIntProperty(int k){return INTS[k];}
#if CPP_PRG_AA
    private void setOrganism(String mnem){
        if(mnem!=null && !mnem.equals(_orgMnem)){
            _orgMnem=mnem;
            final String[]ocos=Strap.taxonomyForMnem(mnem);
            final int n=sze(ocos);
            if(n>0) setProperty(P_TAXONOMY,ocos[0]);
            if(n>1 && getProperty(P_ORGANISM_SC)==null) setProperty(P_ORGANISM_SC,ocos[1]);
        }
    }
#endif //CPP_PRG_AA
    public void setProperty(int key,byte[]T,int b,int e){
        if(T==null || 0!=(key&PROTEINO_FLAG_IF_EMPTY) && sze(iThEl(key,OBJECTS))>0) return;
        if(e>T.length) e=T.length;
        if(e<b){
            if((e=eolTrim(T,b=nxt(chrClas(-SPC),T,b,e),e))>b&&T[e-1]==';')e--;
            setProperty(key,key==PROTEINO_EC && strchr(',',T,b,e)>=0?
                        splitTkns(0,T,b,e,chrClas(SPACE_COMMA)):
                        s(T,b,e));
        }
    }
/* DroMe for Drosophila_melanogaster */
    public String getOrganism5(){
        final String sc=(String)getProperty(P_ORGANISM_SC);
        final int spc=strchr('_',sc);
        BA r=null;
        if(spc>1 && spc+2<sc.length()){
            r=new BA(33);
@*SARRAY_HOMO_SAPIENS_LONG
             Escherichia_Coli|Homo_Sapiens|Mus_Musculus|Rattus_Norvegicus
*@

@*SARRAY_HOMO_SAPIENS_SHORT
             Coli|Human|Mus|Rat
*@
            final int i=idxOfStrg(STR_IC,sc,arry(SARRAY_HOMO_SAPIENS_LONG));
            if(i>=0) r.a(iConst(SARRAY_HOMO_SAPIENS_SHORT,i));
            else r.aa(uCaseC(sc.charAt(0)),lCaseC(sc.charAt(1)),lCaseC(sc.charAt(2)),uCaseC(sc.charAt(spc+1)),lCaseC(sc.charAt(spc+2)));
        }else{
            final String sp=seqId(BLAST4ID_DB_SWISS);
            final int us=strchr('_',sp);
            if(us>=0 && sze(sp)-us>5){
                r=new BA(33);
                FORi(us+1,sp.length()) r.a((char)(i==us+1||i==us+4?sp.charAt(i)&~32: sp.charAt(i)|32));
            }
        }
        return s(r);
    }
#if CPP_WITH_GUI
    private static int _seqDataNoCache;
    private Object _seqData(int i){
#define sbData() baClr(103)
        switch(i){
        case SEQ_DATA_UNIPROT:{
            String id=seqId(BLAST4ID_DB_UNIPROT);
            final BA sb=baClr(104);
            if(null==id && null==(id=_seqId(DB_UNIPROT,getRefs(REFS_BY_IDENT),CTRUE)) && null!=(id=seqId(GETSEQID_ONLY_BY_IDENTITY|BLAST4ID_DB_UNIPROT))) sb.a('=');
            if(id!=null) return sb.or(MAP_UniProt2Swiss.get(id),id).and("+",derefZ(refSeqOffset(false,id),Integer.class));
            break;
        }
        case SEQ_DATA_ACC:return seqId(GETSEQID_ACCESSION);
        case SEQ_DATA_WHEN_MODI:{
            final File f=getFile();
            if(f!=null) return dateToStrg(DATE_YYYY_MM_DD_d_HH_mm,f.lastModified());
            break;
        }
        case SEQ_DATA_WHEN_LOADED:return dateToStrg(DATE_YYYY_MM_DD_d_HH_mm,_when).substring(5);
        case SEQ_DATA_NAME:return getName();
        case SEQ_DATA_TITLE:return getProperty(P_TITLE);
        case SEQ_DATA_COMPOUND:return getProperty(P_COMPOUND);
        case SEQ_DATA_ORGANISM:return getProperty(P_ORGANISM);
        case SEQ_DATA_ORGANISM_SCIENTIFIC:_seqDataNoCache|=(1<<i); return getProperty(P_ORGANISM_SC);
        case SEQ_DATA_EC:return baClr(158).joinSpc(OBJECTS[PROTEINO_EC]);
        case SEQ_DATA_PDB:return getPdbID(PDBID_ID);
        case SEQ_DATA_HAS_XYZ:return hasCalpha(this)||_infXYZP!=null?"Yes":"No";
        case SEQ_DATA_HAS_NUC:return isTranslated()?"Yes":"No";
        case SEQ_DATA_BALLOON:return balloonText(0);
        case SEQ_DATA_HETEROS:{
            final BA sb=sbData();
            for(Protein h:getMolecules(CHAINTYPE_HET)) if(strstr(STR_w,h.getName(),sb)<0) sb.an(' ',sb.end()==0?0:1).a(h);
            for(Protein h:getMolecules(CHAINTYPE_NUC)) h.appendNucColonChain(sb.a(' '));
            return sb;
        }

        case SEQ_DATA_OVERVIEW:{
            final BA sb=sbData();
            sb.aBYTES(' ',' ').a(getPdbID(PDBID_ID)).a1(' ').aUnlessInText(STR_w,seqId(GETSEQID_ACCESSION)).delBlanksR().aln();
            ROFk0(3){
                sb.aBYTES(' ',' ');
                for(String s:k==2?getRefs(0): k==1?getRefs(REFS_OTHER):toStrgArray(0,getProperty(PROTEINO_EC))){
                    if(!(k==0 && strchr('-',s)>=0)) sb.aUnlessInText(STR_w,s).a1(' ');
                }
                sb.delBlanksR().aln();
            }
            return sb.aBYTES(' ',' ').aFile(PRINT_FILE_TILDE_FOR_HOME,getFile()).delBlanksR();
        }
        }
        return null;
    }
    public String seqData(int i){
        if(0!=(_seqDataNoCache&(1<<i))) return(String)_seqData(i);
        if(_seqDataMC==null) {_seqDataMC=new int[SEQ_DATA_ZZZ]; _seqData=new String[SEQ_DATA_ZZZ];}
        final Customize cust=Customize.customize(CUSTOM_proteinInfoRplc);
        if(i<SEQ_DATA_ZZZ && (DIFF_MC(_seqDataMC[i],modic(cust)+MC[P_MC_SEQ_LABELS]+MC[P_MC_RES_TYPE]+MC[P_MC_IDS]) || _seqData[i]==null)){
            final Object cs=_seqData(i);
            String s=null;
            if(cs!=null && i<5){
                s=toBA(cs).replaceChar('\t',' ').replaceChar('\n',' ').toString().replaceAll("   +","  ");
                for(String line:cust.lines()){
                    if(sze(line)==0 || line.charAt(0)=='#') continue;
                    final int tab=line.indexOf('\t');
                    final String pattern=tab<0?line:line.substring(0,tab);
                    try{
                        s=s.replaceAll(pattern,toStrgTrim(strplc(0,"%20"," ",tab<0?"":line.substring(tab+1))));
                    }catch(Exception ex){baOut(RED_WARNING).aa(ex, " proteinInfoRplc  pattern=").aln(pattern);}
                }
            }else{
                s=s(cs);
            }
            _seqData[i]=s;
        }
        return _seqData[i];
    }
#endif //CPP_WITH_GUI
/* <<< Header <<< */
/* ---------------------------------------- */
/* >>> IDs by Similarity>>> */
    private Collection<String>vIdByIdent(boolean create){
        if(DIFF_MC(_vIdByIdentMC,MC[P_MC_RES_TYPE_FULL])||_vIdByIdent==null){
            if(create) _vIdByIdent=new UniqueList(iCLASS_String);
            else clr(_vIdByIdent);
        }
        return _vIdByIdent;
    }
    public String[]getRefs(int opt){
        final Collection v=
            opt==REFS_BY_IDENT?vIdByIdent(false):
            opt==REFS_OTHER?_vRef:
            _vIds;
        return v==null||v.size()==0?NO_String:toStrgArray(0,v);
    }
    Map _mapRefSeqOffset;
/* <<< IDs by Similarity <<< */
/* ---------------------------------------- 173236 */
/* >>> IDs >>> */
    private static String _seqId(String pfx,String[]ss,int dash){
        final char c=pfx.charAt(0);
        for(String s:ss) if(s.charAt(0)==c&&s.startsWith(pfx) && (dash==0||(s.indexOf('_')>0)==(dash==CTRUE))) return s;
        return null;
    }
    public CPP_sync String seqId(int db){
        if(db==GETSEQID_ACCESSION) return _accID;
        final String[]rr=getRefs(0);
        if(db==BLAST4ID_DB_SWISS){
            String id=_seqId(DB_UNIPROT,rr,CTRUE);
            if(id==null){
                for(String u:getRefs(REFS_BY_IDENT)){
                    if(null!=(id=(String)MAP_UniProt2Swiss.get(u))) return id;
                }
            }
            return id;
        }else{
            String id=null,pfx=iConst(SARRAYeq_BLAST4ID_DB,db&255);
            if(0==(db&GETSEQID_ONLY_BY_IDENTITY)){
                if((db&255)==BLAST4ID_DB_UNIPROT) id=_seqId(pfx,rr,CFALSE);
                if(id==null) id=_seqId(pfx,rr,0);
            }
            if(id==null && 0!=(db&(GETSEQID_ALSO_BY_IDENTITY|GETSEQID_ONLY_BY_IDENTITY))) id=_seqId(pfx,getRefs(REFS_BY_IDENT),0);
            return id;
        }
    }
    public String getPdbID(int bits){
        if(_pdbIds!=null){
            final int B=bits!=0?bits:PDBID_ID;
            FORi(0,_pdbIds.length){
                if((B&(1<<i))!=0){
                    final String id=_pdbIds[i];
                    if(id!=null && (bits&PDBID_REQUIRES_CHAIN)==0||pdbChain(id)!=null) return id;
                }
            }
        }
        return null;
    }
    public boolean setPdbID(int opt,String id){
        if(sze(id)==0) id=null; else id=addPfx("PDB:",id);
        final int log2;
        {
            final int bits=opt&(PDBID_NUM-1);
            for(Protein h:getMolecules(CHAINTYPE_NUC_OR_HET))  h.setPdbID(opt,id);
            if(0!=(opt&PDBID_NOT_OVERWRITE) && getPdbID(PDBID_ID)!=null) return false;
            log2=bits==0?0: log2(bits);
        }
        if(_pdbIds==null) _pdbIds=new String[PDBID_NUM-1];
        final boolean changed=!eq(id,_pdbIds[log2]);
        _pdbIds[log2]=id;
        if(log2==0) addSeqRef(ADD_SEQREF_ACC,id);
        _xyzByIDtried=0;
        return changed;
    }
    public CPP_sync boolean hasPdbId(String s){
        return s!=null && strEquAt(STR_IC,pdbID(s),getPdbID(PDBID_ID),4) && eqStr(getChain(),pdbChain(s));
    }
    public CPP_sync void removeSequenceRef(String s){
        if(sze(s)>0){
            if("*".equals(s)) clr(_vIds);
            else{
                rmElmntFromV(s,_vIds);
                if(s.equals(_accID)) _accID=null;
                setToNull(true,s,_pdbIds);
            }
        }
    }

    public CPP_sync String addSeqRef(int opt,String s){
        if(sze(s)==0) return null;
        int offset=opt&0xffFFFF;
        {
            final int exclam=s.indexOf('!');
            if(exclam>0){
                offset=atoi(s,exclam+1);
                s=s.substring(0,exclam);
            }
        }
        if((s=canonicalSeqidColonDB(s))==null) return null;
        {
            final int colon=s.indexOf(':');
            if(s.length()==colon+1) return null;
            if(colon<0) {
                final String db=guessDbFromId(onlyActgn(),s);
                if(sze(db)>0) s=addPfx(db,s);
            }
        }
        if(0!=(opt&ADD_SEQREF_BY_IDENT)){
            if(idxOfStrg(0,s,getRefs(0))>=0) return s;
            if(vIdByIdent(true).add(s)) strapIncMC(P_MC_IDS,this);
            baLog(LOG_PEPMATCH).aa(this,' ',s,'+',offset).aln();
        }else{
            if(s.startsWith("PDB:")) setPdbID(PDBID_ID|PDBID_NOT_OVERWRITE,s);
            if(_vIds==null) _vIds=new UniqueList(iCLASS_String);
            if(0!=(opt&ADD_SEQREF_ACC)){
                if(!s.equals(iThEl(0,_vRef))){
                    _vIds.remove(s);
                    ((List)_vIds).add(0,_accID=s);
                    strapIncMC(P_MC_IDS,this);
                }
            }else if(_vIds.add(s)) strapIncMC(P_MC_IDS,this);
        }
        IF_AA(if(getProperty(P_TAXONOMY)==null && s.startsWith("UNIPROT:") && !cntainsEl(s,_vIds) && s.indexOf('_')>0) setOrganism(delToLstChr1('_',s)));;
        if(offset>0){
            if(_mapRefSeqOffset==null) _mapRefSeqOffset=new HashMap();
            _mapRefSeqOffset.put(s,io(offset));
        }
        return s;
    }
    public CPP_sync void addDatabaseRef(String s){
        if(s!=null && (_vRef==null?_vRef=new UniqueList(iCLASS_String): _vRef).add(s)) strapIncMC(P_MC_IDS,this);
    }
/* <<< IDs <<< */
/* ---------------------------------------- */
/* >>> Sequence name and URL >>> */
    public void setName(Object name){
        final String n=lstPathCmpnt(toStrgN(name).trim());
        if(!n.equals(_name)){
            _name=n;
            _nameHC=0;
            if(OBJECTS[PROTEINO_ORIGINAL_NAME]==null) OBJECTS[PROTEINO_ORIGINAL_NAME]=n;
            IF_GUI(strapIncMC(P_MC_SEQ_LABELS,this));;
#if CPP_PRG_AA
            if(getProperty(P_TAXONOMY)==null){/*X  Pfam names have organism */
                final int nL=n.length(),us=n.indexOf('_');
                if(us>0){
                    final int e=nxt(STR_E,chrClas(-UPPR_DIGT),n,us+1,nL);
                    //if (e-us>2 && (e==n.length() || n.charAt(e)=='_' && cntainsOnly(DIGT_DASH,n,e+1,MAX_INT))){
                    if(e-us>2 && (e==nL||e+1<nL && n.charAt(e)=='_' && 0>nxt(0,chrClas(-DIGT_DASH),n,e+1,nL)))  setOrganism(n.substring(1+us,e));
                }
            }
#endif //CPP_PRG_AA
            final int exclam=n.indexOf('!');
            if(exclam>0) setSubset(n.substring(exclam+1));
        }
    }
    public CPP_sync int getNameHC(){
        if(_nameHC==0) _nameHC=getName().hashCode();
        return _nameHC;
    }
    public String getName(){return _name;}
    OVERRIDE_PUBLIC String toString(){return getName();}
/* <<< Sequence name and URL <<< */
/* ---------------------------------------- */
/* >>> File >>> */
    private File IF_GUI(_fBalloon,) _f;
    public File getFile(){return _f;}
    IF_GUI(long _hashCdTxt);
    public CPP_sync void setFile(File f){
        _f=f;
        if(getName()==UNNAMED && f!=null) setName(f.getName());
#if CPP_WITH_GUI
        MC[P_MC_FILE_CONTENT]=0;
        if(f!=null){
            _viewFileWith.put(f,io(CUSTOM_textEditors));
            INTS[PROTEINI_FILENAME_HC]=(OBJECTS[PROTEINO_FILENAME]=f.getName()).hashCode();
        }else{
            OBJECTS[PROTEINO_FILENAME]=null;
            INTS[PROTEINI_FILENAME_HC]=0;
        }
        strapIncMC(P_MC_SEQ_LABELS,this);
#endif //CPP_WITH_GUI
    }

    public float[]xyzByID(boolean sideChain){/*X PRUEFEN_CIF*/
        float[]xyz=sideChain?getAtomXYZ(): getResidueCalphaCurrent();
#define mask (sideChain?1:2)
        if(xyz==null && 0==(_xyzByIDtried&mask)){
            _xyzByIDtried|=mask;
            final String id4=getPdbID(PDBID_ID|PDBID_INFERRED|PDBID_SUGGESTED),chain=getChain();
            if(id4==null) return null;
            IF_GUI(inferXYZ(pdbDownloadPepOrNuc(PROTPARS_AS_PEP|PROTPARS_NO_HEADER|PROTPARS_NO_SEQRES|PROTPARS_NO_RESSEL,id4,chain),null));;
            UNLESS_GUI(inferXYZ(pdbDownloadPepOrNuc(0,id4,chain)));;
            xyz=sideChain?getAtomXYZ(): getResidueCalphaCurrent();
        }
#undef mask
        return xyz;
    }
/* <<< File <<< */
/* ---------------------------------------- */
/* >>> Structure >>> */
    public boolean residueHasXYZ(boolean fullLen,int idx){
        final float[]ff=getResidueCalphaXYZ(null);
        final int i=idx+(fullLen?0:subsetStart());
        if(ff!=null) return!Float.isNaN(iThFloat(3*i,ff));
        final int[]hasXYZ=_resHasXyz;
        if(hasXYZ!=null){
            final int i32=i>>>5;
            return hasXYZ.length>i32 && (hasXYZ[i32]&(1<<i))!=0;
        }
        return false;
    }
    //N  EF TQ  C
    public int[]firstLastResidueWithXyz(){
        final Object[]cached=cached();
        int[]fstLst=(int[])fromCache(cached,P_CACHE_FST_LST_HAS_XYZ,MC[P_MC_ATOM_COORD_ORIG]);
        if(fstLst==null){
            fstLst=new int[6];
            cached[P_CACHE_FST_LST_HAS_XYZ]=fstLst;
            for(int segment=0;segment<6;segment+=2){
                fstLst[segment]=fstLst[segment+1]=-1;
                final int
                    f=segment==FSTLST_NTERM?0:segment==FSTLST_CTERM?subsetStart():subsetEnd(),
                    t=segment==FSTLST_NTERM?subsetStart():segment==FSTLST_CTERM?subsetEnd():countResidues();
                if(f<t&&f>=0){
                search:
                    FORi(Math.max(0,f),t){
                        if(!residueHasXYZ(true,i)) continue;
                        ROFk(t,f){
                            if(residueHasXYZ(true,k)){
                                fstLst[segment]=i;
                                fstLst[segment+1]=k;
                                break search;
                            }
                        }
                    }
                }
            }
        }
        return fstLst;
    }
#if CPP_PRG_AA
    public void setHasXyzIfUpperCase(){
        if(_cAlpha==null){
            final byte[]aa=getResidueType();
            int hasXYZ[]=null,prev32=-1,bits=0;
            ROFi0(countResidues()){
                final int i32=i>>>5;
                if(i32!=prev32 && prev32>=0){
                    if(hasXYZ==null)hasXYZ=new int[prev32+1];
                    hasXYZ[prev32]=bits;
                    bits=0;
                }
                if(IS_UPPER(aa[i])) bits|=(1<<i);
                prev32=i32;
            }
            if(hasXYZ==null) hasXYZ=bits==0?NO_int:new int[]{bits};
            else hasXYZ[prev32]=bits;
            _resHasXyz=hasXYZ;
        }
    }
#endif //CPP_PRG_AA

    public CPP_sync long hashCodeCalpha(){
        final float[]xyz=INTS[PROTEINI_CHAINTYPE]==CHAINTYPE_PEP?getResidueCalphaXYZ(null):getAtomXYZ(null);
        if(_hcXYZ==0) _hcXYZ=hashCdFloats(xyz,3*subsetStart(),3*subsetEnd());
        return _hcXYZ;
    }

#if CPP_WITH_GUI
    private float _resolution=Float.NaN;
    //public float getResolutionAngstroms(){return _resolution;}
    public void  setResolutionAngstroms(float r) {_resolution=r;}
#endif //CPP_WITH_GUI
/** set the array of untransformed calpha-coordinates {x0,y0,z0,x1,y1,z1,x2,y2,z2 ...} */
    public CPP_sync void setResidueCalphaXYZ(Object xyzOrText){/*X float[]or byte[]*/
        if(sze(xyzOrText)>0) _flags|=PFLAG_HAS_CALPHA; else _flags&=~PFLAG_HAS_CALPHA;
        if(xyzOrText instanceof float[])xyzAddNans(_cAlpha=(float[])xyzOrText,0,MAX_INT); else _cAlphaTxt=(byte[])xyzOrText;
        _hcXYZ=0;
        strapIncMC(P_MC_CALPHA_ORIG,this);
        clearCache();
    }
    public CPP_sync int countCalpha(int max){
        int count=0;
        final float[]xyz=getResidueCalphaXYZ(null);
        if(xyz==null) return 0;
        for(int TO=min(subsetEnd()*3,xyz.length),i=subsetStart()*3;i<TO; i+=3){
            if(!Float.isNaN(xyz[i]) && ++count>=max && max>0) break;
        }
        return count;
    }
    public CPP_sync byte[]resTypeUpperCaseForXYZ(){
        if(!isProteinStructure()) return getResType();
        final int nR=countRes();
        final byte[]rt=getResType();
        final Object[]cached=cached();
        byte[]lc=(byte[])cached[P_P_CACHE_RESIDUES_HAS_XYZ];
        if(lc==null || cacheEmpty(cached,P_P_CACHE_RESIDUES_HAS_XYZ,mc((P_MC_CALPHA_ORIG<<P_MC_SHIFT)|P_MC_RES_TYPE))){
            cached[P_P_CACHE_RESIDUES_HAS_XYZ]=lc=redim(lc,nR,0);
            ROFi0(nR) lc[i]=(byte)(residueHasXYZ(false,i)?(rt[i]&~32): (32|rt[i]));
        }
        return lc;
    }
/**       Get transformed  calpha-coordinates [Angstrom]       @return {x0,y0,z0,x1,y1,z1,x2,y2,z2 ...}    */
    public CPP_sync float[]getResidueCalphaCurrent(){
        final Object[]cached=cached();
        float[]caOri=getResidueCalphaXYZ(null);
        final Matrix3D mx=getRotationAndTranslation();
        if(caOri==null || isUnitOrNull(mx)) return caOri;
        float[]ff=(float[])cached[P_CACHE_CALPHA];
        if(setMC(P_MC_CALPHA,mc((P_MC_CALPHA_ORIG<<P_MC_SHIFT)|P_MC_MATRIX3D)) || ff==null){
            cached[P_CACHE_CALPHA]=ff=new float[min(caOri.length,subsetEnd()*3)];
            mx.transformPoints(caOri,0,subsetEnd(),ff);
        }
        return ff;
    }
/* @return The C-alpha coordinates */
/* @param m3d The coordinate system */
/* If m3d==null then the coriginal coordinates as recorded in the PDB file are returned. */
/* p.getResidueCalphaXYZ(p.getRotationAndTranslation()) is identical to p.getResidueCalphaCurrent() */
    public CPP_sync float[]getResidueCalphaXYZ(final Matrix3D m3d){
        final Object[]cached=cached();
        float[]xyz=_cAlpha;
        if(xyz==null &&_cAlphaTxt!=null){
            CPP_synchronized(TOKEN_FT){final int n=_siPrepareXYZ(_cAlphaTxt,MAX_INT);xyz=copyOfFloats((float[])_siXyz,0,n*3);}
        }
        if(null==xyz){
#if CPP_PRG_AA
            if(0!=(_flags&PFLAG_FROM_PDB_ZIP) && !_triedZipCalpha){
                _triedZipCalpha=true;
                xyzArchiveGetProtein(getPdbID(PDBID_ID),null,this);
            }else
#endif //CPP_PRG_AA
                if(_infXYZP!=null) _inferXYZ(INF3D_CAXYZ);
                else{
                    final float[]coord=getAtomXYZ(null);
                    if(sze(coord)>2){
                        Arrays.fill(xyz=new float[countResidues()*3],Float.NaN);
                        for(int ii[]=getResidueAtomIdx(),
                                CA=INTS[PROTEINI_CHAINTYPE]==CHAINTYPE_PEP?'C'|('A'<<8): 'P',
                                i=countResidues();--i>=0;){
                            final int[]atoms=getResidueAtoms32(false,i);
                            if(ii[i]>=0){
                                final int j=idxOf(CA,atoms),fj3=(ii[i]+j)*3;
                                if(j>=0 && fj3+2<coord.length){
                                    xyz[i*3  ]=coord[fj3  ];
                                    xyz[i*3+1]=coord[fj3+1];
                                    xyz[i*3+2]=coord[fj3+2];
                                }
                            }
                        }
                    }
                    _cAlpha=xyz;
                }
            xyz=_cAlpha;
        }
        if(xyz==null || isUnitOrNull(m3d)) return xyz;
        if(m3d==_m3d) return getResidueCalphaCurrent();
        float[]ff=(float[])cached[P_P_CACHE_CALPHA_PV];
        if(ff==null || _m3dPreviewCalpha!=m3d || cacheEmpty(cached,P_P_CACHE_CALPHA_PV,MC[P_MC_CALPHA_ORIG]+m3d.mc())){
            cached[P_P_CACHE_CALPHA_PV]=ff=redim(ff,min(xyz.length,subsetEnd()*3),0);
            (_m3dPreviewCalpha=m3d).transformPoints(xyz,0,subsetEnd(),ff);
        }
        return ff;
    }
    public Protein getOneOwner(){
        final Object[]owner=(Object[])getProperty(PROTEINO_OWNERS_OF_NUC_OR_HET);
        if(owner!=null) for(Object o:owner) if((o=deref(o))!=null) return(Protein)o;
        return null;
    }
    public CPP_sync Matrix3D getRotationAndTranslation(){
        if(_m3d==null && isSobjectType(CHAINTYPE_NUC,this)){
            final Protein p=getOneOwner();
            if(p!=null) return p._m3d;
        }
        return _m3d;
    }
    public CPP_sync void setRotationAndTranslation(Matrix3D m3d){
        if(_m3d!=m3d){
            strapIncMC(P_MC_MATRIX3D,this);
            _m3d=m3d;
            cached()[P_P_CACHE_ATOM_COORD_PV]=cached()[P_P_CACHE_CALPHA_PV]=null;

        }
    }
    private Matrix3D _m3d,_m3dPreview,_m3dPreviewCalpha;
    public CPP_sync View3d[]get3dViews(){
        final UniqueList v=vChilds(-SOBJECT_V3D);
        if(v==null) return View3d.NONE;
        for(Object v3d:v.asArray()) if(sp(v3d)==null) rmElmntFromV(v3d,v);
        return(View3d[])v.asArray();
    }
/* ---------------------------------------- */
/* >>> pcp >>> */
    CPP_CODE_HasWRef();
/* <<< pcp <<< */
/* ---------------------------------------- */
/* >>> first and last index >>> */
    public CPP_sync void setIndexOffsetAA(int n){
        if(DIFF_MC(INTS[PROTEINI_AA_IDX_OFFSET],n)) strapIncMC(P_MC_1ST_RES_IDX,this);
    }
    public void setIndexOffsetNT(int n){/*X  Larger 0 shifts nucleotide selections to the left */
        if(DIFF_MC(INTS[PROTEINI_NT_IDX_OFFSET],n)) strapIncMC(P_MC_1ST_RES_IDX,this);
    }
/* <<< first and last index <<< */
/* ---------------------------------------- */
/* >>> Subset >>> */
    public int countResidues(){return INTS[PROTEINI_CHAINTYPE]==CHAINTYPE_HET?1: getResidueType().length;}
    public void setSubset(String s){
        int from=0,to=0;
        if(sze(s)==0){
            from=INT_NAN;
        }else if(chrAt(0,s)=='-'){
            to=atoi(s,1);
        }else{
            final int dash=s.indexOf('-');
            from=xatoi(s)-1;
            to=dash<0 || dash==s.length()-1?countResidues(): atoi(s,dash+1);
        }
        setSubsetFT(from,to);
    }
    public CPP_sync void setSubsetFT(int start,int end){
        if(start<0 && start!=INT_NAN) start=0;
        if(start!=_subsS || end!=_subsE){
            _subsS=start;
            _subsE=end;
            clearCache();
            _hcXYZ=0;
            clr(_mapRefSeqOffset);
        }
    }
    public boolean isSubset(){return _subsS!=INT_NAN;}
    public int subsetStart(){return max(0,_subsS);}
    public int subsetEnd(){return _subsS==INT_NAN?countResidues():min(_subsE,countResidues());}

/*     for(ResidueSelection s:ss){ */
/*         if(sp(s)==p){ */
/*             from=mini(from,resSelFirstAmino(s)); */
/*             to=maxi(to,resSelLastAmino(s)+1); */
/*         } */
/*     } */
/*     return from>=to?null: newProteinSubset(p,s(baClr(VCLR_NUMBERS).aFromDashTo(1+from,to))); */
/* } */
/*     final int i0=firstResIdx(p)+1; */
/*     return newProteinSubset(p,(i0+p.columnToIndex(CTRUE,west))+"-"+(i0+p.columnToIndex(CFALSE,east-1))); */
/* } */
#if CPP_WITH_GUI
    public Protein newProteinSubset(Object subset){
        final String expr;
        if(subset instanceof ResidueSelection[]||subset instanceof int[]){
            int f=MAX_INT,t=-1;
            if(subset instanceof int[]){
                f=firstResIdx(this)+columnToIndex(CTRUE,((int[])subset)[0]);
                t=firstResIdx(this)+columnToIndex(CTRUE,((int[])subset)[1]-1)+1;
            }else{
                for(ResidueSelection s:(ResidueSelection[])subset){
                    if(sp(s)==this){
                        f=min(f,resSelFirstAmino(s));
                        t=max(t,resSelLastAmino(s));
                    }
                }
            }
            if(t>=f)return this;
            expr=s(new BA(99).aa(f+1,'-',t));
        }else{
            if(nxt(0,chrClas(-SPC),expr=s(subset))<0) return this;
        }
        final Protein p=new Protein();
        p.setResidueType(getResType());
        p.setName(addPfx("cloned_",getName()));
        p.setResidueCalphaXYZ(copyOfFloats(getResidueCalphaCurrent(),3*subsetStart(),3*subsetEnd()));
        pcp(KEY_CLONED_FROM IF_GUI(|PCP_OPT_WREF),this,p);
        //p.setChain(getChain());
        //p.setResidueName32(copyOfInts(getResidueName32(),subsetStart(),subsetEnd()));
        //p.setIndexOffsetAA(getIntProperty(PROTEINI_AA_IDX_OFFSET));
        p.setSubset(expr);
        return p;
    }
#endif //CPP_WITH_GUI
/* <<< Subset <<< */
/* ---------------------------------------- */
    public TYPE_ALIGN_RESULT cacheSuperimpose(int it,Protein p,TYPE_ALIGN_RESULT result){
        Map[]mm=(Map[])cached()[P_CACHE_SUPERIMPOSE_3D];
        final int mc=p.MC[P_MC_CALPHA_ORIG]+p.MC[P_MC_RES_TYPE];
        if(result!=null){
/* --- Store --- */
            if(mm==null) cached()[P_CACHE_SUPERIMPOSE_3D]=mm=new Map[ALIGNER_ZZZ];
            if(mm[it]==null) mm[it]=new WeakHashMap();
            mm[it].put(p,result);
            result[ALIGNRESULT_PROTEIN_MC]=io(mc);
/* --- Fetch --- */
        }else if(null!=(result=(TYPE_ALIGN_RESULT)gcp(p,iThEl(it,mm))) && mc!=xatoi(result[ALIGNRESULT_PROTEIN_MC])){
            result=null;
        }
        return result;
    }
/* <<<   <<< */
/* ---------------------------------------- */
/* >>> Infer PDB >>> */
    long _infXYZMatch;
    Protein _infXYZP;
    public float inferXYZ(Protein pp3d[]IF_GUI(,BA log)){/*X  no synchronized */
        if(fstNotNull(pp3d)==null) return Float.NaN;
        final byte[]seq=getResType();
        Protein bestP=null;
        float bestScore=Float.MIN_VALUE;
        byte[][]bestGapped=null;
        for(Protein p3d:pp3d){
            if(p3d==null) continue;
            final byte[][]aligned=smithWaterman(p3d.getResType(),seq,null);
            if(aligned!=null){
                final float score=pairAignScore(-10f,-2f,aligned[0],aligned[1],0,MAX_INT,0);
                if(score>bestScore){
                    bestGapped=aligned.clone();
                    bestScore=score;
                    bestP=p3d;
                }
            }
        }
        if(bestP!=null){
            {
/*final String pdbId=bestP.getPdbID(PDBID_ID);*/
/*if (!eq(pdbId,getPdbID(PDBID_INFERRED)) || getAtomXYZ()==null){}*/
#if CPP_WITH_GUI
                if(log!=null){
                    log.aa("inferXYZ(" ,bestP).aa(',',this,") score=",bestScore,'\n');
                    aliWithMidline(PRINT_ALI_TRUNCATE,bestGapped[0],MIN_INT,"",bestGapped[1],MIN_INT,"",99999,log);
                    log.aln();
                }
#endif //CPP_WITH_GUI
                _infXYZGapped=bestGapped;
                _infXYZP=bestP;
                _infXYZTried=0;
                _inferXYZ(INF3D_BASE);
                return bestScore;
            }
        }
        return Float.NaN;
    }

    private static short[][]arrySetIth(short[]v,int i,short[][]aa) {if(aa==null) aa=new short[i+1][]; aa[i]=v; return aa;}
    private static int[][]arrySetIth(int[]v,int i,int[][]aa) {if(aa==null) aa=new int[i+1][]; aa[i]=v; return aa;}
    private static int[]arrySetIth(int v,int i,int[]aa) {if(aa==null)aa=new int[i+1]; aa[i]=v; return aa;}
    private static byte[]arrySetIth(byte v,int i,byte[]aa,byte fill){if (aa==null) {aa=new byte[i+1];if(fill!=0) Arrays.fill(aa,fill);} aa[i]=v; return aa;}
    private void _inferXYZ(int options){
        final Protein p=_infXYZP;
        if(p==null) return;
        p._fromSrc(FROMSRC_XYZ);
        final int opt=options&~_infXYZTried;/*X Reihenfolge*/
        _infXYZTried|=options;
        if(opt==0) return;/*X Nothing to do*/
        final byte[]ali[]=_infXYZGapped,gapped3D=ali[0],gapped=ali[1],sst3D=0!=(opt&INF3D_BASE)?p.getResidueSecStrType():null,rt3D=p.getResType(),ins3D=p.getResidueInsCode();

        int[]anu3D=null,idx3D=null,atom323D[]=null,anus3D[]=null;
        short[][]elements=null;
        if(0!=(opt&INF3D_XYZ)){
            p.getAtomXYZ();/*X Reihenfolge als erstes*/
            idx3D=p.getResidueAtomIdx();
            anus3D=p._resAtomNumOffsets;
            anu3D=p.getResidueAtomNumber();
            atom323D=p._atom32;
            elements=p._elements;
        }
        final int
            num[]=0!=(opt&INF3D_BASE)?new int[subsetEnd()]:null,
            colL=min(gapped.length,gapped3D.length);;
        float[]alpha=null;
        byte[]ins=null,sst=null;
        int[]idx=null,anu=null,nam=null,atom32[]=null,anus[]=null;
        short[][]ee=null;
        int colFrom=0,countMatch=0,countAll=0;
        final boolean[]lettr=chrClas(LETTR);

        FORc(0,colL){
            if(isChrClas(lettr,gapped,c) && isChrClas(lettr,gapped3D,c)) break;
            colFrom=c+1;
        }
        if(alpha!=null) Arrays.fill(alpha,Float.NaN);
        if(0!=(opt&INF3D_BASE)) Arrays.fill(num,INT_NAN);
        boolean[]mismatch=null;
        {

            int countCalpha=0,hasXYZ[]=null;
            for(int
                    dst=idxOfLetters(gapped,getResType())+countChrClas(lettr,gapped,0,MAX_INT)-1,
                    src=idxOfLetters(gapped3D,rt3D)+countChrClas(lettr,gapped3D,0,MAX_INT)-1,
                    col=colL;--col>=0;){
                final int dstFL=dst+subsetStart(),srcFL=src+p.subsetStart();
                if(dst<0 || src<0) break;
                if(dstFL>=subsetEnd() || srcFL>=p.subsetEnd()) continue;
                final byte g=gapped[col],g3=gapped3D[col];
                final boolean dstL=g>0&&lettr[g],srcL=g3>0&&lettr[g3];
                if(srcL && col>=colFrom){
                    if((g|32)==(g3|32))  countMatch++;
                    else{
                        if(mismatch==null) mismatch=new boolean[dst+1];
                        mismatch[dst]=true;
                    }
                    countAll++;
                }
                if(dstL && srcL){
                    if(srcFL<sze(elements))ee=arrySetIth(elements[srcFL],dstFL,ee);
                    if(srcFL<sze(atom323D))atom32=arrySetIth(atom323D[srcFL],dstFL,atom32);
                    if(srcFL<sze(anus3D))anus=arrySetIth(anus3D[srcFL],dstFL,anus);
                    if(srcFL<sze(idx3D)) {
                        if(idx==null)Arrays.fill(idx=new int[dstFL+1],-1);
                        idx[dstFL]=idx3D[srcFL];
                    }
                    //if(srcFL<sze(idx3D))idx=arrySetIth(idx3D[srcFL],dstFL,idx);
                    if(srcFL<sze(anu3D))anu=arrySetIth(anu3D[srcFL],dstFL,anu);
                    if(srcFL<sze(sst3D))sst=arrySetIth(sst3D[srcFL],dstFL,sst,(byte)' ');
                    if(0!=(opt&INF3D_BASE)){
                        num[dstFL]=p.resnAt(RESIDUE_FULL,srcFL);
                        if(srcFL<sze(ins3D))  ins=arrySetIth(ins3D[srcFL],dstFL,ins,(byte)0);
                    }
                    {
                        final int n4=iThInt(srcFL,p.getResidueName32());
                        if((n4!=INT_NAN && (n4&0xFFffFF)!=(toThreeLetterCode(rt3D[src])&0xFFffFF))) nam=arrySetIth(n4,dstFL,nam);
                    }
                    {
                        final float[]alpha3d=0!=(opt&INF3D_CAXYZ)?p.xyzByID(false):null;
                        //final float[]alpha3d=0!=(opt&INF3D_CAXYZ)?p.getResidueCalphaXYZ(null):null;
                        if(alpha3d!=null){
                            final int i=srcFL*3+2;
                            if(i<alpha3d.length){
                                final int iDst=dstFL*3+2;
                                if(alpha==null) Arrays.fill(alpha=new float[iDst+1],Float.NaN);
                                alpha[iDst  ]=alpha3d[i  ];
                                alpha[iDst-1]=alpha3d[i-1];
                                alpha[iDst-2]=alpha3d[i-2];
                                countCalpha++;
                            }
                        }else if(p._resHasXyz!=null && p.residueHasXYZ(true,srcFL)){
                            final int a32=dst>>5;
                            if(hasXYZ==null) hasXYZ=new int[a32+1];
                            hasXYZ[a32]|=(1<<dst);
                        }
                    }
                }
                if(dstL) dst--;
                if(srcL) src--;
            }
            _resHasXyz=hasXYZ;
            if(countCalpha>0 && onlyOnce(36)) baOut("inferXYZ Calpha").aln(GREEN_DONE);
        }
        _infXYZMatch=(((long)countMatch)<<NUMERATOR_SHIFT)|countAll;
        setChain(p.getChain());
        if(0!=(opt&INF3D_BASE)) setResn(num,ins);
        if(countAll-countMatch<2 && nam!=null) setResidueName32(nam);
        if(alpha!=null) setResidueCalphaXYZ(alpha);
        if(sst!=null) setResidueSecStrType(sst);
        if(0!=(opt&INF3D_XYZ)){
            setAtoms(p.getAtomXYZ(null),idx,atom32,ee);
            setChainsByType(p._chainsByType);
            setAtomSerial(anu,anus);
        }
        if(_vv!=null) clr(_vv[CHAINTYPE_HET]);
        addToProt(P_ADD_HETERO_UNIQUE,p.getMolecules(CHAINTYPE_HET),this);
        final String pdbId=p.getPdbID(PDBID_ID);
        if(pdbId!=null && setPdbID(PDBID_INFERRED,pdbId)) strapIncMC(P_MC_INFERRED_PDB,this);
        IF_MEIN_DEBUG(else if(getPdbID(PDBID_ID)==null) baOut(RED_WARNING).aa("inferXYZ pdbId is null for p=",p,' ').joinSpc(_pdbIds).a(' ').aFile(p.getFile()).aln());;

        {
            BA sb=new BA(99).aa(pdbId,' ').and(p.getProperty(P_COMPOUND)," Identity: ");
            if(countAll>0) sb.aa(100*countMatch/countAll,'%');
            OBJECTS[PROTEINO_INF3D_INFO]=s(sb.replaceChar('\n',' '));
        }
        for(ResidueAnnotation a0:p.residueAnnotations()){
            if(a0.whereFeatureLoadedFrom()==SEQFEAT_SRC_MODRES){
                final ResidueAnnotation s=new ResidueAnnotation(this);
                for(ResidueAnnotation.Entry e: a0.entries()) s.addE(0,e.key(),e.value());
                addToProt(s
                          .setFeatureSrc(SEQFEAT_SRC_MODRES)
                          .annoAdd(IRESAN_EVIDENCE,countAll==countMatch?EVIDENCE_BY_IDENTITY: EVIDENCE_BY_SIMILARITY)
                          .annoAdd(IRESAN_SRC,pdbId),
                          this);
            }
        }
        rmResidueSelectionWithName(RESSEL_NAME_MISMATCH_3D);
        if(mismatch!=null){
            final ResidueAnnotation s=new ResidueAnnotation(this);
            runCR1(RUN_SET_COLOR,s,newColr(0xFF0A0A));
            s.setStyle(SSTYLE_UNDERLINE);
            s.setSelectedAminoacids(mismatch,firstResIdx(this));
            s.annoAdd(IRESAN_NAME,RESSEL_NAME_MISMATCH_3D)
                .annoAdd(IRESAN_BALLOON,baTmp().aa("Residues not matching the 3D-model ",pdbId))
                .annoAdd(IRESAN_SRC,pdbId);
            addToProt(s,this);
        }

    }
    public CPP_sync void detach3DStructure(){
        if(getPdbID(PDBID_INFERRED)!=null){
            setPdbID(PDBID_INFERRED,null);
            setResidueCalphaXYZ(null);
            setResidueSecStrType(null);
            setResn(null,null);
            rmResidueSelectionWithName(RESSEL_NAME_MISMATCH_3D);
        }
    }
/* <<< Infer PDB Id <<< */
/* ---------------------------------------- */
/* >>> Paint >>> */
    public boolean isProteinStructure(){
        return _resNum!=null || getChain()!=null || _cAlpha!=null || isLoadedFromStructureFile();
    }
    public boolean isLoadedFromStructureFile(){
        IF_AA(return 0!=(_flags&PFLAG_FROM_PDB_ZIP));;
#if !CPP_PRG_AA
        final int bid=bidForClass(getProperty(PROTEINO_PARSER));
        return bid==BUT_C1(PDBParser) || bid==BUT_C1(CIFParser);
#endif //!CPP_PRG_AA
    }
/* <<< PDB <<< */
/* ---------------------------------------- */
/* >>> Complexes >>> */
/* E.g. Transducine pdb1scg_B.ent pdb1a0r_G.ent pdb1scg_A.ent pdb1a0r_B.ent pdb1a0r_P.ent pdb1scg_G.ent */
    public Protein[]getProteinsSameComplex(){/*X  no synchronized */
        final int N=sze(_vComplex);
        if(N>0){
            final Protein[]pp=new Protein[N];
            int count=0;
            FORi(0,N) if((pp[count]=iThProt(i,_vComplex))!=null && pp[count]!=this) count++;
            return chSze(pp,count,Protein.class);
        }
        final Protein[]ppAli=strapProteins();
        final String thisPdb=delLstCmpnt('_',getPdbID(PDBID_ID));
        if(ppAli.length>0 && sze(thisPdb)>0){
            final Protein[]pp=new Protein[ppAli.length];
            int count=0;
            for(Protein p:ppAli) if(p!=null && strStarts(thisPdb,p.getPdbID(PDBID_ID))) pp[count++]=p;
            return chSze(pp,count,Protein.class);
        }
        return NONE;
    }
    public void setProteinsSameComplex(Protein[]pp){
        if(clr(_vComplex)==null) _vComplex=new ArrayList();
        for(Protein p:pp) if(this!=p&&p!=null) _vComplex.add(wref(p));
    }
/* <<< Complexes <<< */
/* ---------------------------------------- */
/* >>> Nucleotide >>> */
/**  Determines which nucleotide needs to be translated (coding sequence).    True for exon and false for intron or UTR.  */
    public CPP_sync void setExons(int[][]fromTo,boolean reverseComplement){
        clearCache();
        _transFT=fromTo!=null&&fromTo.length==0?new int[][]{{0},{countNucleotides()}}:fromTo;
        //IF_GUI(if(withGui() && fromTo==null) fileDel(0,fileOfProtein(FP_DNA,this)));;
        strapIncMC(P_MC_EXONS,this);
        if(DIFF_MC(_revCompl,reverseComplement))  strapIncMC(P_MC_REVERSE,this);
        if(_charSeq instanceof byte[]&& fileSoftRef()!=null) _charSeq=newSoftRef(_charSeq);
        INTS[PROTEINI_CDS]=-1;
        _ntCount=-1;
        _triplets=null;
        clr(_mapRefSeqOffset);
        clr(_vIdByIdent);
    }
    public boolean isTranslated(){return exons()!=null && !areNucleotidesProjected();}
    public boolean isReverseComplement(){return _revCompl;}
    public CPP_sync byte[]getNucleotides(){
        if(!isTranslated()) return null;
        final byte[]cc=getCharSequence();
        setMC(P_MC_NUC,mc((P_MC_CHARSEQ<<P_MC_SHIFT)|P_MC_REVERSE));
        return cc;
    }

    public CPP_sync int countNucleotides(){
        if(_ntCount<0) _ntCount=sze(getNucleotides());
        return _ntCount;
    }
/* The protein might be a nucleotide sequence */
    public CPP_sync boolean onlyActgn(){
        final byte[]aa=getResType();
        final int nR=countRes();
        if(DIFF_MC(_ACTGNmc,MC[P_MC_RES_TYPE]) || _actgn==0){
            int count=0;
            ROFi0(nR){
                final int c=aa[i]|32;
                if(c=='a' || c=='c' || c=='t' || c=='g' || c=='u') count++;
            }
            _actgn=count>1 && count/(float)nR>0.95?CTRUE: CFALSE;
        }
        return _actgn==CTRUE;
    }
    public byte[]triplets(){
        if(areNucleotidesProjected()) return _pnCDS;
        final int[][]exons=exons();
        final boolean rev=isReverseComplement();
        byte[]nu=_triplets;
        if(setMC(P_MC_TRIPLETS,mc((P_MC_CHARSEQ<<P_MC_SHIFT)|P_MC_EXONS)) || nu==null){
            final byte[]nucl=getNucleotides();
            nu=findTriplets(nucl,MAX_INT,exons,rev,nu);
            _triplets=newByts(nu,0,strLen(nu));
        }
        return nu;
    }
/**       Like getResType() but the full length sequence.    */
    public CPP_sync byte[]getResidueType(){
        final Object[]cached=cached();
        final byte[]triplets=triplets();
        byte[]aa=(byte[])cached[P_P_CACHE_RESIDUES_FULL];
        if(setMC(P_MC_RES_TYPE_FULL,mc((P_MC_EXONS<<P_MC_SHIFT)|P_MC_TRIPLETS)) || aa==null){
            final String translated=iThStrg(PROTEIN_CDS_TRANSLATION,getCDS(appliedCDS()));
            if(translated!=null) cached[P_P_CACHE_RESIDUES_FULL]=aa=toByts(translated);
            else{
                if(!isTranslated()) return getCharSequence();
                cached[P_P_CACHE_RESIDUES_FULL]=aa=triplets2aa(true,triplets,MAX_INT);
            }
        }
        return aa;
    }
    private int[][]_transFT;
    public int[][]exons(){return _transFT;}
/* An array mapping nucleotide indices. E.g. the 100th translated */
/* nucleotide may be found at position 200 of the original */
/* nucleotide array if there is an untranslated region of 100 nucleotides. */
    public CPP_sync int[]coding2allPositions(){
        final Object[]cached=cached();
        final boolean rev=isReverseComplement();
        final int[][]exons=exons();
        if(exons==null) return null;
        int[]kk=(int[])cached[P_CACHE_Ti_2_Ni];
        if(setMC(P_MC_NUC_IDX2TRANSLATED_IDX,mc((P_MC_EXONS<<P_MC_SHIFT)|P_MC_CHARSEQ)) || kk==null){
            final int n3=Bitset.count(MAX_INT,exons);
            if(kk==null || kk.length<n3) kk=redim(kk,n3,33);
            Arrays.fill(kk,0,n3,-1);
            cached[P_CACHE_Ti_2_Ni]=kk;
            for(int idx0=3*subsetStart(),
                    ff[]=exons[0],tt[]=exons[1],b=0,t=0;b<ff.length;b++){
                for(int i=ff[b];i<tt[b] && t<n3;i++){
                    final int k=(rev?n3-++t: t++)-idx0;
                    if(k>=0 && k<kk.length) kk[k]=i;
                }
            }
        }
        return kk;
    }

    public int aa2ntZ(int ia,int c012){
        final int[]c2a=coding2allPositions();
        return iThInt(3*ia+c012,c2a);
    }
#if CPP_WITH_GUI
    public int nt2aaZ(int iN){
        final int[][]xx=exons();
        if(iN<0||!Bitset.get(iN,xx)) return -1;
        final int n=Bitset.count(iN,xx);
        return(isReverseComplement()?triplets().length-n-1: n)/3-subsetStart();
    }
#endif //CPP_WITH_GUI
    public boolean areNucleotidesProjected(){return _pnCDS!=null;}
    public void projectNucleotides(byte[]nt,String cds){
        _pnCDS=nt;/*X  Reihenfolge! */
        parseCDS(cds);
    }
    public static byte[]findTriplets(byte[]dna,int len,int[][]exons,boolean rev,byte[]buf){
        if(dna==null) return null;
        final int L=min(dna.length,len),ff[]=exons[0],tt[]=exons[1],n=Bitset.count(MAX_INT,exons);
        final byte[]aa=buf==null||buf.length<n?new byte[n]: buf;
        int ia=0;
        FORb(0,ff.length){
            FORi(ff[b],tt[b]){
                final int nt=i<0 || i>=L?'n': (rev?COMPLEMENT_BASE[127&dna[i]]: dna[i]);
                if(ia>=n){
/*X assrt(); */
                    break;
                }
                aa[rev?n-ia-1:ia]=(byte)nt;
                ia++;
            }
        }
        if(ia<aa.length) Arrays.fill(aa,ia,aa.length,(byte)0);
        return aa;
    }

/* <<< Nucleotide <<< */
/* ---------------------------------------- */
/* >>> CDS >>> */
    public static boolean unableParseCDS(Object cds){
        if(cds==null) return true;
        if(strchr(':',cds)>=0){
            if(onlyOnce(5)) baOut(RED_WARNING).aa(" unableParseCDS ",cds).aln(" Reason: Reference to external sequence file. ");
            return true;
        }
        return false;
    }

    public boolean asTranslated(boolean printErr,byte[]aa,int L,String cds){
        final byte[]
            triplets=findTriplets(getCharSequence(),MAX_INT,Bitset.parseBitset(cds,L),strstr(STR_IC,"compl",cds)>=0,null),
            predict=triplets2aa(true,triplets,MAX_INT);
        if(predict.length!=L){
            if(printErr&&onlyOnceHC(320,cds)){
                baOut(RED_ERROR).aa(this,'\t',cds," Predicted and given aminoacid sequence ","have different length. ",predict.length,'/',L).aln()
                    .aFT(predict,0,predict.length).aln().aln(aa);
            }
            return false;
        }
        final long ratio=alignmentIdentity(aa,predict,0,L);
        if(CPP_NUMERATOR(ratio)!=L){
            baOut(RED_WARNING).aa(cds," Predicted and given aminoacid sequence ","differ [",L-CPP_NUMERATOR(ratio),'/',L).aln("].");
            return false;
        }
        return true;
    }
    public String[]getCDS(int i) {return (String[])iThEl(i,_vCDS);}
    public int countCDS(){return sze(_vCDS);}
    public CPP_sync void addCDS(String[]cdsData){
        (_vCDS==null?_vCDS=new ArrayList(): _vCDS).add(cdsData);
        if(cdsData[PROTEIN_CDS_CDS]==null) assrt();
    }
    public boolean applyCDS(int i){
        final String[]data=getCDS(i);
        if(data==null) return false;
        parseCDS(data[PROTEIN_CDS_CDS]);
        INTS[PROTEINI_CDS]=i;/*X  Reihenfolge nach parseCDS ! */
        final String refs=iThStrg(PROTEIN_CDS_XREFS,data);
        if(refs!=null){
            clr(_vIds);
            for(String xRef:splitTkns('\t',refs)) addSeqRef(0,xRef);
        }
        return true;
    }

    public boolean setCDS(String f){
        if(sze(f)>0){
            if(0>nxt(0,chrClas(-DIGT),f)) return applyCDS(xatoi(f));
            if(strstr(0,"..",f)>=0){
                parseCDS(f);
                return true;
            }
            if(nxt(0,chrClas(LETTR),f)>=0){
                ROFi0(countCDS()) if(idxOfStrg(STR_IC|STR_w,f,getCDS(i))>=0) return applyCDS(i);
            }
        }
        return false;
    }
/* <<< CDS <<< */
/* ---------------------------------------- */
/* >>> Parsing  >>> */
/* join(7940..7996,8095..8174,8287..8368,8506..8686,*/
/* complement(join(1787209..1787388,1787427.... */
/* join(complement(2261..2639),complement(881..1620)) */
    public CPP_sync void parseCDS(Object txt){
        if(unableParseCDS(txt)){setExons(EXONS_UNABLE_TO_PARSE,false);return;}
        final byte[]z=toByts(txt);
        final int[][]exons;
        final boolean rev;
#if CPP_WITH_GUI
        if((z[2]|32)=='x'){
            if(z.length<3) return;
            rev=z[0]+z[1]=='C'+'R';
            final boolean[]bb=new boolean[z.length-2];
            ROFi0(bb.length) bb[i]=(z[i+2]&32)==0;
            exons=Bitset.fromBool(bb);
        } else
#endif //CPP_WITH_GUI
            {
                rev=strstr(0,"compl",z)>=0;
                exons=Bitset.parseBitset(z,getCharSequence().length);
            }
        setExons(exons,rev);
        final String molType=wordAt(txt,strstr(STR_AFTER,"moleculeType=",txt));
        if(molType!=null) setMoleculeType(toByts(molType),0,MAX_INT);
    }
/* <<< Parsing <<< */
/* ---------------------------------------- */
/* >>> Cache >>> */
    private transient Object _cache;
    private final int[]CACHE_MC=new int[P_NUM_CACHE];
    final int[]MC=new int[P_MC_MAX];
    private int _mcSubset,_mcResSelSorted,_mcGap/*,_mcRefSeq*/ IF_GUI(,_mcResSelNotEmpty);
    public int mc(int mcs){
        int mc,sum=0;
        while((mc=(mcs&((1<<P_MC_SHIFT)-1)))!=0){
            sum+=MC[mc]+MC_PROT_NOT_SPECIFIED[mc];
            mcs>>>=P_MC_SHIFT;
        }
        return sum;
    }
    // CPP_sync Warum synchronized? Gefahr _RUN_WATCH_SEQ_FILE
    public boolean setMC(int type,int value){
        if(MC[type]!=value){
            MC[type]=value;
            return true;
        }
        return false;
    }

    Object[]cached(){
        Object[]r=(Object[])deref(_cache);
        if(r==null) _cache=newSoftRef(r=new Object[P_NUM_CACHE]);
        return r;
    }

    private Object fromCache(Object[]cache,int type,int mc){
        if(CACHE_MC[type]!=mc){
            CACHE_MC[type]=mc;
            cache[type]=null;
        }
        return cache[type];
    }
    private boolean cacheEmpty(Object[]cache,int type,int mc){
        if(CACHE_MC[type]!=mc){
            CACHE_MC[type]=mc;
            cache[type]=null;
            return true;
        }
        return false;
    }
/* <<< Cache <<< */
/* ---------------------------------------- */
/* >>> Gaps >>> */
    int[]_resGap;
#define _setGaps(rg) _resGap=rg;_mcGap++; strapIncMC(MCA_ALIGNMENT,null);
    //    private void _setGaps(int[]rg) {_resGap=rg;_mcGap++; strapIncMC(MCA_ALIGNMENT,null);
    //        if(_resGap==null && getName().startsWith("a2_Mus")) putln(DEBUG_NOW+this+"_setGaps NULL");
    //}
    public CPP_sync void setResidueGap(int[]gg){
        ROFi0(sze(gg)){
            if(gg[i]<0){
                final int nR=countRes();
                if(i<nR && onlyOnce(37))  baOut(RED_ERROR).aIntArray(gg,0,nR).special(STCKTRC).aln();
                gg[i]=0;
            }
        }
        _setGaps(gg);
    }
    public CPP_sync void setResidueGapAt(boolean add,int iA,int gap){
        final int nR=countRes();
        int[]gg=getResGap();
        if(iA<0 || iA>=nR || add && gap==0) return;
        if(sze(gg)<=iA){
            if(gap==0) return;
            gg=chSze(gg,nR);
        }else if(add){
            gap+=gg[iA];
        }
        if(gap<0) gap=0;
        if(gap!=gg[iA]){
            gg[iA]=gap;
            _setGaps(gg);
        }
    }
    public CPP_sync int[]getResGap(){
        final int n=countRes();
        int[]gg=_resGap;
        if(gg!=null && (gg.length<n || gg.length>n+99)){
            gg=_resGap=chSze(gg,n);
        }
        return gg;
    }
#if CPP_WITH_GUI
    public CPP_sync int getResGapAt(int i){
        final int[]gg=getResGap();
        return i>=0 && i<countRes() && gg!=null && i<gg.length?gg[i]:0;
    }
#endif //CPP_WITH_GUI
/* <<< Gaps <<< */
/* ---------------------------------------- */
/* >>> Columns >>> */

/**  Maps residue indices upon horizontal text positions of the alignment.       @return an integer-array of all horizontal positions for each residue  */
    private Gaps2Columns _g2c,_g2cAli;
    IF_GUI(public void setGaps2Columns(Gaps2Columns g2c) {_g2c=g2c;clearCache();});;
    public CPP_sync int[]getResColumn(){
        final Object[]cached=cached();
        final int nR=countRes();
        getResType();
        boolean wide=(_flags&PFLAG_IN_ALI)==0 || (_globFlags&GPFLAGS_WIDE_GAPS)!=0;
        Gaps2Columns gap2col=_g2c;
        if(gap2col==null){
            if(OBJECTS[PROTEINO_ALIGNMENT]!=null) _g2cAli=wide?null:Strap.strapG2C();
            if(null==(gap2col=_g2cAli)) wide=true;
        }
        final int[]gg=getResGap(),wide2view=wide?null:gap2col.wide2viewColumnNoSync();
        int[]cc=(int[])cached[wide?P_P_CACHE_ResColW:P_CACHE_ResCol];
        if(cc==null || cc.length<nR || cacheEmpty(cached,wide?P_P_CACHE_ResColW:P_CACHE_ResCol,MC[P_MC_RES_TYPE]+_mcGap+(wide?0:gap2col.mc()))){
            if(wide){
                cached[P_P_CACHE_ResColW]=cc=redim(cc,nR,33);
                int po=-1,ia=0;
                if(gg!=null) for(int to=min(nR,gg.length);ia<to;ia++) cc[ia]=po+=gg[ia]+1;
                for(;ia<nR;ia++) cc[ia]=(++po);
            }else{
                cached[P_CACHE_ResCol]=cc=Gaps2Columns.computeColumns(wide2view,gg,nR,cc);
            }
        }
        return cc!=null?cc: NO_int;
    }

    public CPP_sync int getResColumnAt(int i){
        if(i<0||i>=countRes()) return INT_NAN;
        if(_resGap==null) return i;
        final int[]cc=getResColumn();
        return i<cc.length?cc[i]:INT_NAN;
    }
/** Get the horizontal position of the last residue.. */
    public CPP_sync int getResColumnMax(){
        final int nR=countRes();
        if(nR==0) return INT_NAN;
        if(_resGap==null) return nR-1;
        return getResColumn()[nR-1];
    }
/**  An array to map horizontal residue positions to residue indices. At gap positions the array contains -1.  */
    public CPP_sync int[]columnsToIndices(){
        final Object[]cached=cached();
        getGappedSequence(false);
        return(int[])_gapped(cached)[P_CACHE_col2i];
    }
#if 0
/**
       Get index of residue at the horizontal alignment position.
       @param col the alignment position (column)
       @param goUp: 0: If there is a gap at position col then return -i. Otherwise return the index at the next (CTRUE) or previous (CFALSE) resisue.
       @return the index of the residue at alignment position
*/
#endif //0
    public CPP_sync int columnToIndex(int goUp,int col){
        final int c2i[]=columnsToIndices(),max=getResColumnMax();
        if(col<0) return goUp==CTRUE?0:-1;
        if(col>max || col>=c2i.length) return goUp==CFALSE?countRes()-1:-1;
        int ia=c2i[col];
        if(ia<0 && goUp!=0){
            if(goUp==CTRUE){
                while(col<=max&&(ia=c2i[col])<0) col++;
            }else{
                while(col>=0&&(ia=c2i[col])<0) col--;
            }
        }
        return ia;
    }
/* <<< Columns <<< */
/* ---------------------------------------- */
/* >>> gapped sequence >>> */
/** The 0-terminated gapped amino acid sequence.  */
    public CPP_sync byte[]getGappedSequence(boolean exactLength){
        final Object[]cached=cached();
        byte[]gg=(byte[])_gapped(cached)[P_CACHE_gapped];
        if(exactLength && gg!=null){
            final int L=getResColumnMax()+1;
            if(gg.length!=L) cached[P_CACHE_gapped]=gg=chSze(gg,L);
        }
        return gg;
    }

    private Object[]_gapped(Object[]cached){
        final byte[]aa=getResType();
        final int[]cc=getResColumn();
        byte[]gs=(byte[])cached[P_CACHE_gapped];
        if(setMC(P_MC_GAPPED_SEQ,MC[P_MC_RES_TYPE]+CACHE_MC[P_P_CACHE_ResColW]+CACHE_MC[P_CACHE_ResCol]+_mcGap+MC_GLOBAL[MCA_EMPTY_COLS]) || gs==null){
            final int n=aa==null||aa.length==0||cc.length==0?0:countRes();
            int[]c2i;
            if(n==0){
                c2i=NO_int;
                gs=NO_byte;
            }else{
                final int maxCol=cc[n-1],maxCol1=maxCol+1,c0=cc[0];
                if(gs==null||gs.length<maxCol1) gs=new byte[maxCol1 IF_GUI(+11)];
                if(c0>0) Arrays.fill(gs,0,c0,(byte)' ');
                if(c0<maxCol) Arrays.fill(gs,c0,maxCol,(byte)'-');
                if(maxCol1<gs.length) Arrays.fill(gs,maxCol1,gs.length,(byte)0);
                c2i=redim((int[])cached[P_CACHE_col2i],maxCol1,IF_GUI(11)UNLESS_GUI(0));
                Arrays.fill(c2i,0,maxCol1,-1);
                try{
                    ROFi0(n){
                        final int col=cc[i];
                        gs[col]=aa[c2i[col]=i];
                    }
                }catch(IndexOutOfBoundsException iobex){
                    if(onlyOnce(32)) baOut(RED_ERROR).aa(this," getGappedSequence: ").aIntArray(cc,0,n).aln();
                    c2i=count01234(0,null,0,maxCol1);
                    gs=aa;
                }
            }
            cached[P_CACHE_col2i]=c2i;
            cached[P_CACHE_gapped]=gs;
        }
        return cached;
    }
/* <<< Get gapped Sequence <<< */
/* ---------------------------------------- */
/* >>> Set gapped Sequence >>> */
/** The original residue types are kept but the gaps are inferred from the gapped sequence seq.*/
/** A letter denotes an amino acid,any other character a gap.*/
    public CPP_sync void inferGapsFromGappedSequence(byte[]seq){
        if(seq==null) return;
        final int[]gaps=new int[countRes()];
        for(int lastPos=-1,ia=0,pos=0;pos<seq.length && ia<gaps.length;pos++){
            final int c=seq[pos]|32;
            if(IS_LOWER(c)){
                gaps[ia++]=pos-lastPos-1;
                lastPos=pos;
            }
        }
        setResidueGap(gaps);
    }
    public CPP_sync void setGappedSequence(byte[]seq,int len){
        setResidueType(allLettersB(seq,0,len));
        inferGapsFromGappedSequence(seq);
    }
/**  Reads a line such as X2XXX3X1XXXX2XXXXX        The numbers are gaps and the letters residue positions    */
#if CPP_WITH_GUI
    public boolean parseGaps(byte[]z,int L){
        if(z==null) return false;
        {
            final boolean[]lettr=chrClas(LETTR),digt=chrClas(DIGT);
            final int[]gaps=new int[countChrClas(lettr,z,0,L)];
            for(int po=0,ga=0,i=0;i<L;i++){
                final int c=z[i];
                if(c>0&&lettr[c]){
                    gaps[po++]=ga;
                    ga=0;
                    continue;
                }
                if(IS_DIGIT(c) || c=='-'){
                    int gap=z[i]-'0';
                    while(i+1<L && isChrClas(digt,z,i+1)) gap=10*gap+z[++i]-'0';
                    ga+=gap;
                }
            }
            setResidueGap(gaps);
        }
/* may be toLowerCase */
        final byte[]aa=getResType();
        for(int nR=countRes(),i=0,ia=0;i<L && ia<nR;i++)if(IS_LOWER(z[i])) aa[ia++]|=32;
        return true;
    }
#endif //CPP_WITH_GUI
/* <<< Set gapped Sequence <<< */
/* ---------------------------------------- */
/* >>> Sort >>> */
    public int getWebTokenIdx(){
        final Object t=OBJECTS[PROTEINO_WEB_TOK],tt[]=(Object[])OBJECTS[PROTEINO_WEB_TOKENS];
        if(_tokenIdx==MIN_INT && t!=null && tt!=null) _tokenIdx=idxOf(t,tt);
        return _tokenIdx;
    }
/* <<< Sort <<< */
/* ---------------------------------------- */
/* >>> Save >>> */
#if CPP_WITH_GUI
    private Collection _save(int file,File dir,CPP_AS_OBJECT(CharSequence)txt,Collection vErr){
        final File f=fileOfProteinForDir(file,this,dir);
        return null==wrte(WRTE_DEL_IF_EMPTY,f,txt)?adUniqNew(f,vErr):vErr;
    }
    public void save(File dir,BA sbTmp,BA error){
        clr(sbTmp);
        Collection v=null;
        if(dir!=iFile(DIR_STRAP_ANNO)){
            {
                final int[]gg=getResGap();
                int count=0;
                if(gg!=null && (dir==iFile(DIR_STRAP_DND) || _mcGap>0)){
                    final int n=min(countRes(),gg.length);
                    FORi(0,n){
                        if(gg[i]>0) {sbTmp.a(gg[i]); count++;}
                        sbTmp.a('X');
                    }
                    //wrte(fileOfProtein(FP_GAPS,this,dir),sbTmp);
                }
                v=_save(FP_GAPS,dir,count==0?null:sbTmp,v);
            }
            //if (isTranslated())  wrte(fileOfProtein(FP_DNA,this,dir),Bitset.toText(exons(),isReverseComplement(),null));
            v=_save(FP_DNA,dir,!isTranslated()?null:Bitset.toText(exons(),isReverseComplement(),clr(sbTmp)),v);
/* final File f=fileOfProtein(FP_1stIdx,this,dir); */
/* if(getIntProperty(PROTEINI_AA_IDX_OFFSET)==0) fileDel(0,f); */
/* else if(!wrte(f,s(getIntProperty(PROTEINI_AA_IDX_OFFSET)))) v=adUniqNew(f,v); */
            v=_save(FP_1stIdx,dir,getIntProperty(PROTEINI_AA_IDX_OFFSET)==0?null:s(getIntProperty(PROTEINI_AA_IDX_OFFSET)),v);
/* final String pdbId=getPdbID(PDBID_INFERRED); */
/* final File f=fileOfProtein(FP_ASSOCPDB,this,dir); */
/* if(pdbId==null) fileDel(0,f); */
/* else if(!wrte(f,pdbId)) v=adUniqNew(f,v); */
            v=_save(FP_ASSOCPDB,dir,getPdbID(PDBID_INFERRED),v);
            final Matrix3D m3d=getRotationAndTranslation();
/* final File f=fileOfProtein(FP_TRANS,this,dir); */
/* if(m3d==null) fileDel(0,f); */
/* else if(!wrte(f,m3d.toText(MTRX_FORMAT_XML,"",clr(sbTmp)))) v=adUniqNew(f,v); */
            v=_save(FP_TRANS,dir,m3d==null?null:m3d.toText(MTRX_FORMAT_XML,"",clr(sbTmp)),v);
        }
        ResidueAnnotation.saveResan(this,dir,clr(sbTmp));
        if((v=_save(FP_ANNO,dir,sbTmp,v))!=null && sze(error)>0) error.aln("Error: Could not write").joinLns(v).aln();
    }
#endif //CPP_WITH_GUI
/* <<< Save <<< */
/* ---------------------------------------- */
/* >>> Sequence Icon >>> */
    public String iconURL(){
        Object url=_iconURL;
        IF_GUI(if(url==null) _iconURL=url=orO(toStrgTrim(readBytes(fileOfProtein(FP_ICON,this))),ALIAS_ERROR));;
        return url==ALIAS_ERROR?null: (String)url;
    }
    public void setSequenceIcon(String dd){/*X  Can set base64 and url at once */
        IF_GUI(_icon=)_iconURL=_icon64=null;;
        IF_GUI(if(dd==null) {_icon=""; fileDel(0,fileOfProtein(FP_ICON,this));});;
        for(String d:splitTkns(dd)){
            if(strStarts(arry(SARRAY_IMAGE_XXX_BASE64),d)){
#if CPP_WITH_GUI
                if(withGui()){
                    final Object i64=base64ToIcon(d,null);
                    if(i64!=ALIAS_ERROR){
                        _icon=i64;
                        wrte(fileOfProtein(FP_ICON64,this),_icon64=new BA(d));
                    }
                } else
#endif //CPP_WITH_GUI
                    _icon64=new BA(d);
            }else{
#if CPP_PRG_AA
                if(looks(LIKE_FILEPATH,d)){
                    final File f=file(d);
                    if(sze(f)==0) baOut(RED_WARNING).a("setSequenceIcon ").aFile(f).aln();
                    IF_READ_FILE_SECURITY(if(aaCanNotRead(d)) return;)
                        _icon64=imgBase64(IMAGEBASE64_H,s(d));
                }
#else
                _iconURL=d;
                if(withGui()) wrte(WRTE_DEL_IF_EMPTY,fileOfProtein(FP_ICON,this),d);
#endif //CPP_PRG_AA
            }
        }
        IF_GUI(strapIncMC(P_MC_SEQ_LABELS,this));;
    }
    public BA iconBase64(){
        Object d=_icon64;
        IF_GUI(if(d==null) _icon64=d=orO(readBytes(fileOfProtein(FP_ICON64,this)),ALIAS_ERROR));;
        return d==ALIAS_ERROR?null:(BA)d;
    }
/* <<< Sequence Icon <<< */
/* ---------------------------------------- */
/* >>> balloon text >>> */
    public void setBalloonText(String t){
        _balloonDirect=sze(t)==0?null:t;
        IF_GUI(_balloon[0]=_balloon[1]=null;  strapIncMC(P_MC_SEQ_LABELS,this));;
    }
    public String balloonText(IF_GUI(int opt)){
#if CPP_WITH_GUI
        if(_balloon==null) _balloon=new String[2];
        if(_balloon[0]==null ||  _fBalloon==null || _balloonWhen!=_fBalloon.lastModified()){
            _balloonWhen=(_fBalloon=fileOfProtein(FP_BALLON,this)).lastModified();
            BA ba=readBytes(_fBalloon);
            if(_balloonDirect!=null) (ba==null?ba=new BA(0): ba).aln().a(_balloonDirect);
            _balloon[0]=toStrgN(ba);
            _balloon[1]=s(baTmp().aHtmlCode(ba));
        }
#endif //CPP_WITH_GUI
        return IF_GUI(orS(_balloon[0!=(opt&SEQ_BALLOON_HTML)?1:0],null)) UNLESS_GUI(_balloonDirect);
    }
/* <<< Balloon text <<< */
/* ---------------------------------------- */
/* >>> Renderer >>> */
#if CPP_WITH_GUI
    private final static Object[]_pLabel=new Object[2];
    private final long HASH_CODE32=uintToLong(hashCode())<<32,_when=System.currentTimeMillis(),_rendMC[]=new long[1];
#endif //CPP_WITH_GUI
    public int exonForAminoZ(int ia,int codon012){
        final int[][]ee=exons();
        if(ee==null) return -1;
        final boolean rev=isReverseComplement();
        final int n=3*(ia+subsetStart())+codon012,exNum=Bitset.selected2block(rev?Bitset.countAll(ee)-1-n:n,ee);
        return rev?ee[0].length-exNum-1:exNum;
    }
/* <<< Renderer <<< */
/* -------------------------------------- */
/* >>> Residue Selection >>> */
    private UniqueList[]_vv;
    UniqueList vChilds(int i){
        UniqueList v=_vv==null?null:_vv[i<0?-i:i];
        if(v==null && i>0){
            //if(i<0) i=-i;
            if(_vv==null) _vv=new UniqueList[SOBJECT_ZZZ];
            v=_vv[i]=new UniqueList(i==SOBJECT_V3D?iCLASS_View3d:
                                    i==SOBJECT_RESSEL || i==SOBJECT_RESSEL_AND_RESAN || i==SOBJECT_RESSEL_NOT_EMPTY?iCLASS_ResidueSelection:
                                    CHAINTYPE_FST<=i && i<=CHAINTYPE_LST?iCLASS_Protein:
                                    iCLASS_ResidueAnnotation);
            IF_GUI(setTxt(iConst(SARRAYeq_STRAP_OBJECT_TITLE,i),v));;
            IF_GUI(if(i==SOBJECT_V3D) v.addHookCR(_RUN_SEQUENCE_V3D_CHANGED,this,UNIQL_HOOK_CHANGE));;
        }
#if CPP_WITH_GUI
        if(v!=null && i==SOBJECT_RESSEL_NOT_EMPTY){
            final UniqueList v0=vChilds(SOBJECT_RESSEL);
            if(DIFF_MC(_mcResSelNotEmpty,v0.mc()+MC[P_MC_RES_SELECTIONS_NOT_EMPTY])){
                clr(v);
                for(Object s:v0.asArray()){
                    if(s!=null&&0!=(((ResidueSelection)s).getVisibleWhere()&VIS123_LIST_NOT_EMPTY) || fstTrue(((ResidueSelection)s).getSelectedAminoacids())>=0) v.add(s);
                }
            }
        }
#endif //CPP_WITH_GUI
        return v;
    }
    public Protein[]getMolecules(int i) {final UniqueList v=vChilds(-i); return v!=null?(Protein[])v.asArray(): Protein.NONE;}
#if CPP_DEACTIVATED
    Protein hetWithNumInsName(int n32,int resn,char ins,String chain){
        for(Protein p:getMolecules(CHAINTYPE_HET)) if(n32==p.getResidueName32()[0] && p.resnAt(RESIDUE_FULL,0)==resn && iThByte(0,p.getResidueInsCode())==insCodeChar(ins)&& eqStr(chain,p.getChain())) return p;
        return null;
    }
#endif //CPP_DEACTIVATED
    public ResidueSelection[]resSel(int i) {final UniqueList v=vChilds(-i); return v!=null?(ResidueSelection[])v.asArray(): ResidueAnnotation.NONE;}
    public CPP_sync ResidueAnnotation[]residueAnnotations(){return (ResidueAnnotation[])resSel(SOBJECT_RESAN);}

    public CPP_sync ResidueSelection[]allResidueSelectionsSorted(){
        if(DIFF_MC(_mcResSelSorted,mc((P_MC_RES_SELECTIONS_V<<P_MC_SHIFT)|P_MC_RES_SELECTION_STYLE))) sortArry(vChilds(SOBJECT_RESSEL_AND_RESAN),comparator(COMPARE_SEL_VIS));
        return resSel(SOBJECT_RESSEL_AND_RESAN);
    }
/** Add a  selection of residues  */

/** Remove residue selection */
    //Synchronized for Ressel but not for Heteros

    boolean _rmOrAdd(int opt,Object s){
        if((s=deref(s))!=null &&  (0!=(opt&P_ADD)||_vv!=null)){
            if(szeVA(s)>=0){
                boolean changed=false;
                ROFi0(szeVA(s)) changed|=_rmOrAdd(opt,xiThEl(i,s));
                return changed;
            }
            if(s instanceof File && 0!=(opt&P_ADD)) return _rmOrAdd(P_ADD,readPepOrNuc(READP_ONLY_HET_OR_NUC,null,s));
            final int t=sobjectType(s);
            //if ("new_annotation".equals(nam(s))) putln(DEBUG_NOW+" SOBJECT_SEQFEAT "+s+"  t="+t);stckTrcCT(0); System.exit(9);
            if(t>=0){
                //                final Protein h=CHAINTYPE_FST<=t && t<=CHAINTYPE_LST?(Protein)s:null;
                // if(h!=null && isContainerForHeteros(h)) return _rmOrAdd(opt,h.getMolecules(CHAINTYPE_NUC_OR_HET));
                final Protein h=derefProt(s);
                final int general=SOBJECT_RESSEL_FST<=t && t<=SOBJECT_RESSEL_LST?SOBJECT_RESSEL_AND_RESAN: h!=null?CHAINTYPE_NUC_OR_HET: SOBJECT_V3D;
                if(h!=null && h.getResidueCalphaXYZ(null)!=null){
                    for(Protein child:getMolecules(h.INTS[PROTEINI_CHAINTYPE])){
                        if(child.getResidueCalphaXYZ(null)!=null && child.hashCodeCalpha()==h.hashCodeCalpha()){
                            baLog(LOG_MSG).aa("@1"+ANSI_GREEN+" ",IF_GUI(iConst(SARRAYeq_sobjectTitle1,t),)' ',h).aln(" ALREADY_ATTACHED_IGNORE."+ANSI_RESET);
                            return false;
                        }
                    }
                }
                IF_GUI(final boolean isCursor=s instanceof ResidueSelectionImpl&&(0!=(((ResidueSelectionImpl)s)._opt&RESSEL_IMPL_NOT_IN_TREE)));;
                if(0!=(opt&P_ADD)?vChilds(general).add(s): rmElmntFromV(s,_vv[general])){
                    ROFi0(SOBJECT_ZZZ){
                        if(i==general) continue;
                        if(0!=(opt&P_ADD)){
                            if(this!=s && sobjectComprises(i,t) IF_GUI(&&!isCursor&&i==SOBJECT_RESSEL)) vChilds(i).add(s);
                        }else if((general==SOBJECT_RESSEL_AND_RESAN?SOBJECT_RESSEL_FST: h!=null?CHAINTYPE_FST:0)<=i&&i<=(general==SOBJECT_RESSEL_AND_RESAN?SOBJECT_RESSEL_LST: h!=null?CHAINTYPE_LST:MAX_INT)){
                            rmElmntFromV(s,_vv[i]);
                        }
                    }
                    if(general==SOBJECT_RESSEL_AND_RESAN){
                        if(t==SOBJECT_SEQFEAT) strapIncMC(MCA_SEQUENCE_FEATURES_V,null);
                        strapIncMC(P_MC_RES_SELECTIONS_V,this);
                        if(0!=(opt&P_ADD)){
                            final boolean enab=runCR(RUN_IS_ENABLED,s)!=FALSEr;
                            if(t!=SOBJECT_RESSEL){
                                if(t==SOBJECT_SEQFEAT){
                                    final boolean e=vChilds(enab?SOBJECT_SEQFEAT:SOBJECT_SEQFEAT_DEACT).add(s);
                                    if(rmElmntFromV(s,vChilds(enab?-SOBJECT_SEQFEAT_DEACT:-SOBJECT_SEQFEAT))||e) strapIncMC(MCA_SEQUENCE_FEATURES_V,null);
                                }else{
                                    vChilds(SOBJECT_RESAN_NF).add(s);
                                }

                                if(enab) vChilds(SOBJECT_RESAN).add(s);
                                else if(t==SOBJECT_SEQFEAT) rmElmntFromV(s,vChilds(-SOBJECT_RESAN));
                            }
                            if(sp(s)!=this) setProt(this,s);
                            //   if(s instanceof SelectorOfNucleotides) vChilds(SOBJECT_SEQFEAT).add(s); Was soll das?
#if CPP_WITH_MEIN_DEBUG
                            if(enab && t==SOBJECT_SEQFEAT && sftrSecStrChar(((ResidueAnnotation)s).featureName())!=0 && getResidueSecStrType()!=null){
                                if(onlyOnce(43)) baOut(RED_ERROR).aa(" Feature sec stru ",s,' ').aln(this).special(STCKTRC);
                            }
#endif //CPP_WITH_MEIN_DEBUG
                        }
                        IF_GUI(if(withGui() && !isCursor) updateChildTreeP(t!=SOBJECT_RESSEL?s:vChilds(-SOBJECT_RESSEL),null,this));;
                    }else if(h!=null){
                        if(0!=(opt&P_ADD)){
                            h.setProperty(PROTEINO_OWNERS_OF_NUC_OR_HET,adToArry(2,wref(this),(Object[])h.getProperty(PROTEINO_OWNERS_OF_NUC_OR_HET),null));
#if CPP_WITH_GUI
                            if(0!=(opt&P_ADD_HETERO_APPLY_INVERSE_MX)){
                                final Matrix3D m3d=getRotationAndTranslation();
                                if(!isUnitOrNull(m3d)){
                                    final Matrix3D m3dInv=m3d.newInverse();
                                    h._atomXYZ=m3dInv.transformPoints(h.getAtomXYZ(null),0,MAX_INT,null);
                                    h.setResidueCalphaXYZ(m3dInv.transformPoints(h.getResidueCalphaXYZ(null),0,MAX_INT,null));
                                    strapIncMC(P_MC_ATOM_COORD_ORIG,this);
                                    clearCache();
                                }
                            }
#endif //CPP_WITH_GUI
                        }else{
                            final Object[]owner=(Object[])h.getProperty(PROTEINO_OWNERS_OF_NUC_OR_HET);
                            setIthEl(idxOf(wref(this),owner),null,owner);
                        }
                        strapIncMC(P_MC_HETERO_V,this);
                        IF_GUI(strapEvtDispatch(EVT_HET_OR_NT_STRUCTURE_ADDED_OR_REMOVED|SEVTMS*333));;
                    }else{
                        strapIncMC(P_MC_PROTEIN_V3D_V,this);
                    }
                }
            }
            IF_GUI(rmElmntFromV(s,strapSelectedObjectsV()));;
            return true;
        }
        return false;
    }
    public void rmResidueSelectionWithName(Object name){
        final int hc=name.hashCode();
        for(ResidueSelection s:resSel(SOBJECT_RESSEL_AND_RESAN)){
            final String n=nam(s);
            if(n!=null && n.hashCode()==hc && n.equals(name)) rmFromProt(s,this);
        }
    }
/**   Returns an array telling what residues are selected by at least one residue selection.  0 means not selected any other number means selected. */
    public byte[]selAminos(){/*X  no synchronized */
        if(_vv==null) return NO_byte;
        final Object[]cached=cached();
        final byte[]cSelA=(byte[])cached[P_CACHE_selAA];
        if(setMC(P_MC_SELECTED_RES,modic(_vv[SOBJECT_RESSEL_AND_RESAN])+MC[P_MC_RES_SELECTIONS]+MC[P_MC_1ST_RES_IDX]+MC[P_MC_RESNUM]) || cSelA==null){
            byte[]bbbA=NO_byte;
            for(ResidueSelection s:resSel(SOBJECT_RESSEL_AND_RESAN)){
                if(vis123isThere(VIS123_SEQUENCE|VIS123_NO_FLASH,s)){
                    final boolean[]bbA=IF_GUI(resSelPosDisplayed(s)) UNLESS_GUI(s.getSelectedAminoacids());
                    final int nR=countRes(),selOffsetA=s.getSelectedAminoacidsOffset()-firstResIdx(this),lastTrue=lstTrue(bbA);
                    if(lastTrue>=0){
                        if(bbbA==NO_byte){
                            if(cSelA!=null && nR<=cSelA.length) clr(bbbA=cSelA);
                            else bbbA=new byte[nR+9];
                        }
                        final int n=min(lastTrue+1,nR-selOffsetA);
                        FORi(Math.max(0,-selOffsetA),n) if(bbA[i] && bbbA[i+selOffsetA]<Byte_MAX_VALUE) bbbA[i+selOffsetA]++;
                    }
                }
            }
            cached[P_CACHE_selAA]=bbbA;
        }
        return(byte[])cached[P_CACHE_selAA];
    }
    public CPP_sync ResidueSelection[]aaSelectionsAtZ(int f,int t,int where){
        final Collection v=vClr(16);
        aaSelectionsAtZ(f,t,where,v);
        return toArryClr(v,ResidueSelection.NONE);
    }
    CPP_sync boolean aaSelectionsAtZ(int aFrom,int aTo,int where,Collection v){
        boolean found=false;
        final int nR=countRes();
        if(aTo==ALIAS_POSITION_PLUS_1) aTo=aFrom+1;
        if(aFrom>=aTo || aTo<1 || aFrom >=nR) return false;
        for(ResidueSelection s:resSel(SOBJECT_RESSEL_AND_RESAN)){
            if(where!=0 && !vis123isThere(where,s)) continue;
#if CPP_WITH_GUI
            {
                final int it=instType(s);
                if(it==RESSEL_IMPL_CURSOR|| 0!=(where&VIS123_OPT_NO_MOUSE_OVER) && it==RESSEL_IMPL_MOUSE_OVER) continue;
            }
#endif //CPP_WITH_GUI
            final boolean[]bb=IF_GUI(0!=(where&VIS123_OPT_ARROW_HEADS)?resSelPosDisplayed(s):)  s.getSelectedAminoacids();
            if(fstTrue(bb)<0) continue;
            final int off=s.getSelectedAminoacidsOffset()-firstResIdx(this),n=min(nR,min(bb.length+off,aTo));
            FORi(Math.max(off,aFrom),n){
                if(bb[i-off]){
                    if(v==null) return true;
                    found=true;
                    v.add(s);
                    break;
                }
            }
        }
        return found;
    }
#if CPP_WITH_GUI
    public Map residueAnnotationsByGroup(){/*X<String,UniqueList<ResidueAnnotation>>*/
        final Object[]cached=cached();
        final ResidueAnnotation[]aa=residueAnnotations();
        ChMap mGrps=(ChMap)cached[P_CACHE_groupAnno]; /*X<String,UniqueList<ResidueAnnotation>>*/
        if(cacheEmpty(cached,P_CACHE_groupAnno,_vv==null?0:MC[MC_RESIDUE_ANNOTATION_GROUPS]+modic(_vv[SOBJECT_RESAN])+modic(_vv[SOBJECT_SEQFEAT])+modic(_vv[SOBJECT_SEQFEAT_DEACT])) || mGrps==null){
            if(mGrps==null){
                setTxt("Residue Annotations",
                       setIcn(IC_ANNO,
                              cached[P_CACHE_groupAnno]=mGrps=new ChMap(0,String.class,UniqueList.class,16)));
            }
            clr(mGrps.vArray());
            for(ResidueAnnotation a:aa){
                if(a.featureName()==null){
                    final String group=a.value(IRESAN_GROUP);
                    UniqueList<ResidueAnnotation>v=(UniqueList)mGrps.get(group);
                    if(v==null) mGrps.put(group,setTxt(group,v=new UniqueList(iCLASS_ResidueAnnotation)));
                    runCR1(RUN_SET_ICON,v,IC_ANNO);
                    v.add(a);
                }
            }
            for(Object v:mGrps.vArray()) if(szeVA(v)<=0) mGrps.remove(getTxt(v));
            ROFi0(2){
                final List v=vChilds(-i==0?SOBJECT_SEQFEAT_DEACT:SOBJECT_SEQFEAT);
                if(sze(v)>2) sortArry(v,comparator(COMPARE_RENDERER_TEXT));
            }
        }
        return mGrps;
    }
#endif //CPP_WITH_GUI
/* <<< ResidueAnnotation <<< */
/* ---------------------------------------- */
/* >>> Sequence Features >>> */
    public void addInvalidFeatureHC(long hc){
        CPP_synchronized(SYNC_INVALID_SEQFEAT){
            if(!isInvalidFeatureHC(hc)){
                if(_iFtr==null||_iFtrCount>=_iFtr.length) _iFtr=chSze(_iFtr,_iFtrCount*2+10);
                _iFtr[_iFtrCount++]=hc;
            }
        }
    }
    public boolean isInvalidFeatureHC(long hc){
        CPP_synchronized(SYNC_INVALID_SEQFEAT){
            ROFi0(_iFtrCount) if(_iFtr[i]==hc) return true;
            return false;
        }
    }
/* <<< Sequence Features <<< */
/* ---------------------------------------- */
/* >>> Threading >>> */

    CPP_RUN_ID_ARG(){
#define baTmp2()  baClr(159)
        IF_GUI(int returnWords=-1);;
        switch(id){
#if CPP_WITH_GUI
            CASE_ARG(RUN_PRESSED_DELETE_OR_BACKSPACE,Object,q){
                final Protein[]pp=spp(sobjectsOfType(CHAINTYPE_HET,selValues(q),null));
                if(pp.length>0 && dlgYesNo(sobjectsTitle(pp,toBA("Delete ")).a('?'))) rmFromProt(pp,this);
                BREAK;
            }
            CASE_ARGV(RUN_GET_ICON){
                Object ic=_icon;
                if(ic==null){
                    final BA d64=iconBase64();/*X readBytes(fileOfProtein(FP_ICON64,this));*/
                    if(sze(d64)>0) _icon=ic=base64ToIcon(s(d64),null);
                    if(ic==null){
                        final String url=iconURL();
                        if(sze(url)>0){
                            _icon="";
                            imgRequest(url,this);
                        }
                    }
                }
                return ic==""?null:ic;
            }
            CASE_ARG(RUN_SEQUENCE_POS_AS_TEXT,int,ia){
                final BA sb=baTmp2();
                final int aFL=ia+subsetStart();
                if(ia<0 || ia>=countRes()) return sb.a("error");
                if(!onlyActgn() && 0==(INTS[PROTEINI_MOL_TYPE]&MOL_TYPE_FLAG_N)) sb.aBytesAdj(getResName32At(ia),4);
                sb.aa(" Index ",firstResIdx(this)+ia+1);
                if(getChain()!=null) resnAsText(0,ia,sb.a(" Residue "));
                if(!Float.isNaN(iThFloat(3*aFL,getResidueCalphaCurrent()))) sb.a(" xyz ");
                switch(iThByte(aFL,getResidueSecStrType())){
                case'H':sb.a("  Helix (red)");break;
                case'E':sb.a("  Beta sheet (yellow)");break;
                }
                {
                    final int ft=iThInt(aFL,_resAtomIdx),f=ft>>>8,t=f+(ft&0xFF);
                    if(ft!=-1 && t>f) sb.a("  Atom ").aFromDashTo(f+1,t);
                }
                final byte[]triplets=triplets();
                if(sze(triplets)>3*ia+2){
                    final int nt=3*aFL;
                    if(hasExons()){
                        final int ex0=exonForAminoZ(ia,0),ex2=exonForAminoZ(ia,2);
                        sb.aa(" Exon ",1+ex0);
                        if(ex0!=ex2) sb.aa(',',ex2+1);
                    }
                    sb.a(" Triplet ").aFT(triplets,nt,nt+3).a(' ');
                    for(int t=0,last=INT_NAN;t<3;t++){
                        final int n=aa2ntZ(ia,t);
                        final char plus1=n-last==1?'+':last-n==1?'-':' ';
                        if(plus1==' ') sb.a(n+1+getIntProperty(PROTEINI_NT_IDX_OFFSET)); else sb.aa(plus1,'1');
                        sb.a(' ');
                        last=n;
                    }
                }
                RETURN sb;
            }
            CASE_ARG(RUN_GET_RENDERER_TXT,int,opt){
                final Object[]cached=cached();
                String s=(String)fromCache(cached,P_CACHE_REND,mc((P_MC_INFERRED_PDB<<P_MC_SHIFT)|P_MC_CHARSEQ)+mc((P_MC_EXONS<<P_MC_SHIFT)|P_MC_SEQ_LABELS));
                if(s==null){
                    final BA sb=baTmp2().a(this);
                    if(isTranslated()) sb.a(' ').aBytes(isReverseComplement()?BYTES('R','C'):'F');
                    cached[P_CACHE_REND]=s=sb.and("  (",getPdbID(PDBID_INFERRED),")").toString();
                }
                RETURN s;
            }
            CASE_ARGV(RUN_GET_RENDERER_MC) _rendMC[0]=HASH_CODE32+mc((P_MC_SEQ_LABELS<<P_MC_SHIFT)|P_MC_CURSOR_SEQ);return _rendMC;

            CASE_ARG(RUN_NEW_SEQUENCE_LABEL,Object,opt){
                final ChButton c=labl(null);
                setProt(this,setBG(0xFFffFF,
                                   updateOn(CHANGED_PROTEIN_AT_CURSOR,
                                            updateOn(CHANGED_PROTEIN_LABEL,addLiMain(LSTNR_MOMO|LSTNR_MO,addSrvc(RUN_SERVICE_PAINTHOOK,_main,c))))));
                c.setFont(getFnt(c).deriveFont(Font_BOLD));
                setProt(this,c);
                RETURN(awtc(AWTC_SET_OPAQUE_OFF,
                            setMaxSze(999,999,
                                      pcp(RUN_PROVIDE_PREF_SIZE,_main,
                                          pcp(KEY_PROVIDE_DND_FILES,_main,
                                              pcp(_KOPT_IS_SEQLABEL,"",
                                                  pcp(KEY_OPTIONS,io(xatoi(opt)|SEQLABEL_ICON_FULLHEIGHT),
                                                      rtt(setTip(_main,c)))))))));

            }
            CASE_ARG(RUN_GET_RENDERER_COMP,int,opt){
                final int i01=0!=(opt&SEQLABEL_VERTICAL)?1:0;
                Object c=_pLabel[i01];
                if(c==null)_pLabel[i01]=c=runCR1(RUN_NEW_SEQUENCE_LABEL,this,arg);
                setProt(this,setBG(0xFFffFF,c));
                RETURN c;
            }
            CASE_ARG(RUN_GET_IMAGE,Object,supported){
                if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                final Object ic=runCR(RUN_GET_ICON,this);
                RETURN img(ic!=null?ic: hasCalpha(this) && CTRUE!=INTS[PROTEINI_NOT_USE_STRUCTURE_FOR_ALIGNMENT]?IC_3D: isTranslated()?IC_DNA:null);
            }
            CASE_ARGV(PROVIDE_HIGHLIGHTS) return getName();
            CASE_ARGV(RUN_PROVIDE_DND_FILES){
                final int dOpts=dragOptions();
                fileOfProteinForDir(FP_GAPS,null,iFile(DIR_STRAP_DND));
                fileOfProteinForDir(FP_ANNO,null,iFile(DIR_STRAP_DND));
#define bioMolecule ((dOpts>>>8)&255)
                final boolean
                    writeSingleFA=(_flags&PFLAG_IS_IN_MSF)!=0 && (dOpts&P_DRAG_MSA)==0 || getFile()==null,
                    writeAllPdbChains=hasCalpha(this) && (dOpts&P_DRAG_ALL_CHAINS)!=0 && sze(iThEl(CHAINTYPE_PEP,chainsByType()))>1;

                getAtomXYZ();

                if(_mapDragfileModi==null) _mapDragfileModi=new HashMap();
                final String mcOpts=s(new BA(99).aa(mc((P_MC_RES_TYPE<<P_MC_SHIFT)|P_MC_ATOM_COORD),'_',dOpts)),base,ext;
                {
                    final String name=getName(),sfx=lstCmpnt('.',name),bas=delLstCmpnt('.',name);
                    boolean success=false;
                    if(sze(sfx)>0){
                        success=2*sze(sfx)<sze(bas);
                        for(String s:custSettings(CUSTOM_proteinFileExtensions)) success=success || chrAt(strstr(STR_AFTER,sfx,s),s)==' ';
                    }
                    base=success?bas:name;
                    ext=success?sfx:"";
                }
                final Collection<File>v=new ArrayList();
                int countB=0;
                final Matrix3D[]mmDrag=new Matrix3D[getAssemblyMatrices(this).length];
                for(Matrix3D m:getAssemblyMatrices(this)) if(m!=null && m._assemblyID==bioMolecule) mmDrag[countB++]=m;
                cpy(fileOfProtein(FP_ICON,this),fileOfProteinForDir(FP_ICON,this,iFile(DIR_STRAP_DND)));
                cpy(fileOfProtein(FP_ICON64,this),fileOfProteinForDir(FP_ICON64,this,iFile(DIR_STRAP_DND)));
                if(countB==0 && !writeAllPdbChains) save(iFile(DIR_STRAP_DND),new BA(333),null);
                if(countB>0){
                    getAtomXYZ();
                    final Collection vTxt=new ArrayList();
                    ROFm0(mmDrag.length){
                        if(mmDrag[m]!=null){
                            final File fB=file(iPath2(DIR_STRAP_DND,base).aa(".biomol_",bioMolecule,'_').an('0',m<10?1:0).aa(m,".pdb"));
                            if(sze(fB)==0 || !mcOpts.equals(_mapDragfileModi.get(fB))){
                                wrte(fB,strapInstance(SEQWRITER_PDB).getProteinText(SEQW_COMPLETE_PDB,this,new Matrix3D[]{mmDrag[m]},null,clr(vTxt)));
                            }
                            v.add(fB);
                        }
                    }
                    final File fB=file(iPath2(DIR_STRAP_DND,base).aa(".biomol_",bioMolecule,"_ALL.pdb"));
                    if(sze(fB)==0 || !mcOpts.equals(_mapDragfileModi.get(fB))){
                        try{
                            final OutputStream fo=fOutStrm(0,fB);
                            wrteOS(fo,strapInstance(SEQWRITER_PDB).getProteinText(SEQW_SEQRES|SEQW_HELIX_SHEET,this,null,null,clr(vTxt)));
                            FORi(0,mmDrag.length){
                                if(mmDrag[i]!=null) wrteOS(fo,strapInstance(SEQWRITER_PDB).getProteinText(SEQW_COMPLETE_PDB,this,new Matrix3D[]{mmDrag[i]},null,clr(vTxt)));
                            }
                            closeStrm(fo);
                            v.add(fB);
                        }catch(IOException iox){errorEx(iox,"RUN_PROVIDE_DND_FILES",fB);}
                    }
                }else{
                    File fExpr=null;
                    BA sbHeteros=null;
                    File fOut=newFile(iFile(DIR_STRAP_DND),
                                      INTS[PROTEINI_CHAINTYPE]==CHAINTYPE_HET?new BA(99).aa(DND_FILE_PFX_HET,nam(this),'_',resnAt(0,0),'_',getChain()).del("_\0").a('_').aHex(hashCdFloats(getAtomXYZ(),0,MAX_INT)).a(".pdb"):
                                      (dOpts&P_DRAG_MSA)!=0 && getFile()!=null?nam(getFile()): new BA(99).aa(base,writeAllPdbChains?"_all":"",writeSingleFA?".fa":ext));
                    if(!mcOpts.equals(_mapDragfileModi.get(fOut))) fileDel(0,fOut);
                    if(writeAllPdbChains){
                        final Matrix3D m3d=getRotationAndTranslation();
                        if((dOpts&P_DRAG_ORIG)!=0 || isUnitOrNull(m3d))  v.add(getFile());
                        else{
                            if(sze(fOut)==0){
                                final int save=seqParserOptions(0);
                                final Protein[]pp=proteinsAllChains(0);
                                ROFi0(pp.length)pp[i].setRotationAndTranslation(m3d);
                                fOut=pdbFileWrite(SEQW_NT_STRUCTURE|SEQW_COMPLETE_CALPHA,pp);
                                seqParserOptions(save);
                            }
                            v.add(fOut);
                        }
                    }else if(writeSingleFA){
                        if(sze(fOut)==0){
                            final BA sb=baTmp2().aa('>',this,'|');
                            final String[]ss=getRefs(0);
                            FORi(0,ss.length) sb.aa(i==0?" refs=":null,ss[i],',');
                            if(firstResIdx(this)>0) sb.aa(" FIRSTINDEX=",firstResIdx(this)+1);
                            wrte(fOut,sb.aln().aln(getResType()));
                        }
                        v.add(fExpr=fOut);
                    }else{
                        if(INTS[PROTEINI_CHAINTYPE]==CHAINTYPE_HET||
                           (dOpts&P_DRAG_ORIG)==0 && getResidueCalphaXYZ(null)!=null && !isUnitOrNull(getRotationAndTranslation())){
                            // if(sze(fOut)==0) wrte(fOut,ProteinWriter1.mergePdbWithOriginal(this));
                            if(sze(fOut)==0) wrte(fOut,strapInstance(SEQWRITER_PDB).getProteinText(SEQW_NT_STRUCTURE|SEQW_COMPLETE_PDB,this,new Matrix3D[]{getRotationAndTranslation()},null,null));
                            v.add(fOut);
                            if(INTS[PROTEINI_CHAINTYPE]==CHAINTYPE_PEP) fExpr=fOut;
                        }else{
                            v.add(fExpr=getFile());
                            for(Protein h:getMolecules(CHAINTYPE_NUC_OR_HET)){
                                if(h.getFile()!=null){
                                    if(sbHeteros==null) sbHeteros=new BA(333).aln(getName());
                                    sbHeteros.aa(h.getFile(),' ');
                                }
                            }
                        }
                    }
                    if(fExpr!=null) wrte(file(iPathExt(DIR_STRAP_DND,fExpr.getName(),FSUFFIX_seqName)),sbHeteros!=null?sbHeteros:getName());/*X  !!!!!*/
                }
                while(v.remove(null)){}
                final File[]ff=toArryClr(v,NO_File);
                for(File f:ff) _mapDragfileModi.put(f,mcOpts);
                return ff;
            }
#if WRITE_CONCATENATED_JAVA||defined _RUN_P_SORT_RA
            CASE_ARGV(_RUN_P_SORT_RA) residueAnnotationsByGroup(); break;/*X ID_ERROR*/
            CASE_ARGV(_RUN_P_H_CHANGED) updateChildTreeP(vChilds(-CHAINTYPE_HET),vChilds(-CHAINTYPE_NUC),this);break;
#endif //WRITE_CONCATENATED_JAVA||defined _RUN_P_SORT_RA
            CASE_ARGV(_RUN_SEQUENCE_V3D_CHANGED) updateChildTreeP(vChilds(-SOBJECT_V3D),null,this);break;
            CASE_ARGV(PROVIDE_JTREE_CHILDS){
                final Object[]cached=cached();
                final ChMap grouped=(ChMap)residueAnnotationsByGroup();
                Object[]cc=(Object[])fromCache(cached,P_CACHE_CHILDS,(_vv==null?0: modic(_vv[SOBJECT_RESSEL_AND_RESAN])+modic(_vv[SOBJECT_V3D])+modic(_vv[CHAINTYPE_NUC_OR_HET]))+MC[MC_RESIDUE_ANNOTATION_GROUPS]+MC[P_MC_RES_SELECTIONS_NOT_EMPTY]);
                if(cc==null){
                    Object[]buf=(Object[])cached[P_CACHE_childsBuf];
                    if(buf==null) cached[P_CACHE_childsBuf]=buf=new Object[7];
                    buf[0]=vChilds(MC[P_MC_RES_SELECTIONS_NOT_EMPTY]==0?SOBJECT_RESSEL: SOBJECT_RESSEL_NOT_EMPTY);
                    buf[1]=vChilds(-SOBJECT_V3D);
                    buf[2]=grouped.vArray().length>0?grouped:null;
                    buf[3]=vChilds(-SOBJECT_SEQFEAT);
                    buf[4]=vChilds(-SOBJECT_SEQFEAT_DEACT);
                    buf[5]=vChilds(-CHAINTYPE_HET);
                    buf[6]=vChilds(-CHAINTYPE_NUC);
                    ROFi0(buf.length) if(sze(buf[i])==0) buf[i]=null;
                    cached[P_CACHE_CHILDS]=cc=rmNullA(buf);
                }
                return cc;
            }
            CASE_ARG(RUN_SET_ICON_IMAGE,Object,im){
                Object ic=runCR(RUN_GET_ICON,this);
                if(ic==null||img(ic)!=im){
                    if(ic==null) _icon=ic=img2ic(im);
                    strapIncMC(P_MC_SEQ_LABELS,this);
                    strapEvtDispatch(EVT_SEQUENCE_RENAMED|SEVTMS*333);
                }
                BREAK;
            }
            CASE_ARGV(PROVIDE_STRINGMATCH_HAYSTACK) return _strgMatchType==2?residueAnnotations():null;
            CASE_ARGV(PROVIDE_STRINGMATCH_STRINGS) returnWords=_strgMatchType;break;
            CASE_ARGV(PROVIDE_WORD_COMPLETION_LIST) returnWords=MAX_INT;break;
            CASE_ARG(RUN_GET_TIP_TEXT,Object,ev){
                if(ev==null && evtId(ev=lstMouseEvt())!=MOUSE_MOVED) ev=null;
                if(x(ev)>Math.max(PROTEIN_BALLOON_MAXX,INTS[PROTEINI_ICON_WIDTH])) return balloonText(0);
                final BA sb=baTmp2();
                if(getColrO(this)!=null) sb.colorBar(rgba(getColrO(this),RGBA_FOR_NULL));
                sb.aFile(PRINT_FILE_TILDE_FOR_HOME,getFile()).htmlBR();
                {
                    Object icon=base64ToFile(iconBase64());
                    if(sze(icon)==0){
                        final String u=iconURL();
                        if(sze(icon=file(u))==0) icon=u;
                    }
                    if(icon!=null){
                        sb.aa("<IMG src=\"",url(icon),"\"><BR>");
                        if(0!=(SHIFT_MASK&evtModi(ev))) return sb;
                    }
                }
                runCR1(_RUN_SEQUENCE_TT_HEADER,this,sb);
                if((_flags&PFLAG_IS_IN_MSF)!=0) sb.aFile(getFile()).aln();
                {
                    final String acc=seqId(GETSEQID_ACCESSION);
                    sb.and(" Acc=",acc);
                    if(getRefs(0).length>0){
                        int count=0;
                        for(String r:getRefs(0)){
                            if(!eq(r,acc)){
                            if(count++==0) sb.a(" IDs: ");
                            sb.aa(count%6==0?'\n': ' ',r);
                            }
                        }
                    }
                }
                sb.htmlBR().a(balloonText(SEQ_BALLOON_HTML)).htmlBR();
                if(isTranslated()) sb.htmlBR().a(isReverseComplement()?"Reverse-Complement":"Forward");
                {
                    final String[]unip=getRefs(REFS_BY_IDENT);
                    if(!ARRAY_EMPTY(unip)){
                        sb.htmlBR().a("By sequ identity:");
                        for(String s:unip) sb.a(' ').aWithoutPfx("UNIPROT:",s);
                        sb.htmlBR();
                    }
                }
                if(!Float.isNaN(_resolution)) sb.htmlBR().aa("Resolution ",_resolution," Angstrom<BR>");
                {
                    final int i0=firstResIdx(this);
                    if(i0>0) sb.htmlBR().a(i0+1).an('.',3).a(i0+subsetEnd()-subsetStart()).htmlBR();
                }
                Protein[]hh;
                if((hh=getMolecules(CHAINTYPE_NUC)).length>0){
                    sobjectsTitle(hh,sb.colorBar(0x00FF00)).a(" &nbsp; ");
                    for(Protein nuc:hh) nuc.appendNucColonChain(sb.a(' '));
                    sb.htmlBR();
                }
                if((hh=getMolecules(CHAINTYPE_HET)).length>0){
                    sb.colorBar(0xFF0000);
                    int sbL0=sze(sb);
                    sobjectsTitle(hh,sb).a(" &nbsp; ");
                    for(Protein h:hh){
                        sb.aa(' ',h.getNameForPymol());
                        if(sze(sb)-sbL0>60) sbL0=sze(sb.htmlBR());
                    }
                    sb.htmlBR();
                }
                RETURN sb.del("<BR>");
            }
#endif //CPP_WITH_GUI
            CASE_ARGV(RUN_GET_NAME) return getName();
            CASE_ARG(RUN_SEQUENCE_TT_HTML,BA,sb){
                runCR1(_RUN_SEQUENCE_TT_HEADER,this,sb);
                final String tt=balloonText(IF_GUI(SEQ_BALLOON_HTML));
                if(sze(tt)>0) sb.htmlBR().a(tt);
                final String pdb=getPdbID(PDBID_INFERRED);
                if(pdb!=null) sb.htmlBR().aa(pdb," identity: ",CPP_NUMERATOR(_infXYZMatch)," of ",CPP_DENOMINATOR(_infXYZMatch));
                RETURN(sb);
            }
            CASE_ARG(RUN_SET_COLOR,Object,color){
                if(!eq(_color,_color=color)){
                    strapIncMC(P_MC_SEQ_LABELS,this);
                    IF_GUI(for(View3d v:get3dViews()) v3dUpdateRibbons(RGBA_INHERIT,v));;
                }
                RETURN TRUEr;
            }
            CASE_ARGV(RUN_GET_COLOR) return _color;
            CASE_ARG(RUN_SEQUENCE_TT_INFO,BA,txt){
                int count=0;
                final BA sb=txt.aln("<UL>");
                {
                    final String acc=seqId(GETSEQID_ACCESSION),uid=seqId(BLAST4ID_DB_UNIPROT),pid=getPdbID(PDBID_ID);
                    if(acc!=null && !acc.equals(pid)) sb.and("<LI>Accession: ",acc).aln("</LI>");
                    if(pid!=null) sb.a("<LI>").aWithoutLstCmpnt('_',pid).a(" Chain ").aLstCmpnt('_',pid).aln("</LI>");
                    if(uid!=null && !uid.equals(acc)) sb.and("<LI>",uid).aln("</LI>");
                    ROFj0(REFS_ZZZ){
                        if(j!=0&&j!=REFS_BY_IDENT) continue;
                        for(String r:getRefs(j)) if(!r.equals(acc)&&!r.equals(uid)&&!r.equals(pid)) sb.aa(count++>0?null:j==0?"<LI>References: ":"<LI>By sequence identity: ",r,' ');
                        if(count>0) sb.aln("</LI>");
                    }
                }
                ROFj0(3){
                    count=0;
                    final int t=j==0?CHAINTYPE_DNA:j==1?CHAINTYPE_RNA:CHAINTYPE_HET;
                    for(Protein h:getMolecules(t)){
                        if(count++==0) sb.aa("<LI>",iConst(SARRAYeq_STRAP_OBJECT_TITLE,t),' ');
                        sb.aa(t==CHAINTYPE_HET?h.getName():h.getChain(),' ');
                        if(count>0) sb.aln("</LI>");
                    }
                }
                sb.a("</UL>").del("<UL>\n</UL>").aln().and(getProperty(P_TAXONOMY),"<BR>");
                BREAK;
            }
            CASE_ARG(_RUN_SEQUENCE_TT_HEADER,BA,txt){
                final BA sb=txt;
                //IF_MEIN_DEBUG(if(_charSeq!=null && !(_charSeq instanceof byte[])) sb.a(deref(_charSeq)!=null?"REF ":"ref "));
                final Object c=orO(getProperty(P_TITLE),getProperty(P_COMPOUND));
                if(sze(getProperty(P_HEADER))>0){
                    final int L=sb.end();
                    sb.aFilter(FILTER_HTML_ENCODE,getProperty(P_HEADER)).replace(0,"|","<BR>",L,MAX_INT).htmlBR();
                }
                final Object o=getProperty(P_ORGANISM),sc=getProperty(P_ORGANISM_SC);
                sb.aFilter(FILTER_HTML_ENCODE,c).htmlBR().aFilter(FILTER_HTML_ENCODE,sc).htmlBR();
                if(sze(o)>0 && !o.equals(sc)) sb.aFilter(FILTER_HTML_ENCODE,o).htmlBR();
                BREAK;
            }
        }/*X switch*/
#if CPP_WITH_GUI
        if(returnWords>=0){
            if(returnWords==2) return resSel(SOBJECT_RESSEL_AND_RESAN);
            if(returnWords==3) return getResTypeSUC();
            Arrays.fill(HAYSTACKS1,null);
            int i=0;
            if(returnWords==0||returnWords==MAX_INT)  HAYSTACKS1[i++]=getName();
            if(returnWords==1||returnWords==MAX_INT){
                for(;i<SEQ_DATA_OVERVIEW;i++) HAYSTACKS1[i]=seqData(i);
                HAYSTACKS1[i++]=getPdbID(PDBID_ID);
                HAYSTACKS1[i++]=getProperty(P_HEADER);
                HAYSTACKS1[i++]=getRefs(0);
            }
            return HAYSTACKS1;
        }
#endif //CPP_WITH_GUI
        return null;
    }
    public Protein[]proteinsAllChains(int opt){/*X  Including self */
        String[]chains=(String[])iThEl(CHAINTYPE_PEP,chainsByType()),cc=null;
        ROFi0(sze(chains)){
            if(chains[i]!=null && !chains[i].equals(getChain())){
                if(cc==null) cc=new String[i+1];
                cc[i]=chains[i];
            }
        }
        return cc==null?spp(this): adToArry(0,this,readAddToPep(null,readPepOrNuc(opt==0?PROTPARS_DEFAULT:opt,cc,getFile())),Protein.class);
    }

/* <<< Threading  <<< */
/* ---------------------------------------- */
/* >>> Script >>> */
#if CPP_WITH_GUI
#define _OPT(x)  0!=(opt&(1<<x))
    public void toXML(int opt,BA sb,String cacheKey){
        final Collection vSel=strapSelectedObjectsV();
        final boolean selected=cntainsEl(this,vSel);
        final String UM=" unmodified=\"true\" />\n";
        final int mc[],nR=countRes();
        if(cacheKey!=null && (_OPT(P_XML_SERVER_CACHE)||_OPT(P_XML_SERVER_CACHE_RESET))){
            if(_serverMC==null) _serverMC=new HashMap();
            final int[]mc0=_OPT(P_XML_SERVER_CACHE_RESET)?null:(int[])_serverMC.get(cacheKey);
            _serverMC.put(cacheKey,MC.clone());
            mc=mc0!=null && MC[P_MC_SEQ_LABELS]==mc0[P_MC_SEQ_LABELS]?mc0:null;

        }else mc=null;
        sb.aa("\n<protein name=\"",this,"\" file=\"",getFile());
        if(selected) sb.a("\" selected=\"true");
        sb.aln("\" >");
        if(firstResIdx(this)!=0) sb.aa("<residueIndex1>",firstResIdx(this)+1,"</residueIndex1>\n");
        sb.a("<sequence");
        if(mc!=null && mc[P_MC_RES_TYPE]==MC[P_MC_RES_TYPE]) sb.a(UM);
        else sb.a('>').a0(getResType()).aln("</sequence>");
        if(getResColumn().length>=nR){
            sb.a("<alignmentColumns");
            if(mc!=null && mc[P_MC_GAPPED_SEQ]==MC[P_MC_GAPPED_SEQ]) sb.a(UM);
            else{
                final int pos=sb.end();
                final byte[]T=seriesToTextN(STT_WRITE_LAST,getResColumn(),nR,1,1,1,sb.a('>')).aln("\n</alignmentColumns>").bytes();
                if(T[pos]=='1' && T[pos+1]==' ') T[pos]=' ';/*X else MEIN_ASSRT();*/
            }
        }
        if(countNucleotides()>0){
            sb.a("<codingSequence");
            if(mc!=null && mc[P_MC_EXONS]==MC[P_MC_EXONS]) sb.a(UM);
            else sb.a('>').a0(triplets()).aln("</codingSequence>");
        }
        if(getPdbID(PDBID_INFERRED)!=null&&_infXYZMatch!=0) sb.aa("<inferredStructure pdbID=\"",getPdbID(PDBID_INFERRED),"\" match=\"",(int)(_infXYZMatch>>>NUMERATOR_SHIFT),'/',(int)(_infXYZMatch&DENOMINATOR_MASK)).aln("\" />");
        ROFi0(3){
@*SARRAY_XML_pdbId_uniprotId_accessionId
 pdbId|uniprotId|accessionId
*@
            final String id=i==0?getPdbID(PDBID_ID): seqId(i==1?BLAST4ID_DB_UNIPROT:GETSEQID_ACCESSION),t=iConst(SARRAY_XML_pdbId_uniprotId_accessionId,i);
            if(id!=null) sb.aa('<',t,'>',id,"</",t,'>').aln();
        }
        if(getResidueSecStrType()!=null){
            sb.a("<secondaryStructure");
            if(mc!=null && mc[P_MC_RES_SECSTRU]==MC[P_MC_RES_SECSTRU]) sb.a(UM);
            else{
                toSeries(SERIES_SECSTRU,0,MAX_INT,sb.a('>').aln());
                sb.aln("\n</secondaryStructure>");
            }
        }
        {
            int e0=sb.end();
            if(resnToSeries(0,sb.aln("<residueNumber>"))) sb.a("\n</residueNumber>"); else sb.setEnd(e0);
            e0=sb.end();
            if(toSeries(SERIES_INS,0,MAX_INT,sb.aln("<residueInsertionCode>"))) sb.aln("\n</residueInsertionCode>"); else sb.setEnd(e0);
        }
        sb.and("<chainChar>",getChain(),"\n</chainChar>\n");
        {
            final ResidueSelection[]ss=resSel(SOBJECT_RESSEL_AND_RESAN);
            if(ss.length>0){
                sb.a("<residueSelections");
                if(mc!=null && mc[P_MC_RES_SELECTIONS]==MC[P_MC_RES_SELECTIONS]) sb.a(UM);
                else{
                    sb.a('>');
                    for(ResidueSelection s:ss){
                        sb.a1('\n').aa("<residueSelection name=\"",nam(s),"\" aa=\"").boolToText(s.getSelectedAminoacids(),s.getSelectedAminoacidsOffset()+1," ","-");
                        if(cntainsEl(s,vSel)) sb.a("\" selected=\"true");
                        sb.a("\" ");
                        if(sobjectType(s)==SOBJECT_RESAN){
                            sb.aln(">\n<data>");
                            for(ResidueAnnotation.Entry e:((ResidueAnnotation)s).entries()) if(e.isEnabled()) sb.a(e.key()).a1(' ').aFilter(FILTER_HTML_ENCODE,e.value()).aln();
                            sb.aln("</data>\n</residueSelection>");
                        }else sb.aln(" />");
                    }
                    sb.aln("</residueSelections>");
                }
            }
        }
        if(!isUnitOrNull(getRotationAndTranslation())){
            sb.a("<transformation3D");
            if(mc!=null && mc[P_MC_MATRIX3D]==MC[P_MC_MATRIX3D]) sb.a(UM);
            else getRotationAndTranslation().toText(MTRX_FORMAT_ROUNDED,null,sb.a('>')).aln("</transformation3D>");
        }
        if(hasCalpha(this)){
            //#define _DEBUG_OPT(x) #x,"=",_OPT(x)," "
            //baOut(DEBUG_NOW).aa("P_XML_CALPHA_XYZ=",_OPT(P_XML_CALPHA_XYZ)," _OPT(P_XML_CALPHA_XYZ_IF_SELECTED=",)).aln(this);
            final boolean atoms=_OPT(P_XML_ATOM_XYZ) || selected&& _OPT(P_XML_ATOM_XYZ_IF_SELECTED);

/* #define _DEBUG_OPT(x) _OPT(x)?ANSI_FG_GREEN:ANSI_FG_GRAY,#x,ANSI_RESET," " */
/* baOut(DEBUG_NOW).aa( */
/*                     _DEBUG_OPT(P_XML_SELECTED), */
/*                     _DEBUG_OPT(P_XML_CALPHA_XYZ), */
/*                     _DEBUG_OPT(P_XML_CALPHA_XYZ_IF_SELECTED), */
/*                     _DEBUG_OPT(P_XML_ATOM_XYZ), */
/*                     _DEBUG_OPT(P_XML_ATOM_XYZ_IF_SELECTED), */
/*                     _DEBUG_OPT(P_XML_FILE_CONTENT), */
/*                     _DEBUG_OPT(P_XML_FILE_CONTENT_IF_SELECTED), */
/*                     atoms?ANSI_FG_GREEN:ANSI_FG_GRAY," atoms ", */
/*                     ).aln(ANSI_RESET); */

            if(_OPT(P_XML_CALPHA_XYZ) || selected&& _OPT(P_XML_CALPHA_XYZ_IF_SELECTED) || atoms){
                sb.a("<pdbFormat");
                 if(mc!=null && mc[atoms?P_MC_ATOM_COORD:P_MC_CALPHA]==MC[atoms?P_MC_ATOM_COORD:P_MC_CALPHA]) sb.a(UM);
                else sb.aBYTES('>','\n').join0(strapInstance(SEQWRITER_PDB).getProteinText(atoms?SEQW_COMPLETE_PDB:(SEQW_SEQRES|SEQW_HELIX_SHEET|SEQW_CALPHA_ATOMS),this,null,null,null)).aln("</pdbFormat>");
            }
        }
        if(sze(getFile())>0 && (_flags&PFLAG_IS_IN_MSF)==0 && (_OPT(P_XML_FILE_CONTENT) || _OPT(P_XML_SELECTED) && _OPT(P_XML_FILE_CONTENT_IF_SELECTED))){
            sb.a("<fileContent>");
            if(mc!=null && mc[P_MC_FILE_CONTENT]==MC[P_MC_FILE_CONTENT]) sb.a(UM);
            else sb.a('>').aln().aFilter(FILTER_HTML_ENCODE,readBytes(getFile())).aln("</fileContent>");
        }
        sb.aln("</protein>\n");
    }
#endif //CPP_WITH_GUI
/* (NUM1 1) */
#define VAR_ORGANISM1  1
#define VAR_GENE 2
#define VAR_GENEPRODUCT 3
#define VAR_ORGANISM5 4
#define VAR_OSCIENTIFIC 5
#define VAR_ORGANISM 6
#define VAR_CHAIN 7
#define VAR_SWISSPROT 8
#define VAR_ACCESSION 9
#define VAR_PDB4 10
#define VAR_UNIPROT 11
#define VAR_NAME 12
/* --- */
@*SARRAYeq_STRAP_PROTEIN_VARS
     $ORGANISM1=VAR_ORGANISM1
     $GENE=VAR_GENE
     $GENEPRODUCT=VAR_GENEPRODUCT
     $ORGANISM5=VAR_ORGANISM5
     $OSCIENTIFIC=VAR_OSCIENTIFIC
     $ORGANISM=VAR_ORGANISM
     $CHAIN=VAR_CHAIN
     $SWISSPROT=VAR_SWISSPROT
     $ACCESSION=VAR_ACCESSION
     $PDB4=VAR_PDB4
     $UNIPROT=VAR_UNIPROT
     $NAME=VAR_NAME
*@

    private static boolean[]_cClasName;
    public Object rplcVars(boolean spc2us,String txt){
        Object s=txt;
        final String[]vv=arry(SARRAYeq_STRAP_PROTEIN_VARS);
        if(strchr('$',s)>=0){
            if(strstr(0,vv[VAR_ORGANISM1],s)>=0){
                final Object osc=getProperty(P_ORGANISM_SC);
                int spc=strchr(' ',osc);
                if(0<spc || 0<(spc=strchr('_',osc))) s=strplc(0,vv[VAR_ORGANISM1],new BA(99).aFT(osc,0,1).a('_').aFT(osc,spc+1,MAX_INT),s);
            }
            if(strstr(0,vv[VAR_GENE],s)>=0){
                final String[]cds=getCDS(appliedCDS());
                if(cds!=null){
                    s=strplc(0,vv[VAR_GENE],orS(cds[PROTEIN_CDS_GENE],"_"),
                             strplc(0,vv[VAR_GENEPRODUCT],orS(cds[PROTEIN_CDS_PRODUCT],cds[PROTEIN_CDS_PROTEIN],"_"),
                                    s));
                }
            }
            s=strplc(0,vv[VAR_NAME],getName(),
                     strplc(0,vv[VAR_UNIPROT],orS(delToLstChr1(':',seqId(BLAST4ID_DB_UNIPROT)),"_"),
                            strplc(0,vv[VAR_PDB4],orS(delToLstChr1(':',getPdbID(PDBID_ID)),"_"),
                                   strplc(0,vv[VAR_ACCESSION],orS(delToLstChr1(':',seqId(GETSEQID_ACCESSION)),"_"),
                                          strplc(0,vv[VAR_SWISSPROT],orS(seqId(BLAST4ID_DB_SWISS),"_"),
                                                 strplc(0,vv[VAR_CHAIN],orS(getChain(),"_"),
                                                        strplc(0,vv[VAR_ORGANISM],orS(getProperty(P_ORGANISM),"_"),
                                                               strplc(0,vv[VAR_OSCIENTIFIC],orS(getProperty(P_ORGANISM_SC),getProperty(P_ORGANISM),"_"),
                                                                      strplc(0,vv[VAR_ORGANISM5],orS(getOrganism5(),"_"),s)))))))));
        }
        if(spc2us && s!=null){
            if(_cClasName==null) (_cClasName=chrClas(-FILENM).clone())['!']=false;
            s=toBA(s).replaceCC(_cClasName,(byte)'_',0,MAX_INT);
        }
        return s;
    }
/* <<< Script  <<< */
/* ---------------------------------------- */
/* >>> Molecule type >>> */
    public boolean hasExons(){
        final int mt=INTS[PROTEINI_MOL_TYPE];
        return exons()!=null && strapAlignmentType()!='C' && (mt==0 || 0!=(mt&MOL_TYPE_FLAG_N) && 0==(mt&MOL_TYPE_FLAG_RNA));
    }
    public void setMoleculeType(byte[]T,int b,int e){
        ROFi0(MOL_TYPE_ZZZ) if(strstr(STR_w,iConst(SARRAYeq_SEQ_MOL_TYPES,i),T,b,e)>0) setIntProperty(PROTEINI_MOL_TYPE,i);
    }
    //public void setMoleculeType(int type) {INTS[PROTEINI_MOL_TYPE]=type;}

/* <<< Molecule type  <<< */
/* ---------------------------------------- */
/* >>> Features >>> */
    public boolean complies(int what){
        boolean e=true;
        if((what&IF_ACTGN)!=0 && !onlyActgn())e=false;
        else if((what&IF_CALPHA)!=0 && !hasCalpha(this))e=false;
        else if((what&IF_XYZ_MOVED)!=0 && isUnitOrNull(getRotationAndTranslation()))e=false;
        else if((what&IF_EC)!=0 && sze(OBJECTS[PROTEINO_EC])==0)e=false;
        else if((what&IF_INFERRED_3D)!=0 && getPdbID(PDBID_INFERRED)==null)e=false;
        else if((what&IF_IN_3D)!=0 && get3dViews().length==0)e=false;
        else if((what&IF_IN_ALI)!=0 && (_flags&PFLAG_IN_ALI)==0)e=false;
        else if((what&IF_NOT_ACTGN)!=0 && onlyActgn())e=false;
        else if((what&IF_NOT_IN_ALI)!=0 && (_flags&PFLAG_IN_ALI)!=0)e=false;
        else if((what&IF_NO_3D_FILE)!=0 && isLoadedFromStructureFile())e=false;
        else if((what&IF_NO_CALPHA)!=0 && hasCalpha(this))e=false;
        else if((what&IF_NO_PDB_ID)!=0 && getPdbID(PDBID_ID)!=null)e=false;
        else if((what&IF_NT)!=0 && !isTranslated())e=false;
        else if((what&IF_NT_or_ACTGN)!=0 && !isTranslated() && !onlyActgn())e=false;
        else if((what&IF_PDB_ID)!=0 && getPdbID(PDBID_ID)==null)e=false;
        else if((what&IF_SECSTRU)!=0 && getResidueSecStrType()==null)e=false;
        else if((what&IF_SOLVENT)!=0 && getResidueAccessibility1(0)==null)e=false;
        else if((what&IF_MISMATCH3D)!=0 && (_infXYZMatch==0||  (_infXYZMatch>>>NUMERATOR_SHIFT)==(_infXYZMatch&DENOMINATOR_MASK)))e=false;
        else if((what&IF_HAS_CDS_DATA)!=0 && countCDS()==0)e=false;

        else{
#if CPP_WITH_GUI
            if(_vv!=null){
                if((what&IF_RES_SEL)!=0 && sze(_vv[SOBJECT_RESSEL_AND_RESAN])==0)e=false;
                else if((what&IF_RES_ANNO)!=0 && sze(_vv[SOBJECT_RESAN])==0)e=false;
                else if((what&IF_SEQ_FEATURE)!=0 && sze(_vv[SOBJECT_SEQFEAT])==0)e=false;
            }
#endif //CPP_WITH_GUI
        }
        if(e && (what&IF_HETERO3D)!=0 && getMolecules(CHAINTYPE_HET).length==0)e=false;
        if(e && (what&IF_NUC3D)!=0 && getMolecules(CHAINTYPE_NUC).length==0)e=false;
        return e;
    }

#include "Protein_ReferenceSequenceInc.java"

#if CPP_WITH_MEIN_DEBUG
    private boolean _parseXYZ_idxOutOfBounds_resCount(int nR,byte[]A,int L){
        if(nR<=_siAminoIdx) baOut(RED_ERROR).aa(this,' ').aPlrl(_siAminoIdx,"_siAminoIdx=%n nR=").a(nR).aln().aFT(A,0,L).aln();
        return nR<=_siAminoIdx;
    }
#else
#define _parseXYZ_idxOutOfBounds_resCount(nR,A,L) nR<=_siAminoIdx
#endif //CPP_WITH_MEIN_DEBUG
    void parseXYZ(byte[]A,int L){
        final int num=_siPrepareXYZ(A,L),nR=countRes();
        if(num>0){
            FORi(3,_b90Tokens){ /*X There are always three blocks corresponding to x y and z-values.  In addition there may be further tokens of the form: letter-or-hash equal-sign value. */
                final int f=TOKEN_FT[2*i],t=TOKEN_FT[1+2*i];
                if(t-f>2 && A[f+1]=='='){
                    final int c0=A[f];
                    if((c0=='a'||c0=='e'||c0=='i')&&_parseXYZ_idxOutOfBounds_resCount(nR,A,L)) return;
                    if(c0=='a'){
                        if(_atom32==null)_atom32=new int[nR][];
                        siParseArray32(A,f+2,t,_atom32[_siAminoIdx]=new int[num],null);/*X N,CA,C,O,CB,CG*/
                    }else if(c0=='e'){
                        if(_elements==null)_elements=new short[nR][];
                        siParseArray32(A,f+2,t,null,_elements[_siAminoIdx]=new short[num]);/*X N,C,C,O,C,C*/
                    }else if(c0=='i'){
                        if(_resAtomNumOffsets==null) _resAtomNumOffsets=new int[nR][];
                        parseSeriesN(1,toknzr(339,SPACE_COMMA).setText(A,f+2,t),_resAtomNumOffsets[_siAminoIdx]=new int[num]);/*X 0,1,2,3*/
                    }else if(c0=='#'){
                        Arrays.fill(_atomXYZ=new float[3*hexToInt(A,f+2,t)],Float.NaN);
                        _resAtomIdx=new int[nR];
                        _elements=new short[nR][];
                        _resAtomNum=new int[nR];
                        _flags|=PFLAG_HAS_XYZ;
                        strapIncMC(P_MC_ATOM_COORD_ORIG,this);
                        clearCache();
                        _siAminoIdx=_siAtomIdx=0;
                        _siAtomSerial=1;
                    }else if(c0=='n'){
                        _siAtomSerial=hexToInt(A,f+2,t);
                    }else if(c0=='I'){
                        _siAminoIdx=hexToInt(A,f+2,t);
                    }else if(c0=='H'){/*X FMN,Flavin_mono_nucleotide*/
                        if(getIntProperty(PROTEINI_CHAINTYPE)!=CHAINTYPE_HET){
                            final String n=s(A,f+2,t);
                            for(Protein h:getMolecules(CHAINTYPE_HET)) if(n.equals(h.getName())) h.parseXYZ(A,L);
                            return;
                        }
                    }
                }
            }
            if(_parseXYZ_idxOutOfBounds_resCount(nR,A,L)) return;
            if(_siAtomIdx*3<sze(_atomXYZ)) System.arraycopy(_siXyz,0,_atomXYZ,_siAtomIdx*3,num*3);
            _resAtomIdx[_siAminoIdx]=_siAtomIdx;_siAtomIdx+=num;
            _resAtomNum[_siAminoIdx++]=_siAtomSerial;_siAtomSerial+=num;

        }
    }
    private static void siParseArray32(byte[]T,int f,int t,int[]destII,short[]destSS){
        if(t<=f) return;
        final boolean komma=T[f]==',';
        for(int count=0,i=f+1,pos=f;i<=t;i++){
            if(i==t || (komma?T[i]==',': (IS_UPPER(T[i])))){
                final int v=komma?charsToBitsSkipSpc(T,pos+1,i-pos-1): charsToBitsSkipSpcUC(T,pos,i-pos);
                if(destII!=null && destII.length>count) destII[count++]=v;
                if(destSS!=null && destSS.length>count) destSS[count++]=(short)v;
                pos=i;
            }
        }
    }
    private static int _b90Tokens;
    private static int _siPrepareXYZ(byte[]A,int L){
        if((_b90Tokens=tokns(' ',A,0,L,TOKEN_FT))<3){
            baLog(LOG_SCRIPT_INTERPRETER).a("Expected 3 base"+B90_DIGITS+" blocks separated by space ").aFT(A,0,L).aln();
            return 0;
        }
        final int f=TOKEN_FT[0],t=TOKEN_FT[5];
        return xyz90FromText(_siXyz=redim(_siXyz,2*(t-f),99),1F/XYZ90_PRECISION,A,f,t);
    }
#include "Protein_writeStrapFormat_Inc.java"

}
