package charite.christo.strap;
import charite.christo.*;
import java.util.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
// ResidueAnnotation_EntryInclude ResidueAnnotation_GuiInc ResidueAnnotation_GuiCasesInc
@*H
 Annotated residue selections, allow the assignment of information to
 specific amino acids or nucleotides of proteins.  A residue annotation
 has a list of entries each having a type and a modifiable text.  The user
 can change these entries and add new entries. Annotated residue selections can be
 created from any residue selection in different ways:

 <UL>

 <LI>Selecting residues with the mouse. Right-click opens the context menu. Click the menu item
 <i>HTMLDOC_BUTTON:M_SEL_EDIT</i>.</LI>

 <LI>Dragging any residue selection to the same or another sequence.</LI>

 </UL>

 Residue selections can be selected in the alignment pane in two different ways: By Ctrl-click or by dragging a rectangular box.
 Selected residue selections have WIKI:Marching_ants.

 <H2>Background Image</H2>

 Image files and images in the browser can be dragged onto an annotated residue selection. See Drop_Web_Link*

 <H2>Edit</H2>

 To edit <i>HTMLDOC_CLASS_REF:BUT_C1(ResidueAnnotation)</i> residue annotations, they can be double-clicked in the alignment pane or the menu
 item <i>HTMLDOC_BUTTON:M_SEL_EDIT</i> of the
 context menu can be used.

 The annotation data is shown as a table. The rows contain the name, the group name, the residue positions and additional annotation.
 <DIV class="figure">
 <TABLE style="caption-side: bottom">
 <CAPTION><B>Figure:</B>
 The left column gives the type  and the right column the annotation text.
 Each row has a toggle button to activate and inactivate the entry.</CAPTION>
 <TR><TD><i>HTMLDOC_JCOMPONENT:HTMLDOC_JC_ResidueAnnotation</i></TD></TR>
 </TABLE>
 </DIV>
 <UL>
 <LI>
 The most important entry is <B>Positions</B> which defines the the selected sequence positions.
 Here are some examples of valid entries
 <OL>
 <LI>
 The expression "1,3,4,6,101-103,110-112"
 selects the residue indices  1,3,4,6,101,102,103,110,111,112.
 Instead of the commas, spaces can by used.
 </LI>
 <LI>
 The expression
 "+2 1 3 4"
 selects the residues 3,5, and 6 because the preceding +2 adds an offset of 2 to all positions. The "+"-sign is the first character in this expression.
 For the user interface  the first residue has the index "1" whereas internally Strap starts counting at zero.
 A negative offset of "2" is achieved by a leading  "+-2".
 </LI>
 <LI>
 The expression
 "1:G-3:G 5:G"
 selects the residues with the pdb-numbers 1,2, 3 and 5 of the chain G.
 If the protein has only one chain the chain identifier can be omitted like
 "1:-3: 5:"

 </LI>
 <LI>
 Referring to nucleotide positions:
 When the toggle button is pressed (default state) the indices refer to <B>amino acid</B> positions.
 Otherwise the positions indicate <B>nucleotides</B> in case the protein is translated from a nucleotide sequence.
 </LI>

 <LI>
 To any group an atom specification can be appended.
 This allows to select certain atoms before changing their style in the 3D-viewers.
 Even though protein 3D viewers usually have a specific language for atom selection,
 the atom expression used here is defined by Strap and works for all 3D-viewers.
 <BR>
 for example "10:-20:.CA.CB" narrows the selection to the atoms CA and CB for the residues 10 to 20.
 A later command  such as "3D_spheres" would affect only c-alpha and c-beta atoms.
 There may be more than one "Atoms"-entries. Each "Atoms" specification take effect only on the following 3D-style
 commands but not on the previous.

 Asterisk can be used as a wild card like "*.CA" or "10:-20:.C".
 For the proper atom identifiers have a look at the PDB file.

 </LI>

 <LI>
 The expression "10-20 REFERENCE=UNIPROT:P25787"
 selects the positions that correspond to residues 10-20 in the homologous sequence UNIPROT:P25787.
 The value of REFERENCE can be a database entry or the name of a loaded sequence.
 </LI>
 </OL>
 </LI>
 <LI><B><I>Atoms</I></B>
 Certain Atoms can be specified by an expression like ".CB.CA" which means only C&alpha; and C&beta; atoms.
 The next 3D-command will act on these rather than on all atoms of the amino acid.
 When sending the commands to a 3D-program, the rows are processed sequentially.
 If there comes yet another <I>Atoms</I>-row,
 the previous atom-specification is replaced by the new one.
 </LI>
 <LI><B><I>Name</I></B> Each selection has a name. Un-checking the check box deactivates the residue annotation.</LI>
 <LI><B><I>Group</I></B> Several selections may be bundled in one group e.g. "active site"</LI>
 <LI><i>HTMLDOC_ICON:IC_PDF</i>: TeXshade commands. See menu Export in the file menu.</LI>
 <LI><B>Note, Remark:</B> Free text. URLs are clickable. Supports cross-links like PDB:1ryp, <SPAN>PUB</SPAN>MED:0815. The list of databases can be changed by Ctrl-click the cross-link.</LI>
 <LI><B>Balloon:</B> The balloon text appears when the mouse is over the highlighted residues.</LI>
 </UL>

 <BR><B>Drag and drop: </B> Rows can be reordered with the mouse or can be dropped on other residue selections.

 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogResidueAnnotationChanges)</i>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogResidueAnnotationList)</i>
*@
#define CHANGED_COLOR (1<<1)
#define CHANGED_STOP_EDITING (1<<2)
/* (NUM1 6) */
#define REND_LABEL 6
#define REND_LABEL_NE 7
#define REND_BUTTON 8
#define REND_BUTTON_E 9
#define REND_DELETE 10
#define REND_OPT 11
#define REND_EMPTY 12
#define REND_ERROR 13
#define REND_ZZZ 14

#define _north _d[15]
#define _panel _d[16]
#define _jt _d[17]
#define _jlVar _d[18]
#define _ctxt _d[19]
#define _entryEdited _d[20]
#define _entryFocused _d[21]
#define RESAN_OBJECT_NUM 22
/* int (NUM1 0) */
#define _canSimplify _i[0]
#define _mcGui _i[1]
#define _rowCount _i[2]
#define _isDisposed _i[3]
#define RESAN_INT_NUM 4
#define _mapFeatColor mapNoClr(265)
public final class ResidueAnnotation implements ResidueSelection,SelectorOfNucleotides,ChRunnable,HasWRef,HasMC IF_GUI(,javax.swing.ListCellRenderer){
    public final static ResidueAnnotation[]NONE={};
    static int _countInst;
    IF_GUI(private static int _anyHidden);;
    private FeatureColor _fColor;
    private Object _p,_color,_paper;
    private String _name,_ftrName;
    private boolean _parseIsAmino IF_GUI(,_hidden);
    private int _mc,_ntOffset,_aaOffset,_aaMC,_enabled,_style=SSTYLE_UNDERLINE,_ftrSrc IF_GUI(,_where=VIS123_EVERYWHERE);
    float _simRegionScore=Float.NaN;
    long _srcTextHC;
    int _resanFlags=RESANFLAG_SAVE;
    final int NUM=_countInst++,ENDS_AA[]={0};
    CPP_CODE_HasWRef();
    public int mc(){return _mc;}
    public ResidueAnnotation(Protein p){
        _p=wref(p);
        annoAdd(IRESAN_NAME,"new_annotation");
        annoAdd(IRESAN_GROUP,"new_group");
    }
#include "ResidueAnnotation_Entry_Inc.java"
#if CPP_WITH_GUI
#include "ResidueAnnotation_GuiInc.java"
#endif //CPP_WITH_GUI
    public String getName(){return orS(_name,featureName(),"");}
/* <<< Instance <<< */
/* ---------------------------------------- */
/* >>> Selected Nucleotides and Aminoacids >>> */
    UNLESS_THREADS(private final static int[]returnMinIdx={0});;
    private transient Object _rCached;
    Object[]cached(){
        Object[]r=(Object[])deref(_rCached);
        if(r==null) _rCached=newSoftRef(r=new Object[6]);
        return r;
    }
    OVERRIDE_PUBLIC void setSelectedAminoacids(boolean[]bb,int offset){
        annoAdd(IRESAN_POS,selectedPositionsToText(strchr(':',value(IRESAN_POS))>0?SELPOS2TXT_PDB_RESNUM:0,bb,offset,sp(this)));
        setEnabledE(true,_uniqEE[IRESAN_POS]);
    }
/** e.g. s.setSelectedAminoacids("3-5"); */
    OVERRIDE_PUBLIC_IF void setSelectedAminoacids(String selection) {annoAdd(IRESAN_POS,selection);}
    OVERRIDE_PUBLIC_IF boolean[]getSelectedNucleotides(){return (boolean[])mayParse(null)[RESANCACHE_IS_SEL_NT];}
    OVERRIDE_PUBLIC_IF int getSelectedAminoacidsOffset(){mayParse(null); return _aaOffset;}
    OVERRIDE_PUBLIC_IF int getSelectedNucleotidesOffset(){mayParse(null); return _ntOffset;}
    public boolean[]getSelectedAminoacids(){
        final Object bb=mayParse(null)[RESANCACHE_IS_SEL];
        return bb!=null?(boolean[])bb: NO_boolean;
    }
/* <<< Selected Nucleotides and Aminoacids <<< */
/* ---------------------------------------- */
/* >>> Rendering >>> */
    OVERRIDE_PUBLIC_IF int getVisibleWhere(){
        return
            IF_GUI((_name==RESSEL_NAME_MISMATCH_3D && !isCbSlct(STOG_UL_MISMATCH3D) || _hidden && !isCbSlct(STOG_Hidden_ResSel))?0:)
            _style!=SSTYLE_HIDDEN && run(RUN_IS_ENABLED,null)==TRUEr?IF_GUI(_where)UNLESS_GUI(VIS123_EVERYWHERE):0;
    }
    OVERRIDE_PUBLIC_IF void setVisibleWhere(int where){
        IF_GUI(_where=where);;
    }
    OVERRIDE_PUBLIC_IF int getStyle(){
        IF_GUI(if(_style!=SSTYLE_IMAGE && _style!=SSTYLE_IMAGE_LUCID && _img!=null) return SSTYLE_IMAGE_LUCID);;
        return _style;
    }
    OVERRIDE_PUBLIC_IF void setStyle(int i){
        if(0!=(i&SFLAG_NO_SAVE)) _resanFlags&=~RESANFLAG_SAVE;
        _style=i;
        if((i&SSTYLE_MASK)!=SSTYLE_UNDERLINE) annoAdd(IRESAN_STYLE,iConst(SARRAY_RESSEL_SSTYLE,i&0xf));
    }
    OVERRIDE_PUBLIC_IF void setColor(int whiteOrBlackBackground,Object c){
        if((whiteOrBlackBackground&~32)!='B' && c!=_paper){
            _paper=c;
            resanChanged(IRESAN_COLOR);
            IF_GUI(_changed(CHANGED_COLOR));;
        }
        if((whiteOrBlackBackground&~32)!='W' && c!=_color){
            _color=c;
            resanChanged(IRESAN_COLOR);
        }
    }
#define HIDE_IF_LONGER 7
    public boolean isHiddenInHTML(){/*X  Hidden Residue selections are deactivated with a check-box in HTML */
        final String h=value(IRESAN_HIDDEN),fn=featureName();
        return h!=null?isTrue(h): fn!=null && 0==sftrSecStrChar(fn) && countTrue(getSelectedAminoacids())>HIDE_IF_LONGER;
    }
#undef HIDE_IF_LONGER
/* <<< Rendering  <<< */
/* ---------------------------------------- */
/* >>> Image >>> */
    CPP_RUN_ID_ARG(){
        final Protein p=(Protein)derefProt(_p);
        switch(id){
            CASE_ARGV(RUN_SET_ENABLED){
                setEnabledE(true,_uniqEE[IRESAN_NAME]);
                break;
            }
            CASE_ARGV(RUN_SET_DISABLED){
                setEnabledE(false,_uniqEE[IRESAN_NAME]);
                break;
            }
            CASE_ARGV(RUN_IS_ENABLED){
                if(_enabled==0){
                    final Entry e=_uniqEE[IRESAN_NAME];
                    if(e==null) return FALSEr;
                    _enabled=e.isEnabled()?CTRUE:CFALSE;
                }
                return IF_GUI(((featureName()==null||_allEnabled==0)?_enabled==CTRUE: _allEnabled==CTRUE)?TRUEr:FALSEr)
                    UNLESS_GUI(_enabled==CTRUE?TRUEr:FALSEr);;
            }
            CASE_ARGV(RUN_GET_NAME) RETURN getName();
            CASE_ARGV(RUN_DISPOSE){
                rmFromProt(this,p);
                IF_GUI(_img=null; _vAllResidueAnnotation.remove(wref(this)));;
                RETURN TRUEr;
            }
            CASE_ARGV(RUN_GET_PROTEIN) RETURN p;
            CASE_ARG(RUN_SET_PROTEIN,CPP_AS_OBJECT(Protein),newP){
                if(p!=newP){
                    _p=wref(newP);
                    IF_GUI(_mc++);;
                }
                RETURN TRUEr;
            }
            CASE_ARGV(RUN_GET_COLOR_WHITE_BG)
                CASE_ARGV(RUN_GET_COLOR){
                Object c=id==RUN_GET_COLOR_WHITE_BG&&_paper!=null?_paper:_color;
                if(c!=null) return c;
                if(_mapFeatColor!=null){
                    final Object[]cc=(Object[])_mapFeatColor.get(orS(featureName(),getName()));
                    if(cc!=null) return cc[id==RUN_GET_COLOR_WHITE_BG?1:0];
                }
                final FeatureColor fc=_fColor;
                c=fc==null?null:fc.color(id==RUN_GET_COLOR_WHITE_BG);
                return c!=null?c: IF_GUI(C(RGBA_PINK)) UNLESS_GUI(newColr(RGBA_PINK));
            }
            CASE_ARG(RUN_SET_COLOR,Object,color){
                setColor('*',color);
                IF_GUI(_changed(CHANGED_COLOR));;
                RETURN TRUEr;
            }
#if CPP_WITH_GUI
#include "ResidueAnnotation_GuiCasesInc.java"
#endif //CPP_WITH_GUI
        }
#if CPP_WITH_GUI
#include "ResidueAnnotation_Evt_Inc.java"
#endif //CPP_WITH_GUI
        return null;
    }
/* <<< Image <<< */
/* ---------------------------------------- */
/* >>>  Get Entry >>> */
    public String value(int ki){
        Entry e,ee[];
        if(ki<IRESAN_UNIQ_ZZZ) return(e=_uniqEE[ki])==null||(ki!=IRESAN_POS && !e.isEnabled())?null:e._v;
        ROFi0((ee=entries()).length){
            if((e=ee[i]).isEnabled() && ki==e._ki){
                final String v=e.value();
                if(v.length()>0) return v;
            }
        }
        return null;
    }
    public boolean isAmino(){
        final Entry e=_uniqEE[IRESAN_POS];
        return e==null||e.isEnabled();
    }
/* <<< Get Value <<< */
/* ---------------------------------------- */
/* >>> Set Value >>> */
/** Adds a new key-value-pair */
    boolean resanSetE(int opt,Object value,Entry e){
        if(e==null){
            resanRemoveE(e);
            return false;
        }
        final int ki=e._ki,fromTo[]=derefZ(value,int[].class);
        if((ki==IRESAN_NAME || ki==IRESAN_GROUP) && nxt(0,chrClas(-FILENM),value)>=0) value=new BA(sze(value)).aFilter(FILTER_NO_MATCH_TO_US|FILTER_TRIM|FILENM,value);
        final Object mayParse=value instanceof Integer || fromTo!=null?value:null;
        String v=fromTo==null?toStrgTrim(value): fromTo[0]==fromTo[1]?s(fromTo[0]): s(baClr(109).a(fromTo[0]).a('-').a(fromTo[1]));
        if(v.equals(e.value())) return false;
        if(ki==IRESAN_DISABLED) runCR(RUN_SET_DISABLED,this);
        IF_GUI(if(ki==IRESAN_POS && _i!=null) _canSimplify=0);;
        if(ki==IRESAN_NAME)  _name=RESSEL_NAME_MISMATCH_3D.equals(v)?RESSEL_NAME_MISMATCH_3D: v;
        e._v=v;
        e._hcV=v==null?0:v.hashCode();
        e._opt=opt;
        IF_GUI(if(ki==IRESAN_HIDDEN && (_hidden=isTrue(v)) && _anyHidden++==0) awtc(AWTC_SET_ENABLED,buttn(STOG_Hidden_ResSel)));;
        resanChanged(ki);
        if(mayParse!=null && ki==IRESAN_POS) mayParse(mayParse);
        return true;
    }

    private void resanChanged(int k){
#if CPP_WITH_GUI
        final Protein p=sp(this);
        strapIncMC(P_MC_RES_SELECTIONS,p);
        if(k==IRESAN_NAME || k==IRESAN_COLOR) strapIncMC(P_MC_RES_SELECTION_LABELS,p);
        if(k==IRESAN_GROUP) strapIncMC(MC_RESIDUE_ANNOTATION_GROUPS,p);
        if(k==IRESAN_BG_IMAGE) runCR(RUN_RESAN_FIND_IMG,this);
        _mc++;
        _resanFlags|=RESANFLAG_SAVE;
#endif //CPP_WITH_GUI
        if(k==IRESAN_COLOR) _resanFlags|=RESANFLAG_COLOR_SET;
        _enabled=0;
    }
    public void setEnabledE(boolean b,Entry e){
        if(e!=null && e.isEnabled()!=b){
            if(b) e._opt&=~RESAN_ENTRY_DISABLED;
            else e._opt|=RESAN_ENTRY_DISABLED;
            resanChanged(e._ki);
        }
    }
/* <<< Set Value <<< */
/* ---------------------------------------- */
/* >>> Get Entry Objects >>> */
    final UniqueList<Entry>_vE=new UniqueList(iCLASS_ResidueAnnotation_Entry);
    private final Entry[]_uniqEE=new Entry[IRESAN_UNIQ_ZZZ];
    public Entry[]entries(){
        IF_GUI(final Entry oe=_onlyE; if(oe!=null) return new Entry[]{oe};)
            return _vE.asArray();
    }
    public void resanRemoveE(Entry e){
        if(e!=null){
            final int ki=e._ki;
            if(_vE.remove(e)) resanChanged(ki);
            if(ki>=0 && ki<IRESAN_UNIQ_ZZZ) _uniqEE[ki]=null;
        }
    }
    public ResidueAnnotation annoAdd(int i,Object v){
        if(v!=null||0!=(i&RESAN_ENTRY_OVERRIDE)){
            final int opt=i;
            if((i&=IRESAN_MASK)<0){
                assrt();
            }else if(i<IRESAN_UNIQ_ZZZ){
                if(i==IRESAN_STYLE){
                    String vs=s(v);
                    IF_GUI(if((vs=delPfx("STYLE_",vs)).endsWith("HALF_BACKGROUND")) vs=delSfx("_BACKGROUND",vs));;
                    strapIncMC(P_MC_RES_SELECTION_STYLE,sp(this));
                    _style=vs==null?SSTYLE_UNDERLINE:   valOfDecConstant(SARRAY_RESSEL_SSTYLE,vs);
                }else{
                    final Entry e=_uniqEE[i];
                    if(e!=null){
                        if(v==null){
                            _uniqEE[i]=null;
                            _vE.remove(e);
                        }else resanSetE(opt,v,e);
                    }else if(v!=null){
                        _annoAdd(opt,iConst(SARRAYeq_RESAN_KEYS,i),i,v);
                        if(i==IRESAN_SRC && v instanceof String && ((String)v).startsWith("PDB:")) setFeatureSrc(SEQFEAT_SRC_FILE);
                    }
                }
            }else{
                addE(i,iConst(SARRAYeq_RESAN_KEYS,i),v);
            }
        }
        return this;
    }

    public void addE(int opt,String k,Object value){
        if(k==null || value==null) return;
#if CPP_WITH_GUI
        if(strstr(STR_IC,KRESAN_TEXSHADE,k=delToLstChr1('.',k))>=0) k=iConst(SARRAYeq_RESAN_KEYS,IRESAN_TEXSHADE);
        else{
            String astex=null;
            if(strstr(STR_IC,astex="Astex",k)>=0){
                k=iConst(SARRAYeq_RESAN_KEYS,IRESAN_VIEW3D);
                value=new BA(99).aa(iConst(SARRAY_STRAP_SCRIPT_CMD,iV3DCMD_native),astex,',',value);
            }
        }
#endif //CPP_WITH_GUI
        k=strM(STR_INTERN_RESAN_KEY,k);
        final String v=toStrgTrim(value);
        final int ki=resanKeyToUniqIdx(k);
        if(ki>=0 && ki<IRESAN_UNIQ_ZZZ)  annoAdd(ki|opt,v);
        else{
            if(ki!=IRESAN_VIEW3D && (0==(opt&RESAN_ENTRY_NOT_UNIQUE)||0!=(opt&RESAN_ENTRY_OVERRIDE))){
                for(Entry e:entries()){
                    if(k==e.key()){
                        if(0==(opt&RESAN_ENTRY_NOT_UNIQUE) && v.equals(e.value())) return;
                        if(0!=(opt&RESAN_ENTRY_OVERRIDE)){
                            resanSetE(opt,v,e);
                            return;
                        }
                    }
                }
            }
            _annoAdd(opt,k,-1,v);
        }
    }
    private void _annoAdd(int opt,String k,int ki,Object v){
        if(ki<0) ki=resanKeyToUniqIdx(k);
        final Entry e=new Entry(wref(ResidueAnnotation.this),k,ki);
        if(ki>=0 && ki<IRESAN_UNIQ_ZZZ) _uniqEE[ki]=e;
        IF_GUI(final int row=0!=(opt&RESAN_ENTRY_ROW)?((opt>>>RESAN_ENTRY_ROW_SHIFT)): MAX_INT);;
        IF_GUI(_vE.add(row<0?sze(_vE): mini(sze(_vE),row),e));;
        UNLESS_GUI(_vE.add(e));;
        resanSetE(opt,v,e);/*X  Reihenfolge wegen KRESAN_BG_IMAGE */
    }
/* <<< Entry List  <<< */
/* ---------------------------------------- */
/* >>> Parse >>> */
#if 0
/**
       Example
       texshade=  X\feature...
       ^
       i1234
       value is substring(i+4);
       X/x  is substring(i+3);
*/
#endif //0
#if CPP_WITH_GUI
    void parseResan(BA txt,int fromLine,int toLine){
        if(txt==null) return;
        final byte[]T=txt.bytes();
        final int eol[]=txt.eol();
        toLine=mini(toLine,eol.length);
        FORiL(fromLine,toLine){
            final int b=BOL0(iL,eol),e=eol[iL],eq=strchr('=',T,b,e);
            if(eq<b+2 || e<eq+4) continue;
            final String k=strM(STR_INTERN_RESAN_KEY,s(T,b,eq)),v=s(T,eq+4,e);
            if(k==KRESAN_COLOR){
                final Object c=str2color(v,0);
                if(c!=null) _color=c;
            }else{
                addE(RESAN_ENTRY_NOT_UNIQUE| (T[eq+3]=='X'?0:RESAN_ENTRY_DISABLED)|(T[eq+2]=='X'?RESAN_ENTRY_EDITED:0),k,v);
            }
        }
    }
#endif //CPP_WITH_GUI
/* <<< Parse <<< */
/* ---------------------------------------- */
/* >>> Parse >>> */
    private Object[]mayParse(Object pos){
        final Object[]cached=cached();
        final String txt=value(IRESAN_POS);
        final Protein p=sp(this);
        if((txt!=null||pos!=null) && p!=null){
            final boolean isA=isAmino();
            if(DIFF_MC(_aaMC,IF_GUI(_mc+(resSelMaxUnderline()<<10)+)
                        (p.mc((P_MC_RES_TYPE<<P_MC_SHIFT*2)|(P_MC_RES_SELECTION_REFERENCE<<P_MC_SHIFT)|P_MC_RESNUM<<P_MC_SHIFT)+
                         p.mc((P_MC_1ST_RES_IDX<<P_MC_SHIFT*2)|(P_MC_EXONS<<P_MC_SHIFT)|P_MC_1ST_RES_IDX)+
                         p.mc((P_MC_HETERO_V<<P_MC_SHIFT*2)|(P_MC_MATRIX3D<<P_MC_SHIFT))))||
                cached[RESANCACHE_IS_SEL]==null || isA!=_parseIsAmino){
                _parseIsAmino=isA;
                boolean[]bb=null;
                if(pos!=null){
                    final int f,t;
                    if(pos instanceof int[]){
                        f=((int[])pos)[0];
                        t=((int[])pos)[1];
                    }else{
                        f=t=xatoi(pos);
                    }
                    bb=t<f?NO_boolean:setTrue(0,t-f+1,null);
                    _ntOffset=0;
                    _aaOffset=f-1;
                }else if(isA){
                    if(null==(bb=_parseAA(txt))) bb=NO_boolean;
                    _ntOffset=0;
                }else{
                    final int[]c2a=p.coding2allPositions();
                    boolean[]nn=NO_boolean;
                    if(c2a!=null){
                        final int maxIdx=maxi(c2a)IF_THREADS(,returnMinIdx[]=new int[1]);
                        CPP_synchronized(SYNC_PARSE_SET){
                            final long range=parseSet(toknzr(340,SPACE_COMMA).setText(toByts(txt),0,MAX_INT),0,maxIdx+2);
                            final int r1=(int)(range>>RANGEFROM_SHIFT);
                            if((range&RANGETO_MASK)>r1){
                                bb=ntPositions2aaZ(nn=parseSetGet(r1,MAX_INT),(_ntOffset=r1-1)-p.getIntProperty(PROTEINI_NT_IDX_OFFSET),returnMinIdx,p);
                                _aaOffset=returnMinIdx[0]+firstResIdx(p);
                            }
                        }
                    }
                    cached[RESANCACHE_IS_SEL_NT]=nn;
                }
                if(bb!=null){
                    cached[RESANCACHE_IS_SEL]=bb;
#if CPP_WITH_GUI
                        if(bb.length>resSelMaxUnderline() && countTrue(bb)==bb.length && vis123isUnderline(this)){
                            final boolean lastResIsSelected=bb.length+_aaOffset>=p.countRes(),sel[]=new boolean[lastResIsSelected?2: bb.length];
                            sel[0]=sel[1]=sel[0]=sel[sel.length-1]=sel[sel.length-2]=true;
                            cached[RESANCACHE_IS_SEL_DISPLAYED]=sel;
                            _where&=~VIS123_STRUCTURE;
                        }else cached[RESANCACHE_IS_SEL_DISPLAYED]=null;
#endif //CPP_WITH_GUI
                }
                strapIncMC(P_MC_RES_SELECTIONS,p);
            }
        }
        return cached;
    }
    private boolean[]_parseAA(String txt){
        final Protein p=sp(this);
        String s;
        boolean[]bb=null;
        if((s=declaredValue(RESAN_POS_AROUND,txt,0,MAX_INT,null))!=null){
/* Reihenfolge: Im Moment brauche ich die coordinaten fuer die bestimmung des DSSP files. */
/* Eigentlich koennte man auf das einlesen der Koordinaten verzichten. */
            IF_AA(p.xyzByID(true));;
            boolean hasXYZ=p.getAtomXYZ()!=null;/*X  Download falls AA*/
            if(!hasXYZ){
                final String id=p.getPdbID(PDBID_ID);
                if(id!=null && strstr(STR_w_R,"--INFERRED_COORDINATES",txt)>=0){
                    projectXYZ(0,new Protein[]{p},new String[]{id});
                    hasXYZ=p.getAtomXYZ()!=null;
                }
            }
            if(hasXYZ){
                float distance=(float)atof(declaredValue(RESAN_POS_ANGSTROM,txt,0,MAX_INT,null));
                if(distance<=0 || Float.isNaN(distance)) distance=5;
                _aaOffset=0;
                final String pdb=p.getPdbID(PDBID_INFERRED);
                if(pdb!=null){
                    final long match=p._infXYZMatch;
                    annoAdd(IRESAN_EVIDENCE,(match>>>NUMERATOR_SHIFT)==(match&DENOMINATOR_MASK)?EVIDENCE_BY_IDENTITY: EVIDENCE_BY_SIMILARITY);
                }
                _aaOffset=firstResIdx(p);
                bb=residuesAroundMoleculeZ(distance,toBA(s),p,bb UNLESS_AA(,null));
            }
        }else if((s=declaredValue(RESAN_POS_MIN_ACCESSIBILITY,txt,0,MAX_INT,null))!=null){
            final float minArea=(float)atof(s);
            if(minArea>0){
                Collection<Protein>v=null;
                for(String subunit:splitTkns(declaredValue(RESAN_POS_SUBUNITS,txt,0,MAX_INT,null))){
                    final int opt=PROTPARS_NO_SEQRES|PROTPARS_NO_HEADER;
                    if("ALL".equals(subunit)){
                        v=adAllNotNullNew(p.proteinsAllChains(opt),v);
                    }else if(subunit.startsWith("PDB:")){
                        v=adAllNotNullNew(pdbDownloadPepOrNuc(opt,subunit,null),v);
                    }else{
                        v=adNotNullNew(p,v);
                    }
                }
                float[]resAcc=getAccessibility(false,spp(v));
                if(resAcc!=null){
                    final int subsetStart=_aaOffset=p.subsetStart(),subsetEnd=p.subsetEnd();
                    for(int i=mini(subsetEnd,resAcc.length);--i>=subsetStart;){
                        if(resAcc[i]>minArea){
                            if(bb==null) bb=new boolean[i+1-subsetStart];
                            bb[i-subsetStart]=true;
                        }
                    }
                }
            }
        }else{
            bb=p.residueSubsetAsBool(txt,_returnMinIdx);
            _aaOffset=_returnMinIdx[0]-1;
        }
        return bb;

    }
    private final int[]_returnMinIdx={0,0};
/* <<< Parse <<< */
/* ---------------------------------------- */
/* >>> Sequence Features >>> */
    java.io.File featureFile(java.io.File dir){
        final Protein p=sp(this);
        if(p==null) return null;
        final BA sb=IF_GUI(new BA(99).aa(dir==null?iFile(DIR_STRAP_ANNO):dir,'/')) UNLESS_GUI(baClr(110).a(dir)).a("/"+DIRNAME_ANNOTATIONS+"/");
        if(p.seqId(GETSEQID_ACCESSION)!=null) sb.aFilter(FILTER_NO_MATCH_TO_US|LETTR_DIGT_US,p.seqId(GETSEQID_ACCESSION)).and("_",p.getChain());
        else sb.aRplc(':','_',p);
        final boolean[]bb=getSelectedAminoacids();
        final int offset=getSelectedAminoacidsOffset();
        return file(sb.an('_',2)
                    .a(_ftrName)
                    .an('_',2).boolToText(bb,offset+1,"_","-")
                    .an('_',2).a(hashCdUC(p.getResType(),maxi(0,offset+fstTrue(bb)-firstResIdx(p)),mini(offset+lstTrue(bb)+1-firstResIdx(p),p.countRes())))
                    .a(".fAnno"));
    }
    public ResidueAnnotation setFeatureSrc(int featureSrc){
        final String name=nam(this);
        _ftrName=sftrMapSynonyms(SEQFEAT_NOT_MAP_SYN,name);
        _ftrSrc=featureSrc;
        _fColor=FeatureColor.featureColor(name);
        return this;
    }
    public String featureName(){
        if(_ftrName!=null) return _ftrName;
        final Map m=_mapFeatColor;
        if(m!=null){
            final String n=value(IRESAN_NAME);
            if(n!=null&&n.length()>0 && m!=null && m.get(n)!=null) return n;
        }
        return null;
    }
    public int whereFeatureLoadedFrom(){return _ftrSrc;}
/* <<< Sequence Features <<< */
/* ---------------------------------------- */
/* >>> Compare entries >>> */
    public Entry entryNotContained(ResidueAnnotation a,boolean add){
        ROFi0(IRESAN_UNIQ_ZZZ){
            final Entry e2=a._uniqEE[i],e=_uniqEE[i];
            if(e2==null || e2._ki==IRESAN_GROUP || e2._ki!=IRESAN_POS && !e2.isEnabled()) continue;
            if(e==null || e._hcV!=e2._hcV || !e.value().equals(e2.value())){
                if(!add) return e2;
                annoAdd(RESAN_ENTRY_OVERRIDE|i,e2.value());
            }
        }
        final Entry[]ee=entries();
    next:
        for(Entry e2:a.entries()){
            if(e2._ki>=0 && e2._ki<IRESAN_UNIQ_ZZZ || !e2.isEnabled()) continue;
            final String k2=e2.key();
            final int hc2=e2._hcV;
            for(Entry e:ee)  if((e._ki<0 || e._ki<IRESAN_UNIQ_ZZZ) && e.isEnabled() && e.key()==k2 && e._hcV==hc2 && e.value()==e2.value()) continue next;
            if(!add) return e2;
            addE(RESAN_ENTRY_OVERRIDE,k2,e2.value());
        }
        return null;
    }
/* <<< Compare entries <<< */
/* ---------------------------------------- */
/* >>> Feature color >>> */
    static boolean sftrAddColors(String fn,String expr){
        final int colon=expr.indexOf(',');
        final Object c1=str2color(expr,0);
        if(c1==null) return false;
        _mapFeatColor.put(fn,new Object[]{c1,colon<0?c1:str2color(expr,colon+1)});
        return true;
    }
/* <<< Feature color <<< */
/* ---------------------------------------- */
/* >>> Main >>> */
#if CPP_DEACTIVATED_MAIN
/* java charite.christo.test.ResidueAnnotationTest */
    static boolean resanEquals(boolean[]bb,ResidueSelection s) {return eqBoolArraysOffset(bb,0,s.getSelectedAminoacids(),s.getSelectedAminoacidsOffset());}
    static ResidueSelection mkRessel(String pos,int from,int to){
        final Protein p=new Protein();
        p.setResidueType("ASDFGHJKLMNOPQRST".getBytes());
        final ResidueAnnotation a=new ResidueAnnotation(p);
        a.annoAdd(IRESAN_NAME,"Hallo").annoAdd(IRESAN_POS,pos).setStyle(SSTYLE_LOWER_HALF);
        resSelSetAminoSelected(SELECTION_ADD,from,to,a);
        return a;
    }
    static void check(String txt,String pos,int from,int to){
        final ResidueSelection s=mkRessel(pos,from,to);
        final boolean bb[]=parseSet(txt,9999,-1),success=resanEquals(bb,s);
        BA sb=new BA(99).aa(" ",txt," = ",pos," + ",from,'-',to,success?GREEN_SUCCESS:RED_FAILED,"  First-Last=",fstTrue(bb),'-',lstTrue(bb)).aln();
        if(!success) resSelAsText(false,s,sb.a("S=")," bb=").boolToText(bb).aln();
        putln(sb);
    }
    public static void main(String[]argv)throws Exception{
        setNoGui(argv);
        check("5-8,10","5-8",9,10);
        check("2,5-8","5-8",1,2);
        check("1,2,5-8","5-8",-1,2);
        check("5-8","5-8",4,8);
        check("5-8","5-8",4,8);
        check("4-8","5-8",3,8);
        check("4-9","5-8",3,9);
    }
#endif //CPP_DEACTIVATED_MAIN
}
