package charite.christo.strap;
import static charite.christo.ChUtils.*;
public final class Selection3D{
    public final static Selection3D[]NONE={};
    public final char  _fIns,_lIns;
    public final int _f,_l,_opt;
    public String _atoms[],_nativeAtoms,_chain,_residueName;
    private Selection3D(int opt,int first,char insF,int last,char insL,String chain,String[]atoms,String nativeAtoms,String name){
        _opt=opt;
        _f=first;
        _l=last;
        _lIns=Strap.insCodeChar(insL);
        _fIns=Strap.insCodeChar(insF);
        _chain=chain==null?"":chain;
        _atoms=atoms;
        _nativeAtoms=nativeAtoms;
        _residueName=name;
    }
    public Selection3D(int opt,Selection3D s,Object change){
        this(s._opt,s._f,s._fIns,s._l,s._lIns,s._chain,opt==S3D_NEW_INSTANCE_CHANGE_ATOMS?(String[])change:s._atoms,
             opt==S3D_NEW_INSTANCE_CHANGE_NATIVEATOMS?(String)change:s._nativeAtoms,
             s._residueName);
    }
    public Selection3D(int opt,int first,char insF,int last,char insL,String chain,String[]atoms){
        this(opt,first,insF,last,insL,chain,atoms,null,null);
    }
    public Selection3D(int opt,String name,String chain,String[]atoms){
        this(opt,0,'\0',0,'\0',chain,atoms,null,name);
    }
#define _NE(v) v!=s.v
#define _NEQ(v) !eq(v,s.v)
    public boolean equals(Object o){
        if(!(o instanceof Selection3D)) return false;
        final Selection3D s=(Selection3D)o;
        return!(_NE(_fIns)||_NE(_lIns)||_NE(_f)||_NE(_l)||_NE(_opt)||
                 _NEQ(_residueName)||_NEQ(_nativeAtoms)||_NEQ(_chain)||
                 !eqArry(EQARRY_EQUALS,_atoms,s._atoms));
    }
#if CPP_WITH_MEIN_DEBUG
    public String toString(){return new charite.christo.BA(99).aa(" Selection3D[",_f,'-',_l," _chain=",_chain," _residueName=",_residueName," _atoms=").joinSpc(_atoms).a(']').toString();}
#endif //CPP_WITH_MEIN_DEBUG
}
